<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include_once('../php/funcoes.php');
	include_once('../php/TParams.class.php');
	include_once('../class/barcode/barcode.php');

	$TParams = new TParams();
	$company = $TParams->getCompany(); //dados da empresa

	$dados  = json_decode(base64_decode($_REQUEST['dados']));
	$produtos = $dados->{'produtos'};
	
	function gerarEtiquetasCodigoBarras($params) {
		// Mesclar parâmetros recebidos com defaults
		//$params = array_merge($defaults, $params);
		
		// Converter medidas de sm para pixels (1 polegada = 2.54 cm)
		$pxPorCm = $params['dpi'] / 2.54;
		
		$larguraEtiquetaPx = round($params['largura_etiqueta'] * $pxPorCm);
		$alturaEtiquetaPx = round($params['altura_etiqueta'] * $pxPorCm);
		$margemPx = round($params['margem'] * $pxPorCm);
		
		// Calcular quantas etiquetas cabem na largura do rolo
		$etiquetasPorLinha = floor($params['largura_rolo'] / ($params['largura_etiqueta'] + $params['margem']));
		
		// Calcular largura total da div (em pixels)
		$larguraTotalPx = round($params['largura_rolo'] * $pxPorCm);
		
		// Calcular largura efetiva disponível para as etiquetas (descontando as margens)
		$larguraEfetivaPx = ($larguraEtiquetaPx + $margemPx) * $etiquetasPorLinha - $margemPx;
		
		// Estilo CSS para a div container
		$styleContainer = "width: {$larguraEfetivaPx}px; " .
						  "display: flex; " .
						  "flex-wrap: wrap; " .
						  "gap: {$margemPx}px; " .
						  "padding-top: 0px;";
		
		// Estilo CSS para cada etiqueta
		$styleEtiqueta = "width: {$larguraEtiquetaPx}px; " .
						 "height: {$alturaEtiquetaPx}px; " .
						 "background-color: white; " .
						 
						 "display: flex; " .
						 "flex-direction: column; " .
						 "align-items: center; " .
						 "justify-content: center; " .
						 "padding: 5px; " .
						 "margin-bottom: 5px; " .
						 "box-sizing: border-box;
						 float:left;";
		
		// Iniciar a saída HTML
		$html = "<div style='{$styleContainer}'>";
		
		// Gerar as etiquetas
		for ($i = 0; $i <= $params['quantidade']; $i++) {
			$qtde = $params['produtos'][$i]->{"ref_qtde"}; //qtde de cada um
			for($j=0;$j<$qtde;$j++){
				// $codigo = $params['texto'] . str_pad($i, 4, '0', STR_PAD_LEFT);
				$codigo = $params['produtos'][$i]->{"ref_codbar"};
				
				// URL da API de código de barras (usando barcode.tec-it.com como exemplo)
				$barcodeUrl = "https://barcode.tec-it.com/barcode.ashx?data={$codigo}&code=Code128&dpi={$params['dpi']}";
				//$barcodeUrl = "http://".$_SERVER['SERVER_NAME']."/desktop/rel/img-codbarras.php?cod=".$params['texto']."&tipo=code128";
				
				$html .= "<div style='{$styleEtiqueta}'>";
				$html .= "<div style='font-size: 8px;text-align: center'>".$params['produtos'][$i]->{"ref_codigo"}." - ".substr($params['produtos'][$i]->{"ref_descr"},0,30)."</div>";
				$html .= "<center><img src='{$barcodeUrl}' alt='{$codigo}' style='width:70%; height: 70%;margin-top:5px'></center>";
				$html .= "<div style='font-size: 13px; text-align: center;font-weight:bold'>R$ ".number_format($params['produtos'][$i]->{"ref_preco"},2,",", "")."</div><br>";
				$html .= "</div>";
			}
		}
		
		$html .= "</div>";
		
		return $html;
	}

	$parametros = [
	   'largura_rolo' => $company->cfg_etq_w, // cm
		'largura_etiqueta' => $company->cfg_etq_w2, // cm
		'altura_etiqueta' => $company->cfg_etq_h2, // cm
		'margem' => $company->cfg_etq_margem, // cm entre etiquetas
		'quantidade' => count($produtos), // número de etiquetas a gerar
		'dpi' => 147, // DPI para impressão
		// 'dpi' => 72, // DPI para impressão
		'tipo' => ( isset($company->cfg_etq_codbar) && $company->cfg_etq_codbar!="" ) ? $company->cfg_etq_codbar : 'Code128',
		'produtos' => $produtos // texto base para o código de barras
	];


	echo gerarEtiquetasCodigoBarras($parametros);


	$tipo = "a";
	$heigthFolha=1000;
	$whidhtFolha=1000;
	$html = ob_get_clean();
	$arquivo = str_replace(array(".",","), "", microtime(true));
	$fp = fopen("../tmp/".$arquivo.'.html', 'w');
	fwrite($fp, $html);
	fclose($fp);
	exec($TParams->getHostRoot().'class/phantomjs/bin/phantomjs '.$TParams->getHostRoot().'class/phantomjs/rasterizeEtiquetas.js '.$TParams->getHostRoot().'tmp/'.$arquivo.'.html '.$TParams->getHostRoot().'tmp/'.$arquivo.'.pdf ["7,5in*5in"] '.$tipo." ".$heigthFolha." ".$whidhtFolha);
	if(file_exists("../tmp/".$arquivo.'.pdf')){
		echo "tmp/".$arquivo.'.pdf';
	}else{
		echo "Ocorreu um erro ao gerar o arquivo.";
	}

?>
