<?php
	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	$dados  = json_decode(base64_decode($_REQUEST['dados']));
	
	if(isset($dados->{'not_dtfaturam_ini'})&&!empty($dados->{'not_dtfaturam_ini'})){
		$not_dtfaturam_ini = data($dados->{'not_dtfaturam_ini'},true);
	}else{
		$not_dtfaturam_ini = "2000-01-01";
	}
	
	if(isset($dados->{'not_dtfaturam_fim'})&&!empty($dados->{'not_dtfaturam_fim'})){
		$not_dtfaturam_fim = data($dados->{'not_dtfaturam_fim'},true);
	}else{
		$not_dtfaturam_fim = date('Y-m-d');
	}
		
	if(isset($dados->{'cad_codvend'})&&!empty($dados->{'cad_codvend'}) && $dados->{'cad_codvend'} != "Novo Registro"){
		$cad_codvend = " and header_nota.cad_codvend = ".$dados->{'cad_codvend'};
	}else{
		$cad_codvend = "";
	}
	
	if(isset($dados->{'cad_codigo'})&&!empty($dados->{'cad_codigo'}) && $dados->{'cad_codigo'} != "Novo Registro"){
		$cad_codigo = " and header_nota.cad_codigo = ".$dados->{'cad_codigo'};	
	}else{
		$cad_codigo = "";
	}
	
	if(isset($dados->{'ser_codigo'})&&!empty($dados->{'ser_codigo'}) && $dados->{'ser_codigo'} != "Novo Registro"){
		$ser_codigo = " and header_nota.ser_codigo = ".$dados->{'ser_codigo'};
		$serie = $dados->{'ser_codigo'};
	}else{
		$ser_codigo = "";
		$serie = "Não informada";
	}
	
	if(isset($dados->{'ccu_codigo'})&&!empty($dados->{'ccu_codigo'}) && $dados->{'ccu_codigo'} != "Novo Registro"){
		$ccu_codigo = "and header_nota.ccu_codigo = '".$dados->{'ccu_codigo'}."'";
		$descrCusto = $dados->{'ccu_descr'};
	}else{
		$ccu_codigo = "";
		$descrCusto = "Não informado";
	}

	$tipo = "TODOS";
	if(isset($dados->{'tipo'})&&!empty($dados->{'tipo'})||$dados->{'tipo'}==0){
		if($dados->{'tipo'} != 0){
			$not_tipo = $dados->{'tipo'};
			if($dados->{'tipo'}==2){
				$tipo = "PEDIDO";
			}else{
				$tipo = "NOTA FISCAL DE SAÍDA";
			}
		}else{
			$not_tipo = "2,9";
		}
	}else{
		$not_tipo = "2,9";
	}
	
	if(isset($dados->{'frete'})){
		$frete = "Sim";
	}else{
		$frete = "Não";
	}
	
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->emp_codigo.'","type":"string"}
	]}';
	
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();
	
	$empr_razao		= $company[0]->emp_razao;
	$empLogo 		= $company[0]->emp_logo;
	$empCodigo 		= $company[0]->emp_codigo;
	
	$filtro = '{"cod":"500500", "params":[
		{"name":"db","value":"'.$company[0]->emp_db_comum.'","type":"other"},
		{"name":"not_dtfaturam_ini","value":"'.$not_dtfaturam_ini.'","type":"string"},
		{"name":"not_dtfaturam_fim","value":"'.$not_dtfaturam_fim.'","type":"string"},
		{"name":"cad_codvend","value":"'.$cad_codvend.'","type":"other"},
		{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"other"},
		{"name":"ser_codigo","value":"'.$ser_codigo.'","type":"other"},
		{"name":"ccu_codigo","value":"'.$ccu_codigo.'","type":"other"},
		{"name":"not_tipo","value":"'.$not_tipo.'","type":"other"}
	]}';
	
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();

	echo "TOTAL BRUTO;DESCONTO;DEVOLUCAO;FRETE;TOTAL LIQ.;COMISSAO;".chr(13).chr(10);
	
	$arrayVendedor = array();
	$vendedor = "";
	$comissao = 0;
	$qntPorVend = 0;
	$somaFrete= 0;		
	$somaLiquido= 0;
	$somaBruto= 0;
	$somaDesconto= 0;
	$somaDevolucao= 0;
	$somaComissao= 0;
	
	for($i=0; $i<$cnt; $i++){
		if($vendedor != $rowdata[$i]->{'cad_codvend'}){
			array_push($arrayVendedor, $rowdata[$i]->{'cad_codvend'}."-".$rowdata[$i]->{'cad_nomeraz'}."-".$rowdata[$i]->{'comissao'});
			$vendedor = $rowdata[$i]->{'cad_codvend'};
		}
	}
	
	for($a=0; $a<count($arrayVendedor); $a++){ 
		$aux = explode("-", $arrayVendedor[$a]);

		for($b=0; $b<$cnt; $b++){
			
			if(!$rowdata[$b]->{'comissao'} || $rowdata[$b]->{'comissao'}=="" || $rowdata[$b]->{'comissao'}==0){
				$rowdata[$b]->{'comissao'} = $rowdata[$b]->{'comissao2'};
			}
				
			if($rowdata[$b]->{'cad_codvend'} == $aux[0]){ 
					
				if($dados->frete==0){
					$total = $rowdata[$b]->{'not_liquido'};
					$comissao = ($rowdata[$b]->{'comissao'}/100 )*$rowdata[$b]->{'not_liquido'};
				}else{
					$total = $rowdata[$b]->{'not_liquido'} - $rowdata[$b]->{'not_frete'};
					$comissao = ($rowdata[$b]->{'comissao'}/100)*$total;
				}
				
				$qntPorVend++;
				$somaBruto+=$rowdata[$b]->{'not_totalnota'}; 
				$somaDesconto+=$rowdata[$b]->{'not_valordesc'}; 
				$somaDevolucao+=$rowdata[$b]->{'not_devolucao'}; 
				$somaFrete+=$rowdata[$b]->{'not_frete'};		
				$somaLiquido+=$total; 
				$somaComissao+=$comissao;

			}
		}
		echo $aux[1]. " (".formatarPercentual($aux[2]).");".$qntPorVend.";".str_replace(",",".",valorFormat($somaBruto)).";".str_replace(",",".",valorFormat($somaDesconto)).";".str_replace(",",".",valorFormat($somaDevolucao)).";".str_replace(",",".",valorFormat($somaFrete)).";".str_replace(",",".",valorFormat($somaLiquido)).";".str_replace(",",".",valorFormat($somaComissao)).";".chr(13).chr(10);		
	}
	
	$html = ob_get_clean();
	$nome = str_replace(array(".",","), "", microtime(true));
	$arquivo = $TParams->getHostRoot()."tmp/".$nome.'.csv';
	$fp = fopen($arquivo, 'w');
	fwrite($fp, $html); 
	$type = pathinfo($arquivo);
	header("Content-Type: ".mime_content_type($arquivo));
	header("Content-Length:".filesize($arquivo));
	header('Content-Disposition: attachment; filename="'.$type['filename'].'.'.$type['extension'].'"');
	header("Content-Transfer-Encoding: binary");
	header('Expires: 0');
	header('Pragma: no-cache');
	fclose($fp);
	$fp = fopen($arquivo, "r");
	fclose($fp);

	exit($TParams->getHostRoot()."tmp/".$nome.".csv");
	
?>