<?php

	set_time_limit(0);

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$Datapacket = new TParams();
	$company[0] = $Datapacket->getCompany();

	$not_status = (isset($_POST['not_cancelada']) && $_POST['not_cancelada']==true) ? '2,3' : '2';
	$dataFinal = (isset($_POST['dataFinal']) && $_POST['dataFinal']!="") ? implode("-",array_reverse(explode("/",$_POST['dataFinal']))) : null;
	$dataInicio = (isset($_POST['dataInicio']) && $_POST['dataInicio']!="") ? implode("-",array_reverse(explode("/",$_POST['dataInicio']))) : null;
    $listaCfop = (isset($_POST['listaCfop']) && $_POST['listaCfop']!="") ? explode(",",$_POST['listaCfop']) : "";
	$cfop_base = ( isset($_POST["cfop_base"]) && $_POST["cfop_base"]==1 ) ? "cfop_nota" : "cfop";
	$not_entrsaida = "";
	
	if( isset($_POST["nfe_entrada"]) ){
		$not_entrsaida.="1,";
	}
	if( isset($_POST["nfe_saida"]) ){
		$not_entrsaida.="2,";
	}
	$not_entrsaida = substr($not_entrsaida,0,-1);
	

    if(empty($dataFinal)){
        $dataFinal = date ('Y-m-d H:i:s');
    }

    if(empty($dataInicio)){
        $dataInicio = date('Y-m-d H:i:s', strtotime('-30 days', strtotime($dataFinal)));
    }
        
	$filtro = '{"cod":"700542", "params":[
		{"name":"db","value":"'.$company[0]->emp_db_comum.'","type":"other"},
		{"name":"not_entrsaida","value":"'.$not_entrsaida.'","type":"other"},
		{"name":"dataInicio","value":"'.$dataInicio.'","type":"string"},
		{"name":"dataFinal","value":"'.$dataFinal.'","type":"string"},
		{"name":"not_status","value":"'.$not_status.'","type":"other"}
	]}';
	$Datapacket->setHost($Datapacket->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	$contador_linhas = $Datapacket->getRecordCount();
	$Datapacket->clear();
	
	$totalNotas=0;
	$totalItens=0;
	$tempCodigoNota="";
  
    //montando array de CFOP e produtos
    $cfop_produtos = array();
    for($i=0; $i<count($rowdata); $i++) {
        $tmp1 = base64_decode($rowdata[$i]->itn_tribjson);
        $tmp2 = json_decode($tmp1)->rowdata;

        $cfop_produtos[] = array(
            "cfop" => $tmp2[0]->ref_cfop,
			"numero_nota" => $rowdata[$i]->not_numero,
            "cfop_nota" => $rowdata[$i]->cfo_codigo,
            "cst" => ($company[0]->emp_codregtrib==1) ? $tmp2[0]->tri_csosn : $tmp2[0]->tri_situacao,
            "produto" => $rowdata[$i]->itn_descr,
            "preco" => $rowdata[$i]->itn_valor,
            "icms" => $rowdata[$i]->not_toticms,
            "quantidade" => $rowdata[$i]->itn_qtde,
            "total" => $rowdata[$i]->itn_subtotal,
            "cliente" =>  $rowdata[$i]->cad_nomeraz,
            "total_nota" => $rowdata[$i]->not_totalnota,
            "data" => $rowdata[$i]->not_data,
            "not_status" => $rowdata[$i]->not_status,
            "not_entrsaida" => $rowdata[$i]->not_entrsaida
        );
		if($tempCodigoNota!=$rowdata[$i]->not_codigo){
			$totalNotas++;
			$tempCodigoNota=$rowdata[$i]->not_codigo;
		}
    }

    //ordena o resultado pelo CFOP obtido
    sort($cfop_produtos);    

    //se a lista foi declarada sera selecionada do resulado do banco
    if(!empty($listaCfop) && is_array($listaCfop) && count($listaCfop)>0){
        $resTmp;

        for($i = 0; $i < count($cfop_produtos); $i++){
            if(in_array($cfop_produtos[$i][$cfop_base], $listaCfop)){
                $resTmp[] = $cfop_produtos[$i];
            }
        }

        $cfop_produtos = $resTmp;
    }

    //gerar total do cfop
    $valorTotalCfop = array();
    foreach ($cfop_produtos as $item){
        if(!array_key_exists($item[$cfop_base], $valorTotalCfop) ){
            $valorTotalCfop[$item[$cfop_base]] = 0;
        }

        $valorTotalCfop[$item[$cfop_base]] += $item['preco'] * $item['quantidade'];
    }

    //total geral para o final do relatorio
    $totalGeralValor = 0;
    foreach ($valorTotalCfop as $item) {
        $totalGeralValor += $item;
    }

	if($rowdata > 0){
		
		$arrayNotas = array();
		$not_codigo = "";
		$nota = "";
		
		echo "CFOP;TIPO;NUMERO NFE;CLIENTE;DATA;VALOR TOTAL;STATUS;ITEM;QUANTIDADE;CFOP(ITEM);CST/ CSOSN;ICMS TOTAL (NOTA);VALOR UNIT;SUBTOTAL;".chr(13).chr(10);
		
		$tempCfop = "";
		foreach($cfop_produtos as $item){
			
			$tipo = ($item["not_entrsaida"]==2) ? "SAIDA" : "ENTRADA";
			$status="";
			if($item["not_status"]==0){
				$status="PENDENTE";
			}elseif($item["not_status"]==2){
				$status="AUTORIZADA";
			}elseif($item["not_status"]==3){
				$status="CANCELADA";
			}

			echo $item['cfop_nota'].";".$tipo.";".$item['numero_nota'].";".$item['cliente'].";".implode('/', array_reverse(explode("-", substr($item['data'], 0, 10)))).";".valorFormat($item['total_nota']).";".$status.";".$item['produto'].";".qtde($item['quantidade']).";".$item['cfop'].";".$item['cst'].";".valorFormat($item['icms']).";".valorFormat($item['preco']).";".valorFormat($item['total']).";".chr(13).chr(10);
			$totalItens++;
				
		}
		
	}else{
		echo chr(13).chr(10);
		echo chr(13).chr(10);
		echo "SEM REGISTROS";
	}
	
	$html = ob_get_clean();
	$nome = str_replace(array(".",","), "", microtime(true));
	$arquivo = $Datapacket->getHostRoot()."tmp/".$nome.'.csv';
	$fp = fopen($arquivo, 'w');
	fwrite($fp, $html); 
	$type = pathinfo($arquivo);
	header("Content-Type: ".mime_content_type($arquivo));
	header("Content-Length:".filesize($arquivo));
	header('Content-Disposition: attachment; filename="'.$type['filename'].'.'.$type['extension'].'"');
	header("Content-Transfer-Encoding: binary");
	header('Expires: 0');
	header('Pragma: no-cache');
	fclose($fp);
	$fp = fopen($arquivo, "r");
	fclose($fp);

	exit($Datapacket->HostClient."/tmp/".$nome.".csv");
	
?>