<?php

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");

	function key_format($chave){
		if(!$chave) return false;
		if(strlen($chave) == 44){
			return substr($chave, 0,2) . "." . substr($chave, 2,4) . "." . substr($chave, 6,2) . "." . substr($chave, 8,3) . "." . substr($chave, 11,3) . "/" . substr($chave, 14, 4) . "-" . substr($chave, 18,2) . "-" . substr($chave, 20,2) . "-" . substr($chave, 22,3) . "-" . substr($chave, 25,3) . "." . substr($chave, 28,3) . "." . substr($chave, 31,3) . "-" . substr($chave, 34,3) . "." . substr($chave, 37,3) . "." . substr($chave, 40,3) . "-" . substr($chave, 43,1);
		}
	}
	
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	$datapacket = new TParams();

	if(!isset($_REQUEST['not_codigo']) || empty($_REQUEST['not_codigo'])){
		echo "Informar o código da NF-e";
		return false;
	}else{
		$not_codigo = $_REQUEST['not_codigo'];
	}

	$filtro = '{"cod":"700002","params":[
		{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
		{"name":"db","value":"'.$datapacket->getCompany()->emp_db_comum.'","type":"other"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	$datapacket->clear();
	
		$filtroTransp = '{"cod":"500002","params":[
			{"name":"cad_codigo","value":"'.$rowdata[0]->{'cad_codtransp'}.'","type":"string"}
		]}';
		//pega dados da transportadora
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtroTransp);
		$transportadora = $datapacket->open(true);

	?>

		<html>

			<head>
				<title></title>
				<meta charset="UTF-8">
				<style type="text/css">
					body{
						margin: 0;
						padding: 0px;
						font-size: 11px;
						font-family:Times;
					}
				</style>
			</head>
		
			<body>
				<div style="width:100%; float:right; border:1px solid #000; border-radius:5px;">
					<div style="width:18%; float:right; border-left:1px solid #000; font-size:10px; text-align:center; font-weight:bold; height:57px; padding:5px; font-size:14px;">
						<b style="font-size:18px;">NF-e</b><br>
						N&ordm; <?php echo $rowdata[0]->{'not_numero'}; ?><br>
						Série: <?php echo $rowdata[0]->{'ser_codigo'}; ?>
					</div>
					<div style="width:80%; float:left;">
						<div style="width:100%; float:left; border-bottom:1px solid #000; border-left:1px solid #000; font-size:10px; line-height:10px; height:35px;">
								RECEBEMOS DE <?php echo $rowdata[0]->{'cad_nomeraz'}; ?> OS PRODUTOS E/OU SERVIÇOS CONSTANTES DA NOTA FISCAL ELETRÔNICA INDICADA
								ABAIXO. EMISSÃO: <?php echo implode("/", array_reverse(explode("-",substr($rowdata[0]->{'not_data'},0,10)))); ?> VALOR TOTAL: R$ <?php echo number_format($rowdata[0]->{'not_totalnota'},2,",",""); ?> DESTINATÁRIO: 
								<?php echo $datapacket->getCompany()->emp_razao; ?> - <?php echo $datapacket->getCompany()->emp_endereco; ?>, <?php echo $datapacket->getCompany()->emp_num; ?> - 
								<?php echo $datapacket->getCompany()->emp_bairro; ?> <?php echo $datapacket->getCompany()->emp_cidade; ?>-<?php echo $datapacket->getCompany()->emp_uf; ?>
						</div>
						<div style="width:24.3%; float:left; border-left:1px solid #000; font-size:10px; line-height:10px; height:30px;">
							DATA DE RECEBIMENTO
						</div>
						<div style="width:75%; float:left; border-left:1px solid #000;  font-size:10px; line-height:10px; height:30px;">
							IDENTIFICAÇÃO E ASSINATURA DO RECEBEDOR
						</div>
					</div>
				</div>
				
				<br style="clear:both">
				<!--emitente-->
				<div style="width:100%; float:right; border:1px solid #000; border-radius:5px;">
					<div style="width:39%; float:left; border-left:1px solid #000; border-bottom:1px solid #000;;font-size:10px; text-align:center; height:120px; padding:0 5px;">
						IDENTIFICAÇÃO DO EMITENTE<br><br>
						<b style="font-size:16px"><?php echo $rowdata[0]->{'cad_nomeraz'}; ?></b><br>
						<?php echo $rowdata[0]->{'end_nome'}; ?>, <?php echo $rowdata[0]->{'end_num'}; ?><br>
						<?php echo $rowdata[0]->{'end_bairro'}; ?> - <?php echo $rowdata[0]->{'end_cep'}; ?><br>
						<?php echo $rowdata[0]->{'end_cidade'}; ?> - <?php echo $rowdata[0]->{'end_uf'}; ?> Fone: <?php echo "(".$rowdata[0]->{'tel_ddd'}.") ".$rowdata[0]->{'tel_prefixo'}."-".$rowdata[0]->{'tel_numero'}; ?><br>
					</div>
					<div style="width:15%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:10px; text-align:center; height:120px; padding:0 5px;">
						<b style="font-size:18px">DANFE</b><br>
						<b>Documento Auxiliar de Nota Fiscal Eletrônica</b><br>
						<div style="float:right; border:1px solid #000; padding:5px;">1</div>
						<div style="float:left;margin-left:5px;">0 - ENTRADA</div><br>
						<div style="float:left;margin-left:5px;">1 - SAÍDA</div>
						<br style="clear:both"><br>
						<b style="font-size:13px">N&ordm; <?php echo $rowdata[0]->{'not_numero'}; ?></b><br>
						<b style="font-size:13px">Série: <?php echo $rowdata[0]->{'ser_codigo'}; ?></b>
					</div>
					<div style="width:40.8%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:10px; text-align:center; height:50px; padding:5px;">
						<img src="img-codbarras.php?cod=<?php echo $rowdata[0]->{'not_key_nfe'}; ?>" style="width:290px; height:50px;margin-top:2px;">
					</div>
					<div style="width:42.3%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; border-bottom:1px solid #000; font-size:10px; height:30px;">
						CHAVE DE ACESSO<br>
						<center style="margin-top:5px"><b><?php echo key_format($rowdata[0]->{'not_key_nfe'}); ?></b></center>
					</div>
					<div style="width:42.3%; float:left; border-left:1px solid #000; border-bottom:1px solid #000;font-size:10px; height:26px; text-align:center">
						Consulta de Autenticidade no portal nacional da NF-e<br>
						www.nfe.fazenda.gov.br/portal ou no site da Sefaz Autorizadora
					</div>
					
					<div style="width:55.5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000;font-size:10px; height:26px; padding:0 5px;">
						NATUREZA DA OPERAÇÃO<br>
						<center style="font-weight:bold;margin-top:5px;"><?php echo str_replace(array("1","2"), array("5", "6"), substr($rowdata[0]->{'cfo_codigo'},0,1)).substr($rowdata[0]->{'cfo_codigo'},1)." - ".substr($rowdata[0]->{'cfo_descr'},0,70); ?></center>
					</div>
					<div style="width:41%; float:left; border-left:1px solid #000; border-bottom:1px solid #000;font-size:10px; height:26px; padding:0 5px;">
						PROTOCOLO DE AUTORIZAÇÃO<br>
						<center style="font-weight:bold;margin-top:5px;"><?php echo $rowdata[0]->{'not_nprot'}." - ".implode("/", array_reverse(explode("-",substr($rowdata[0]->{'not_dtemissao'},0,10)))); ?></center>
					</div>
					<div style="width:33.3%; float:left; border-left:1px solid #000; font-size:10px; height:26px; padding:0 5px;">
						INSCR. ESTADUAL<br>
						<center style="font-weight:bold;margin-top:1px; font-size:13px"><?php echo $rowdata[0]->{'cad_inscrg'}; ?></center>
					</div>
					<div style="width:28.1%; float:left; border-left:1px solid #000; font-size:10px; height:26px; padding:0 5px;">
						INSCR. EST. SUBST.<br>
					</div>
					<div style="width:33.3%; float:left; border-left:1px solid #000; font-size:10px; height:26px; padding:0 5px;">
						CNPJ<br>
						<center style="font-weight:bold;margin-top:1px; font-size:13px"><?php echo maskCnpjCpf($rowdata[0]->{'cad_cnpjcpf'}); ?></center>
					</div>
				</div>
				
				<br style="clear:both">
				<!--destinatario-->
				
				<b style="line-height:20px">DESTINATÁRIO/ REMETENTE</b><br>
				<div style="width:100%; float:right; border:1px solid #000; border-radius:5px;">
					<div style="width:59.5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding:0 5px;">
						NOME/ RAZÃO SOCIAL<br>
						<b style="font-weight:bold;line-height:16px"><?php echo $datapacket->getCompany()->emp_razao; ?></b>
					</div>
					<div style="width:20%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding:0 5px;">
						CNPJ/ CPF<br>
						<center style="font-weight:bold;line-height:16px;font-weight:bold"><?php echo maskCnpjCpf($datapacket->getCompany()->emp_cpfcnpj); ?></center>
					</div>
					<div style="width:15.3%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding:0 5px;">
						DATA DA EMISSÃO<br>
						<center style="font-weight:bold;line-height:16px;font-weight:bold"><?php echo implode("/", array_reverse(explode("-",substr($rowdata[0]->{'not_dtemissao'},0,10)))); ?></center>
					</div>
					<div style="width:45.8%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding:0 5px;">
						ENDEREÇO<br>
						<b style="font-weight:bold;line-height:16px"><?php echo $datapacket->getCompany()->emp_endereco.", ".$datapacket->getCompany()->emp_num." ".$datapacket->getCompany()->emp_complem; ?></b>
					</div>
					<div style="width:20%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding:0 5px;">
						BAIRRO/ DISTRITO<br>
						<center style="font-weight:bold;line-height:16px"><?php echo substr($datapacket->getCompany()->emp_bairro,0,20); ?></center>
					</div>
					<div style="width:12%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding:0 5px;">
						CEP<br>
						<center style="font-weight:bold;line-height:16px"><?php echo $datapacket->getCompany()->emp_cep; ?></center>
					</div>
					<div style="width:15.4%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding:0 5px;">
						DATA DA SAÍDA<br>
						<center style="font-weight:bold;line-height:16px;font-weight:bold"><?php echo implode("/", array_reverse(explode("-",substr($rowdata[0]->{'not_data'},0,10)))); ?></center>
					</div>
					<div style="width:45.8%; float:left; border-left:1px solid #000; height:26px; padding:0 5px;">
						MUNICÍPIO<br>
						<b style="font-weight:bold;line-height:16px"><?php echo $datapacket->getCompany()->emp_cidade; ?></b>
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; height:26px; padding:0 5px;">
						UF<br>
						<center style="font-weight:bold;line-height:16px"><?php echo $datapacket->getCompany()->emp_uf; ?></center>
					</div>
					<div style="width:10.3%; float:left; border-left:1px solid #000; height:26px; padding:0 5px;">
						TELEFONE<br>
						<center style="font-weight:bold;line-height:16px"><?php echo $datapacket->getCompany()->emp_fone; ?></center>
					</div>
					<div style="width:15%; float:left; border-left:1px solid #000; height:26px; padding:0 5px;">
						INSCR. ESTADUAL<br>
						<center style="font-weight:bold;line-height:16px"><?php echo $datapacket->getCompany()->emp_inscrg; ?></center>
					</div>
					<div style="width:15.4%; float:left; border-left:1px solid #000; height:26px; padding:0 5px;">
						HORA DA SAÍDA<br>
					</div>
				</div>
				
				<br style="clear:both">
				<!--imposto-->
				<b style="line-height:20px">CÁLCULO DO IMPOSTO</b><br>
				<div style="width:100%; float:right; border:1px solid #000; border-radius:5px;">
					<div style="width:14%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						BASE CÁLC. ICMS<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo number_format($rowdata[0]->{'not_totbaseicms'},2,",",""); ?></b>
					</div>
					<div style="width:14%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						VALOR ICMS<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo number_format($rowdata[0]->{'not_toticms'},2,",",""); ?></b>
					</div>
					<div style="width:14%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						VALOR ICMS ST<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo number_format($rowdata[0]->{'not_totbaseicmsst'},2,",",""); ?></b>
					</div>
					<div style="width:14%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						VALOR IPI<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo number_format($rowdata[0]->{'not_totipi'},2,",",""); ?></b>
					</div>
					<div style="width:14%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						VALOR PIS<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo "0,00"; ?></b>
					</div>
					<div style="width:24%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						VALOR TOTAL PRODUTOS<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo number_format($rowdata[0]->{'not_totalprod'},2,",",""); ?></b>
					</div>
					<div style="width:14%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						VALOR FRETE<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo number_format($rowdata[0]->{'not_frete'},2,",",""); ?></b>
					</div>
					<div style="width:14%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						VALOR SEGURO<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo number_format($rowdata[0]->{'not_seguro'},2,",",""); ?></b>
					</div>
					<div style="width:14%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						DESCONTO<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo number_format($rowdata[0]->{'not_valordesc'},2,",",""); ?></b>
					</div>
					<div style="width:14%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						OUT. DESPESAS<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo number_format($rowdata[0]->{'not_despesa'},2,",",""); ?></b>
					</div>
					<div style="width:14%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						VALOR COFINS<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:16px;"><?php echo "0,00"; ?></b>
					</div>
					<div style="width:24%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						VALOR TOTAL NOTA<br>
						<b style="font-weight:bold;line-height:16px;float:right; font-size:21px;"><?php echo number_format($rowdata[0]->{'not_totalnota'},2,",",""); ?></b>
					</div>
				</div>
				
				<br style="clear:both">
				<!--transporte-->
				<b style="line-height:20px">TRANSPORTADOR/ VOLUMES TRANSPORTADOS</b><br>
				<div style="width:100%; float:right; border:1px solid #000; border-radius:5px;">
					<div style="width:34%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						NOME/ RAZÃO SOCIAL<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo (isset($transportadora) && isset($transportadora[0]->{"cad_nomeraz"})) ? substr($transportadora[0]->{"cad_nomeraz"},0,40) : ""; ?></b>
					</div>
					<div style="width:14%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						TIPO FRETE<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo "(9) Sem Frete"; ?></b>
					</div>
					<div style="width:18.5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						PLACA<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo ( isset($rowdata[0]->{"not_placa"}) ) ? $rowdata[0]->{"not_placa"} : ""; ?></b>
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						UF<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo (isset($transportadora) && isset($transportadora[0]->{"end_uf"})) ? $transportadora[0]->{"end_uf"} : ""; ?></b>
					</div>
					<div style="width:24%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						CNPJ/ CPF<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo (isset($transportadora) && isset($transportadora[0]->{"cad_cnpjcpf"})) ? maskCnpjCpf($transportadora[0]->{"cad_cnpjcpf"}) : ""; ?></b>
					</div>
					<div style="width:39%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						ENDEREÇO<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo (isset($transportadora) && isset($transportadora[0]->{"end_nome"})) ? substr($transportadora[0]->{"end_nome"},0,40) : ""; ?></b>
					</div>
					<div style="width:28%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						MUNICÍPIO<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo (isset($transportadora) && isset($transportadora[0]->{"end_cidade"})) ? substr($transportadora[0]->{"end_cidade"},0,40) : ""; ?></b>
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						UF<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo (isset($transportadora) && isset($transportadora[0]->{"end_uf"})) ? $transportadora[0]->{"end_uf"} : ""; ?></b>
					</div>
					<div style="width:24%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; height:26px; padding-right:5px">
						INSCR ESTADUAL<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo (isset($transportadora) && isset($transportadora[0]->{"cad_inscrg"})) ? substr($transportadora[0]->{"cad_inscrg"},0,40) : ""; ?></b>
					</div>
					<div style="width:9%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						QTDE<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo ( isset($rowdata[0]->{"not_qtde"})) ? $transportadora[0]->{"not_qtde"} : ""; ?></b>
					</div>
					<div style="width:15%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						ESPÉCIE<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo ( isset($rowdata[0]->{"not_especie"})) ? $transportadora[0]->{"not_especie"} : ""; ?></b>
					</div>
					<div style="width:15%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						MARCA<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo ( isset($rowdata[0]->{"not_marca"})) ? $transportadora[0]->{"not_marca"} : ""; ?></b>
					</div>
					<div style="width:15%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						NUMERAÇÃO<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo ( isset($rowdata[0]->{"not_nro"})) ? $transportadora[0]->{"not_nro"} : ""; ?></b>
					</div>
					<div style="width:20%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						PESO BRUTO<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo ( isset($rowdata[0]->{"not_pesobruto"})) ? $transportadora[0]->{"not_pesobruto"} : ""; ?></b>
					</div>
					<div style="width:20%; float:left; border-left:1px solid #000; height:26px; padding-right:5px">
						PESO LÍQ.<br>
						<b style="font-weight:bold;line-height:16px; font-size:16px;"><?php echo ( isset($rowdata[0]->{"not_pesoliquido"})) ? $transportadora[0]->{"not_pesoliquido"} : ""; ?></b>
					</div>
				</div>
				
				<br style="clear:both">
				<!--transporte-->
				<b style="line-height:20px">DADOS DOS PRODUTOS/ SERVIÇOS</b><br>
				<div style="width:100%; border:1px solid #000; border-radius:5px; height:400px;">
					<div style="width:8%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						CODIGO
					</div>
					<div style="width:30%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						DESCRIÇÃO DO PRODUTO
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						NCM/ SH
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						O/ CST
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						CFOP
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						UN
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						QUANT
					</div>
					<div style="width:7%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						VALOR UNIT
					</div>
					<div style="width:7%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						VALOR TOTAL
					</div>
					<div style="width:6%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						BASE ICMS
					</div>
					<div style="width:6%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						VALOR ICMS
					</div>
					<div style="width:6%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						VALOR IPI
					</div>
					<div style="width:3%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:20px;">
						ALIQ ICMS
					</div>
					<?php
						foreach($rowdata as $r){
							$tribjson = json_decode(base64_decode($r->{"itn_tribjson"}));
					?>
					<div style="width:8%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px; text-align:center">
						<?php echo $r->ref_codigo;?>
					</div>
					<div style="width:30%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo substr($r->itn_descr,0,40);?>
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo $r->itn_ncm;?>
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo str_pad($tribjson->{"rowdata"}[0]->{"tri_situacao"}, 2, "0", STR_PAD_LEFT);?>
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo $tribjson->{"rowdata"}[0]->{"ref_cfop"};?>
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo ($r->uni_codigo) ? $r->uni_codigo : "UN";?>
					</div>
					<div style="width:5%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo number_format($r->itn_qtde,2,"'","");?>
					</div>
					<div style="width:7%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo number_format($r->itn_valor,2,"'","");?>
					</div>
					<div style="width:7%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo number_format($r->itn_subtotal,2,"'","");?>
					</div>
					<div style="width:6%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo number_format($r->itn_bseicms,2,"'","");?>
					</div>
					<div style="width:6%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo number_format($r->itn_icms,2,"'","");?>
					</div>
					<div style="width:6%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo number_format($r->itn_ipi,2,"'","");?>
					</div>
					<div style="width:3%; float:left; border-left:1px solid #000; border-bottom:1px solid #000; font-size:9px; height:15px;">
						<?php echo number_format($r->itn_aliqicms,2,"'","");?>
					</div>
					<?php
						}
					?>
				</div>
				
			</body>

		</html>

	<?php
	
	
	// $html = ob_get_clean();
	// $arquivo = str_replace(array(".",","), "", microtime(true));
	// $fp = fopen($datapacket->getHostRoot()."tmp/".$arquivo.'.html', 'w');
	// fwrite($fp, $html);
	// fclose($fp);
	// exec($datapacket->getHostRoot().'class/phantomjs/bin/phantomjs '.$datapacket->getHostRoot().'class/phantomjs/rasterizedamdfe.js '.$datapacket->getHostRoot().'tmp/'.$arquivo.'.html '.$datapacket->getHostRoot().'tmp/'.$arquivo.'.pdf ["7,5in*5in"] ');

	// if(file_exists($datapacket->getHostRoot()."tmp/".$arquivo.'.pdf')){
	// 	echo "/desktop/tmp/".$arquivo.'.pdf';
	// }else{
	// 	echo "Ocorreu um erro ao gerar o arquivo.";
	// }

	// unlink(dirname(__DIR__) ."/tmp/". $img.'.png');

?>