<?php

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	include_once '../php/phpnfe/libs/qrcode/qrcode.class.php';
	
	$datapacket = new TParams();
	
	if($datapacket->getCompany()->{"emp_amb_nfse"} == 1){
		$varAmb = 'producao';
	}else{
		$varAmb = 'homologacao';
	}
	if(!is_dir($datapacket->uploads.$datapacket->getCompany()->emp_codigo.'/nfse/'.$varAmb)){
		mkdir($datapacket->uploads.$datapacket->getCompany()->emp_codigo.'/nfse/'.$varAmb, 0777, true);
	}
	if(!is_dir($datapacket->uploads.$datapacket->getCompany()->emp_codigo.'/nfse/'.$varAmb.'/qrcode')){
		mkdir($datapacket->uploads.$datapacket->getCompany()->emp_codigo.'/nfse/'.$varAmb.'/qrcode', 0777, true);
	}
	if(!is_dir($datapacket->uploads.$datapacket->getCompany()->emp_codigo.'/nfse/'.$varAmb.'/qrcode/'.date('Ym'))){
		mkdir($datapacket->uploads.$datapacket->getCompany()->emp_codigo.'/nfse/'.$varAmb.'/qrcode/'.date('Ym'), 0777, true);
	}

	/* Validacao dos parametros necessarios */
	if(!isset($_REQUEST['nfs_codigo']) || empty($_REQUEST['nfs_codigo'])){
		exit("Informar o código da NFS-e");
	}else{
		$nfs_codigo = $_REQUEST['nfs_codigo'];
	}

	$filtro = '{"cod":"500001","params":[
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
		{"name":"nfs_codigo","value":"'.$nfs_codigo.'","type":"string"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	$datapacket->clear();
	
	$arquivo = $rowdata[0]->nfs_nronfse."-nfse";
	$localDir = $datapacket->uploads.$datapacket->getCompany()->emp_codigo.'/nfse/'.$varAmb.'/autorizadas/'.str_replace("-", "",substr($rowdata[0]->nfs_dtemissao,0,7)).'/'.$arquivo;
	
	//QR Code
	//Maringa
	if($datapacket->getCompany()->emp_codmun=="4115200"){
		$imgQrCode = new QRcode('http://isse.maringa.pr.gov.br/app/print/nfe/'.$datapacket->getCompany()->emp_cpfcnpj.'/'.$rowdata[0]->nfs_nronfse.'/'.$rowdata[0]->nfs_codver, 'M');
	//Sarandi
	}elseif($datapacket->getCompany()->emp_codmun=="4126256"){
		$imgQrCode = ( isset($rowdata[0]->nfs_xml) && $rowdata[0]->nfs_xml!=" " ) ? new QRcode(base64_decode($rowdata[0]->nfs_xml), 'M') : "";
	//Porto Rico
	}elseif($datapacket->getCompany()->emp_codmun=="4120200"){
		$imgQrCode = new QRcode('http://portorico.oxy.elotech.com.br/iss/autenticar-documento-fiscal?cpfCnpjPrestador='.$datapacket->getCompany()->emp_cpfcnpj.'&numeroNFSe='.$rowdata[0]->nfs_nronfse.'&codigoAutenticidade='.$rowdata[0]->nfs_codver.'&dataEmissao='.substr($rowdata[0]->nfs_dtemissao,0,10), 'M');
	}else{
		$imgQrCode="";
	}
	if($imgQrCode && $imgQrCode!=""){
		$filename = $datapacket->uploads.$datapacket->getCompany()->emp_codigo.'/nfse/'.$varAmb.'/qrcode/'.date('Ym').'/'.$rowdata[0]->nfs_nronfse.'.png';
		$imgQrCode->displayPNG(200, array(255,255,255), array(0,0,0), $filename, 0);
	}
	
	
	//Maringa (baixo o PDF igual da prefeitura)
	if($datapacket->getCompany()->emp_codmun=="4115200"){
		if($datapacket->getCompany()->{"emp_amb_nfse"} == 1){
			$pdfUrl = 'https://nfse.ecity.maringa.pr.gov.br/ImprimirNfse/'.$rowdata[0]->nfs_nronfse.'/'.$datapacket->getCompany()->emp_cpfcnpj.'/'.$rowdata[0]->nfs_codver;
		}else{
			$pdfUrl = 'https://nfse.hom-ecity.maringa.pr.gov.br/ImprimirNfse/'.$rowdata[0]->nfs_nronfse.'/'.$datapacket->getCompany()->emp_cpfcnpj.'/'.$rowdata[0]->nfs_codver;
		}
		
		$fileContent = file_get_contents($pdfUrl);
		if ($fileContent === false) die('Erro ao baixar o PDF.');

		file_put_contents($localDir.'.pdf', $fileContent);
	}else{
		
		$cabecalho = ($datapacket->getCompany()->emp_codmun=="4117503") ? "Secretaria de Finanças - Divisão de Fiscalização" : "Secretaria Municipal de Fazenda";
		$logo = "https://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $datapacket->getCompany()->{"emp_codigo"} . "/" . $datapacket->getCompany()->{"emp_logo"};
		$logo2 = $datapacket->uploads . $datapacket->getCompany()->{"emp_codigo"} . "/" . $datapacket->getCompany()->{"emp_logo"};
		$natOp="";
		switch($rowdata[0]->nfs_exigibilidadeiss){
			case 1:
				$natOp = "Exigível";
				break;
			case 2:
				$natOp = "Não Incidência";
				break;
			case 3:
				$natOp = "Isenção";
				break;
			case 4:
				$natOp = "Exportação";
				break;
			case 5:
				$natOp = "Imunidade";
				break;
			case 6:
				$natOp = "Exi. Suspensa Judicialmente";
				break;
			case 7:
				$natOp = "Exi. Suspensa por Processo";
				break;
		}
		?>

			<html>

				<head>
					<title>NFS-e - Fácil Online - JC Mantovan</title>
					<meta charset="UTF-8">
					<style type="text/css">
						body{
							margin: 0;
							padding: 0px;
							font-size: 12px;
							font-family: Arial, Verdana, sans-serif;
						}
						#cencelada{
							-moz-transform: rotate(326deg);
							-webkit-transform: rotate(326deg);
							-o-transform: rotate(326deg);
							-ms-transform: rotate(326deg);
							transform: rotate(326deg);
							color: rgba(245, 125, 125, 0.5);
							position:absolute; top:50%;
							left:50%;
							margin:-100px 0px 0px -300px;
							font-size:100px;
						}
					</style>
				</head>
			
				<body>
					<?php
						//tarja nota cancelada
						if( $rowdata[0]->nfs_situacao==3 ){
					?>
						<div id="cencelada">CANCELADA</div>
					<?php
						}
					?>
					<div style="width:99.5%; float:left; border:1px solid #000; height:75px">

						<div style="width: 55%; float: left; font-size: 15px; font-weight: bold; height: 65px; padding-top:10px">
							<img src="http://<?php echo $_SERVER['SERVER_NAME']?>/desktop/php/phpnfe/images/NFSe/<?php echo $datapacket->getCompany()->emp_codmun?>/brasao.jpg" style="float:left; width:55px; margin-left:4px;">
							Prefeitura do Município de <?php echo ucwords(strtolower($datapacket->getCompany()->emp_cidade)); ?><br>
							<span style="font-weight:normal"><?php echo $cabecalho ;?></span><br>
							Nota Fiscal de Serviços Eletrônica - NFS-e
						</div>
						
						<div style="width: 17%; border-left: 1px solid #000; float: left; font-size: 12px; padding-left:4px; height: 65px; padding-top:10px">
							Número<br>
							Código Verificação<br>
							Emitida em
						</div>
						
						<div style="width:27%;float: left; font-size: 12px; font-weight:bold;  height: 65px; padding-top:10px ">
							<img src="http://<?php echo $_SERVER['SERVER_NAME']?>/desktop/php/phpnfe/images/NFSe/<?php echo $datapacket->getCompany()->emp_codmun?>/nfse.jpg" style="float:right; width:50px; margin-right:4px;">
							<?php echo $rowdata[0]->nfs_nronfse; ?><br>
							<span style="font-family:Times"><?php echo $rowdata[0]->nfs_codver ;?></span><br>
							<?php echo implode("/", array_reverse(explode("-",substr($rowdata[0]->nfs_dtemissao, 0, 10)))).substr($rowdata[0]->nfs_dtemissao, 10) ;?>
						</div>

					</div>
					
					<div style="width:99.5%; float:left; border:1px solid #000; height:22px; line-height:22px; font-weight:bold;border-top:none; text-indent:10px">
						RPS N&ordm; <?php echo $rowdata[0]->nfs_nrorps;?> Série <?php echo $rowdata[0]->nfs_serierps;?> de <?php echo implode("/", array_reverse(explode("-",substr($rowdata[0]->nfs_dtprestacao,0,10))));?>
					</div>
					
					<!--Prestador-->
					<div style="width:99.5%; float:left; border:1px solid #000; height:170px; border-top:none;">
						<div style="width:18%; float:left;">&nbsp;
						<?php
							if(is_file($logo2) && file_exists($logo2)){
						?>
							<img src="<?php echo $logo2?>" style="float:left; width:110px; margin:30px 0px 0px 4px;">
						<?php
							}
						?>
						</div>
						<div style="width:80%; padding-top:5px; overflow:hidden;">
							
							<b>&nbsp;Prestador de Serviços</b><br><br>
							<div style="float:left; width:17%; margin-left:4px">
								CNPJ:<br>
								Razão Social:<br>
								Nome Fantasia:<br>
								Endereço:<br>
								Município:<br>
								CEP:<br>
								Fone:<br>
								E-mail:
							</div>
							<div style="float:left; width:60%">
								<b><?php echo maskCNPJCPF($datapacket->getCompany()->emp_cpfcnpj);?></b><br>
								<b><?php echo substr($datapacket->getCompany()->emp_razao,0,40);?></b><br>
								<b><?php echo substr($datapacket->getCompany()->emp_fantasia,0,40);?></b><br>
								<b><?php echo ucwords(strtolower(substr($datapacket->getCompany()->emp_endereco,0,21).", ".$datapacket->getCompany()->emp_num." - ".substr($datapacket->getCompany()->emp_bairro,0,21)));?></b><br>
								<b><?php echo ucwords(strtolower($datapacket->getCompany()->emp_cidade))." - ".$datapacket->getCompany()->emp_uf;?></b><br>
								<b><?php echo formataCEP($datapacket->getCompany()->emp_cep);?></b><br>
								<b><?php echo telefone($datapacket->getCompany()->emp_fone);?></b><br>
								<b><?php echo $datapacket->getCompany()->emp_email;?></b>
							</div>
							<?php
								if( file_exists($datapacket->uploads . $datapacket->getCompany()->{"emp_codigo"}.'/nfse/'.$varAmb.'/qrcode/'.date("Ym").'/'.$rowdata[0]->nfs_nronfse.'.png') ){
							?>
							<img src="http://<?php echo $_SERVER['SERVER_NAME'].'/uploads/'.$datapacket->getCompany()->{'emp_codigo'}.'/nfse/'.$varAmb.'/qrcode/'.date("Ym").'/'.$rowdata[0]->nfs_nronfse.'.png';?>" width="110" height="110" style="margin-top:2px;float:right">
							<?php
								}
							?>
						</div>
					</div>
					
					<!--Tomador-->
					<div style="width:99.5%; float:left; border:1px solid #000; height:150px; border-top:none; padding-top:5px">
						<b>&nbsp;Tomador de Serviços</b><br><br>
						<div style="float:left; width:14%; margin-left:4px">
							CPF/CNPJ:<br>
							Razão Social:<br>
							Endereço:<br>
							Município:<br>
							CEP:<br>
							Fone:<br>
							E-mail:
						</div>
						<div style="float:left; width:76%">
							<b><?php echo maskCNPJCPF($rowdata[0]->tom_cnpjcpf);?></b><br>
							<b><?php echo substr($rowdata[0]->tom_nomeraz,0,60);?></b><br>
							<b><?php echo ucwords(strtolower(substr($rowdata[0]->end_nome,0,21).", ".$rowdata[0]->end_num." - ".substr($rowdata[0]->end_bairro,0,21)));?></b><br>
							<b><?php echo ucwords(strtolower($rowdata[0]->end_cidade))." - ".$rowdata[0]->end_uf;?></b><br>
							<b><?php echo formataCEP($rowdata[0]->end_cep);?></b><br>
							<b><?php echo telefone($rowdata[0]->tel_ddd.$rowdata[0]->tel_prefixo.$rowdata[0]->tel_numero);?></b><br>
							<b><?php echo $rowdata[0]->tom_email;?></b>
						</div>
					</div>
					
					<!--serviços-->
					<div style="width:99.5%; float:left; border:1px solid #000; height:400px; border-top:none; padding-top:5px">
						<div style="margin-left:4px">
							<b>Discriminação dos Serviços</b><br><br>
							<?php echo utf8_encode(base64_decode($rowdata[0]->nfs_descrserv));?>
						</div>
					</div>
					
					<div style="width:99.5%; float:left; border:1px solid #000; height:22px; line-height:22px; font-weight:bold;border-top:none; font-size:16px;">
					<div style="width:45%; border-left:1px solid #000; float:right;padding-left:4px">
							R$ <?php echo valorFormat($rowdata[0]->nfs_vlrservico);?>
						</div>
						<div style="width:50%; margin-left:4px; float:left;">
							Valor Total da NFS-e
						</div>
					</div>
					
					<div style="width:99.5%; float:left; border:1px solid #000; height:50px; line-height:16px;border-top:none;">
						<div style="margin-left:4px;">
							<b>Código de tributação</b><br>
							<?php echo substr($rowdata[0]->nfs_coditnlistserv,0,2).".".substr($rowdata[0]->nfs_coditnlistserv,2)." - ".htmlentities($rowdata[0]->atv_descr);?>
						</div>
					</div>
					
					<div style="width:99.5%; float:left; border:1px solid #000; height:40px; line-height:17px;border-top:none; ">
						<div style="width:18%; margin-left:4px; float:left; padding-top:5px;">
							Valor Total Deduções<br>
							<b><?php echo valorFormat($rowdata[0]->nfs_vlrdeducao);?></b>
						</div>
						<div style="width:18%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Base de Cálculo<br>
							<b><?php echo valorFormat($rowdata[0]->nfs_vlrservico);?></b>
						</div>
						<div style="width:18%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Alíquota (%)<br>
							<b><?php echo valorFormat($rowdata[0]->nfs_aliqiss);?></b>
						</div>
						<div style="width:18%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Valor do ISSQN<br>
							<b><?php echo valorFormat(($rowdata[0]->nfs_vlrservico-$rowdata[0]->nfs_vlrdeducao)*$rowdata[0]->nfs_aliqiss/100);?></b>
						</div>
						<div style="width:18%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Valor Líquido NFS-e<br>
							<b><?php echo number_format($rowdata[0]->nfs_vlrservico - ($rowdata[0]->nfs_vlrpis+$rowdata[0]->nfs_vlrcofins+$rowdata[0]->nfs_vlrinss+$rowdata[0]->nfs_vlrir+$rowdata[0]->nfs_vlrcsll+$rowdata[0]->nfs_vlrissret), 2, ",","");?></b>
						</div>
					</div>
					
					<div style="width:99.5%; float:left; border:1px solid #000; height:40px; line-height:17px;border-top:none; ">
						<div style="width:18%; margin-left:4px; float:left; padding-top:5px;">
							Valor do PIS<br>
							<b><?php echo valorFormat($rowdata[0]->nfs_vlrpis);?></b>
						</div>
						<div style="width:18%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Valor da COFINS<br>
							<b><?php echo valorFormat($rowdata[0]->nfs_vlrcofins);?></b>
						</div>
						<div style="width:18%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Valor do INSS<br>
							<b><?php echo valorFormat($rowdata[0]->nfs_vlrinss);?></b>
						</div>
						<div style="width:18%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Valor do IRRF<br>
							<b><?php echo valorFormat($rowdata[0]->nfs_vlrir);?></b>
						</div>
						<div style="width:18%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Valor da CSLL<br>
							<b><?php echo valorFormat($rowdata[0]->nfs_vlrcsll);?></b>
						</div>
					</div>
					
					<div style="width:99.5%; float:left; border:1px solid #000; height:40px; line-height:17px;border-top:none; ">
						<div style="width:10%; margin-left:4px; float:left; padding-top:5px;">
							Competência<br>
							<b><?php echo implode("/", array_reverse(explode("-",substr($rowdata[0]->nfs_dtprestacao,0,7))));?></b>
						</div>
						<div style="width:15%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Optante Simples<br>
							<b><?php echo ($datapacket->getCompany()->emp_codregtrib==1) ? "Sim" : "Não";?></b>
						</div>
						<div style="width:12%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Situação<br>
							<b>Normal</b>
						</div>
						<div style="width:18%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Município Credor<br>
							<b><?php
								if( isset($rowdata[0]->mun_cidade) && $rowdata[0]->mun_cidade!="" ){
									echo ucwords(strtolower($rowdata[0]->mun_cidade))." - ".$rowdata[0]->mun_uf_sigla;
								}else{
									echo ucwords(strtolower($datapacket->getCompany()->emp_cidade))." - ".$datapacket->getCompany()->emp_uf;
								}
								?>
							</b>
						</div>
						<div style="width:20%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Natureza da Operação<br>
							<b><?php echo $rowdata[0]->nfs_exigibilidadeiss." - ".substr($natOp,0,18);?></b>
						</div>
						<div style="width:17%; margin-left:4px; float:left; border-left:1px solid #000;padding:5px 0px 0px 4px;">
							Resp. Recolhimento<br>
							<b><?php echo ($rowdata[0]->nfs_responsavel==1) ? "Prestador" : "Tomador";?></b>
						</div>
					</div>
					
					<div style="width:99.5%; float:left;border:1px solid #000; height:80px; line-height:17px;border-top:none;">
						<div style="margin-left:4px;">
							Outras Informações<br>
							
						</div>
					</div>

				</body>

			</html>

		<?php

			if(!isset($logo)) $logo = "";
			if(!isset($data)) $data = "";
			if(!isset($titulo)) $titulo = "";
			if(!isset($relatorioTitle)) $relatorioTitle = "";
			if(!isset($filtros)) $filtros = "";
			if(!isset($colunas)) $colunas = "";
			if(!isset($cabecalhoHeight)) $cabecalhoHeight = "0";
			$html = ob_get_clean();
			
			$fp = fopen($localDir.'.html', 'w');
			fwrite($fp, $html);
			fclose($fp);

			exec($datapacket->getHostRoot().'class/phantomjs/bin/phantomjs '.$datapacket->getHostRoot().'class/phantomjs/rasterizeOs.js '.$localDir.'.html '.$localDir.'.pdf ["7,5in*5in"] "'.$relatorioTitle.'" "'.base64_encode($titulo).'" "'.$data.'" "'.base64_encode(json_encode($filtros)).'" "'.base64_encode(json_encode($colunas)).'" "'.base64_encode($logo).'" "'.$cabecalhoHeight.'"');
	}	
		if(file_exists($localDir.'.pdf')){
			
			//modelo de e-mail (envio de NFS-e)
			if( isset($_REQUEST["email"]) ){
				$filtro = '{"cod":"700268","params":[
					{"name":"dbcomum","value":"'.$datapacket->getCompany()->emp_db_comum.'","type":"other"},
					{"name":"men_codigo","value":"8","type":"integer"}
				]}';
				$datapacket->add($filtro);
				$modelo = $datapacket->open(true);
				$datapacket->clear();
				
				if( date("l")=="Friday" ){
					$data_base = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s")."+ 3 days"));
				}else{
					$data_base = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s")."+ 1 days"));
				}
				$msg_dtenvio = ( isset($_POST["auto"]) && $_POST["auto"]==true ) ? $data_base : date("Y-m-d H:i:s");
				
				$filtro = '{"cod":"700321","params":[
					{"name":"msg_codigo","value":"","type":"string"},
					{"name":"msg_tipo","value":"1","type":"integer"},
					{"name":"men_codigo","value":"8","type":"integer"},
					{"name":"msg_remetente","value":"'.$modelo[0]->men_remetente.'","type":"string"},
					{"name":"msg_destinatario","value":"'.strtolower($_REQUEST["email"]).'","type":"string"},
					{"name":"cad_codigo","value":"'.$rowdata[0]->nfs_tomador.'","type":"string"},
					{"name":"msg_assunto","value":"'.$modelo[0]->men_assunto.'","type":"string"},
					{"name":"msg_conteudo","value":"'.$modelo[0]->men_conteudo.'","type":"string"},
					{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_dtenvio","value":"'.$msg_dtenvio.'","type":"string"},
					{"name":"msg_status","value":"0","type":"integer"},
					{"name":"msg_anexo","value":"","type":"string"}
				]}';

				$datapacket->add($filtro);
				$msg = $datapacket->open(false, true);
				$datapacket->clear();

				if($msg){
					//anexos
					$fields = array(
						'p' => $_REQUEST["p"],
						'acao' => 'anexar',
						'msg_codigo' => $msg,
						'ane_descricao' => base64_encode(utf8_decode("NFS-e N ".$rowdata[0]->nfs_nronfse)),
						'msg_anexo' => new CURLFile($localDir.'.pdf')
					);
					$ch = curl_init();
					curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
					curl_setopt($ch,CURLOPT_POST, true);
					curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
					curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
					curl_exec($ch);
					curl_close($ch);
					$fields = array(
						'p' => $_REQUEST["p"],
						'acao' => 'anexar',
						'msg_codigo' => $msg,
						'ane_descricao' => base64_encode(utf8_decode("NFS-e N ".$rowdata[0]->nfs_nronfse)),
						'msg_anexo' => new CURLFile($localDir.'.xml')
					);
					$ch = curl_init();
					curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
					curl_setopt($ch,CURLOPT_POST, true);
					curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
					curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
					curl_exec($ch);
					curl_close($ch);
					
					//requisição para envio da mensagem
					if( !isset($_POST["auto"]) ){
						$fields = array(
							'p' => $_REQUEST["p"],
							'acao' => 'enviar',
							'msg_codigo' => $msg
						);
						$fields = http_build_query($fields);
						$ch = curl_init();
						curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
						curl_setopt($ch,CURLOPT_POST, true);
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
						$result = curl_exec($ch);
						curl_close($ch);
					}
					exit("ok");
					
				}
				
			}else{

				echo "https://" . $_SERVER["SERVER_NAME"] . "/uploads/".$datapacket->getCompany()->emp_codigo.'/nfse/'.$varAmb.'/autorizadas/'.str_replace("-", "",substr($rowdata[0]->nfs_dtemissao,0,7)).'/'.$arquivo.'.pdf';
			
			}
			
			if(file_exists($localDir.'.html')){
				unlink($localDir.'.html');
			}

		} else {

			echo "Ocorreu um erro ao gerar o arquivo.";
		}
?>