<?php
	header('Content-Type: text/html; charset=utf-8');
	include '../php/datapacket.php';
	include '../php/TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	
	if( isset($_REQUEST["email"]) && $_REQUEST["email"]!="" ){
		ob_start();
	}
	
	if( isset($_REQUEST["opr_codigo"]) ){
		
		
		$filtro = '{"cod":"700577","params":[
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
			{"name":"opr_codigo","value":"'.$_REQUEST["opr_codigo"].'","type":"string"}
		]}';

		$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		
		$company = $TParams->getCompany();
		
		if( isset($ret[0]) ){
			$rendimento = 100 - ($ret[0]["opr_qtdedescarte"]*100)/$ret[0]["opr_qtdeprod"];
			$falta = $ret[0]["opr_qtde"] - $ret[0]["opr_qtdeprod"];
			
?>
<!DOCTYPE HTML>
<html lang="pt-BR">
<head>
	<meta charset="UTF-8">
	<title>Ordem de Produção Nº <?php echo $ret[0]["opr_codigo"]?> - Fácil Online</title>
	<link rel="stylesheet" href="css/ordemServico.css">
	<link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">
	<style>
		*{
			margin:0;
			padding:0;
			font-family:Arial, Verdana, sans-serif;
			font-size:11px;
		}

		body{
			max-width:900px;
			margin:0 auto;
			width:100%;
		}
		table{
			border-collapse: collapse;
		}
		table tr td{
			border: 1px solid #000;
			padding:0px 5px;
			height:20px;
		}
		table tr th{
			padding:0px 5px;
		}
		table tr{
			height:30px;
		}
		#patrimonio tr, #produto tr, #servico tr, #analise tr, #relatorio tr{
			height:23px;
		}

		/*Header*/
		#header{
			width:80%;
			float:left;
			margin-right:8px;
		}
		#logo{
			max-width:200px;
			max-height:65px;
		}
		#direita{
			width:19%;
		}
		#direita tr td{
			text-align: center
		}

		#patrimonio, #produto, #servico, #analise, #relatorio{
			width: 100%;
		}

		#total{
			border: 1px solid #000;
			width:25%;
			height:25px;
			line-height:25px;
			float: right;
			padding: 0px 5px;
		}

		/*Rodape*/
		.assinatura{
			position: relative;
			float: left;
			width:20%;
			border-top:1px solid #000;
			margin:30px 5%;
			text-align: center;
			top:120px;
		}

		.assinatura img{
			position: absolute;
			top: -153px;
			left: 15px;
		}

		.dia{
			float:left;
			margin:140px 10% 0 10%;
			text-align: center;
		}
	</style>
</head>
<body>
	<!--header-->
	<table id="header" cellspacing="0" cellpadding="0">
		<tr style="height:70px;">
			<td style="text-align: center;border-right:none">
				<?php 
					if(isset($company->{"emp_logo"})&&!empty($company->{"emp_logo"})){
						?>
							<img src="<?php echo "http://".$_SERVER["SERVER_NAME"]."/uploads/".$company->{"emp_codigo"}."/".$company->{"emp_logo"} ;?>" alt="" id="logo">
						<?php
					}
				?>
			</td>
			<td style="text-align: center; border-left:none" colspan="4">
				<?php echo $company->{"emp_razao"};?><br>
				<?php echo $company->{"emp_fone"}." / ".$company->{"emp_cel"}."  ".$company->{"emp_emailremetente"};?><br>
				CNPJ: <?php echo $company->{"emp_cpfcnpj"}." - CEP: ".$company->{"emp_cep"};?><br>
				<?php echo $company->{"emp_endereco"}.", ".$company->{"emp_num"}." - ".$company->{"emp_bairro"};?>
			</td>
		</tr>
		<?php
			if( isset($ret[0]["cad_nomeraz"]) && $ret[0]["cad_nomeraz"]!="" ){
		?>
		<tr>
			<td colspan="4" style="width:75%">
				<strong>Cliente:</strong><br>
				<?php echo substr($ret[0]["cad_nomeraz"],0,40)?>
			</td>
			<td>
				<?php
				echo (strlen($ret[0]["cad_cnpjcpf"])>12) 
					? "<strong>CNPJ:</strong><br>".substr($ret[0]["cad_cnpjcpf"],0,2).".".substr($ret[0]["cad_cnpjcpf"],2,3).".".substr($ret[0]["cad_cnpjcpf"],5,3)."/".substr($ret[0]["cad_cnpjcpf"],8,4)."-".substr($ret[0]["cad_cnpjcpf"],12,2)
					: "<strong>CPF:</strong><br>".substr($ret[0]["cad_cnpjcpf"],0,3).".".substr($ret[0]["cad_cnpjcpf"],3,3).".".substr($ret[0]["cad_cnpjcpf"],6,3)."-".substr($ret[0]["cad_cnpjcpf"],9,2);
				?>
			</td>
		</tr>
		<tr>
			<td colspan="3">
				<strong>Endereço:</strong><br>
				<?php echo $ret[0]["end_nome"].", ".$ret[0]["end_num"]; ?>
			</td>
			<td>
				<strong>Bairro:</strong><br>
				<?php echo $ret[0]["end_bairro"]; ?>
			</td>
			<td>
				<strong>CEP:</strong><br>
				<?php echo $ret[0]["end_cep"]; ?>
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<strong>Município:</strong><br>
				<?php echo $ret[0]["end_cidade"]; ?>
			</td>
			<td>
				<strong>UF:</strong><br>
				<?php echo $ret[0]["end_uf"]; ?>
			</td>
			<td style="vertical-align:top">
				<strong>Telefone:</strong><br>
				<?php echo ($ret[0]["tel_numero"]) ? "(".$ret[0]["tel_ddd"].") ".$ret[0]["tel_prefixo"]."-".$ret[0]["tel_numero"] : ""; ?>
			</td>
			<td style="vertical-align:top">
				<strong>E-mail:</strong><br>
				<?php echo strtolower($ret[0]["eml_ender"]); ?>
			</td>
		</tr>
		<?php
			}
		?>
		<tr>
			<td colspan="5">
				<strong>Responsável Técnico:</strong><br>
				<?php echo substr($ret[0]["responsavel"],0,40)?>
			</td>
		</tr>
		<tr>
			<td colspan="3">
				<strong>Referência:</strong>
				<?php echo substr($ret[0]["opr_referencia"],0,40)?>
			</td>
			<td colspan="2">
				<strong>Situação:</strong>
				<?php 
					switch($ret[0]["opr_situacao"]){
						case 0:
							echo "Aguardando";
							break;
						case 1:
							echo "Em Execução";
							break;
						case 2:
							echo "Concluída";
							break;
						case 3:
							echo "Cancelada";
							break;
					}
				?>
			</td>
		</tr>
	</table>
	<table id="direita">
		<tr>
			<td style="height:69px; font-size:18px; font-weight:bold">
				OP Nº <?php echo $ret[0]["opr_codigo"]?>
			</td>
		</tr>
		<tr>
			<td style="vertical-align:top">
				Data de Emissão:<br>
				<?php echo implode("/", array_reverse(explode("-", substr($ret[0]["opr_data"], 0, 10))));?>
			</td>
		</tr>
		<tr>
			<td style="vertical-align:top">
				Previsão de Entrega:<br>
				<?php echo implode("/", array_reverse(explode("-", substr($ret[0]["opr_previsao"], 0, 10))));?>
			</td>
		</tr>
	</table>
	
	<br style="clear:both">
	
	<?php
		$arr=array();
		foreach($ret as $prod){
			if($prod["ori_tipo"]==2 && array_search($prod["ori_ordem"], $arr)===false){
				array_push($arr, $prod["ori_ordem"]);
			}
		}
		if( count($arr)>0 || $ret[0]["ose_status"]<5 ){
	?>
	
	<!--Produtos-->
	<table id="produto">
		<tr style="height:20px;">
			<td colspan="7" style="font-weight: bold">
				Produzir <?php echo number_format($ret[0]["opr_qtde"], 5,",", ".")." ".$ret[0]["uni_codigo"]?> DE <?php echo $ret[0]["ref_descr2"]." (Cód: ".$ret[0]["ref_codigo2"]." - Ref: ".$ret[0]["ref_propriedade2"].")";?>
			</td>
		</tr>
		<tr style="height:20px;">
			<td colspan="7" style="text-align:center; font-weight: bold">
				Composição
			</td>
		</tr>
		<tr>
			<th style="text-align:left;">Código</th>
			<th style="text-align:left;">Referência</th>
			<th style="text-align:left; width:55%">Matéria-Prima/ Insumo</th>
			<th>Qtde Necessária</th>
			<th>Lote</th>
			<th>Qtde Disponível</th>
			<th>Qtde Utilizada</th>
		</tr>
		<?php
			$total=0;
			foreach($ret as $prod){
				if($prod["iop_qtde"] && $prod["iop_qtde"]>0){
		?>
				<tr>
					<td><?php echo $prod["ref_codigo"]?></td>
					<td><?php echo $prod["ref_propriedade"]?></td>
					<td><?php echo $prod["ref_descr"]?></td>
					<td style="text-align:center"><?php  echo ($prod["ref_qtde"]>0) ? number_format($prod["ref_qtde"], 5, ",", ".") : "";?></td>
					<td style="text-align:center"><?php echo $prod["lot_descr"];?></td>
					<td style="text-align:center"><?php echo (floor($prod["stk_saldo"])!=$prod["stk_saldo"]) ? number_format($prod["stk_saldo"], 5, ",", ".") : (int) $prod["stk_saldo"];?></td>
					<td style="text-align:center"><?php echo (floor($prod["iop_qtde"])!=$prod["iop_qtde"]) ? number_format($prod["iop_qtde"], 5, ",", ".") : (int) $prod["iop_qtde"];?></td>
				</tr>
		<?php
				$total+=$prod["iop_qtde"];
				}				
			}
		?>
		<tr>
			<td colspan="7" style="text-align:right"><strong>Total Produtos:</strong> <?php echo ($total>0) ? number_format($total, 5, ",", ".") : "<div style='width:70px;float:right'>&nbsp;</div>"?></td>
		</tr>
	</table>
	
	<br style="clear:both">
	
	<?php
		}

		if( isset($ret[0]["opr_historico"]) && $ret[0]["opr_historico"]!="" ){
	?>
	
	<!--Apontamentos-->
	<table id="servico">
		<tr style="height:20px;">
			<td colspan="6" style="text-align:center; font-weight: bold">
				Registro de Apontamentos
			</td>
		</tr>
		<tr>
			<th style="text-align:left; width:20%"">Data/ Hora</th>
			<th style="text-align:left; width:30%">Funcionário</th>
			<th>Qtde Produzida</th>
			<th>Qtde Descartada</th>
			<th style="text-align:left; width:30%">Observação</th>
		</tr>
		<?php
			$historico = json_decode(base64_decode($ret[0]["opr_historico"]), true);
			if(is_array($historico)){
				foreach($historico as $hist){
			?>
				<tr>
					<td><?php echo implode("/", array_reverse(explode("-", substr($hist["data"],0,10)))).substr($hist["data"],10)?></td>
					<td><?php echo $hist["usu_nome"]?></td>
					<td style="text-align:center"><?php echo (floor($hist["qtdeprod"])!=$hist["qtdeprod"]) ? number_format($hist["qtdeprod"], 5, ",", ".") : (int) $hist["qtdeprod"];?></td>
					<td style="text-align:center"><?php echo (floor($hist["qtdedescarte"])!=$hist["qtdedescarte"]) ? number_format($hist["qtdedescarte"], 5, ",", ".") : (int) $hist["qtdedescarte"];?></td>
					<td><?php echo utf8_encode(base64_decode($hist["obs"]))?></td>
				</tr>
			<?php					
				}
			}
		?>
	</table>
	
	<br style="clear:both">
	
	<?php
		}
		
		if( isset($ret[0]["opr_obs"]) && $ret[0]["opr_obs"]!="" ){
	?>
	<div><?php echo utf8_encode(base64_decode($ret[0]["opr_obs"]))?></div>
	<br style="clear:both">
	<?php
		}
	?>
	
	
	<div id="total" style="width:23%"><strong style="font-size:13px">Rendimento: <?php echo ($rendimento>0) ? number_format($rendimento, 2, ",", "")." %" : "";?></strong></div>
	<div id="total" style="width:23%"><strong style="font-size:13px">Falta Produzir: <?php echo ($falta>0) ? number_format($falta, 5, ",", "") : "";?></strong></div>
	<div id="total" style="width:23%"><strong style="font-size:13px">Qtde Descartada: <?php echo ($ret[0]["opr_qtdedescarte"]>0) ? number_format($ret[0]["opr_qtdedescarte"], 5, ",", "") : "0,00";?></strong></div>
	<div id="total" style="width:23%"><strong style="font-size:13px">Qtde Produzida: <?php echo ($ret[0]["opr_qtdeprod"]>0) ? number_format($ret[0]["opr_qtdeprod"], 5, ",", "") : "0,00";?></strong></div>
	
	<br style="clear:both"><br>
	
	<div class="dia">
		______/______/______
		<br>Data
	</div>
	
	<div class="assinatura">
		Assinatura do Cliente
	</div>
	
	<div class="assinatura">
		Assinatura do Técnico
	</div>
	
</body>
</html>
	
<?php
		//envio por e-mail
		if( isset($_REQUEST["email"]) && $_REQUEST["email"]!="" ){

			if(!isset($logo)) $logo = "";
			if(!isset($data)) $data = "";
			if(!isset($titulo)) $titulo = "";
			if(!isset($relatorioTitle)) $relatorioTitle = "";
			if(!isset($filtros)) $filtros = "";
			if(!isset($colunas)) $colunas = "";
			if(!isset($cabecalhoHeight)) $cabecalhoHeight = "0"; // passar apenas numeros sem px, %..;
			$html = ob_get_clean();
			if(!is_dir($TParams->getHostRoot()."tmp/")){
				mkdir($TParams->getHostRoot()."tmp/", 0777, true);
			}
			$arquivo = str_replace(array(".",","), "", microtime(true));
			$fp = fopen($TParams->getHostRoot()."tmp/".$arquivo.'.html', 'w');
			fwrite($fp, $html);
			fclose($fp);

			exec($TParams->getHostRoot().'class/phantomjs/bin/phantomjs '.$TParams->getHostRoot().'class/phantomjs/rasterizeOs.js '.$TParams->getHostRoot().'tmp/'.$arquivo.'.html '.$TParams->getHostRoot().'tmp/'.$arquivo.'.pdf ["7,5in*5in"] "'.$relatorioTitle.'" "'.base64_encode($titulo).'" "'.$data.'" "'.base64_encode(json_encode($filtros)).'" "'.base64_encode(json_encode($colunas)).'" "'.base64_encode($logo).'" "'.$cabecalhoHeight.'"');
			
			if(file_exists($TParams->getHostRoot()."tmp/".$arquivo.'.pdf')){
				
				//modelo de e-mail (envio de OS)
				$filtro = '{"cod":"700268","params":[
					{"name":"dbcomum","value":"'.$company->emp_db_comum.'","type":"other"},
					{"name":"men_codigo","value":"22","type":"integer"}
				]}';
				$datapacket->add($filtro);
				$modelo = $datapacket->open(true);
				$datapacket->clear();
				
				
				
				$filtro = '{"cod":"700321","params":[
					{"name":"msg_codigo","value":"","type":"string"},
					{"name":"msg_tipo","value":"1","type":"integer"},
					{"name":"men_codigo","value":"22","type":"integer"},
					{"name":"msg_remetente","value":"'.$modelo[0]->men_remetente.'","type":"string"},
					{"name":"msg_destinatario","value":"'.strtolower($_REQUEST["email"]).'","type":"string"},
					{"name":"cad_codigo","value":"'.$ret[0]["cad_codigo"].'","type":"string"},
					{"name":"msg_assunto","value":"'.$modelo[0]->men_assunto.'","type":"string"},
					{"name":"msg_conteudo","value":"'.$modelo[0]->men_conteudo.'","type":"string"},
					{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_status","value":"0","type":"integer"},
					{"name":"msg_anexo","value":"","type":"string"}
				]}';

				$datapacket->add($filtro);
				$msg = $datapacket->open(false, true);
				$datapacket->clear();

				//anexar e enviar mensagem de e-mail
				if($msg){
					
					$fields = array(
						'p' => $_REQUEST["p"],
						'acao' => 'anexar',
						'msg_codigo' => $msg,
						'ane_descricao' => base64_encode(utf8_decode("Ordem de Serviço número ".$ret[0]["ose_numero"])),
						'msg_anexo' => new CURLFile($TParams->getHostRoot()."tmp/".$arquivo.'.pdf')
					);
					$ch = curl_init();
					curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
					curl_setopt($ch,CURLOPT_POST, true);
					curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
					curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
					curl_exec($ch);
					curl_close($ch);
					
					$textos = array(
						'ose_numero' => $ret[0]["ose_numero"]
					);			
					//requisição para envio da mensagem
					$fields = array(
						'p' => $_REQUEST["p"],
						'acao' => 'enviar',
						'textos' => $textos,
						'msg_codigo' => $msg
					);
					$fields = http_build_query($fields);
					$ch = curl_init();
					curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
					curl_setopt($ch,CURLOPT_POST, true);
					curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
					$result = curl_exec($ch);
					curl_close($ch);
					
				}
				
				/*
				if($_SERVER['SERVER_NAME'] == "dev.uds.com.br"){

					$ambiente = explode("/", substr($_SERVER['SCRIPT_NAME'], 1));

					if($ambiente[0] != "desktop"){

						exit("/" . $ambiente[0] . "/" . $ambiente[1] . "/tmp/" . $arquivo . ".pdf");
					}
				}
				*/

			} else {

				echo "Ocorreu um erro ao gerar o arquivo.";
			}
			
		}

		}else{
			exit("Dados Incompletos para impressão, favor verificar o cadastro do Cliente desta OS");
		}
		
	}else{
		exit("Nâo há dados para serem impressos");
	}
?>