<?php
	header('Content-Type: text/html; charset=utf-8');
	include '../php/datapacket.php';
	include '../php/TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	
	if( (isset($_REQUEST["email"]) && $_REQUEST["email"]!="") || (isset($_REQUEST["api"]) && $_REQUEST["api"]==1) ){
		ob_start();
	}
	
	if( isset($_REQUEST["ose_codigo"]) ){
		
		
		$filtro = '{"cod":"700512","params":[
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
			{"name":"ose_codigo","value":"'.$_REQUEST["ose_codigo"].'","type":"string"}
		]}';

		$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		
		$company = $TParams->getCompany();
		
		if( isset($ret[0]) ){
			
?>
<!DOCTYPE HTML>
<html lang="pt-BR">
<head>
	<meta charset="UTF-8">
	<title>Ordem de Serviço Nº <?php echo $ret[0]["ose_numero"]?> - Fácil Online</title>
	<link rel="stylesheet" href="css/ordemServico.css">
	<link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">
	<style>
		*{
			margin:0;
			padding:0;
			font-family:Arial, Verdana, sans-serif;
			font-size:11px;
		}

		body{
			max-width:900px;
			margin:0 auto;
			width:100%;
		}
		table{
			border-collapse: collapse;
		}
		table tr td{
			border: 1px solid #000;
			padding:0px 5px;
			height:20px;
		}
		table tr th{
			padding:0px 5px;
		}
		table tr{
			height:30px;
		}
		#patrimonio tr, #produto tr, #servico tr, #analise tr, #relatorio tr{
			height:23px;
		}

		/*Header*/
		#header{
			width:80%;
			float:left;
			margin-right:5px;
		}
		#logo{
			max-width:200px;
			max-height:65px;
		}
		#direita{
			width:19%;
		}
		#direita tr td{
			text-align: center
		}

		#patrimonio, #produto, #servico, #analise, #relatorio{
			width: 100%;
		}

		#total{
			border: 1px solid #000;
			width:25%;
			height:25px;
			line-height:25px;
			float: right;
			padding: 0px 5px;
		}

		/*Rodape*/
		.assinatura{
			position: relative;
			float: left;
			width:20%;
			border-top:1px solid #000;
			margin:30px 5%;
			text-align: center;
			top:120px;
		}

		.assinatura img{
			position: absolute;
			top: -153px;
			left: 15px;
		}

		.dia{
			float:left;
			margin:140px 10% 0 10%;
			text-align: center;
		}
	</style>
</head>
<body>
	<!--header-->
	<table id="header" cellspacing="0" cellpadding="0">
		<tr style="height:70px;">
			<td style="text-align: center;border-right:none">
				<?php 
					if(isset($company->{"emp_logo"})&&!empty($company->{"emp_logo"})){
						?>
							<img src="<?php echo "http://".$_SERVER["SERVER_NAME"]."/uploads/".$company->{"emp_codigo"}."/".$company->{"emp_logo"} ;?>" alt="" id="logo">
						<?php
					}
				?>
			</td>
			<td style="text-align: center; border-left:none" colspan="4">
				<?php
					if(isset($company->{"emp_titulo"}) && $company->{"emp_titulo"} == 1){
						echo $company->{"emp_razao"};
					}else if(isset($company->{"emp_titulo"}) && $company->{"emp_titulo"} == 2){
						echo $company->{"emp_fantasia"};
					}
				?>
				<br>
				<?php echo $company->{"emp_fone"}." / ".$company->{"emp_cel"}."  ".$company->{"emp_email"};?><br>
				CNPJ: <?php echo $company->{"emp_cpfcnpj"}." - CEP: ".$company->{"emp_cep"};?><br>
				<?php echo $company->{"emp_endereco"}.", ".$company->{"emp_num"}." - ".$company->{"emp_bairro"};?>
			</td>
		</tr>
		<tr>
			<td colspan="4" style="width:75%">
				<strong>Cliente:</strong><br>
				<?php echo substr($ret[0]["cad_nomeraz"],0,40)?>
			</td>
			<td>
				<?php
				echo (strlen($ret[0]["cad_cnpjcpf"])>12) 
					? "<strong>CNPJ:</strong><br>".substr($ret[0]["cad_cnpjcpf"],0,2).".".substr($ret[0]["cad_cnpjcpf"],2,3).".".substr($ret[0]["cad_cnpjcpf"],5,3)."/".substr($ret[0]["cad_cnpjcpf"],8,4)."-".substr($ret[0]["cad_cnpjcpf"],12,2)
					: "<strong>CPF:</strong><br>".substr($ret[0]["cad_cnpjcpf"],0,3).".".substr($ret[0]["cad_cnpjcpf"],3,3).".".substr($ret[0]["cad_cnpjcpf"],6,3)."-".substr($ret[0]["cad_cnpjcpf"],9,2);
				?>
			</td>
		</tr>
		<tr>
			<td colspan="3">
				<strong>Endereço:</strong><br>
				<?php echo $ret[0]["end_nome"].", ".$ret[0]["end_num"]; ?>
			</td>
			<td>
				<strong>Bairro:</strong><br>
				<?php echo $ret[0]["end_bairro"]; ?>
			</td>
			<td>
				<strong>CEP:</strong><br>
				<?php echo $ret[0]["end_cep"]; ?>
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<strong>Município:</strong><br>
				<?php echo $ret[0]["end_cidade"]; ?>
			</td>
			<td>
				<strong>UF:</strong><br>
				<?php echo $ret[0]["end_uf"]; ?>
			</td>
			<td style="vertical-align:top">
				<strong>Telefone:</strong><br>
				<?php echo ($ret[0]["tel_numero"]) ? "(".$ret[0]["tel_ddd"].") ".$ret[0]["tel_prefixo"]."-".$ret[0]["tel_numero"] : ""; ?>
			</td>
			<td style="vertical-align:top">
				<strong>E-mail:</strong><br>
				<?php echo strtolower($ret[0]["eml_ender"]); ?>
			</td>
		</tr>
		<tr>
			<td colspan="5">
				<strong>Responsável Técnico:</strong><br>
				<?php echo substr($ret[0]["responsavel"],0,40)?>
			</td>
		</tr>
	</table>
	<table id="direita">
		<tr>
			<td style="height:69px; font-size:18px; font-weight:bold">
				OS Nº <?php echo $ret[0]["ose_numero"]?>
			</td>
		</tr>
		<tr>
			<td style="vertical-align:top">
				Data de Emissão:<br>
				<?php echo implode("/", array_reverse(explode("-", substr($ret[0]["ose_data"], 0, 10))));?>
			</td>
		</tr>
		<tr>
			<td style="vertical-align:top">
				Previsão de Saída:<br>
				<?php echo implode("/", array_reverse(explode("-", substr($ret[0]["ose_dtprev"], 0, 10))));?>
			</td>
		</tr>
		<tr>
			<td style="vertical-align:top">
				Data/ Hora da Entrega:<br>
				<?php echo ($ret[0]["ose_dtconclusao"] && $ret[0]["ose_dtconclusao"]!="" && $ret[0]["ose_dtconclusao"]!=0) ? implode("/", array_reverse(explode("-", substr($ret[0]["ose_dtconclusao"], 0, 10))))." às ".substr($ret[0]["ose_dtconclusao"], 11, 5)."h" : "";?>
			</td>
		</tr>
		<tr>
			<td style="vertical-align:top">
				Hora da Saída:<br>
			</td>
		</tr>
	</table>
	
	<br style="clear:both">
	
	<!--Patrimonio-->
	<table id="patrimonio">
		<?php
			$i=0;
			$ant="";
			foreach($ret as $patr){
				if($ant!=$patr["osd_descr"] && $patr["osd_descr"]!=""){
					if($i==0){
		?>
		<tr style="height:20px;">
			<td colspan="4" style="text-align:center; font-weight: bold;">
				<?php
					if($patr["osd_tipo"]==0){
						echo "Equipamento";
						$identificacao="Código";
					}elseif($patr["osd_tipo"]==1){
						echo "Veículo";
						$identificacao="Placa";
					}elseif($patr["osd_tipo"]==2){
						echo "Ordem de Produção";
						$identificacao="Código";
					}elseif($patr["osd_tipo"]==3){
						echo "Ordem de Serviço";
						$identificacao="Código";
					}else{
						echo "Patrimônio";
						$identificacao="Identificação";
					}
				?>
			</td>
		</tr>
		<tr>
			<th style="text-align:left; width:10%">
				<?php echo $identificacao; ?>
			</th>
			<th colspan="2" style="width:80%; text-align:left">Descrição</th>
			<th>Quantidade</th>
		</tr>
		<?php
			}
		?>
		<tr>
			<td><?php echo $patr["osd_identificacao"]?></td>
			<td colspan="2"><?php echo $patr["osd_descr"]?></td>
			<td style="text-align:center"><?php echo (floor($patr["osd_qtde"])!=$patr["osd_qtde"]) ? number_format($patr["osd_qtde"], 2, ",", ".") : (int) $patr["osd_qtde"];?></td>
		</tr>
		<?php
					if( isset($patr["osd_solicitacao"]) && $patr["osd_solicitacao"]!="" ){
		?>
		<tr>
			<td colspan="4" style="height:25px;vertical-align:top">
				<strong>Solicitação:</strong><br>
				<?php echo utf8_encode(base64_decode($patr["osd_solicitacao"]))?>
			</td>
		</tr>
		<?php
					}
					$i++;
					$ant=$patr["osd_descr"];
				}
			}
		?>
	</table>
	
	<br style="clear:both">
	
	<?php
		$arr=array();
		foreach($ret as $prod){
			if($prod["ori_tipo"]==2 && array_search($prod["ori_ordem"], $arr)===false){
				array_push($arr, $prod["ori_ordem"]);
			}
		}
		// if( count($arr)>0 || $ret[0]["ose_status"]<5 ){
		//comentado na versao 03/2025
		if( count($arr)>0 ){
	?>
	
	<!--Produtos-->
	<table id="produto">
		<tr style="height:20px;">
			<td colspan="6" style="text-align:center; font-weight: bold">
				Produtos
			</td>
		</tr>
		<tr>
			<th style="text-align:left;">Código</th>
			<th style="text-align:left; width:55%">Descrição</th>
		<?php
				if( isset($prod["ori_img"]) && $prod["ori_img"]!="" && $company->{"emp_modelo_imp"}==1){
					$img = json_decode(base64_decode($prod["ori_img"]), true);
					if($img[0]["imagem"]){
		?>
			<th>Imagem</th>
		<?php
					}
					
				}
		?>
			<th>Qtde</th>
			<th>Valor R$</th>
		<?php
			if($company->{"emp_modelo_imp"}==1){
		?>
			<th colspan="2">Referência</th>
		<?php
			}else{
		?>
			<th>Desconto R$</th>
			<th>Subtotal R$</th>
		<?php
			}
		?>
		</tr>
		<?php
			$arr=array();
			$total=0;
			foreach($ret as $prod){
				
				if($prod["ori_tipo"]==2 && array_search($prod["ori_ordem"], $arr)===false){
					array_push($arr, $prod["ori_ordem"]);
		?>
					<tr>
						<td><?php echo $prod["ori_codigo"]?></td>
						<td><?php echo $prod["ori_descr"]?></td>
		<?php
				if( isset($prod["ori_img"]) && $prod["ori_img"]!="" && $company->{"emp_modelo_imp"}==1){
					$img = json_decode(base64_decode($prod["ori_img"]), true);
					if($img[0]["imagem"] && $company->{"emp_modelo_imp"}==1){
						$emp_codigo = ($company->{"emp_codigo"}=="ORNATO") ? "BIANTEX" : $company->{"emp_codigo"};
		?>
						<td style="text-align:center"><img src="<?php echo "http://".$_SERVER["SERVER_NAME"]."/uploads/".$emp_codigo."/produtos/".$prod["ori_codigo"]."/".$img[0]["imagem"];?>" style="width:200px;"></td>
		<?php
					}
				}
		?>
						<td style="text-align:center"><?php echo (floor($prod["ori_quantidade"])!=$prod["ori_quantidade"]) ? number_format($prod["ori_quantidade"], 2, ",", ".") : (int) $prod["ori_quantidade"];?></td>
						<td style="text-align:center"><?php echo ($prod["ori_valor_unitario"]>0) ? number_format($prod["ori_valor_unitario"], 2, ",", ".") : "0,00"?></td>
		<?php
			if( $company->{"emp_modelo_imp"}==1){
		?>
						<td colspan="2" style="text-align:center"><?php echo $prod["ref_propriedade"];?></td>
		<?php
			}else{
		?>
						<td style="text-align:center"><?php echo ($prod["ori_desconto"]>0) ? number_format($prod["ori_desconto"], 2, ",", ".") : "0,00"?></td>
						<td style="text-align:center"><?php echo ($prod["ori_subtotal"]>0) ? number_format($prod["ori_subtotal"], 2, ",", ".") : "0,00"?></td>
		<?php
			}
		?>
					</tr>
		<?php
					$total+=$prod["ori_subtotal"];
				}
				
			}
			if( count($arr)==0 ){
			//comentado na versao 03/2025
		?>
				<!--<tr>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
				</tr>-->
		<?php
			}
		?>
		<tr>
			<td colspan="7" style="text-align:right"><strong>Total Produtos R$:</strong> <?php echo ($total>0) ? number_format($total, 2, ",", ".") : "<div style='width:70px;float:right'>&nbsp;</div>"?></td>
		</tr>
	</table>
	
	<br style="clear:both">
	
	<?php
		}
		
		$arr=array();
		foreach($ret as $prod){
			if($prod["ori_tipo"]==1 && array_search($prod["ori_ordem"], $arr)===false){
				array_push($arr, $prod["ori_ordem"]);
			}
		}
		// if( count($arr)>0 || $ret[0]["ose_status"]<5 ){
		//comentado na versao 03/2025
		if( count($arr)>0 ){
	?>
	
	<!--Serviços-->
	<table id="servico">
		<tr style="height:20px;">
			<td colspan="6" style="text-align:center; font-weight: bold">
				Serviços
			</td>
		</tr>
		<tr>
			<th style="text-align:left;">Código</th>
			<th style="text-align:left; width:55%">Descrição</th>
			<th>Qtde</th>
			<th>Valor R$</th>
			<th>Desconto R$</th>
			<th>Subtotal R$</th>
		</tr>
		<?php
			$arr=array();
			$total=0;
			foreach($ret as $prod){
				
				if($prod["ori_tipo"]==1 && array_search($prod["ori_ordem"], $arr)===false){
					array_push($arr, $prod["ori_ordem"]);
		?>
					<tr>
						<td><?php echo $prod["ori_codigo"]?></td>
						<td><?php echo $prod["ori_descr"]?></td>
						<td style="text-align:center"><?php echo (floor($prod["ori_quantidade"])!=$prod["ori_quantidade"]) ? number_format($prod["ori_quantidade"], 2, ",", ".") : (int) $prod["ori_quantidade"];?></td>
						<td style="text-align:center"><?php echo ($prod["ori_valor_unitario"]>0) ? number_format($prod["ori_valor_unitario"], 2, ",", ".") : "0,00"?></td>
						<td style="text-align:center"><?php echo ($prod["ori_desconto"]>0) ? number_format($prod["ori_desconto"], 2, ",", ".") : "0,00"?></td>
						<td style="text-align:center"><?php echo ($prod["ori_subtotal"]>0) ? number_format($prod["ori_subtotal"], 2, ",", ".") : "0,00"?></td>
					</tr>
		<?php
					$total+=$prod["ori_subtotal"];
				}
				
			}
			if( count($arr)==0 ){
				//comentado na versao 03/2025
		?>
				<!--<tr>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
				</tr>-->
		<?php
			}
		?>
		<tr>
			<td colspan="6" style="text-align:right"><strong>Total Serviços R$:</strong> <?php echo ($total>0) ? number_format($total, 2, ",", ".") : "<div style='width:70px;float:right'>&nbsp;</div>"?></td>
		</tr>
	</table>
	
	<br style="clear:both">
	
	<?php
		}
		
		$ant="";
		foreach($ret as $patr){
			if($ant!=$patr["osd_descr"] && $patr["osd_descr"]!=""){
				$analise = json_decode(utf8_encode(base64_decode($patr["osd_analise"])));
			}	
		}
		if(count($analise)>0 || $ret[0]["ose_status"]<5){
	?>
	
	<!--Análise-->
	<table id="analise">
		<tr style="height:20px;">
			<td colspan="3" style="text-align:center; font-weight:bold">Análise Técnica</td>
		</tr>
		<tr>
			<th style="text-align:left">Descrição</th>
			<th style="text-align:left">Responsável</th>
			<th style="text-align:left">Situação</th>
		</tr>
		<?php
			$ant="";
			foreach($ret as $patr){
				if($ant!=$patr["osd_descr"] && $patr["osd_descr"]!=""){
					$analise = json_decode(utf8_encode(base64_decode($patr["osd_analise"])));
					if(count($analise)>0){
						foreach($analise as $ana){
			?>
					<tr>
						<td style="width:65%;"><?php echo $ana->{"ana_descr"};?></td>
						<td style="width:20%;"><?php echo (isset($ana->{"usu_nome"})) ? $ana->{"usu_nome"} : "";?></td>
						<td>
							<?php
								if($ana->{"ana_status"}==0){
									echo "Aguardando Execução";
								}elseif($ana->{"ana_status"}==1){
									echo "Aguardando Aprovação";
								}elseif($ana->{"ana_status"}==2){
									echo "Concluída";
								}elseif($ana->{"ana_status"}==3){
									echo "Rejeitada";
								}
							?>
						</td>
					</tr>
			<?php
						}
					}else{
			?>
				<tr>
					<td style="width:65%;"></td>
					<td style="width:20%;"></td>
					<td></td>
				</tr>
				<tr>
					<td style="width:65%;"></td>
					<td style="width:20%;"></td>
					<td></td>
				</tr>
				<tr>
					<td style="width:65%;"></td>
					<td style="width:20%;"></td>
					<td></td>
				</tr>
			<?php
						break;
					}
					$ant=$patr["osd_descr"];
				}
			}
		?>
	</table>
	
	<br style="clear:both">
	
	<?php
		}
	?>
	
	<?php
		// if( $ret[0]["ose_status"]>4 && $ret[0]["ose_obs"] && $ret[0]["ose_obs"]!="" ){ //relatorio tecnico
		if( $ret[0]["ose_obs"] && $ret[0]["ose_obs"]!="" ){ //relatorio tecnico
			$relatorio = json_decode(base64_decode($ret[0]["ose_obs"]));
			$cont = 0;
			if(is_array($relatorio)){
				foreach( $relatorio as $rel ){
					if($rel->obs_tipo &&$rel->obs_tipo==1){
						if($cont==0){
	?>
							<!--Relatório Técnico-->
							<table id="relatorio">
								<tr style="height:20px;">
									<td colspan="3" style="text-align:center; font-weight:bold">Relatório Técnico</td>
								</tr>
								<tr>
									<th style="text-align:left">Descrição</th>
									<th style="text-align:left">Responsável</th>
									<th style="text-align:left">Data/ Hora</th>
								</tr>
					<?php
						}
						if($rel->obs_obs!=""){
					?>
								<tr>
									<td width="60%"><?php echo utf8_encode(base64_decode($rel->obs_obs))?></td>
									<td width="20%"><?php echo $rel->usu_nome?></td>
									<td width="20%"><?php echo implode("/", array_reverse(explode("-", substr($rel->obs_data,0,10))))." ".substr($rel->obs_data,11,8)?></td>
								</tr>
					<?php
						}
						$cont++;
					}
				}
			}
		}
	?>
	</table><br style="clear:both">
	
	<div id="total">
		Valor Total da OS: <strong style="font-size:13px">R$ <?php echo ($ret[0]["ose_total"] && $ret[0]["ose_total"]>0) ? number_format($ret[0]["ose_total"], 2, ",", "") : "";?></strong>
	</div>
	
	<br style="clear:both"><br>
	
	<?php
		if($company->emp_codigo=="UDS" || $company->emp_codigo=="MODELO"){
			echo "Todos os programas e componentes do equipamento estão funcionando perfeitamente, diante disso dou o serviço como concluído. Os serviços executados têm garantia de 30 (trinta) dias, exceto por problemas causados por spiwares, vírus, trojans, utilização indevida e eventos físicos. A empresa UDS Soluções Digitais não se responsabiliza pela origem dos softwares instalados nos equipamentos.<br>";
		}
	?>
	
	<div class="dia">
		______/______/______
		<br>Data
	</div>
	
	<div class="assinatura">
	<?php
			if( isset($ret[0]["ose_assinatura"]) && $ret[0]["ose_assinatura"]!="" ){
		?>
				<img src="data:image/jpeg;base64, <?php echo $ret[0]["ose_assinatura"]?>"/>
		<?php
			}
		?>
		Assinatura do Cliente
	</div>
	
	<div class="assinatura">
		Assinatura do Técnico
	</div>
	
</body>
</html>
	
<?php
		//envio por e-mail ou geracao do pdf por API
		if( (isset($_REQUEST["email"]) && $_REQUEST["email"]!="") || (isset($_REQUEST["api"]) && $_REQUEST["api"]==1) ){

			if(!isset($logo)) $logo = "";
			if(!isset($data)) $data = "";
			if(!isset($titulo)) $titulo = "";
			if(!isset($relatorioTitle)) $relatorioTitle = "";
			if(!isset($filtros)) $filtros = "";
			if(!isset($colunas)) $colunas = "";
			if(!isset($cabecalhoHeight)) $cabecalhoHeight = "0"; // passar apenas numeros sem px, %..;
			$html = ob_get_clean();
			if(!is_dir($TParams->getHostRoot()."tmp/")){
				mkdir($TParams->getHostRoot()."tmp/", 0777, true);
			}
			$arquivo = str_replace(array(".",","), "", microtime(true));
			$fp = fopen($TParams->getHostRoot()."tmp/".$arquivo.'.html', 'w');
			fwrite($fp, $html);
			fclose($fp);

			exec($TParams->getHostRoot().'class/phantomjs/bin/phantomjs '.$TParams->getHostRoot().'class/phantomjs/rasterizeOs.js '.$TParams->getHostRoot().'tmp/'.$arquivo.'.html '.$TParams->getHostRoot().'tmp/'.$arquivo.'.pdf ["7,5in*5in"] "'.$relatorioTitle.'" "'.base64_encode($titulo).'" "'.$data.'" "'.base64_encode(json_encode($filtros)).'" "'.base64_encode(json_encode($colunas)).'" "'.base64_encode($logo).'" "'.$cabecalhoHeight.'"');
			
			if(file_exists($TParams->getHostRoot()."tmp/".$arquivo.'.pdf')){
				
				if( isset($_REQUEST["email"]) && $_REQUEST["email"]!=""){
					//modelo de e-mail (envio de OS)
					$filtro = '{"cod":"700268","params":[
						{"name":"dbcomum","value":"'.$company->emp_db_comum.'","type":"other"},
						{"name":"men_codigo","value":"22","type":"integer"}
					]}';
					$datapacket->add($filtro);
					$modelo = $datapacket->open(true);
					$datapacket->clear();
					
					
					
					$filtro = '{"cod":"700321","params":[
						{"name":"msg_codigo","value":"","type":"string"},
						{"name":"msg_tipo","value":"1","type":"integer"},
						{"name":"men_codigo","value":"22","type":"integer"},
						{"name":"msg_remetente","value":"'.$modelo[0]->men_remetente.'","type":"string"},
						{"name":"msg_destinatario","value":"'.strtolower($_REQUEST["email"]).'","type":"string"},
						{"name":"cad_codigo","value":"'.$ret[0]["cad_codigo"].'","type":"string"},
						{"name":"msg_assunto","value":"'.$modelo[0]->men_assunto.'","type":"string"},
						{"name":"msg_conteudo","value":"'.$modelo[0]->men_conteudo.'","type":"string"},
						{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"msg_status","value":"0","type":"integer"},
						{"name":"msg_anexo","value":"","type":"string"}
					]}';

					$datapacket->add($filtro);
					$msg = $datapacket->open(false, true);
					$datapacket->clear();

					//anexar e enviar mensagem de e-mail
					if($msg){
						
						$fields = array(
							'p' => $_REQUEST["p"],
							'acao' => 'anexar',
							'msg_codigo' => $msg,
							'ane_descricao' => base64_encode(utf8_decode("Ordem de Serviço número ".$ret[0]["ose_numero"])),
							'msg_anexo' => new CURLFile($TParams->getHostRoot()."tmp/".$arquivo.'.pdf')
						);
						$ch = curl_init();
						curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
						curl_setopt($ch,CURLOPT_POST, true);
						curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
						curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
						curl_exec($ch);
						curl_close($ch);
						
						$textos = array(
							'ose_numero' => $ret[0]["ose_numero"]
						);			
						//requisição para envio da mensagem
						$fields = array(
							'p' => $_REQUEST["p"],
							'acao' => 'enviar',
							'textos' => $textos,
							'msg_codigo' => $msg
						);
						$fields = http_build_query($fields);
						$ch = curl_init();
						curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
						curl_setopt($ch,CURLOPT_POST, true);
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
						$result = curl_exec($ch);
						curl_close($ch);
						
					}
					
				}elseif( isset($_REQUEST["api"]) && $_REQUEST["api"]==1 ){
					$filename = basename($TParams->getHostRoot()."tmp/".$arquivo.'.pdf');
					$filecontent = file_get_contents($TParams->getHostRoot()."tmp/".$arquivo.'.pdf');
					$base64content = base64_encode($filecontent);
					$response = [
						'nomearquivo' => $filename,
						'conteudo' => $base64content,
					];
					$jsonResponse = json_encode($response);
					header('Content-Type: application/json');
					echo $jsonResponse;
				}

			} else {

				echo "Ocorreu um erro ao gerar o arquivo.";
			}
			
		}

		}else{
			exit("Dados Incompletos para impressão, favor verificar o cadastro do Cliente desta OS");
		}
		
	}else{
		exit("Nâo há dados para serem impressos");
	}
?>