<?php
	header('Content-Type: text/html; charset=utf-8');
	setlocale(LC_ALL, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
	date_default_timezone_set('America/Sao_Paulo');

	ob_start();

	include '../php/TParams.class.php';
	include '../php/funcoes.php';
	
	$datapacket = new TParams();
	$company = $datapacket->getCompany();
	
	if(!isset($_REQUEST["not_codigo"]) || empty($_REQUEST["not_codigo"])) exit("Nâo há dados para serem impressos");

	define("CINZA_CLARO", "#69676C");
	define("CINZA_ESCURO", "#535156");
	define("LARANJA", "#F16432");
	define("AZUL", "#0B599B");
	define("ZEBRADO", "#EAE8E6");
		
	$filtro = '{"cod":"501193","params":[
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
		{"name":"not_codigo","value":"'.$_REQUEST['not_codigo'].'","type":"string"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$pedido = $datapacket->open(true);
	$datapacket->clear();

	$totitem = 0;
	$totprod = 0;
	$totdesc = 0;

	foreach($pedido as $prod){
		$totitem+=$prod->{"itn_qtde"};
		$totprod++;
	}

	if ($pedido[0]->{"ecm_status"} == 1) {
        $statusNota = "Aguardando";
    } else if ($pedido[0]->{"ecm_status"} == 2) {
        $statusNota = "Processando";
    } else if ($pedido[0]->{"ecm_status"} == 3) {
        $statusNota = "Pago";
    } else if ($pedido[0]->{"ecm_status"} == 4) {
        $statusNota = "Expedição";
    } else if ($pedido[0]->{"ecm_status"} == 5) {
        $statusNota = "Enviado";
    } else if ($pedido[0]->{"ecm_status"} == 6) {
        $statusNota = "Cancelado";
    } else if ($pedido[0]->{"ecm_status"} == 7) {
        $statusNota = "Análise para garantia";
    } else if ($pedido[0]->{"ecm_status"} == 8) {
        $statusNota = "Reenviado";
    } else if ($pedido[0]->{"ecm_status"} == 99) {
        $statusNota = "Outros";
    }
    
?>

	<!DOCTYPE HTML>
	<html lang="pt-BR">
		
		<head>

			<meta charset="UTF-8">
			
			<title> Pedido Nº <?php echo $pedido[0]->{"not_numero"}; ?> - Fácil Online </title>
			
			<link rel="icon" href="../favicon.ico" type="image/x-icon">

		</head>

		<style type="text/css">

			@font-face {
				font-family: signik;
				src: url(../resources/fontes/signik/Signika-Regular.otf);
			}

			.status {
			    position:relative;
			    width: 350px;
			    left:13%;
			    top:42%;
			    padding: 20px 0px;
			    color:#FFF;
			    background-color: #0B599B;
			    text-align: center;


			    -ms-transform: rotate(35deg); 
			    -webkit-transform: rotate(35deg); 
			    transform: rotate(35deg);
			}

		</style>
		
		<body style="width:100%; margin:0px; padding:0px; font-size:24px; font-family:signik; -webkit-print-color-adjust: exact">

			<!--header-->
			<div style="width:98%; float:left; height:170px; padding:0 0 0 2%; ">
				
				<div style="width:48%; float:left; margin-top:50px">
					
					<div style="width:100%; color:<?php echo CINZA_ESCURO; ?>"> 
						<span>
							<?php 
								if(isset($company->{"emp_titulo"}) && $company->{"emp_titulo"} == 2){
									echo ucfirst(strtolower($company->{"emp_fantasia"}));
								}else{
									echo ucfirst(strtolower($company->{"emp_razao"}));
								}
							?>
						</span>
					</div>

					<div style="width:100%; margin-top:10px; color:<?php echo CINZA_CLARO; ?>"> 
						
						<span> <?php echo ucfirst(strtolower($company->{"emp_endereco"} . ", " . $company->{"emp_num"})); ?> </span>

					</div>
					
					<div style="width:100%; margin-top:10px; color:<?php echo CINZA_CLARO; ?>"> 
						
						<span> <?php echo ucfirst(utf8_encode(strftime('%A, %d de %B de %Y', strtotime('today')))); ?> </span>

					</div>

				</div>
				
				<div style="width:27%; height:210px; float:left; text-align:center; overflow: hidden;">
					<img style="height:auto; max-height: 210px; width: 100%" src="<?php echo "http://".$_SERVER["SERVER_NAME"]."/uploads/".$company->{"emp_codigo"}."/".$company->{"emp_logo"}; ?>"> 

				</div>

				<div style="width:25%; height:100px; float:left;">
				
					<div class="status"> <?php echo $statusNota; ?> </div>

				</div>

			</div>

			<!--informação do cliente-->
			<div style="width:98%; padding-left:2%; float:left; margin-top:40px;">
			
				<div style="width:50%; float:left; padding-top:10px;">

					<div style="width:100%; float:left; font-size:45px; color:<?php echo LARANJA; ?>"> 
						<span> PEDIDO <?php echo $pedido[0]->{"not_numero"}; ?> </span> 
					</div>

					<div style="width:100%; float:left; margin-top:40px;"> 
						<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> Cliente: </span> 
						<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo $pedido[0]->{"cad_nomeraz"}; ?></span>
					</div>

					<div style="width:100%; float:left; margin-top:15px;"> 
						<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> E-mail: </span> 
						<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo $pedido[0]->{"email"}; ?></span>
					</div>

					<div style="width:100%; float:left; margin-top:15px;"> 
						<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> Tel: </span> 
						<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo $pedido[0]->{"telefone"}; ?></span>
					</div>

					<div style="width:100%; float:left; margin-top:15px;"> 
						<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> CPF:  </span> 
						<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo maskCNPJCPF($pedido[0]->{"cad_cnpjcpf"}); ?></span>
					</div>

					<div style="width:100%; float:left; margin-top:15px;"> 
						<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> Cep:  </span> 
						<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo cep($pedido[0]->{"end_cep"}); ?></span>
					</div>

					<div style="width:100%; float:left; margin-top:15px;"> 
						<div style="width:50%; float:left;"> 
							<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> Logradouro:  </span> 
							<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo $pedido[0]->{"end_nome"}; ?></span>
						</div>
						<div style="width:50%; float:left;"> 

							<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> N°  </span> 
							<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo $pedido[0]->{"end_num"}; ?></span>
						</div>
					</div>

					<div style="width:100%; float:left; margin-top:15px;"> 
						<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> Bairro:  </span> 
						<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo $pedido[0]->{"end_bairro"}; ?></span>
					</div>

					<div style="width:100%; float:left; margin-top:15px;"> 
						<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> Complemento:  </span> 
						<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo $pedido[0]->{"end_compl"}; ?></span>
					</div>

					<div style="width:100%; float:left; margin-top:15px;">
						<div style="width:50%; float:left;">
							<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> Município:  </span> 
							<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo $pedido[0]->{"end_cidade"}; ?></span>
						</div>  

						<div style="width:20%; float:left;";>
							<span style="color:<?php echo CINZA_ESCURO;?>; font-weight:bold;"> UF:  </span> 
							<span style="color:<?php echo CINZA_CLARO; ?>"> <?php echo $pedido[0]->{"end_uf"}; ?></span>
						</div>
					</div>

				</div>

				<div style="width:49%; float:left; height:auto; padding:10px 0px 0px 1%; padding-bottom: 15px; background-color:<?php echo LARANJA; ?>; color:#fff;">
					
					<div style="width:99%; float:left; margin-left:2%;"> 

						<div style="width:100%; float:left; font-size:45px;"> 
							<span> <b>RESUMO</b> </span>
						</div>

						<div style="width:95%; float:left; margin-top:40px;">
							<div style="float:left"><span> <b>Total de produtos: </b> </span></div>
							<div style="float:right"><span> <?php echo (int) $totprod; ?></span></div>
						</div>

						<div style="width:95%; float:left; margin-top:15px;"> 
							<div style="float:left"><span> <b>Total de Ítens: </b> </span></div>
							<div style="float:right"><span> <?php echo (int) $totitem; ?></span></div>
						</div>

						<div style="width:95%; float:left; margin-top:15px;"> 
							<div style="float:left">
								<span> 
									<b>Tipo de Frete: </b> 
								</span>
							</div>
							<div style="float:right">
								<span> 
									<?php 
										if ($pedido[0]->{'ecm_tpfrete'} == 1) {
											echo "PAC"; 
										} else if ($pedido[0]->{'ecm_tpfrete'} == 2) {
											echo "SEDEX";
										}

									?>
								</span>
							</div>
						</div>

						<div style="width:95%; float:left; margin-top:15px;"> 
							<div style="float:left"><span> <b>Valor Total: </b> </span></div>
							<div style="float:right"><span> <?php echo valorFormat($pedido[0]->{"not_totalnota"}); ?></span></div>
						</div>

						<div style="width:95%; float:left; margin-top:15px;"> 
							<div style="float:left"><span> <b>Status: </b> </span></div>
							<div style="float:right"><span> <?php echo $statusNota; ?></span></div>
						</div>

						<div style="width:95%; float:left; margin-top:15px;"> 
							<div style="float:left"><span> <b>Forma do Pagamento: </b> </span></div>
							<div style="float:right"><span> <?php echo $pedido[0]->{"cdp_descr"}; ?></span></div>
						</div>
						<?php
							if(isset($pedido[0]->{"ecm_cart_bandeira"}) && $pedido[0]->{"ecm_cart_bandeira"}!=""){
						?>
							<div style="width:95%; float:left; margin-top:15px;"> 
								<div style="float:left"><span> <b>Bandeira: </b> </span></div>
								<div style="float:right"><span> <?php echo $pedido[0]->{"ecm_cart_bandeira"}; ?></span></div>
							</div>
						<?php
							}
						?>
						
						<div style="width:95%; float:left; margin-top:15px;"> 
							<div style="float:left"><span> <b>Data do Pedido: </b> </span></div>
							<div style="float:right"><span> <?php echo data($pedido[0]->{"not_data"}); ?></span></div>
						</div>
						<?php
							if (isset($pedido[0]->{"ecm_cod_rastreamento"}) && !empty($pedido[0]->{"ecm_cod_rastreamento"})) {
								?>
								<div style="width:95%; float:left; margin-top: 15px;"> 
									<div style="float:left"><span> <b>Rastreamento: </b> </span></div>
									<div style="float:right"><span> <?php echo $pedido[0]->{"ecm_cod_rastreamento"}; ?></span></div>
								</div>
								<?php
							}
							if (isset($pedido[0]->{"ecm_cart_cod_trans"}) && !empty($pedido[0]->{"ecm_cart_cod_trans"})) {
								?>
								<div style="width:95%; float:left; margin-top: 15px;"> 
									<div style="float:left"><span> <b>Código da Transação: </b> </span></div>
									<div style="float:right"><span> <?php echo $pedido[0]->{"ecm_cart_cod_trans"}; ?></span></div>
								</div>
								<?php
							}
						?>
					</div>

				</div>

			</div>

			<!--Produtos-->
			<div style="width:100%; float:left; margin-top:50px;">
				
				<div style="width:100%; float:left; padding:20px; font-weight:bold; color:<?php echo CINZA_ESCURO; ?>">
					
					<div style="width:39%; float:left; margin-left:1%;"> Produto </div>
					<div style="width:15%; float:left; text-align:center; "> Quantidade </div>
					<div style="width:15%; float:left; text-align:center; "> Unitário </div>
					<div style="width:15%; float:left; text-align:center; "> Desconto </div>
					<div style="width:15%; float:left; text-align:center; "> Subtotal </div>

				</div>

				<?php 

					$totQtde = 0;
					$totUni = 0;
					$totDesc = 0;
					$totSub = 0;
				
					foreach($pedido as $indice => $prod) {

						if($indice % 2 == 0){
							$bgcolor = ZEBRADO;
						} else {
							$bgcolor = "#FFFFFF";
						}

						$totdesc += $prod->{"itn_valordesc"};
						
						?>
							<div style="width:100%; height:50px; float:left; padding:20px; background-color:<?php echo $bgcolor; ?>; color:<?php echo CINZA_CLARO; ?>">

								<div style="width:39%; float:left; padding-left:1%; font-weight:bold"> <?php echo $prod->{"ref_codigo"} . " - " . $prod->{"itn_descr"}; ?></div>
								<div style="width:15%; float:left; text-align:center; "> 
									<?php 
										$totQtde += $prod->{"itn_qtde"};
										echo qtde($prod->{"itn_qtde"}); 
									?>
								</div>
								<div style="width:15%; float:left; text-align:center; "> 
									<?php 
										$totUni += $prod->{"itn_valor"};
										echo valorFormat($prod->{"itn_valor"}); 
									?>
								</div>
								<div style="width:15%; float:left; text-align:center; "> 
									<?php 
										$totDesc += ($prod->{"itn_qtde"} * $prod->{"itn_valordesc"});
										echo valorFormat($prod->{"itn_valordesc"}); 
									?>
								</div>
								<div style="width:15%; float:left; text-align:center; "> 

									<?php 
									
										if(isset($prod->{"itn_subtotal"}) && !empty($prod->{"itn_subtotal"})){
											$totSub += $prod->{"itn_subtotal"};
											echo "R$" . valorFormat($totSub);
										} else { 
											$totSub += ($prod->{"itn_qtde"} * $prod->{"itn_valor"}) - $prod->{"itn_valordesc"};
											echo  "R$" . valorFormat(($prod->{"itn_qtde"} * $prod->{"itn_valor"}) - $prod->{"itn_valordesc"});
										} 
									?>
								</div>

							</div>

						<?php 
					}
					if( isset($pedido[0]->{"not_cdp_desc"}) && $pedido[0]->{"not_cdp_desc"}<0 ){
						$totDesc+= (-$pedido[0]->{"not_cdp_desc"});
					}
					
					if($totdesc>0){
				?>
				
				<div style="width:45%; float:right; margin-top:50px; padding:25px 40px 25px 25px; font-weight:bold; border-top: 1px solid <?php echo LARANJA; ?>; border-bottom: 1px solid <?php echo LARANJA; ?>; border-left: 1px solid <?php echo LARANJA; ?>; color:<?php echo LARANJA; ?>">
					<div style="float:left;"> DESCONTO </div>
					<div style="float:right;"> <?php echo "R$" . valorFormat($totDesc); ?> </div>
				</div>
				
				<?php
					}
				?>
				
				<div style="width:45%; float:right; margin-top:50px; padding:25px 40px 25px 25px; font-weight:bold; border-top: 1px solid <?php echo LARANJA; ?>; border-bottom: 1px solid <?php echo LARANJA; ?>; border-left: 1px solid <?php echo LARANJA; ?>; color:<?php echo LARANJA; ?>">
					<div style="float:left;"> FRETE </div>
					<div style="float:right;"> <?php echo "R$" . valorFormat($pedido[0]->{"ecm_valor_frete"}); ?> </div>
				</div>

				<div style="width:45%; float:right; margin-top:50px; padding:25px 40px 25px 25px; font-weight:bold; border-top: 1px solid <?php echo LARANJA; ?>; border-bottom: 1px solid <?php echo LARANJA; ?>; border-left: 1px solid <?php echo LARANJA; ?>; color:<?php echo LARANJA; ?>">
					<div style="float:left;"> TOTAL </div>
					<div style="float:right;"> <?php echo "R$" . valorFormat($pedido[0]->{"not_totalnota"}); ?> </div>
				</div>
			</div>

		</body>

	</html>

<?php 

	$html = ob_get_clean();
	$arquivo = str_replace(array(".",","), "", microtime(true));
	$fp = fopen($datapacket->getHostRoot()."tmp/".$arquivo.'.html', 'w');
	fwrite($fp, $html);
	fclose($fp);
	exec($datapacket->getHostRoot().'class/phantomjs/bin/phantomjs '.$datapacket->getHostRoot().'class/phantomjs/rasterizeEcommerce.js '.$datapacket->getHostRoot().'tmp/'.$arquivo.'.html '.$datapacket->getHostRoot().'tmp/'.$arquivo.'.pdf ["7,5in*5in"] ');

	if(file_exists($datapacket->getHostRoot()."tmp/".$arquivo.'.pdf')){
		
		if($_SERVER['SERVER_NAME'] == "dev.uds.com.br"){

			$ambiente = explode("/", substr($_SERVER['SCRIPT_NAME'], 1));
			
			if($ambiente[0] != "desktop"){

				exit("/" . $ambiente[0] . "/" . $ambiente[1] . "/tmp/" . $arquivo . ".pdf");
			}	
		} 
	
		echo "/desktop/tmp/" . $arquivo . ".pdf";

	} else { 
		
		echo "Ocorreu um erro ao gerar o arquivo.";
	}


 ?>