<?php
	header('Content-Type: text/html; charset=utf-8');
	include '../php/datapacket.php';
	include '../php/TParams.class.php';
	
	ob_start();
	
	function extenso($valor=0, $complemento=true) {
		$rt="";
		$singular = array("centavo", "real", "mil", "milhão", "bilhão", "trilhão", "quatrilhão");
		$plural = array("centavos", "reais", "mil", "milhões", "bilhões", "trilhões","quatrilhões");
	 
		$c = array("", "cem", "duzentos", "trezentos", "quatrocentos","quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
		$d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta","sessenta", "setenta", "oitenta", "noventa");
		$d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze","dezesseis", "dezesete", "dezoito", "dezenove");
		$u = array("", "um", "dois", "três", "quatro", "cinco", "seis","sete", "oito", "nove");
		$z=0;
	 
		$valor = number_format($valor, 2, ".", ".");
		$inteiro = explode(".", $valor);
		for($i=0;$i<count($inteiro);$i++){	
			for($ii=strlen($inteiro[$i]);$ii<3;$ii++){				
				$inteiro[$i] = "0".$inteiro[$i];
			}
		}
	 
		// $fim identifica onde que deve se dar junção de centenas por "e" ou por "," ;) 
		$fim = count($inteiro) - ($inteiro[count($inteiro)-1] > 0 ? 1 : 2);
		for ($i=0;$i<count($inteiro);$i++) {
			$valor = $inteiro[$i];
			$rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
			$rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
			$ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";
		
			$r = $rc.(($rc && ($rd || $ru)) ? " e " : "").$rd.(($rd && $ru) ? " e " : "").$ru;
			$t = count($inteiro)-1-$i;
			if ($complemento == true) {
				$r .= $r ? " ".($valor > 1 ? $plural[$t] : $singular[$t]) : "";
				if ($valor == "000")$z++; elseif ($z > 0) $z--;
				if (($t==1) && ($z>0) && ($inteiro[0] > 0)) $r .= (($z>1) ? " de " : "").$plural[$t]; 
			}
			
			if ($r) $rt = $rt . ((($i > 0) && ($i <= $fim) && ($inteiro[0] > 0) && ($z < 1)) ? ( ($i < $fim) ? ", " : " e ") : " ") . $r;
		}
		return($rt ? $rt : "zero");
	}
	
	function ordenar($a, $b) {
		if ( $a['itn_modelo'] == $b['itn_modelo'] )
			return 0;
		else if ( $a['itn_modelo'] > $b['itn_modelo'] )
			return -1;
		else
			return 1;
	}
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	
	if( isset($_REQUEST["not_codigo"]) ){
		
		$filtro = '{"cod":"700510","params":[
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
			{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"}
		]}';
		$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		
		//parcelas
		$filtro = '{"cod":"700826","params":[
			{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"}
		]}';
		$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		$datapacket->add($filtro);
		$doctos = $datapacket->open();
		$datapacket->clear();
		
		$company = $TParams->getCompany();
		
		//ordenar por modelo
		if( isset($ret[0]["itn_modelo"]) && $ret[0]["itn_modelo"]!="" ){
			uasort($ret, 'ordenar');
			$ret = array_values($ret);
		}
		
		if( isset($ret[0]) ){

			$totalDesconto = ($ret[0]['not_valordesc']) ? $ret[0]['not_valordesc'] : 0;
			$totalDespesa = $ret[0]['not_frete']+$ret[0]["not_despesa"]+$ret[0]["not_seguro"];
			if( $ret[0]['not_cdp_desc'] && $ret[0]['not_cdp_desc']<0 ){
				$totalDesconto+=-$ret[0]['not_cdp_desc'];
			}elseif( $ret[0]['not_cdp_desc'] && $ret[0]['not_cdp_desc']>0 ){
				$totalDespesa+=$ret[0]['not_cdp_desc'];
			}
			$subtotal = 0;
			$desconto = 0;
			$totalprod = 0;
			$totalserv= 0;
			$numero = ($ret[0]["not_auxiliar"] && !isset($_GET["oc"])) ? $ret[0]["not_auxiliar"] : $ret[0]["not_numero"];
			if( isset($_GET["op"]) && $_GET["op"]==1 ){
				$titulo = "Ordem de Produção";
			}elseif( isset($_GET["orc"]) && $_GET["orc"]==1 ){
				$titulo = "Orçamento";
			}elseif( isset($_GET["oc"]) && $_GET["oc"]==1 ){
				$titulo = "Ordem de Compra";
			}else{
				$titulo = "Pedido";
			}
			$modelo="";
			
			?>
				<!DOCTYPE HTML>
				<html lang="pt-BR">
					
					<head>
					
						<meta charset="UTF-8">
					
						<title> <?php echo $titulo;?> Nº <?php echo $ret[0]["not_numero"]?> - Fácil Online </title>
					
						<style>
							*{
								margin:0;
								padding:0;
								font-family:Arial, Verdana, sans-serif;
								font-size:12px;
							}

							body{
								max-width:900px;
								margin:0px auto;
								width:100%;
							}

							.spacer{
								clear:both;
								height:0px;
								width: 100%;
								border-bottom: 1px solid #CCC;
								margin:14px 0px;
							}

							/*Header*/
							#header{
								width:100%;
								min-height:120px;
							}

							.coluna{

							}
							.pgmto{
								width: 50%;
							}
							.itens{
								width:100%;
							}
							.itens tr th{
								text-align: left;
								border-bottom: 1px solid #CCC;
								padding: 0px 5px 10px 5px;
							}
							.itens tr td{
								text-align: left;
								height:30px;
								line-height:22px;
								vertical-align: top;
								padding: 3px 0 3px 0;
							}
							
							.cinza{
								background-color: #F1F1F1;
							}

						@media print and (max-width: 390px) {
							.coluna{
								width:100%;
							}
							#logo{
								width:50%;
							}
							.pgmto{
								width: 100%;
								padding-top:30px;
							}
							.itens tr td:nth-child(6), .itens tr th:nth-child(6){
								display:none
							}
							/*
							.itens tr td:nth-child(4), .itens tr th:nth-child(4){
								text-transform: lowercase;
							}
							*/
							.itens tr td{
								font-size:10px;
								padding: 5px 0px;
								height:30px;
							}
							.itens tr th{
								text-align: left;
								border-bottom: 1px solid #CCC;
								padding: 0px 5px 10px 5px;
							}
							.cinza{
								background-color: #FFF;
							}
							.col-desconto{
								display:none;
							}
						}

						h1{
							font-size:26px;
						}

						h2{
							font-size:15px;
						}

						.pgmto tr th{
							text-align: left;
							padding-bottom: 10px;
						}

						.pgmto tr td{
							text-align: left;
							height:23px;
							line-height:23px;
						}

						.total{
							float: right;
							width:49%;
							text-align: right;
						}

						.assinatura{
							float: left;
							width:40%;
							border-top: 1px solid #000;
							margin:100px 30px 0px 0px;
						}

						</style>
					
						<link rel="icon" href="../resources/images/favicon.ico" type="image/x-icon">
					
					</head>

					<body>
						
						<!--header-->
						<table id="header">
							<tr>
							<td style="width:33%">
								<?php 
									
									if(isset($company->{"emp_logo"})&&!empty($company->{"emp_logo"})){
										?>
											<img src="<?php echo "https://".$_SERVER["SERVER_NAME"]."/uploads/".$company->{"emp_codigo"}."/".$company->{"emp_logo"} ;?>" alt="" style="width:250px"><br><br>
										<?php
									}

								?>
							</td>
							
							<td style="padding-top:30px;width:33%">
								<strong>Nome Fantasia: </strong>
								<?php
									if(isset($company->{"emp_titulo"}) && $company->{"emp_titulo"} == 2){
										
										echo $company->{"emp_fantasia"};
									}else{
										
										echo $company->{"emp_razao"};
									}
								?><br>
								<strong>CNPJ: </strong><?php echo substr($company->emp_cpfcnpj,0,2).".".substr($company->emp_cpfcnpj,2,3).".".substr($company->emp_cpfcnpj,5,3)."/".substr($company->emp_cpfcnpj,8,4)."-".substr($company->emp_cpfcnpj,12,2) ?><br>
								<strong>Inscrição Estadual: </strong><?php echo $company->emp_inscrg; ?><br>
								<strong>CEP: </strong><?php echo $company->emp_cep; ?><br>
								<strong>Endereço: </strong><?php echo $company->emp_endereco;?>, <?php echo $company->emp_num;?><?php echo (isset($company->emp_complem) && $company->emp_complem!="") ? " - ".$company->emp_complem : "";?><br>
								<strong>Bairro: </strong><?php echo $company->emp_bairro;?><br>
								<strong>Cidade: </strong><?php echo $company->emp_cidade;?>-<?php echo $company->emp_uf;?><br>
								<strong>Telefone: </strong><?php echo (isset($company->emp_fone) && $company->emp_fone!="") ? "(".substr($company->emp_fone,0,2).")".substr($company->emp_fone,2,4)."-".substr($company->emp_fone,6) : "";?><br>
							</td>
							
							<td style="padding-top:30px;margin:0;width:33%">
								<!--<strong>E-mail: </strong><?php //echo $company->emp_email;?><br>-->
								<div style="margin-top:5px; text-align:right; font-size:9px; width:100%">
									<h1><?php echo $titulo; ?><br> nº <?php echo $numero;?></h1>
									<strong>Data do <?php echo $titulo; ?>: </strong> <?php  echo date("d/m/Y", strtotime($ret[0]["not_data"])); ?><br>
									<?php if( isset($ret[0]["pedido_nfe"]) && $ret[0]["pedido_nfe"]!="" ){ ?><strong>Número da NF-e vinculada: </strong> <span style="font-size:2=18px"><?php  echo $ret[0]["pedido_nfe"]; ?></span><br><?php } ?>
									<?php if( isset($_GET["orc"]) && $_GET["orc"]==1 ){ ?>
									<strong>Validade do Orçamento: </strong> <?php echo date("d/m/Y", strtotime($ret[0]["not_data"]."+ 7 days")); ?><br>
									<?php } ?>
									<strong><?php echo ( isset($_GET["oc"]) && $_GET["oc"]==1 ) ? "Comprador:" : "Vendedor:"?> </strong><?php echo $ret[0]["cad_nomevend"];?><br>
									<strong>Condição Pgto: </strong> <?php echo $ret[0]["cdp_descr"]; ?><br>
								</div>
							</td>
							</tr>
						</table>
						
						<div class="spacer"></div>
						
						<strong><?php echo ( isset($_GET["oc"]) && $_GET["oc"]==1 ) ? "Fornecedor:" : "Cliente:"?> </strong><?php echo substr($ret[0]["cad_nomeraz"],0,70); ?><br><br>
						
						<table style="width:100%"><tr>
						<td style="width:33%">
							<strong>Contato: </strong><?php echo $ret[0]["con_nome"];?><br>
							<strong><?php echo ($ret[0]["cad_pessoa"]==2) ? "CNPJ:" : "CPF:"?>: </strong><?php echo ($ret[0]["cad_pessoa"]==2)
												? substr($ret[0]["cad_cnpjcpf"],0,2).".".substr($ret[0]["cad_cnpjcpf"],2,3).".".substr($ret[0]["cad_cnpjcpf"],5,3)."/".substr($ret[0]["cad_cnpjcpf"],8,4)."-".substr($ret[0]["cad_cnpjcpf"],12,2)
												: substr($ret[0]["cad_cnpjcpf"],0,3).".".substr($ret[0]["cad_cnpjcpf"],3,3).".".substr($ret[0]["cad_cnpjcpf"],6,3)."-".substr($ret[0]["cad_cnpjcpf"],9,2);?><br>
							<strong>CEP: </strong><?php if( isset($ret[0]["end_cep"]) && $ret[0]["end_cep"]!="" ) echo substr($ret[0]["end_cep"],0,5)."-".substr($ret[0]["end_cep"],5);?><br>
						</td>
						
						<td style="width:33%">
							<strong>Endereço: </strong><?php echo $ret[0]["end_nome"];?>, <?php echo $ret[0]["end_num"];?><?php echo (isset($ret[0]["end_compl"]) && $ret[0]["end_compl"]!="") ? " - ".$ret[0]["end_compl"] : "";?><br>
							<strong>Bairro: </strong><?php echo $ret[0]["end_bairro"];?><br>
							<strong>Cidade: </strong><?php echo $ret[0]["end_cidade"];?>-<?php echo $ret[0]["end_uf"];?><br>
						</td>
						
						<td style="margin:0; width:33%">
							<strong>Telefone: </strong><?php echo $ret[0]["cad_telefone"];?><br>
							<strong>Celular: </strong><?php echo $ret[0]["cad_celular"];?><br>
							<strong>E-mail: </strong><?php echo $ret[0]["cad_email"];?><br>
						</td>
						</tr></table>
						
						<div class="spacer"></div>
						
						<!--produtos-->
						<?php
							if( isset($ret[0]["ref_codigo"]) ){
								
								if( isset($_GET["oc"]) && $_GET["oc"]==1 ){
									$cs = "colspan='6'";
								}else if($ret[0]["itn_obs"]!=""){
									$cs = "colspan='5'";
								}else{
									$cs = "colspan='4'";
								}
									
								//separar por modelo (se houver)
								if( isset($ret[0]["itn_modelo"]) && $ret[0]["itn_modelo"]!="" ){
									echo "<h2>".$ret[0]["itn_modelo"]."</h2><br>";
									$modelo = $ret[0]["itn_modelo"];
								}
						?>
						<table cellspacing="0" cellpadding="0" class="itens">
							<tr>
								<th>Cód.</th>
								<th style="text-align: center">Unid.</th>
								<th style="text-align: center">Qtde.</th>
								<th>Produto</th>
								<?php
									if( isset($_GET["oc"]) && $_GET["oc"]==1 ){
								?>
									<th style="text-align:right">IPI</th>
									<th style="text-align:right">ICMS ST</th>
								<?php
									}
									if( !isset($_GET["op"]) ){
								?>
								<?php if($ret[0]["itn_largura"]>0){ ?><th style="text-align:right">Larg.</th><?php } ?>
								<?php if($ret[0]["itn_altura"]>0){ ?><th style="text-align:right">Alt.</th><?php } ?>
								<?php if($ret[0]["itn_obs"]!=""){ ?><th>Obs.</th><?php } ?>
								<th style="text-align:right">Vlr Un.</th>
								<th style="text-align:right">Desconto</th>
								<th style="text-align:right">Subtotal</th>
								<?php
									}
								?>
							</tr>
							<?php 
								$prods = array();
								$i=0;
								foreach($ret as $prod){
									//separar por modelo (se houver)
									if( isset($ret[0]["itn_modelo"]) && $ret[0]["itn_modelo"]!="" ){
										if($i!=0 && $modelo!=$ret[$i]["itn_modelo"]){
							?>
										<?php
											if( !isset($_GET["op"])  ){
										?>
										<tr>
											<td <?php echo  $cs;?> style="border-top:1px solid #CCC; padding:10px 0px;">&nbsp;</td>
											<td style="border-top:1px solid #CCC; padding:10px 0px; text-align:right;font-weight:bold"><?php echo ($subtotal>0) ? number_format($subtotal, 2, ",", ".") : "0,00"; ?></td>
											<td style="border-top:1px solid #CCC; padding:10px 0px; text-align:right;font-weight:bold"><?php echo ($desconto>0) ? number_format($desconto, 2, ",", ".") : "0,00"; ?></td>
											<td style="border-top:1px solid #CCC; padding:10px 0px; text-align:right;font-weight:bold"><?php echo ($totalprod>0) ? number_format($totalprod, 2, ",", ".") : "0,00"; ?></td>
										</tr>
										<?php
											}
										?>
										</table>
										<h2><?php echo $ret[$i]["itn_modelo"]?></h2><br>
										<table cellspacing="0" cellpadding="0" class="itens">
											<tr>
												<th>Cód.</th>
												<th style="text-align: center">Unid.</th>
												<th style="text-align: center">Qtde.</th>
												<th>Produto</th>
												<?php
													if( isset($_GET["oc"]) && $_GET["oc"]==1 ){
												?>
												<th style="text-align:right">IPI</th>
												<th style="text-align:right">ICMS ST</th>
												<?php
													}
													if( !isset($_GET["op"])  ){
												?>
												<?php if($ret[0]["itn_largura"]>0){ ?><th style="text-align:right">Larg.</th><?php } ?>
												<?php if($ret[0]["itn_altura"]>0){ ?><th style="text-align:right">Alt.</th><?php } ?>
												<?php if($ret[0]["itn_obs"]!=""){ ?><th>Obs.</th><?php } ?>
												<th style="text-align:right">Vlr Un.</th>
												<th style="text-align:right">Desconto</th>
												<th style="text-align:right">Subtotal</th>
												<?php
													}
												?>
											</tr>
							<?php
											$modelo=$ret[$i]["itn_modelo"];
											$subtotal=0;
											$desconto=0;
											$totalprod=0;
										}
									}
									if( array_search($prod["ref_codigo"]."-".$prod["itn_ordem"], $prods)===false ){
									$subtotal+=$prod["itn_valor"]*$prod["itn_qtde"];
									$desconto+=$prod["itn_valordesc"]*$prod["itn_qtde"];
									$totalprod+=$prod["itn_subtotal"]+$prod["itn_ipi"]+$prod["itn_icmssubst"];
									$tribjson = json_decode(base64_decode($prod["itn_tribjson"]));
									$ref_codigo = $tribjson->rowdata[0]->ref_codigo;
							?>
							<tr <?php //echo ($i%2!=0) ? 'class="cinza"' : '';?>>								
								<td style="width:6%;border-bottom: 1px solid #CCC;"><?php echo $ref_codigo;?></td>
								<td style="width:6%;text-align:center; border-bottom: 1px solid #CCC;"><?php echo $prod["uni_codigo"];?></td>
								<td style="width:6%; text-align: center;border-bottom: 1px solid #CCC;"><?php echo (floor($prod["itn_qtde"]) == $prod["itn_qtde"]) ? (int) $prod["itn_qtde"] : number_format($prod["itn_qtde"], 2, ",", ".");?></td>
								<td style="width:38%;border-bottom: 1px solid #CCC;"><?php echo $prod["itn_descr"]; echo ($prod["itn_obs"] && $prod["itn_obs"]!="") ? "<br>".$prod["itn_obs"] : "";?></td>
								<?php
									if( isset($_GET["oc"]) && $_GET["oc"]==1 ){
								?>
								<td style="width:8%; text-align:right;border-bottom: 1px solid #CCC;"><?php echo ($prod["itn_ipi"]>0) ? number_format($prod["itn_ipi"], 2, ",", ".") : "0,00";?></td>
								<td style="width:9%; text-align:right;border-bottom: 1px solid #CCC;"><?php echo ($prod["itn_icmssubst"]>0) ? number_format($prod["itn_icmssubst"], 2, ",", ".") : "0,00";?></td>
								<?php
									}
									if( !isset($_GET["op"]) ){
								?>
								<?php if($ret[0]["itn_largura"]>0){ ?><td style="width:8%; text-align:right;border-bottom: 1px solid #CCC;"><?php echo ($prod["itn_largura"]>0) ? number_format($prod["itn_largura"], 2, ",", ".") : "0,00";?></td><?php } ?>
								<?php if($ret[0]["itn_altura"]>0){ ?><td style="width:8%; text-align:right;border-bottom: 1px solid #CCC;"><?php echo ($prod["itn_altura"]>0) ? number_format($prod["itn_altura"], 2, ",", ".") : "0,00";?></td><?php } ?>
								<?php if($ret[0]["itn_obs"]!=""){ ?><td style="width:15%; padding-left:4px;border-bottom: 1px solid #CCC;"><?php echo $prod["itn_obs"];?></td><?php } ?>
								<td style="width:12%; text-align:righ;border-bottom: 1px solid #CCC;t"><?php echo ($prod["itn_valor"]>0) ? number_format($prod["itn_valor"], 2, ",", ".") : "0,00";?></td>
								<td style="width:10%; text-align:right;border-bottom: 1px solid #CCC;"><?php echo ($prod["itn_valordesc"]>0) ? number_format($prod["itn_valordesc"], 2, ",", ".") : "0,00";?></td>
								<td style="width:12%; text-align:right;border-bottom: 1px solid #CCC;"><?php echo ($prod["itn_subtotal"]>0) ? number_format(($prod["itn_subtotal"]+$prod["itn_ipi"]+$prod["itn_icmssubst"]), 2, ",", ".") : "0,00";?></td>
								<?php
									}
								?>
							</tr>
							<?php
									array_push($prods, $prod["ref_codigo"]."-".$prod["itn_ordem"]);
									}
									$i++;
								}
							?>
							<?php
								if( !isset($_GET["op"])  ){
									
							?>
							<tr>
								<td <?php echo  $cs;?> style="border-top:1px solid #CCC; padding:10px 0px;">&nbsp;</td>
								<td style="border-top:1px solid #CCC; padding:10px 0px; text-align:right;font-weight:bold"><?php echo ($subtotal>0) ? number_format($subtotal, 2, ",", ".") : "0,00"; ?></td>
								<td style="border-top:1px solid #CCC; padding:10px 0px; text-align:right;font-weight:bold" class="col-desconto"><?php echo ($desconto>0) ? number_format($desconto, 2, ",", ".") : "0,00"; ?></td>
								<td style="border-top:1px solid #CCC; padding:10px 0px; text-align:right;font-weight:bold"><?php echo ($totalprod>0) ? number_format($totalprod, 2, ",", ".") : "0,00"; ?></td>
							</tr>
							<?php
								}
							?>
						</table>
						<?php } ?>
						
						<!--serviços-->
						<?php if( isset($ret[0]["svc_codigo"]) && !isset($_GET["op"]) ){ ?>
						
						<div class="spacer"></div>
						
						<table cellspacing="0" cellpadding="0" class="itens">
							<tr>
								<th>Cód.</th>
								<th style="text-align:center">Qtde.</th>
								<th>Serviço</th>
								<th>Data Prest.</th>
								<th>OBS</th>
								<th style="text-align:right">Vlr Un.</th>
								<th style="text-align:right">Desconto</th>
								<th style="text-align:right">Subtotal</th>
							</tr>
							<?php 
								$servs = array();
								$subtotal=0;
								$desconto=0;
								foreach($ret as $serv){
									if( array_search($serv["its_codigo"], $servs)===false ){
									$subtotal+=$serv["its_valor"]*$serv["its_qtde"];
									$desconto+=$serv["its_desc"];
							?>
							<tr>								
								<td style="width:7%; border-bottom: 1px solid #CCC;"><?php echo $serv["svc_codigo"];?></td>
								<td style="width:8%; text-align: center; border-bottom: 1px solid #CCC;"><?php echo (floor($serv["its_qtde"]) == $serv["its_qtde"]) ? (int) $serv["its_qtde"] : number_format($serv["its_qtde"], 2, ",", ".");?></td>
								<td style="width:26%; border-bottom: 1px solid #CCC;"><?php echo utf8_decode($serv["its_descr"]);?></td>
								<td style="width:14%; border-bottom: 1px solid #CCC;"><?php echo implode("/", array_reverse(explode("-", substr($serv["its_data"],0,10)))).substr($serv["its_data"], 10, 6);?></td>
								<td style="width:11%; border-bottom: 1px solid #CCC;"><?php echo $serv["its_obs"];?></td>
								<td style="width:12%; text-align:right; border-bottom: 1px solid #CCC;"><?php echo ($serv["its_valor"]>0) ? number_format($serv["its_valor"], 2, ",", ".") : "0,00";?></td>
								<td style="width:10%; text-align:right; border-bottom: 1px solid #CCC;"><?php echo ($serv["its_desc"]>0) ? number_format($serv["its_desc"], 2, ",", ".") : "0,00";?></td>
								<td style="width:12%; text-align:right; border-bottom: 1px solid #CCC;"><?php echo ($serv["its_subtotal"]>0) ? number_format($serv["its_subtotal"], 2, ",", ".") : "0,00";?></td>
							</tr>
							<?php
										array_push($servs, $serv["its_codigo"]);
									}
								}
							?>
							<tr>
								<td colspan="5" style="border-top:1px solid #CCC; padding:10px 0px;">&nbsp;</td>
								<td style="border-top:1px solid #CCC; padding:10px 0px; text-align:right;font-weight:bold"><?php echo ($subtotal>0) ? number_format($subtotal, 2, ",", ".") : "0,00"; ?></td>
								<td style="border-top:1px solid #CCC; padding:10px 0px; text-align:right;font-weight:bold" class="col-desconto"><?php echo ($desconto>0) ? number_format($desconto, 2, ",", ".") : "0,00"; ?></td>
								<td style="border-top:1px solid #CCC; padding:10px 0px; text-align:right;font-weight:bold"><?php echo ($ret[0]["not_totalserv"]>0) ? number_format($ret[0]["not_totalserv"], 2, ",", ".") : "0,00"; ?></td>
							</tr>
						</table>
						<?php } ?>
						
						<div class="spacer"></div>
						
						<!--Transporte/ Frete-->
						<?php
							if( (isset($ret[0]["transportadora"]) && $ret[0]["transportadora"]!="") || (isset($ret[0]["not_placa"]) && $ret[0]["not_placa"]!="") || (isset($ret[0]["not_pesobruto"]) && $ret[0]["not_pesobruto"]>0) || (isset($ret[0]["not_especie"]) && $ret[0]["not_especie"]!="") ){
						?>							
							<?php  if(isset($ret[0]["transportadora"]) && $ret[0]["transportadora"]!=""){ ?>
							<strong>Transportadora: </strong><?php echo substr($ret[0]["transportadora"],0,70); ?><br><br>
							<?php } ?>
							<div class="coluna">
								<strong>Tipo do Frete: </strong><?php echo ($ret[0]["not_tpfrete"]==1) ? "Por conta do Emitente" : "Por conta do Destinatário";?><br>
								<strong>Valor do Frete: </strong><?php echo ($ret[0]["not_frete"]>0) ? number_format($ret[0]["not_frete"], 2, ",", "") : "0,00"?><br>
								<strong>Placa: </strong><?php echo ($ret[0]["not_placa"]!="") ? $ret[0]["not_placa"] : ""?><br>
							</div>
							
							<div class="coluna" >
								<strong>Espécie: </strong><?php echo $ret[0]["not_especie"];?><br>
								<strong>Marca: </strong><?php echo $ret[0]["not_marca"];?><br>
								<strong>Número: </strong><?php echo $ret[0]["not_nro"];?><br>
							</div>
							
							<div class="coluna" style="margin:0">
								<strong>Quantidade: </strong><?php echo ($ret[0]["not_qtde"]>0)  ? number_format($ret[0]["not_qtde"], 2, ",", "") : "";?><br>
								<strong>Peso Bruto: </strong><?php echo ($ret[0]["not_pesobruto"]>0)  ? number_format($ret[0]["not_pesobruto"], 2, ",", "") : "";?><br>
								<strong>Peso Líquido: </strong><?php echo ($ret[0]["not_pesoliquido"]>0)  ? number_format($ret[0]["not_pesoliquido"], 2, ",", "") : "";?><br>
							</div><br style="clear:both">
						
						<div class="spacer"></div>
						<?php
							}
						?>
						
						<!--plano de conta/ centro de custo-->
						<?php
							if((isset($ret[0]["ccu_codigo"]) && $ret[0]["ccu_codigo"]!="") || (isset($ret[0]["plc_codigo"]) && $ret[0]["plc_codigo"]!="")){
						?>
								<div class="coluna" style="margin:0;width:50%">
									<strong><?php echo (isset($ret[0]["ccu_codigo"]) && $ret[0]["ccu_codigo"]!="") ? "CENTRO DE CUSTO: ".$ret[0]["ccu_codigo"]." - ".$ret[0]["ccu_descr"] : ""?></strong>
								</div>
								<div class="coluna" style="margin:0; width:50%">
									<strong><?php echo (isset($ret[0]["plc_codigo"]) && $ret[0]["plc_codigo"]!="") ? "PLANO DE CONTA: ".$ret[0]["plc_codigo"]." - ".$ret[0]["plc_descr"] : ""?></strong>
								</div><br style="clear:both"><br>
						<?php
							}
						?>
						
						<!--totais-->
						<?php
							if( !isset($_GET["op"]) ){
						?>
						<div class="total">
							<h1>Totais</h1>
							<strong>Subtotal: </strong><?php echo ( ($ret[0]["not_totalprod"]+$ret[0]["not_totalserv"]) >0) ? number_format(($ret[0]["not_totalprod"]+$ret[0]["not_totalserv"]), 2, ",", ".") : "0,00";?><br>
							<strong>Descontos: </strong><?php echo ($totalDesconto>0) ? number_format($totalDesconto, 2, ",", ".") : "0,00";?><br>
							<strong>Frete+adicionais: </strong><?php echo ($totalDespesa>0) ? number_format($totalDespesa, 2, ",", ".") : "0,00";?><br><br>
							<strong style="font-size:20px">Total R$: <?php echo ($ret[0]["not_totalnota"]>0) ? number_format($ret[0]["not_totalnota"], 2, ",",".") : "0,00"?></strong> <br>
						</div>
						<?php
							}
						?>
						
						<!--pagamento-->
						<?php
							if( !isset($_GET["op"]) ){
						?>
						
						<?php
							if( 1==1 ){
								$docs = array();
						?>
							
							<table cellpadding="0" cellspacing="0" class="pgmto">
							<tr>
								<th>Número</th>
								<th>Tipo Pag.</th>
								<th>Valor R$</th>
								<th>Vencimento</th>
							</tr>
						<?php
								foreach($doctos as $doc){
									if( isset($doc["doc_numero"]) && array_search($doc["doc_numero"], $docs)===false ){
						?>
							<tr>
								<td><?php echo $doc["doc_numero"];?></td>
								<td>
									<?php 
										switch($doc["doc_tipo"]){
											case 1:
												echo "DUPLICATA";
												break;
											case 2:
												echo "BOLETO";
												break;
											case 3:
												echo "PROMISSÓRIA";
												break;
											case 4:
												echo "CHEQUE";
												break;
											case 5:
												echo "CARTÃO CRÉD.";
												break;
											case 6:
												echo "CARTÃO DÉB.";
												break;
											case 7:
												echo "CARNÊ";
												break;
											case 8:
												echo "DARF";
												break;
											case 9:
												echo "DÉP. EM CONTA";
												break;
											case 10:
												echo "DINHEIRO";
												break;
											case 11:
												echo "DÉB. EM CONTA";
												break;
											case 12:
												echo "FATURA";
												break;
											default:
												echo "OUTRO";
												break;
										}
									?>
								</td>
								<td><?php echo ($doc["doc_valor"]>0) ? number_format($doc["doc_valor"], 2, ",", ".") : "0,00";?></td>
								<td><?php echo implode("/", array_reverse(explode("-", substr($doc["doc_dtvcto"],0,10))));?></td>
							</tr>
						<?php
										array_push($docs, $doc["doc_numero"]);
									}
								}
						?>
						</table>
						<?php
							}
						?>
						
						<?php
							}
						?>

						

						<?php 
							if( isset($ret[0]["not_obs1"]) && !empty($ret[0]["not_obs1"]) || (isset($company->emp_pdv_msgpadrao) && !empty($company->emp_pdv_msgpadrao) && isset($_GET["oc"]) && $_GET["oc"]==1) ){
						?>
									<!--Observação-->
									<br style="clear:both"><div class="spacer"></div>
									<fieldset id="observacao">
										
										<legend>OBSERVAÇÃO</legend>
										
										<table cellspacing="6">							
											<tr>
												<td></td>
												<td>
													<?php 
														echo ( isset($ret[0]["not_obs1"]) && !empty($ret[0]["not_obs1"]) ) ? str_replace("\n", "<br>", utf8_encode(base64_decode($ret[0]["not_obs1"]))) : "";
														echo ( isset($company->emp_pdv_msgpadrao) && !empty($company->emp_pdv_msgpadrao ) && isset($_GET["oc"]) && $_GET["oc"]==1 ) ? "<br>".str_replace("\n", "<br>", utf8_encode(base64_decode($company->emp_pdv_msgpadrao))) : "";
													?>
												</td>
											</tr>
										
										</table>

									</fieldset>
								<?php
							}
						?>

						<!--Nota Promissória-->
						<?php 

							if( isset($_REQUEST["np"]) ){

								?>
								<br style="clear:both"><div class="spacer" style="margin-top:100px"></div>
									<div id="np">
									
										<b>NOTA PROMISSÓRIA Nº: <?php echo $numero?></b><br>
										
										<!--<b>NO DIA: </b><br>-->
										
										PAGAREI POR ESTA ÚNICA NOTA PROMISSÓRIA À <b><?php echo $company->{"emp_razao"};?></b>, CNPJ: <b><?php  echo substr($company->{"emp_cpfcnpj"},0,2).".".substr($company->{"emp_cpfcnpj"},2,3).".".substr($company->{"emp_cpfcnpj"},5,3)."/".substr($company->{"emp_cpfcnpj"},8,4)."-".substr($company->{"emp_cpfcnpj"},12,2)?></b>, OU À SUA ORDEM, A QUANTIA DE R$ <b><?php echo ($ret[0]["not_totalnota"]>0) ? number_format($ret[0]["not_totalnota"], 2, ",", ".") : "0,00";?>
										(<?php	echo mb_strtoupper(extenso($ret[0]["not_totalnota"]), 'UTF-8');	?>)</b>
										
										<table>
											
											<tr>
												<td colspan="3"><b>CLIENTE:</b> <?php echo $ret[0]["cad_nomeraz"]?></td>
											</tr>
											
											<tr>
												<td colspan="3"><b><?php echo ($ret[0]["cad_pessoa"]==2) ? "CNPJ:" : "CPF:"?></b>
													<?php
														if($ret[0]["cad_pessoa"]==2){ 
															echo substr($ret[0]["cad_cnpjcpf"],0,2).".".substr($ret[0]["cad_cnpjcpf"],2,3).".".substr($ret[0]["cad_cnpjcpf"],5,3)."/".substr($ret[0]["cad_cnpjcpf"],8,4)."-".substr($ret[0]["cad_cnpjcpf"],12,2);
														}else{
															echo substr($ret[0]["cad_cnpjcpf"],0,3).".".substr($ret[0]["cad_cnpjcpf"],3,3).".".substr($ret[0]["cad_cnpjcpf"],6,3)."-".substr($ret[0]["cad_cnpjcpf"],9,2);
														}
													?>
												</td>
											</tr>
											
											<tr>
												<td><b>ENDEREÇO:</b> <?php echo $ret[0]["end_nome"]?>, <?php echo $ret[0]["end_num"]?></td>
												<td><b>BAIRRO:</b> <?php echo $ret[0]["end_bairro"]?></td>
												<td><b>CIDADE/UF:</b> <?php echo $ret[0]["end_cidade"]."-".$ret[0]["end_uf"]?></td>
											</tr>
											
											<tr>
												<td><b>EMISSÃO:</b> <?php echo date("d/m/Y");?></td>
												<td><b>PAGÁVEL EM <?php echo $company->{"emp_cidade"}."-".$company->{"emp_uf"};?></b></td>
												<td></td>
											</tr>
											
											<tr style="height:30px;">
												<td colspan="3"></td>
											</tr>
											
											<tr>
												<td colspan="2"></td>
												<td style="border-top:1px solid #000; text-align:center;width:330px"><?php echo substr($ret[0]["cad_nomeraz"],0,40)?></td>
											</tr>
										
										</table>
										
									</div>
						
								<?php 
						
							}else{
						?>
									<br style="clear:both"><div class="assinatura">
										<?php echo (isset($company->emp_titulo) && $company->emp_titulo==2) ? $company->emp_fantasia : $company->emp_razao; ?>
									</div>
									
									<div class="assinatura">
										<?php echo $ret[0]["cad_nomeraz"]; ?>
									</div>
						<?php
								
							}

						?>
						
					</body>

				</html>
				
			<?php

			if(!isset($logo)) $logo = "";
			if(!isset($data)) $data = "";
			if(!isset($titulo)) $titulo = "";
			if(!isset($relatorioTitle)) $relatorioTitle = "";
			if(!isset($filtros)) $filtros = "";
			if(!isset($colunas)) $colunas = "";
			if(!isset($cabecalhoHeight)) $cabecalhoHeight = "0"; // passar apenas numeros sem px, %..;
			$html = ob_get_clean();
			if(!is_dir($TParams->getHostRoot()."tmp/")){
				mkdir($TParams->getHostRoot()."tmp/", 0777, true);
			}
			$arquivo = str_replace(array(".",","), "", microtime(true));
			$fp = fopen($TParams->getHostRoot()."tmp/".$arquivo.'.html', 'w');
			fwrite($fp, $html);
			fclose($fp);

			exec($TParams->getHostRoot().'class/phantomjs/bin/phantomjs '.$TParams->getHostRoot().'class/phantomjs/rasterizeOs.js '.$TParams->getHostRoot()."tmp/".$arquivo.'.html '.$TParams->getHostRoot()."tmp/".$arquivo.'.pdf ["7,5in*5in"] "'.$relatorioTitle.'" "'.base64_encode($titulo).'" "'.$data.'" "'.base64_encode(json_encode($filtros)).'" "'.base64_encode(json_encode($colunas)).'" "'.base64_encode($logo).'" "'.$cabecalhoHeight.'"');
	
			if( file_exists($TParams->getHostRoot()."tmp/".$arquivo.'.pdf') ){
				
				//envio por e-mail
				if( isset($_REQUEST["email"]) && $_REQUEST["email"]!="" ){
					echo $TParams->getHostRoot()."tmp/".$arquivo.'.pdf';
				}else if( isset($_REQUEST["api"]) && $_REQUEST["api"]==1 ){
					$filename = basename($TParams->getHostRoot()."tmp/".$arquivo.'.pdf');
					$filecontent = file_get_contents($TParams->getHostRoot()."tmp/".$arquivo.'.pdf');
					$base64content = base64_encode($filecontent);
					$response = [
						'nomearquivo' => $filename,
						'conteudo' => $base64content,
					];
					$jsonResponse = json_encode($response);
					header('Content-Type: application/json');
					echo $jsonResponse;
				}else{
					header('Content-Type: application/pdf');
					header('Content-Disposition: inline; filename="'.$titulo.' Nº '.$ret[0]["not_numero"].' - Fácil Online .pdf"');
					header('Content-Transfer-Encoding: binary');
					header('Accept-Ranges: bytes');
					// Lê o arquivo e envia-o para o output buffer
					@readfile($TParams->getHostRoot()."tmp/".$arquivo.'.pdf');
				}
			}

		}else{
		
			exit("Dados Incompletos para impressão, favor verificar o cadastro do Cliente deste ".$titulo);
		}

	}else{
		
		exit("Nâo há dados para serem impressos");
	
	}
?>