<?php
	header('Content-Type: text/html; charset=utf-8');
	include '../php/datapacket.php';
	include '../php/TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	
	function telefone($telefone){
		$ddd = substr($telefone,0,2);
		$fone1 = (strlen($telefone==10)) ? substr($telefone,2,4) : substr($telefone,2,5);
		$fone2 = (strlen($telefone==10)) ? substr($telefone,6) : substr($telefone,7);
		return "(".$ddd.") ".$fone1."-".$fone2; 
	}
	
	function maskCNPJCPF($str){
		if(!empty($str)){
			if(strlen($str)==11){
				$cpfCnpj = substr($str,0,3).'.'.substr($str,3,3).'.'.substr($str,6,3).'-'.substr($str,9,2);
			}else if(strlen($str)==14){
				$cpfCnpj = substr($str,0,2).'.'.substr($str,2,3).'.'.substr($str,5,3).'/'.substr($str,8,4).'-'.substr($str,12,2);
			}else{
				$cpfCnpj = $str;
			}
		}else{
			$cpfCnpj = "";	
		}
		return $cpfCnpj;
	}
	
	if( (isset($_REQUEST["email"]) && $_REQUEST["email"]!="") || (isset($_REQUEST["api"]) && $_REQUEST["api"]==1) ){
		ob_start();
	}
	
	if( isset($_REQUEST["ipj_codigo"]) ){
		
		$filtro = '{"cod":"700806","params":[
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
			{"name":"ipj_codigo","value":"'.$_REQUEST["ipj_codigo"].'","type":"string"}
		]}';

		$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		
		$company = $TParams->getCompany();
		
		if( isset($ret[0]) ){
			
?>
<!DOCTYPE HTML>
<html lang="pt-BR">
<head>
	<meta charset="UTF-8">
	<title>Projeto <?php echo $ret[0]["ipj_titulo"]?> - Fácil Online</title>
	<link rel="stylesheet" href="css/ordemServico.css">
	<link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">
	<style>
		*{
			margin:0;
			padding:0;
			font-family:Arial, Verdana, sans-serif;
			font-size:11px;
		}

		body{
			max-width:900px;
			margin:0 auto;
			width:100%;
		}
		table{
			border-collapse: collapse;
		}
		table tr td{
			border: 1px solid #000;
			padding:0px 5px;
			height:20px;
		}
		table tr th{
			padding:0px 5px;
		}
		table tr{
			height:30px;
		}
		#patrimonio tr, #produto tr, #servico tr, #analise tr, #relatorio tr{
			height:23px;
		}

		/*Header*/
		#header{
			width:70%;
			float:left;
			margin-right:5px;
		}
		#logo{
			max-width:200px;
			max-height:65px;
		}
		#direita{
			width:29%;
		}
		#direita tr td{
			text-align: center
		}

		#patrimonio, #produto, #servico, #analise, #relatorio{
			width: 100%;
		}

		#total{
			border: 1px solid #000;
			width:25%;
			height:25px;
			line-height:25px;
			float: right;
			padding: 0px 5px;
		}
		
		#descricao{
			border: 1px solid #000;
			width:95.5%;
			padding:15px;
		}

		/*Rodape*/
		.assinatura{
			position: relative;
			float: left;
			width:20%;
			border-top:1px solid #000;
			margin:30px 5%;
			text-align: center;
			top:120px;
		}

		.assinatura img{
			position: absolute;
			top: -153px;
			left: 15px;
		}

		.dia{
			float:left;
			margin:140px 10% 0 10%;
			text-align: center;
		}
	</style>
</head>
<body>
	<!--header-->
	<table id="header" cellspacing="0" cellpadding="0">
		<tr style="height:70px;">
			<td style="text-align: center;border-right:none">
				<?php 
					if(isset($company->{"emp_logo"})&&!empty($company->{"emp_logo"})){
						?>
							<img src="<?php echo "https://".$_SERVER["SERVER_NAME"]."/uploads/".$company->{"emp_codigo"}."/".$company->{"emp_logo"} ;?>" alt="" id="logo">
						<?php
					}
				?>
			</td>
			<td style="text-align: center; border-left:none" colspan="4">
				<?php
					if(isset($company->{"emp_titulo"}) && $company->{"emp_titulo"} == 1){
						echo $company->{"emp_razao"};
					}else if(isset($company->{"emp_titulo"}) && $company->{"emp_titulo"} == 2){
						echo $company->{"emp_fantasia"};
					}
				?>
				<br>
				<?php echo telefone($company->{"emp_fone"})." / ".telefone($company->{"emp_cel"})."  ".$company->{"emp_email"};?><br>
				CNPJ: <?php echo maskCNPJCPF($company->{"emp_cpfcnpj"})." - CEP: ".$company->{"emp_cep"};?><br>
				<?php echo $company->{"emp_endereco"}.", ".$company->{"emp_num"}." - ".$company->{"emp_bairro"};?>
			</td>
		</tr>
		<tr>
			<td colspan="4" style="width:75%">
				<strong>Cliente:</strong><br>
				<?php echo substr($ret[0]["cliente"],0,40)?>
			</td>
			<td>
				<?php
				echo "<strong>CNPJ/ CPF:</strong><br>".maskCNPJCPF($ret[0]["clientecnpj"]);
				?>
			</td>
		</tr>
		<tr>
			<td colspan="3">
				<strong>Endereço:</strong><br>
				<?php echo $ret[0]["end_nome"].", ".$ret[0]["end_num"]; ?>
			</td>
			<td>
				<strong>Bairro:</strong><br>
				<?php echo $ret[0]["end_bairro"]; ?>
			</td>
			<td>
				<strong>CEP:</strong><br>
				<?php echo $ret[0]["end_cep"]; ?>
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<strong>Município:</strong><br>
				<?php echo $ret[0]["end_cidade"]; ?>
			</td>
			<td>
				<strong>UF:</strong><br>
				<?php echo $ret[0]["end_uf"]; ?>
			</td>
			<td style="vertical-align:top">
				<strong>Telefone:</strong><br>
				<?php echo ($ret[0]["tel_numero"]) ? "(".$ret[0]["tel_ddd"].") ".$ret[0]["tel_prefixo"]."-".$ret[0]["tel_numero"] : ""; ?>
			</td>
			<td style="vertical-align:top">
				<strong>E-mail:</strong><br>
				<?php echo strtolower($ret[0]["eml_ender"]); ?>
			</td>
		</tr>
		<tr>
			<td colspan="5">
				<strong>Responsável:</strong><br>
				<?php echo substr($ret[0]["responsavel"],0,40)?>
			</td>
		</tr>
	</table>
	<table id="direita">
		<tr>
			<td style="height:99px; font-size:18px; font-weight:bold">
				Projeto <br> <?php echo $ret[0]["ipj_titulo"]?>
			</td>
		</tr>
		<tr>
			<td style="height:60px; font-size:14px; font-weight:bold">
				Etapa:<br><?php echo $ret[0]["etp_descr"]?>
			</td>
		</tr>
		<tr>
			<td style="vertical-align:top">
				Data:<?php echo implode("/", array_reverse(explode("-", substr($ret[0]["ipj_data"], 0, 10))));?><br>Hor&aacute;rio:<?php echo $ret[0]["ipj_hora"];?>
			</td>
		</tr>
	</table>
	
	<br style="clear:both">
	
	<!--Produtos-->
	<table id="produto">
		<tr style="height:20px;">
			<td colspan="6" style="text-align:center; font-weight: bold">
				Descrição
			</td>
		</tr>
	</table>
	<br style="clear:both">
	
	<div id="descricao">
		<?php echo nl2br(utf8_encode(base64_decode($ret[0]{"ipj_descr"})));?>
	</div>
	
	
	<br style="clear:both">
	
	<?php
		// if( $ret[0]["ose_status"]>4 && $ret[0]["ose_obs"] && $ret[0]["ose_obs"]!="" ){ //relatorio tecnico
		if( $ret[0]["tag_descr"] && $ret[0]["tag_descr"]!="" ){ //relatorio tecnico
	?>
			<!--Relatório Técnico-->
			<table id="produto">
				<tr style="height:20px;">
					<td colspan="3" style="text-align:center; font-weight:bold">Tags</td>
				</tr>
				<tr>
					<th style="text-align:left;">Descrição</th>
					<!--<th style="text-align:left">Cor Representativa</th>-->
				</tr>
		<?php
			$ant="";
			foreach( $ret as $r ){
				if($ant != $r["tag_codigo"]){
		?>
					<tr>
						<td width="85%"><?php echo $r["tag_descr"];?></td>
						<!--<td style="background-color:#<?php //echo $r["tag_cor"]?>">&nbsp;</td>-->
					</tr>
		<?php
				$ant = $r["tag_codigo"];
				}
			}
			
		}
	?>
	</table><br style="clear:both">
	
	<?php
		if(($ret[0]["ipj_valor"] && $ret[0]["ipj_valor"]>0)){
	?>
	
	<div id="total">
		Valor do Projeto: <strong style="font-size:13px">R$ <?php echo ($ret[0]["ipj_valor"] && $ret[0]["ipj_valor"]>0) ? number_format($ret[0]["ipj_valor"], 2, ",", "") : "";?></strong>
	</div>
	
	<?php
		}
	?>
	
	<!--<br style="clear:both"><br>
	
	<div class="dia">
		______/______/______
		<br>Data
	</div>
	
	<div class="assinatura">
		Assinatura do Cliente
	</div>
	
	<div class="assinatura">
		Assinatura do Técnico
	</div>-->
	
</body>
</html>
	
<?php
		//envio por e-mail ou geracao do pdf por API
		if( (isset($_REQUEST["email"]) && $_REQUEST["email"]!="") || (isset($_REQUEST["api"]) && $_REQUEST["api"]==1) ){

			if(!isset($logo)) $logo = "";
			if(!isset($data)) $data = "";
			if(!isset($titulo)) $titulo = "";
			if(!isset($relatorioTitle)) $relatorioTitle = "";
			if(!isset($filtros)) $filtros = "";
			if(!isset($colunas)) $colunas = "";
			if(!isset($cabecalhoHeight)) $cabecalhoHeight = "0"; // passar apenas numeros sem px, %..;
			$html = ob_get_clean();
			if(!is_dir($TParams->getHostRoot()."tmp/")){
				mkdir($TParams->getHostRoot()."tmp/", 0777, true);
			}
			$arquivo = str_replace(array(".",","), "", microtime(true));
			$fp = fopen($TParams->getHostRoot()."tmp/".$arquivo.'.html', 'w');
			fwrite($fp, $html);
			fclose($fp);

			exec($TParams->getHostRoot().'class/phantomjs/bin/phantomjs '.$TParams->getHostRoot().'class/phantomjs/rasterizeOs.js '.$TParams->getHostRoot().'tmp/'.$arquivo.'.html '.$TParams->getHostRoot().'tmp/'.$arquivo.'.pdf ["7,5in*5in"] "'.$relatorioTitle.'" "'.base64_encode($titulo).'" "'.$data.'" "'.base64_encode(json_encode($filtros)).'" "'.base64_encode(json_encode($colunas)).'" "'.base64_encode($logo).'" "'.$cabecalhoHeight.'"');
			
			if(file_exists($TParams->getHostRoot()."tmp/".$arquivo.'.pdf')){
				
				if( isset($_REQUEST["email"]) && $_REQUEST["email"]!=""){
					//modelo de e-mail (envio de OS)
					$filtro = '{"cod":"700268","params":[
						{"name":"dbcomum","value":"'.$company->emp_db_comum.'","type":"other"},
						{"name":"men_codigo","value":"22","type":"integer"}
					]}';
					$datapacket->add($filtro);
					$modelo = $datapacket->open(true);
					$datapacket->clear();
					
					
					
					$filtro = '{"cod":"700321","params":[
						{"name":"msg_codigo","value":"","type":"string"},
						{"name":"msg_tipo","value":"1","type":"integer"},
						{"name":"men_codigo","value":"22","type":"integer"},
						{"name":"msg_remetente","value":"'.$modelo[0]->men_remetente.'","type":"string"},
						{"name":"msg_destinatario","value":"'.strtolower($_REQUEST["email"]).'","type":"string"},
						{"name":"cad_codigo","value":"'.$ret[0]["cad_codigo"].'","type":"string"},
						{"name":"msg_assunto","value":"'.$modelo[0]->men_assunto.'","type":"string"},
						{"name":"msg_conteudo","value":"'.$modelo[0]->men_conteudo.'","type":"string"},
						{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"msg_status","value":"0","type":"integer"},
						{"name":"msg_anexo","value":"","type":"string"}
					]}';

					$datapacket->add($filtro);
					$msg = $datapacket->open(false, true);
					$datapacket->clear();

					//anexar e enviar mensagem de e-mail
					if($msg){
						
						$fields = array(
							'p' => $_REQUEST["p"],
							'acao' => 'anexar',
							'msg_codigo' => $msg,
							'ane_descricao' => base64_encode(utf8_decode("Ordem de Serviço número ".$ret[0]["ose_numero"])),
							'msg_anexo' => new CURLFile($TParams->getHostRoot()."tmp/".$arquivo.'.pdf')
						);
						$ch = curl_init();
						curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
						curl_setopt($ch,CURLOPT_POST, true);
						curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
						curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
						curl_exec($ch);
						curl_close($ch);
						
						$textos = array(
							'ose_numero' => $ret[0]["ose_numero"]
						);			
						//requisição para envio da mensagem
						$fields = array(
							'p' => $_REQUEST["p"],
							'acao' => 'enviar',
							'textos' => $textos,
							'msg_codigo' => $msg
						);
						$fields = http_build_query($fields);
						$ch = curl_init();
						curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
						curl_setopt($ch,CURLOPT_POST, true);
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
						$result = curl_exec($ch);
						curl_close($ch);
						
					}
					
				}elseif( isset($_REQUEST["api"]) && $_REQUEST["api"]==1 ){
					$filename = basename($TParams->getHostRoot()."tmp/".$arquivo.'.pdf');
					$filecontent = file_get_contents($TParams->getHostRoot()."tmp/".$arquivo.'.pdf');
					$base64content = base64_encode($filecontent);
					$response = [
						'nomearquivo' => $filename,
						'conteudo' => $base64content,
					];
					$jsonResponse = json_encode($response);
					header('Content-Type: application/json');
					echo $jsonResponse;
				}

			} else {

				echo "Ocorreu um erro ao gerar o arquivo.";
			}
			
		}

		}else{
			exit("Dados Incompletos para impressão, favor verificar o cadastro do Cliente desta OS");
		}
		
	}else{
		exit("Nâo há dados para serem impressos");
	}
?>