<?php
error_reporting(E_ALL);

set_time_limit(600);

ob_start();
date_default_timezone_set("America/Sao_Paulo");
setlocale(LC_ALL, 'pt_BR');

include('../php/datapacket.php');
include('../php/TParams.class.php');
include('../php/funcoes.php');

$TParams 	= new TParams();
$Datapacket = new datapacket();
$Datapacket->debug(true);

$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$balancete = $dados->balancete; //0 PARA ANALITICO E 1 PARA SINTÉTICO
	
	$perInclusao="";
	if(!empty($dados->datini)){
		$dataini =  "'".implode("-", array_reverse(explode("/", $dados->datini)))." 00:00:00'";
		$perInclusao.="DE ".$dados->datini;
	}else{
		$dataini = "'2000-01-01 00:00:00'";
	}
	if(!empty($dados->datfim)){
		$datafim =  "'".implode("-", array_reverse(explode("/", $dados->datfim)))." 23:59:59'";
		$perInclusao.=utf8_decode(" ATÉ ").$dados->datfim;
	}else{
		$datafim = "'2043-12-31 23:59:59'";
		$perInclusao.=utf8_decode(" ATÉ ").date('d/m/Y');
	}

	$perVencto = "TODOS";
	$venctoini = "";
	$venctofim = "";
	if(isset($dados->venctoini)&&!empty($dados->venctoini)){
		$venctoini =  " and a.doc_dtvcto >= '".data($dados->venctoini, true, "/")." 00:00:00'";
		$perVencto = "DE ".$dados->venctoini;
		if(isset($dados->venctofim)&&!empty($dados->venctofim)){
			$venctofim =  " and a.doc_dtvcto < '".data($dados->venctofim, true, "/")." 23:59:59'";
			$perVencto .= utf8_decode(" ATÉ ").$dados->venctofim;
		}
	}else if(isset($dados->venctofim)&&!empty($dados->venctofim)){
		$venctofim =  " and a.doc_dtvcto < '".data($dados->venctofim, true, "/")." 23:59:59'";
		$perVencto = utf8_decode(" ATÉ ").$dados->venctofim;
	}
	

	$perPagto = "TODOS";
	$pagtoini = "";
	$pagtofim = "";
	if(!empty($dados->pagtoini)){
		$pagtoini =  " and a.doc_dtpgto >= '".data($dados->pagtoini, true, "/")." 00:00:00'";
		$perPagto = "DE ".$dados->pagtoini;
		if(!empty($dados->pagtofim)){
			$pagtofim =  " and a.doc_dtpgto <= '".data($dados->pagtofim, true, "/")." 23:59:59'";
			$perPagto .= utf8_decode(" ATÉ ").$dados->pagtofim;
		}
	}else if(!empty($dados->pagtofim)){
		$pagtofim =  " and a.doc_dtpgto <= '".data($dados->pagtofim, true, "/")." 23:59:59'";
		$perPagto = utf8_decode(" ATÉ ").$dados->pagtofim;
	}
	
	$perMvto = "TODOS";
	if(!empty($dados->mvtoini)){
		$pagtoini .=  " and l.lan_dtmov >= '".data($dados->mvtoini, true, "/")." 00:00:00'";
		$perMvto = "DE ".$dados->mvtoini;
		if(!empty($dados->mvtofim)){
			$pagtofim .=  " and l.lan_dtmov <= '".data($dados->mvtofim, true, "/")." 23:59:59'";
			$perMvto .= utf8_decode(" ATÉ ").$dados->mvtofim;
		}
	}else if(!empty($dados->mvtofim)){
		$pagtofim .=  " and l.lan_dtmov <= '".data($dados->mvtofim, true, "/")." 23:59:59'";
		$perMvto = utf8_decode(" ATÉ ").$dados->mvtofim;
	}
	
	if(!empty($dados->cta_codigo)){
		$pagtoini .=  " and l.cta_codigo = '".$dados->cta_codigo."'";
	}
	
	$cadcodigo = "";
	if(!empty($dados->{'cliente'}) && $dados->{'cliente'} != "Novo Registro"){
		$aux = $dados->{'cliente'};
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= "'".$aux[$i]."'"; 
			}else{
				$aux2 .= ", '".$aux[$i]."'"; 
			}
		}
		$cadcodigo = "and a.cad_codigo in (" . $aux2 . ")";	
	}
	
	//somente pagos e pagos parcialmente
	$docstatus = 'in (1,2)';

	$ccucodigo = "";
	if(!empty($dados->{'ccucodigo'}) && $dados->{'ccucodigo'} != "Novo Registro"){
		$aux = $dados->{'ccucodigo'};
		$ccucodigo = ' and (';
		for($i=0;$i<count($aux);$i++){
			if($i!=0) $ccucodigo.= " or ";
			$ccucodigo .= " ( (a.ccu_codigo='".$aux[$i]."' or a.ccu_codigo like '".$aux[$i].".%') or (c.ccu_codigo='".$aux[$i]."' or c.ccu_codigo like '".$aux[$i].".%') ) ";
		}
		$ccucodigo .= ')';
	}

	$plccodigo = " a.plc_codigo is not null";
	if(!empty($dados->{'plccodigo'}) && $dados->{'plccodigo'} != "Novo Registro"){
		$aux = $dados->{'plccodigo'};
		$plccodigo = ' (';
		for($i=0;$i<count($aux);$i++){
			if($i!=0) $plccodigo.= " or ";
			$plccodigo .= " ( a.plc_codigo='".$aux[$i]."' or a.plc_codigo like '".$aux[$i].".%' ) ";
		}
		$plccodigo .= ')';
	}
	
	$doc_pagrec = "";
	$pagRec = "TODOS";
	if(!empty($dados->{'doc_pagrec'}) && $dados->{'doc_pagrec'}!=0){
		$doc_pagrec = "and a.doc_pagrec = ".$dados->{'doc_pagrec'};
		if($dados->{'doc_pagrec'}==1){
			$pagRec = "PAGAR";
		}else{
			$pagRec  = "RECEBER";
		}
	}
	//competencia
	$competencia = "TODAS";
	if(!empty($dados->{'docmes'}) && !empty($dados->{'docano'})){
		$doc_pagrec .= " and a.doc_competencia = '".$dados->{'docmes'}."/".$dados->{'docano'}."' ";
		$competencia = $dados->{'docmes'}."/".$dados->{'docano'};
	}
	
	$conciliado="AMBOS";
	if( isset($dados->conciliado) && $dados->conciliado!=2){
		$doc_pagrec .=  " and (l.lan_conc = ".$dados->conciliado." ";
		if($dados->conciliado==0){
			$conciliado="NÃO";
			$doc_pagrec .= " or l.lan_conc IS NULL) ";
		}else{
			$conciliado="SIM";
			$doc_pagrec .= " ) ";
		}
	}

	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->emp_codigo.'","type":"string"}
	]}';
	
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	// echo $Datapacket->getLastQuery();
	$Datapacket->clear();	 

	$filtroCusto = '{"cod":"500080","params":[]}';
	
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtroCusto);
	$rowdataCusto = $Datapacket->open(true);
	$cntCusto = $Datapacket->getRecordCount();
	$Datapacket->clear();

	$filtroPlc = '{"cod":"500081","params":[
		{"name":"plc_codigo","value":"'.$plccodigo.'","type":"other"}
	]}';
	
	
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtroPlc);
	$rowdataPlc = $Datapacket->open(true);
	$cntPlc = $Datapacket->getRecordCount();
	//echo $Datapacket->getLastQuery();
	$Datapacket->clear();

	$filtroCustoSemPlc = '{"cod":"500083","params":[
		{"name":"database","value":"'.$company[0]->emp_db_comum.'","type":"other"},
		{"name":"dataini","value":"'.$dataini.'","type":"other"},
		{"name":"datafim","value":"'.$datafim.'","type":"other"},
		{"name":"venctoini","value":"'.$venctoini.'","type":"other"},
		{"name":"venctofim","value":"'.$venctofim.'","type":"other"},
		{"name":"pagtoini","value":"'.$pagtoini.'","type":"other"},
		{"name":"pagtofim","value":"'.$pagtofim.'","type":"other"},
		{"name":"doc_status","value":"'.$docstatus.'","type":"other"},
		{"name":"cad_codigo","value":"'.$cadcodigo.'","type":"other"},
		{"name":"ccu_codigo","value":"'.$ccucodigo.'","type":"other"},
		{"name":"doc_pagrec","value":"'.$doc_pagrec.'","type":"other"},
		{"name":"plc_codigo","value":"a.plc_codigo is null","type":"other"}
	]}';

	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtroCustoSemPlc);
	$rowdataCustoSemPlc = $Datapacket->open(true);

	// echo $Datapacket->getLastQuery();
	$cntCustoSemPlc = $Datapacket->getRecordCount();
	$Datapacket->clear();


	$filtroDoctoPlc = '{"cod":"500083","params":[
		{"name":"database","value":"'.$company[0]->emp_db_comum.'","type":"other"},
		{"name":"dataini","value":"'.$dataini.'","type":"other"},
		{"name":"datafim","value":"'.$datafim.'","type":"other"},
		{"name":"venctoini","value":"'.$venctoini.'","type":"other"},
		{"name":"venctofim","value":"'.$venctofim.'","type":"other"},
		{"name":"pagtoini","value":"'.$pagtoini.'","type":"other"},
		{"name":"pagtofim","value":"'.$pagtofim.'","type":"other"},
		{"name":"doc_status","value":"'.$docstatus.'","type":"other"},
		{"name":"cad_codigo","value":"'.$cadcodigo.'","type":"other"},
		{"name":"ccu_codigo","value":"'.$ccucodigo.'","type":"other"},
		{"name":"doc_pagrec","value":"'.$doc_pagrec.'","type":"other"},
		{"name":"plc_codigo","value":"'.$plccodigo.'","type":"other"}
	]}';
	
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtroDoctoPlc);
	$rowdataDoctoPlc = $Datapacket->open(true);
	$cntDoctoPlc = $Datapacket->getRecordCount();
	$Datapacket->clear();
	
	/* * * CABECALHO DOS RELATORIOS * * */
	$cabecalhoHeight=280;
	$relatorioTitle = $company[0]->{"emp_razao"};
	if($balancete == 0){
		$titulo = utf8_decode("RELATÓRIO DE BALANCETE DE CONTAS ANALÍTICO");
	}else if($balancete == 1){
		$titulo = utf8_decode("RELATÓRIO DE BALANCETE DE CONTAS SINTÉTICO");
	}
	$data = date("d/m/Y H:i:s");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");
	
	$filtro1 = base64_encode('<div style="font-weight:normal; float:left; margin-right:10px"><span style="font-weight:bold">'.utf8_decode("PERÍODO: ").'</span>'.$perInclusao.'</div>');
	$filtro2 = base64_encode('<div style="font-weight:normal; float:left; margin-right:10px"><span style="font-weight:bold">VENCIMENTO: </span>'.$perVencto.'</div>');
	$filtro3 = base64_encode('<div style="font-weight:normal; float:left; margin-right:10px"><span style="font-weight:bold">PAGAMENTO: </span>'.$perPagto.'</div>');
	$filtro4 = base64_encode('<div style="font-weight:normal; float:left; margin-right:10px"><span style="font-weight:bold">'.utf8_decode('MOVIMENTAÇÃO: ').'</span>'.$perMvto.'</div>');
	$filtro5 = base64_encode('<div style="font-weight:normal; float:left; margin-right:10px"><span style="font-weight:bold">DOCUMENTOS: </span>'.$pagRec.'</div>');
	$filtro6 = base64_encode('<div style="font-weight:normal; float:left; margin-right:10px"><span style="font-weight:bold">CONCILIADO: </span>'.$conciliado.'</div>');
	$filtro7 = base64_encode('<div style="font-weight:normal; float:left; margin-right:10px"><span style="font-weight:bold">COMPETENCIA: </span>'.$competencia.'</div>');
	
	$objFiltro = new stdClass();
	
	$filtros = array(
		$objFiltro->filtro = $filtro1,
		$objFiltro->filtro = $filtro2,
		$objFiltro->filtro = $filtro3,
		$objFiltro->filtro = $filtro4,
		$objFiltro->filtro = $filtro5,
		$objFiltro->filtro = $filtro6,
		$objFiltro->filtro = $filtro7
	);

	//DEFINIÇÃO DAS VARIÁVEIS DE TOTALIZADORES QUE SERÁ UTILIZADA NO RELATÓRIO DO TIPO ANALÍTICO
	
	$aPagarCplano = 0; //recebe o valor de cada docto a pagar com plano de conta
	$aReceberCplano = 0; // rebe o valor de cada docto a receber com plano de conta
	$aPagarSplano = 0; //recebe o valor de cada docto a pagar sem plano de conta
	$aReceberSplano = 0; // rebe o valor de cada docto a receber sem plano de conta
	$totalCustoCplano = 0; //total de cada centro de custo com plano de conta
	$totalCustoSplano = 0; //total de cada centro de custo sem plano de conta
	$totalaPagarCplano = 0;  //totalizador para cada centro de custo de doctos a pagar com planos de conta
	$totalaReceberCplano =0; //totalizador para cada centro de custo de doctos a receber com planos de conta
	$totalFinalCplano = 0;			//soma total dos documentos com planos de conta
	$totalFinalReceberCplano = 0;	//total a receber dos doctos com planos de conta
	$totalFinalPagarCplano = 0;  	//total a pagar dos doctos com planos de conta
	$totalFinalSaldoCplano =0 ;		//saldo final dos doctos com planos de conta
	$totalFinalSplano = 0;			//soma total dos documentos sem planos de conta
	$totalFinalReceberSplano = 0;	//total a receber dos doctos sem planos de conta
	$totalFinalPagarSplano = 0;  	//total a pagar dos doctos sem planos de conta
	$totalFinalSaldoSplano = 0;		//saldo final dos doctos sem planos de conta
	
	$arrayPlc = array(); 
	$arrayCusto = array();
	$arrayCustoSemPlc = array();
	$totalComPlano = "";
	$totalaReceberCplano = "";
	$totalaPagarCplano = "";
	$totalaPagarSplano ="";
	$totalaReceberSplano = "";
	$totalSemPlano = "";

	//####################################### SE O RELATÓRIO FOR ANALITICO ################################################# //
	
	if($balancete == 0){ 

			//----------------------------- INICIO LISTAGEM DOS DOCUMENTOS SEM PLANO DE CONTA -------------------------------------------
		$colunas = array();
        
            array_push($colunas, base64_encode('<div style="float:left; width:12%; text-align:left">'.utf8_decode("NÚMERO").'</div>')); 
            array_push($colunas, base64_encode('<div style="float:left; width:6%; text-align:left"> DOC. </div>')); 
            array_push($colunas, base64_encode('<div style="float:left; width:25%; text-align:left"> CLIENTE </div>')); 
            array_push($colunas, base64_encode('<div style="float:left; width:10%; text-align:left"> TIPO </div>')); 
            array_push($colunas, base64_encode('<div style="float:left; width:8%; text-align:left;"> VENCIMENTO</div>')); 
            array_push($colunas, base64_encode('<div style="float:left; width:8%; text-align:left;"> PAGAMENTO</div>')); 
            array_push($colunas, base64_encode('<div style="float:left; width:10%; text-align:left;"> VALOR R$ </div>')); 
            array_push($colunas, base64_encode('<div style="float:left; width:18%; text-align:left;">'.utf8_decode("OBSERVAÇÃO").'</div>')); 

		if(empty($dados->{'plccodigo'})) {
			
			if($cntCustoSemPlc>0){
			
				for($i=0; $i<$cntCustoSemPlc; $i++){
					//rateio
					if( isset($rowdataCustoSemPlc[$i]->{'ccu_codigo_rateio'}) ){
						if(!in_array($rowdataCustoSemPlc[$i]->{'ccu_codigo_rateio'},$arrayCustoSemPlc,true)){
							array_push($arrayCustoSemPlc,$rowdataCustoSemPlc[$i]->{'ccu_codigo_rateio'});
						}
					}else{
						if(!in_array($rowdataCustoSemPlc[$i]->{'ccu_codigo'},$arrayCustoSemPlc,true)){
							array_push($arrayCustoSemPlc,$rowdataCustoSemPlc[$i]->{'ccu_codigo'});
						}
					}
				}
				
				rsort($arrayCustoSemPlc);

				?>
				
				<div style="width:100%; float:left; padding:10px 0px; background-color:#D1814B; font-size:14px; border-top:1px solid #1A1A1A; border-bottom:1px solid #1A1A1A;">
					<span style="font-weight:bold; margin-left:5px;"> SEM PLANO DE CONTA </span>
				</div>
				
				<?php 
				for($a=0; $a<count($arrayCustoSemPlc); $a++){ ?>
					<div class="informacaoListagem">
						<span style='font-weight:bold;'> <?php if(!empty($arrayCustoSemPlc[$a])) echo "CENTRO DE CUSTO:"; else echo "SEM CENTRO DE CUSTO"; ?> </span> 
						<?php
						for($c=0; $c<$cntCusto; $c++){
							if($rowdataCusto[$c]->{'ccu_codigo'} === $arrayCustoSemPlc[$a]){
								echo $rowdataCusto[$c]->{'ccu_descr'};
							}
						}
						?>
					</div>

					<?php 

					$totalCustoSplano = 0; 
					$apagarSplano = 0; 
					$areceberSplano = 0;
					$doctos = array();

					for($b=0; $b<$cntCustoSemPlc; $b++){
						if( (isset($rowdataCustoSemPlc[$b]->{'ccu_codigo_rateio'}) && $rowdataCustoSemPlc[$b]->{'ccu_codigo_rateio'} === $arrayCustoSemPlc[$a]) || (!isset($rowdataCustoSemPlc[$b]->{'ccu_codigo_rateio'}) && $rowdataCustoSemPlc[$b]->{'ccu_codigo'} === $arrayCustoSemPlc[$a])){
							
							array_push($doctos, $rowdataCustoSemPlc[$b]->{'lan_estorno'});
							if( array_search($rowdataCustoSemPlc[$b]->{'lan_sequencia'}, $doctos)===false &&  $rowdataCustoSemPlc[$b]->{'lan_tipo'}!=4 ){
								$valorpg = ( isset($rowdataCustoSemPlc[$b]->{'ccu_codigo_rateio'}) ) ? (($rowdataCustoSemPlc[$b]->{'ccr_porcentagem'}*$rowdataCustoSemPlc[$b]->{'lan_valor'})/100) : $rowdataCustoSemPlc[$b]->{'lan_valor'};
								$totalCustoSplano += $valorpg;
								if($rowdataCustoSemPlc[$b]->{'doc_pagrec'}==1){
									$apagarSplano += $valorpg;
								}else{
									$areceberSplano += $valorpg;
								}

								if($b % 2 == 0){
									$backCor = "#FFF";
								}else{
									$backCor = "#EFEEED";
								}

								?>
								<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>;">
									<div style="width:12%; float:left; text-align:left;"><?php echo $rowdataCustoSemPlc[$b]->{'doc_numero'}."&nbsp"; ?></div>
									<div style="width:6%; float:left; text-align:left;"><?php echo pagarReceber($rowdataCustoSemPlc[$b]->{'doc_pagrec'})."&nbsp"; ?></div>
									<div style="width:25%; float:left; text-align:left;"><?php echo $rowdataCustoSemPlc[$b]->{'cad_nomeraz'}."&nbsp"; ?></div>
									<div style="width:10%; float:left; text-align:left;"><?php echo tipoDocumento($rowdataCustoSemPlc[$b]->{'doc_tipo'})."&nbsp"; ?></div>
									<div style="width:8%; float:left; text-align:left;"><?php echo data($rowdataCustoSemPlc[$b]->{'doc_dtvcto'})."&nbsp"; ?></div>
									<div style="width:8%; float:left; text-align:left;"><?php echo data($rowdataCustoSemPlc[$b]->{'doc_dtpgto'})."&nbsp"; ?></div>
									<div style="width:10%; float:left; text-align:left;"><?php echo valorFormat($valorpg)."&nbsp"; ?></div>
									<div style="width:18%; float:left; text-align:left;"> <?php echo substr($rowdataCustoSemPlc[$b]->{'doc_obs'}."&nbsp",0,45); ?></div>
							</div>
							
							<?php
							}
							
						}
					}

					$totalaPagarSplano += $apagarSplano;
					$totalaReceberSplano += $areceberSplano;
					$totalSemPlano += $totalCustoSplano;
					$op = saldo($areceberSplano, $apagarSplano);

					?> 
					<div class="informacaoRodape">
						<span style="font-weight:bold;"> Movimento: </span> <?php echo valorFormat($totalCustoSplano); ?> |
						<span style="font-weight:bold;"> Crédito: </span> <?php echo valorFormat($areceberSplano); ?> |
						<span style="font-weight:bold;"> Débito: </span> <?php echo valorFormat($apagarSplano); ?> |
						<span style="font-weight:bold;"> Saldo: </span> <?php echo $op."".valorFormat($areceberSplano-$apagarSplano, true); ?>
					</div> 
					<?php
				}

				$totalFinalSplano = $totalSemPlano;
				$totalFinalReceberSplano = $totalaReceberSplano;
				$totalFinalPagarSplano = $totalaPagarSplano;
				$totalFinalSaldoSplano = $totalaReceberSplano - $totalaPagarSplano;

				$op = saldo($totalaReceberSplano, $totalaPagarSplano)
				
				?>
				<div class="informacaoRodape_outro">
					<span style="font-weight:bold; "> TOTAL GERAL SEM PLANOS DE CONTA => </span>
					<span style="font-weight:bold;"> Movimento: </span> <?php echo valorFormat($totalSemPlano); ?> |
					<span style="font-weight:bold; "> Crédito: </span> <?php echo valorFormat($totalaReceberSplano); ?> |
					<span style="font-weight:bold;"> Débito: </span> <?php echo valorFormat($totalaPagarSplano); ?> |
					<span style="font-weight:bold;"> Saldo: </span> <?php echo $op."".valorFormat($totalaReceberSplano - $totalaPagarSplano, true); ?>
				</div>
				<?php
			}
		}
		
		//---------------------------------- INICIO LISTAGEM DOS DOCUMENTOS COM PLANO DE CONTA --------------------------------
		
		$totalGreceberCplano = 0;
		$totalGpagarCplano = 0;
		$totalGeralCplano = 0;

		if($cntDoctoPlc > 0){

			for($i=0; $i<$cntDoctoPlc; $i++){ //Separa os planos de contas repetidos de documentos que possuem plano de conta
				if(!in_array($rowdataDoctoPlc[$i]->{'plc_codigo'}, $arrayPlc, true)){
					array_push($arrayPlc, $rowdataDoctoPlc[$i]->{'plc_codigo'});
				}
			}

			for($j=0; $j<count($arrayPlc); $j++){ 
				
				$totalComPlano = 0;
				$totalaReceberCplano = 0;
				$totalaPagarCplano = 0;
				
				?>
				
				<div style="width:100%; margin: 0px 0px 0px 0px; float:left;">

					<?php 

					for($c=0; $c<$cntPlc; $c++){
						if($rowdataPlc[$c]->{'plc_codigo'} === $arrayPlc[$j]){ 
							?>
							<div style="width:100%; float:left; padding:10px 0px; margin-top:30px; background-color:#D1814B; border-top:1px solid #1A1A1A; border-bottom:1px solid #1A1A1A;">
								<span style="font-weight:bold; margin-left:5px;"> PLANO DE CONTA: </span> 
								<?php
								$planoatualDescr = $rowdataPlc[$c]->{'plc_descr'};
								echo $rowdataPlc[$c]->{'plc_codigo'}." - ".$rowdataPlc[$c]->{'plc_descr'}; 
								?>
							</div>
							<?php
						} 	
					}

					$arrayCusto = array();

					for($a=0; $a<$cntDoctoPlc; $a++){  
						if($arrayPlc[$j] === $rowdataDoctoPlc[$a]->{'plc_codigo'}){ 
							//rateio
							if( isset($rowdataDoctoPlc[$a]->{'ccu_codigo_rateio'}) ){
								if(!in_array($rowdataDoctoPlc[$a]->{'ccu_codigo_rateio'},$arrayCusto,true)){
									array_push($arrayCusto,$rowdataDoctoPlc[$a]->{'ccu_codigo_rateio'});
								}
							}else{
								if(!in_array($rowdataDoctoPlc[$a]->{'ccu_codigo'},$arrayCusto,true)){
									array_push($arrayCusto,$rowdataDoctoPlc[$a]->{'ccu_codigo'});
								}
							}
						}
					}

					for($a=0; $a<count($arrayCusto); $a++){ 

						?>
						<div class="informacaoListagem">
							<span style='font-weight:bold;'> <?php if($arrayCusto[$a]!='') echo "CENTRO DE CUSTO:"; else echo "SEM CENTRO DE CUSTO"; ?> </span> 
							<?php
							for($c=0; $c<$cntCusto; $c++){
								if($rowdataCusto[$c]->{'ccu_codigo'} === $arrayCusto[$a]){
									echo $rowdataCusto[$c]->{'ccu_codigo'}." - ".$rowdataCusto[$c]->{'ccu_descr'};
								}
							}
							?>
						</div>
						<?php 

						$totalCustoCplano = 0;
						$aPagarCplano = 0;
						$aReceberCplano = 0;
						$doctos = array();

						for($d=0; $d<$cntDoctoPlc; $d++){
							
							if( $rowdataDoctoPlc[$d]->{'plc_codigo'}===$arrayPlc[$j] && ((isset($rowdataDoctoPlc[$d]->{'ccu_codigo_rateio'}) && $rowdataDoctoPlc[$d]->{'ccu_codigo_rateio'} === $arrayCusto[$a]) || (!isset($rowdataDoctoPlc[$d]->{'ccu_codigo_rateio'}) && $rowdataDoctoPlc[$d]->{'ccu_codigo'}===$arrayCusto[$a])) ){
								
								array_push($doctos, $rowdataDoctoPlc[$d]->{'lan_estorno'});
								if( array_search($rowdataDoctoPlc[$d]->{'lan_sequencia'}, $doctos)===false && $rowdataDoctoPlc[$d]->{'lan_tipo'}!=4 ){
									$valorpg = ( isset($rowdataDoctoPlc[$d]->{'ccu_codigo_rateio'}) ) ? (($rowdataDoctoPlc[$d]->{'ccr_porcentagem'}*$rowdataDoctoPlc[$d]->{'lan_valor'})/100) : $rowdataDoctoPlc[$d]->{'lan_valor'};
									
									if($rowdataDoctoPlc[$d]->{'doc_pagrec'}==1){
										$aPagarCplano += $valorpg;
									}else{
										$aReceberCplano += $valorpg;
									}
									$totalCustoCplano += $valorpg; 

									if($d % 2 == 0){
										$backCor = "#FFF";
									}else{
										$backCor = "#EFEEED";
									}

									?>
									<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>;">								
										<div style="width:12%; float:left; text-align:left; padding-left: 0.5%"> <?php echo $rowdataDoctoPlc[$d]->{'doc_numero'}; ?> </div>
										<div style="width:6%; float:left; text-align:left;"> <?php echo pagarReceber($rowdataDoctoPlc[$d]->{'doc_pagrec'}); ?> </div>	
										<div style="width:25%; float:left; text-align:left;"> <?php echo $rowdataDoctoPlc[$d]->{'cad_nomeraz'}."&nbsp;"; ?> </div>
										<div style="width:10%; float:left; text-align:left;"> <?php echo tipoDocumento($rowdataDoctoPlc[$d]->{'doc_tipo'}); ?> </div>
										<div style="width:8%; float:left; text-align:left;"> <?php echo data($rowdataDoctoPlc[$d]->{'doc_dtvcto'}); ?></div>
										<div style="width:8%; float:left; text-align:left;"> <?php echo data($rowdataDoctoPlc[$d]->{'doc_dtpgto'}); ?></div>
										<div style="width:10%; float:left; text-align:left;"> <?php echo valorFormat($valorpg); ?> </div>
										<div style="width:18%; float:left; text-align:left;"> <?php echo substr($rowdataDoctoPlc[$d]->{'doc_obs'},0,26); ?> </div>
									</div>		
									<?php
								}
							}
						}

						$totalaPagarCplano += $aPagarCplano;			
						$totalaReceberCplano += $aReceberCplano;				
						$totalComPlano += $totalCustoCplano;
						$op = saldo($aReceberCplano, $aPagarCplano);

						?> 
						<div class="informacaoRodape">
							<span style="font-weight:bold;"> Movimento: </span> <?php echo valorFormat($totalCustoCplano); ?> |
							<span style="font-weight:bold; "> Crédito: </span> <?php echo valorFormat($aReceberCplano); ?> |
							<span style="font-weight:bold;"> Débito: </span> <?php echo valorFormat($aPagarCplano); ?> |
							<span style="font-weight:bold; "> Saldo: </span> <?php echo $op."".valorFormat($aReceberCplano-$aPagarCplano, true); ?>
						</div> 
						<?php
					}

					$op = saldo($totalaReceberCplano, $totalaPagarCplano);
					?> 
				</div>

				<div class="informacaoRodape_outro">
					<span style="font-weight:bold ">  TOTAL DO PLANO DE CONTA <?php echo $planoatualDescr; ?> => </span>
					<span style="font-weight:bold;"> Movimento: </span>  <?php echo valorFormat($totalComPlano); ?> |
					<span style="font-weight:bold; "> Crédito: </span> <?php echo valorFormat($totalaReceberCplano); ?> |
					<span style="font-weight:bold;"> Débito: </span> <?php echo valorFormat($totalaPagarCplano); ?> |
					<span style="font-weight:bold; "> Saldo: </span> <?php echo $op."".valorFormat($totalaReceberCplano - $totalaPagarCplano, true); ?>
				</div>

				<?php 
				$totalGreceberCplano += $totalaReceberCplano;
				$totalGpagarCplano += $totalaPagarCplano;
				$totalGeralCplano += $totalComPlano;
			}
			
			$totalFinalCplano = $totalGeralCplano;
			$totalFinalReceberCplano = $totalGreceberCplano;
			$totalFinalPagarCplano = $totalGpagarCplano;
			$totalFinalSaldoCplano = $totalGreceberCplano - $totalGpagarCplano;
			
			$op = saldo($totalGreceberCplano, $totalGpagarCplano);
			
			?>
			<div class="informacaoRodape_outro">
				<span style="font-weight:bold;"> TOTAL GERAL COM PLANOS DE CONTA => </span> 
				<span style="font-weight:bold;"> Movimento: </span> <?php echo valorFormat($totalGeralCplano); ?> |
				<span style="font-weight:bold;"> Crédito: </span> <?php echo valorFormat($totalGreceberCplano); ?> |
				<span style="font-weight:bold;"> Débito: </span> <?php echo valorFormat($totalGpagarCplano); ?> |
				<span style="font-weight:bold;"> Saldo: </span> <?php echo $op."".valorFormat($totalGreceberCplano - $totalGpagarCplano, true); ?>
			</div> 
			<?php
		}

		$valorFinalReceber = $totalFinalReceberCplano + $totalFinalReceberSplano;
		$valorFinalPagar = $totalFinalPagarCplano + $totalFinalPagarSplano;
		$op = saldo($valorFinalReceber, $valorFinalPagar);
		
		?>
		<div class="informacaoRodape_outro">
			<span style="font-weight:bold;"> TOTAL GERAL FINAL => </span> 
			<span style="font-weight:bold;"> Movimento: </span> <?php echo valorFormat($totalFinalCplano + $totalFinalSplano); ?> |
			<span style="font-weight:bold;"> Crédito: </span> <?php echo valorFormat($totalFinalReceberCplano + $totalFinalReceberSplano); ?> |
			<span style="font-weight:bold;"> Débito: </span> <?php echo valorFormat($totalFinalPagarCplano + $totalFinalPagarSplano ); ?> |
			<span style="font-weight:bold;"> Saldo: </span> <?php echo $op."".valorFormat($valorFinalReceber - $valorFinalPagar, true); ?>
		</div> 
		<?php
		
		//--------------------------------------- FIM LISTAGEM DOS DOCUMENTOS COM PLANO DE CONTA ----------------------------------	
		
	} else if($balancete == 1){ 

			//############################# SE O RELATÓRIO FOR SINTÉTICO ##################################### // 

			$colunas = array();


				array_push($colunas, base64_encode('<div style="float:left; width:16%; text-align:left"> CENTRO DE CUSTO</div>')); 
				array_push($colunas, base64_encode('<div style="float:left; width:16%; text-align:right;"> MOVIMENTO </div>')); 
				array_push($colunas, base64_encode('<div style="float:left; width:16%; text-align:right;">'. utf8_decode("CRÉDITO").'</div>')); 
				array_push($colunas, base64_encode('<div style="float:left; width:16%; text-align:right;">'. utf8_decode("DÉBITO").'</div>')); 
				array_push($colunas, base64_encode('<div style="float:left; width:16%; text-align:right;"> SALDO</div>')); 
	

		if(empty($dados->{'plccodigo'})) {

			//----------------------------- INICIO LISTAGEM DOS DOCUMENTOS SEM PLANO DE CONTA -------------------------------------------
			for($i=0; $i<$cntCustoSemPlc; $i++){
				//rateio
				if( isset($rowdataCustoSemPlc[$i]->{'ccu_codigo_rateio'}) ){
					if(!in_array($rowdataCustoSemPlc[$i]->{'ccu_codigo_rateio'},$arrayCustoSemPlc,true)){
						array_push($arrayCustoSemPlc,$rowdataCustoSemPlc[$i]->{'ccu_codigo_rateio'});
					}
				}else{
					if(!in_array($rowdataCustoSemPlc[$i]->{'ccu_codigo'},$arrayCustoSemPlc,true)){
						array_push($arrayCustoSemPlc,$rowdataCustoSemPlc[$i]->{'ccu_codigo'});
					}
				}
			}
			
			rsort($arrayCustoSemPlc);

			?>
			
			<div class="informacaoListagem">
				<span style="font-weight:bold; margin-left:5px;"> SEM PLANO DE CONTA </span>
			</div>			
			<?php 
			for($a=0; $a<count($arrayCustoSemPlc); $a++){ $doctos=array(); ?>
				<div style="width:100%; float:left; margin-top: 7px; background-color:<?php echo $backCor; ?>;">
					<div style="width:16%; float:left; text-align: left; padding-left: 0.5%">
						<?php 
						if(empty($arrayCustoSemPlc[$a])) echo "SEM CENTRO DE CUSTO";
						for($c=0; $c<$cntCusto; $c++){
							if($rowdataCusto[$c]->{'ccu_codigo'} === $arrayCustoSemPlc[$a]){
								echo $rowdataCusto[$c]->{'ccu_descr'};
							}
						}
						?>
					</div>

					<?php $totalCustoSplano = 0; $apagarSplano = 0; $areceberSplano = 0;
					for($b=0; $b<$cntCustoSemPlc; $b++){
						
						if( (isset($rowdataCustoSemPlc[$b]->{'ccu_codigo_rateio'}) && $rowdataCustoSemPlc[$b]->{'ccu_codigo_rateio'} === $arrayCustoSemPlc[$a]) || (!isset($rowdataCustoSemPlc[$b]->{'ccu_codigo_rateio'}) && $rowdataCustoSemPlc[$b]->{'ccu_codigo'} === $arrayCustoSemPlc[$a]) ){ 
							array_push($doctos, $rowdataCustoSemPlc[$b]->{'lan_estorno'});
							if( array_search($rowdataCustoSemPlc[$b]->{'lan_sequencia'}, $doctos)===false && $rowdataCustoSemPlc[$b]->{'lan_tipo'}!=4 ){
								$valorpg = ( isset($rowdataCustoSemPlc[$b]->{'ccu_codigo_rateio'}) ) ? (($rowdataCustoSemPlc[$b]->{'ccr_porcentagem'}*$rowdataCustoSemPlc[$b]->{'lan_valor'})/100) : $rowdataCustoSemPlc[$b]->{'lan_valor'};
								$totalCustoSplano += $valorpg;
								if($rowdataCustoSemPlc[$b]->{'doc_pagrec'}==1){
									$apagarSplano += $valorpg;
								}else{
									$areceberSplano += $valorpg;
								}
							}
						}
					}
					$totalaPagarSplano += $apagarSplano;
					$totalaReceberSplano += $areceberSplano;
					$totalSemPlano += $totalCustoSplano;

					$op = saldo($areceberSplano, $apagarSplano);
					
					?> 
					<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($totalCustoSplano); ?> </div>
					<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($areceberSplano); ?> </div>
					<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($apagarSplano); ?> </div>
					<div style="width:16%; float:left; text-align: right;"> <?php echo $op."".valorFormat($areceberSplano-$apagarSplano, true); ?> </div>

				</div>
				<?php
			}
		

			$totalFinalSplano = $totalSemPlano;
			$totalFinalReceberSplano = $totalaReceberSplano;
			$totalFinalPagarSplano = $totalaPagarSplano;
			$totalFinalSaldoSplano = $totalaReceberSplano - $totalaPagarSplano;

			$op = saldo($totalaReceberSplano, $totalaPagarSplano)
			?>

			<div class="informacaoRodape">
				<div style="width:16%; float:left; text-align: right; padding-left: 0.5%"> TOTAL </div>
				<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($totalSemPlano); ?> </div>
				<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($totalaReceberSplano); ?> </div>
				<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($totalaPagarSplano); ?> </div>
				<div style="width:16%; float:left; text-align: right;"> <?php echo $op."".valorFormat($totalaReceberSplano - $totalaPagarSplano, true); ?> </div>
			</div>

			<?php
		}
		
		//---------------------------------- INICIO LISTAGEM DOS DOCUMENTOS COM PLANO DE CONTA --------------------------------
		
		$totalGreceberCplano = 0;
		$totalGpagarCplano = 0;
		$totalGeralCplano = 0;

		for($i=0; $i<$cntDoctoPlc; $i++){ //Separa os planos de contas repetidos de documentos que possuem plano de conta
			if(!in_array($rowdataDoctoPlc[$i]->{'plc_codigo'},$arrayPlc,true)){
				array_push($arrayPlc,$rowdataDoctoPlc[$i]->{'plc_codigo'});
			}
		}

		for($j=0; $j<count($arrayPlc); $j++){ 
			$totalComPlano = 0;
			$totalaReceberCplano = 0;
			$totalaPagarCplano = 0;
			if($j % 2 == 0){
            	$backCor = "#FFF";
	        }else{
	            $backCor = "#EFEEED";
	        }
			?>
			<div style="width:100%; margin: 0px 0px 0px 0px; float:left;">
				<?php 
				for($c=0; $c<$cntPlc; $c++){
					if($rowdataPlc[$c]->{'plc_codigo'} === $arrayPlc[$j]){ ?>
						<div class="informacaoListagem">
							<span style="font-weight:bold; margin-left:5px;"> PLANO DE CONTA: </span> 
							<?php
							$planoatualDescr = $rowdataPlc[$c]->{'plc_descr'};
							echo $rowdataPlc[$c]->{'plc_descr'}; ?>
						</div>
						<?php
					} 	
				}

				$arrayCusto = array();

				for($a=0; $a<$cntDoctoPlc; $a++){  
					if($arrayPlc[$j] === $rowdataDoctoPlc[$a]->{'plc_codigo'}){ 
						//rateio
						if( isset($rowdataDoctoPlc[$a]->{'ccu_codigo_rateio'}) ){
							if(!in_array($rowdataDoctoPlc[$a]->{'ccu_codigo_rateio'},$arrayCusto,true)){
								array_push($arrayCusto,$rowdataDoctoPlc[$a]->{'ccu_codigo_rateio'});
							}
						}else{
							if(!in_array($rowdataDoctoPlc[$a]->{'ccu_codigo'},$arrayCusto,true)){
								array_push($arrayCusto,$rowdataDoctoPlc[$a]->{'ccu_codigo'});
							}
						}
					}
				}

				for($a=0; $a<count($arrayCusto); $a++){ $doctos=array(); ?>
					<div style="width:100%; background-color:<?php echo $backCor; ?>; float:left;">
						<div style="width:16%; padding-right: 0.5%; float:left; text-align: left;">
							<?php 
							if(empty($arrayCusto[$a]))
								echo "SEM CENTRO DE CUSTO"; 

							for($c=0; $c<$cntCusto; $c++){
								if($rowdataCusto[$c]->{'ccu_codigo'} === $arrayCusto[$a]){
									echo $rowdataCusto[$c]->{'ccu_descr'};
								}
							}
							?>
						</div>

						<?php 
						$totalCustoCplano = 0;
						$aPagarCplano = 0;
						$aReceberCplano = 0;

						for($d=0; $d<$cntDoctoPlc; $d++){
							if($rowdataDoctoPlc[$d]->{'plc_codigo'}===$arrayPlc[$j] && ( (isset($rowdataDoctoPlc[$d]->{'ccu_codigo_rateio'}) && $rowdataDoctoPlc[$d]->{'ccu_codigo_rateio'}===$arrayCusto[$a]) || (!isset($rowdataDoctoPlc[$d]->{'ccu_codigo_rateio'}) && $rowdataDoctoPlc[$d]->{'ccu_codigo'}===$arrayCusto[$a])) ){
								array_push($doctos, $rowdataDoctoPlc[$d]->{'lan_estorno'});
								if( array_search($rowdataDoctoPlc[$d]->{'lan_sequencia'}, $doctos)===false && $rowdataDoctoPlc[$d]->{'lan_tipo'}!=4 ){
									$valorpg = ( isset($rowdataDoctoPlc[$d]->{'ccu_codigo_rateio'}) ) ? (($rowdataDoctoPlc[$d]->{'ccr_porcentagem'}*$rowdataDoctoPlc[$d]->{'lan_valor'})/100) : $rowdataDoctoPlc[$d]->{'lan_valor'};
									if($rowdataDoctoPlc[$d]->{'doc_pagrec'}==1){
										$aPagarCplano += $valorpg;
									}else{
										$aReceberCplano += $valorpg;
									}
									$totalCustoCplano += $valorpg;
									
								}
							}
						}

						$totalaPagarCplano += $aPagarCplano;			
						$totalaReceberCplano += $aReceberCplano;				
						$totalComPlano += $totalCustoCplano;

						$op = saldo($aReceberCplano, $aPagarCplano);
						?> 
						<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($totalCustoCplano); ?>  </div>
						<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($aReceberCplano); ?> </div>
						<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($aPagarCplano); ?> </div>
						<div style="width:16%; float:left; text-align: right;"> <?php echo $op."".valorFormat($aReceberCplano-$aPagarCplano, true); ?> </div>
						
					</div>
					<?php
				}

				$op = saldo($totalaReceberCplano, $totalaPagarCplano);
				?> 
			</div>
			
			<div class="informacaoRodape">
				<div style="width:16%; float:left; text-align: right; padding-right:0.5%; font-weight:bold;"> TOTAL <?php //echo $planoatualDescr; ?> </div>
				<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($totalComPlano); ?> </div>
				<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($totalaReceberCplano); ?> </div>
				<div style="width:16%; float:left; text-align: right;"> <?php echo valorFormat($totalaPagarCplano); ?> </div>
				<div style="width:16%; float:left; text-align: right;"> <?php echo $op."".valorFormat($totalaReceberCplano - $totalaPagarCplano, true); ?> </div>
			</div>
			
			<?php 
			$totalGreceberCplano += $totalaReceberCplano;
			$totalGpagarCplano += $totalaPagarCplano;
			$totalGeralCplano += $totalComPlano;
		}
		
		$totalFinalCplano = $totalGeralCplano;
		$totalFinalReceberCplano = $totalGreceberCplano;
		$totalFinalPagarCplano = $totalGpagarCplano;
		$totalFinalSaldoCplano = $totalGreceberCplano - $totalGpagarCplano;
		
		$op = saldo($totalGreceberCplano, $totalGpagarCplano);
		
		?>
		<div class="informacaoRodape_outro">
			<span style="font-weight:bold;"> TOTAL GERAL DOS PLANOS DE CONTA => </span> 
			<span style="font-weight:bold;"> Movimento: </span> 
			<?php echo valorFormat($totalGeralCplano); ?> |
			<span style="font-weight:bold;"> Crédito: </span> 
			<?php echo valorFormat($totalGreceberCplano); ?> |
			<span style="font-weight:bold;"> Débito: </span> 
			<?php echo valorFormat($totalGpagarCplano); ?> |
			<span style="font-weight:bold;"> Saldo: </span> 
			<?php echo $op."".valorFormat($totalGreceberCplano - $totalGpagarCplano, true); ?>
		</div> 
		
		<?php
		$valorFinalReceber = $totalFinalReceberCplano + $totalFinalReceberSplano;
		$valorFinalPagar = $totalFinalPagarCplano + $totalFinalPagarSplano;
		$op = saldo($valorFinalReceber, $valorFinalPagar);
		?>

		<div class="informacaoRodape_outro">
			<span style="font-weight:bold;"> TOTAL GERAL FINAL => </span> 
			<span style="font-weight:bold;"> Movimento: </span> 
			<?php echo valorFormat($totalFinalCplano + $totalFinalSplano); ?> |
			<span style="font-weight:bold;"> Crédito: </span> 
			<?php echo valorFormat($totalFinalReceberCplano + $totalFinalReceberSplano); ?> |
			<span style="font-weight:bold;"> Débito: </span> 
			<?php echo valorFormat($totalFinalPagarCplano + $totalFinalPagarSplano ); ?> |
			<span style="font-weight:bold;"> Saldo: </span> 
			<?php echo $op."".valorFormat($valorFinalReceber - $valorFinalPagar, true); ?>
		</div> 
		
		<?php

	}

	/*
	 * *	RODAPE DOS RELATORIOS
	*/
	include("inc/relatorioRodape.php");

	?>