<?php
	setlocale (LC_ALL, 'pt_BR.UTF-8');
	include_once "../class/mpdf/mpdf.php";
	include_once "../class/class_calculoJuros.php";
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	
	function cnpj($n){
		$n = substr($n, 0, 2).".".substr($n, 2, 3).".".substr($n, 5, 3)."/".substr($n, 8, 4)."-".substr($n, 12, 2);
		return $n;
	}
	
	function cpf($n){
		$n = substr($n, 0, 3).".".substr($n, 3, 3).".".substr($n, 6, 3)."-".substr($n, 9, 2);
		return $n;
	}

	$Datapacket = new Datapacket();
	$TParams=new TParams();
	$mpdfTodos = new mPDF('utf-8', 'A4', 0, '', 0, 0, 0, 0, 0);
	$mpdfTodos->SetHTMLFooter('
	<div style="width:950px; height:20px; margin:0px auto; font-size:8px;">
		<div style="width:950px; text-align:right;">FACIL ONLINE - JC MANTOVAN</div>
	</div>'
	);
	
	//doc_codigo(s)
	$doc_codigo = json_decode($_REQUEST["doc_codigo"]);
	$codigos="";
	
	if( is_array($doc_codigo) ){
		foreach($doc_codigo as $c) $codigos.= "'".$c."', ";
		$codigos = substr($codigos, 0, -2);
	}else{
		$codigos = "'".$doc_codigo."'";
	}
	
	//empresa
	$company = $TParams->getCompany();	

	//docto
	$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
	$filtro = '{"cod":"500480","params":[
		{"name":"doc_codigo","value":"'.$codigos.'","type":"other"},
		{"name":"database","value":"'.$company->{'emp_db_comum'}.'","type":"other"}
	]}';
	$Datapacket->add($filtro);
	$doctos = $Datapacket->open(true);
	
	//dados para imprimir atualizado
	if(isset($_REQUEST["boletoAtt"])){
		
		$boletoAtt = json_decode(base64_decode($_REQUEST["boletoAtt"]));
		
	//verifica se carne esta vencido	
	}elseif( substr($doctos[0]->{'doc_dtvcto'}, 0, 10) < date("Y-m-d") ){
		/*
		$boletoAtt = new StdClass();
		$boletoAtt->{"juros"} = true;
		$boletoAtt->{"multa"} = true;
		$boletoAtt->{"novaData"} = date("Y-m-d", strtotime(date("Y-m-d H:i:s")."+ 1 day"));
		*/
	}
	
	if(count($doctos)>0){
		
		ob_start();
		
		if($doctos[0]->{'doc_tipo'}==7){
			
			?>
				<!DOCTYPE HTML>
				<html lang="pt_BR">
					
					<head>
						
						<meta charset="UTF-8">
						
						<?php

							$css = '
							<style type="text/css">
								strong{
									font-size:13px;
								}
								body{
									width:750px;
									margin:0;
									padding:0;
									font-family: Arial, Helvetica, sans-serif;
									font-size:11px;
								}
								.logo{
									width:100px;
									margin:4px;
								}
								.esq{
									float:left;
									border:1px solid #000;
									width:20%;
									height:325px;
								}
								.dir{
									float:left;
									width:79%;
									height:325px;
									border:1px solid #000;
								}
								.campo{
									border:1px solid #000;
									width:90%;
									padding:1px 4px;
									margin-bottom:3px;
								}
								.esq2{
									width:80%;
									float:left;
								}
								.dir2{
									width:20%;
									float:left;
									margin-bottom
								}
							</style>';
						?>
					</head>

					<body>

						<?php
						
							foreach($doctos as $docto){
								
								//desconto
								if( isset($docto->{'doc_desconto'}) && $docto->{'doc_desconto'}>0 ) $docto->{'doc_valor'} -= $docto->{'doc_desconto'};
								
								//juros/ multa
								if(isset($boletoAtt)){
									
									$bolJuros = 0;
									if($docto->{'doc_juros'}>0 && $boletoAtt->{"juros"}){
										$bolJuros = $docto->{'doc_juros'};
									}
									$bolMulta = 0;
									if($docto->{'doc_multa'}>0 && $boletoAtt->{"multa"}){
										$bolMulta= $docto->{'doc_multa'};
									}
									
								}else{
									// if($company->{'emp_multa'}>0)
										$bolMulta = $company->{'emp_multa'};
									// if($docto->{'cad_multa'}>0)
										$bolMulta = $docto->{'cad_multa'};
									// if($docto->{'doc_multa'}>0)
										$bolMulta = $docto->{'doc_multa'};

									// if($company->{'emp_jurosdiario'}>0)
										$bolJuros = $company->{'emp_jurosdiario'};
									if($docto->{'cad_jurosdiario'}>0)
										$bolJuros = $docto->{'cad_jurosdiario'};
									// if($docto->{'doc_juros'}>0)
										$bolJuros = $docto->{'doc_juros'};
								}
								
								
								
								$filter = '{"cod":"700290","params":[{"name":"cad_codigo","value":"'.$docto->{"cad_codigo"}.'","type":"string"}]}';

								$Datapacket->clear();
								$Datapacket->setHost($TParams->getHost($company->{'emp_db_comum'}));
								$Datapacket->add($filter);
								$endereco = $Datapacket->open(true);
								
								$instr = "";
								if( isset($boletoAtt->{"instr1"}) || isset($boletoAtt->{"instr2"}) || isset($boletoAtt->{"instr3"}) || isset($boletoAtt->{"instr4"}) || isset($boletoAtt->{"instr5"}) ){
									$instr  .= (isset($boletoAtt->{"instr1"})) ? strtoupper($boletoAtt->{"instr1"})."<br>" : "";
									$instr  .= (isset($boletoAtt->{"instr2"})) ? strtoupper($boletoAtt->{"instr2"})."<br>" : "";
									$instr  .= (isset($boletoAtt->{"instr3"})) ? strtoupper($boletoAtt->{"instr3"})."<br>" : "";
									$instr  .= (isset($boletoAtt->{"instr4"})) ? strtoupper($boletoAtt->{"instr4"})."<br>" : "";
									$instr  .= (isset($boletoAtt->{"instr5"})) ? strtoupper($boletoAtt->{"instr5"})."<br>" : "";
								}else{
									$instr .= ($company->{'emp_carne_instr1'}) ? $company->{'emp_carne_instr1'}."<br>" : "";
									$instr .= ($company->{'emp_carne_instr2'}) ? $company->{'emp_carne_instr2'}."<br>" : "";
								}
								
								//calculo
								$constructor  = '{
									"valor":"'.$docto->{"doc_valor"}.'",
									"vencto":"'.$docto->{'doc_dtvcto'}.'",
									"novoVencto":"';
								$constructor.= $boletoAtt->{"novaData"};
								$constructor.= '",
									"multa":"'.$bolMulta.'",
									"juros":"'.$bolJuros.'"
								}';
								$CalculoJuros = new CalculoJuros($constructor);
								$juros = json_decode($CalculoJuros->getData());
								
								if( isset($boletoAtt->{"juros"}) || isset($boletoAtt->{"multa"}) || isset($boletoAtt->{"novaData"}) ){
								
									$instr .= "VENCIMENTO ORIGINAL: ".implode("/", array_reverse(explode("-", substr($docto->{"doc_dtvcto"}, 0, 10))))."<br>";
									if(isset($boletoAtt->{"juros"}) || isset($boletoAtt->{"multa"})){
										$instr .= "VALOR ORIGINAL: ".number_format((float) $docto->{"doc_valor"}, 2, ",", "")."<br>";
										$instr .= "ENCARGOS POR ATRASO JUROS/MULTA: ".sprintf("%5.2f",$juros->{'multa'}+$juros->{'juros'});
										$docValor = $juros->{'total'};
									}else{
										$docValor = number_format((float) $docto->{"doc_valor"}, 2, ",", "");
									}
									$docVcto  = date('d/m/Y',strtotime($boletoAtt->{"novaData"}));
									
								}else{
									
									$bolJuros = (isset($bolJuros) && $bolJuros>0) ? (float) $docto->{"doc_valor"} * ($bolJuros/100) : 0;
									$bolMulta = (isset($bolMulta) && $bolMulta>0) ? (float) $docto->{"doc_valor"} * ($bolMulta/100) : 0;
								
									$instr .= "DOCUMENTO Nº " . $docto->{'doc_numero'}."<br>";
									$instr .= ($juros->{'multa'}>0) ? "AP&Oacute;S VENCIMENTO COBRAR MULTA DE: R$ ".sprintf("%5.2f",$juros->{'multa'}) : "";
									$instr .= ($juros->{'infJuros'}>0) ? "<br>JUROS POR DIA DE ATRASO: R$ ".sprintf("%5.2f",$juros->{'infJuros'}) : "";
									
									$docVcto = implode("/", array_reverse(explode("-", substr($docto->{"doc_dtvcto"}, 0, 10))));
									$docValor = number_format((float) $docto->{"doc_valor"}, 2, ",", "");
									
								}
								
								?>
						
								<div class="esq">
									<?php if($company->{"emp_logo"}!=""){ ?>
										<img src="<?php echo "http://".$_SERVER['SERVER_NAME']."/uploads/".$company->{"emp_codigo"}."/".$company->{"emp_logo"}?>" class="logo" alt="<?php echo $company->{"emp_fantasia"}?>"><br>
									<?php }else{
										echo $company->{"emp_fantasia"}."<br>";
									}?>
									<div class="campo">
										<strong>Vencimento</strong><br><div style="margin-left:30px;"><?php echo $docVcto;?></div>
									</div>
									<div class="campo">
										<strong>Valor R$</strong><br><div style="margin-left:30px;"><?php echo $docValor;?></div>
									</div>
									<div class="campo">
										<strong>Desconto</strong><br><br>
									</div>
									<div class="campo">
										<strong>Multa/ Mora</strong><br><br>
									</div>
									<div class="campo">
										<strong>Valor Cobrado</strong><br><br>
									</div>
									<div class="campo">
										<strong>Pagador</strong><br><span><?php echo substr($docto->{"cad_nomeraz"}, 0, 40)?></span><br>
									</div>
									<div class="campo">
										<strong>Nº Documento</strong><br><span><?php echo $docto->{"doc_numero"};?></span><br>
									</div>
									<div style="margin-left:30px;"><strong >Parcela <?php echo $docto->{"doc_nparc"}?> / <?php echo $docto->{"doc_tparc"}?></strong></div>
								</div>
								
								<div class="dir">
									<?php if($company->{"emp_logo"}!=""){ ?>
										<img src="<?php echo "http://".$_SERVER['SERVER_NAME']."/uploads/".$company->{"emp_codigo"}."/".$company->{"emp_logo"}?>" class="logo" style="margin-bottom:6px;" alt="<?php echo $company->{"emp_fantasia"}?>"><br>
									<?php }else{
										echo $company->{"emp_fantasia"}."<br>";
									}?>
									<div class="esq2">
										<div class="campo" style="height:30px; width:100%">
											<strong>Local de Pagamento</strong><br>
											<?php echo $company->{"emp_endereco"}?>, <?php echo $company->{"emp_num"}?>, <?php echo $company->{"emp_bairro"} ?> - <?php echo $company->{"emp_cidade"}?>-<?php echo $company->{"emp_uf"}?>
										</div>
										
										<div class="campo" style="height:158px; width:100%">
											<?php echo $instr."<br>".$docto->{"doc_descr"}?>
										</div>
									</div>
									
									
									<div class="dir2">
										<div class="campo">
											<strong>Vencimento</strong><br><div style="margin-left:30px;"><?php echo $docVcto;?></div>
										</div>
										
										<div class="campo">
											<strong>Valor R$</strong><br><div style="margin-left:30px;"><?php echo $docValor;?></div>
										</div>
										<div class="campo">
											<strong>Desconto</strong><br><br>
										</div>
										<div class="campo">
											<strong>Multa/ Mora</strong><br><br>
										</div>
										<div class="campo">
											<strong>Valor Cobrado</strong><br><br>
										</div>
									</div>
									<div class="campo" style="height:45px; width:100%">
										<strong>Pagador</strong><br>
										<?php echo $docto->{"cad_nomeraz"}?> - CPF/CNPJ: <?php echo (strlen($docto->{"cad_cnpjcpf"})<14) ? cpf($docto->{"cad_cnpjcpf"}) : cnpj($docto->{"cad_cnpjcpf"})?>
										<br>
										<?php echo $docto->{"end_nome"}; ?>
									</div>
								</div><br><br>
								
								<?php
							}
						?>
					</body>
				</html>
			<?php

			$dir = $TParams->uploads.$company->{'emp_codigo'}.'/carnes/';
			$dir2 = $TParams->uploads2.$company->{'emp_codigo'}.'/carnes/';
			if(!is_dir($dir)) @mkdir($dir,0777);
			
			$html = ob_get_clean();
			$mpdfTodos->WriteHTML($css, 1);
			$mpdfTodos->WriteHTML($html, 2);
			$mpdfTodos->Output($dir.$doctos[0]->{"doc_codigo"}.".pdf");
			
			echo "<a href='".$dir2.$doctos[0]->{"doc_codigo"}.".pdf"."' style='text-decoration:none; font-weight:bold; color:#000'>Clique aqui para imprimir o Carnê</a>
			<script>
				setTimeout(function(){
					location.href='".$dir2.$doctos[0]->{"doc_codigo"}.".pdf"."'
				},500);
			</script>
			";
			
		}else{
			
			echo "O documento selecionado não é do tipo Carnê!";
			
		}
		
	}else{
		
		echo "Nâo foram encontrados documentos correspondentes!";
		
	}
?>