<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$datapacket = new TParams();
	$datapacket->debug(true);
	$company = $datapacket->getCompany();
	
	if(isset($_REQUEST['chmd_codigo']) && !empty($_REQUEST['chmd_codigo'])){

		$filtro = '{"cod":"701074","params":[
			{"name":"database","value":"' . $company->{'emp_db_sge'} . '","type":"other"},
			{"name":"chmd_codigo","value":"' . $_REQUEST['chmd_codigo'] . '","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($company->{'emp_db_comum'}));
		$datapacket->add($filtro);
		$rowdata = $datapacket->open(true);
		$datapacket->clear();

		ob_start();

		$colunas = "";

		?>

			<html>

				<head>
					
					<title>Relatório de Movimentações</title>
					
					<meta charset="UTF-8">

				</head>
				
				<body style="font-size:20px;">

					<?php

						if (count($rowdata) > 0) {

							?>

								<div style="float:left; width:100%; margin-bottom:30px; font-size: 20px;"> 

									<div style="float:left; width:60%"> CLIENTE: <?php echo $rowdata[0]->{'cad_nomeraz'} ;?> </div>

									<div style="float:left; width:40%; text-align:right;"> CHAMADO Nº <?php echo $rowdata[0]->{'chmd_numero'} ;?> </div>

								</div>

							<?php

							foreach ($rowdata as $indice => $movimentacao) {

								$corFundo = ($indice % 2 == 0) ? "#E4E4E4" : "#FFF";

								?>

									<div style="float:left; width:98.5%; padding:10px; margin-bottom: 30px; background-color:<?php echo $corFundo ;?>">

										<div style="float:left; width:100%;">
											
											<div style="float:left; width:40%;">
											
												<span style="font-size:30px; border-bottom:1px solid #000;"> <?php echo dataComHoras($movimentacao->{'chmm_data'}) ;?> </span>

											</div>

										</div>
										
										<div style="float:left; width:100%; margin-top:30px;">

											<div style="float:left; width:60%"> TÉCNICO: <span style="border-bottom:1px solid #000;"> <?php echo $movimentacao->{'chmm_tecnico_nome'} ;?> </span></div>
											<div style="float:left; width:40%; text-align:right;"> 
												
												<?php 

													$tempo = $movimentacao->{'chmm_tempo'};

	                                                $horas = (intval($tempo) < 10) ? "0" . intval($tempo) : intval($tempo);

	                                                $minutos = intval(((($tempo - intval($tempo)) * 60)	/ 100) * 100);

	                                                $minutos = (strlen(strval($minutos)) == 1) ? "0" . $minutos : $minutos;

	                                                $tempo = $horas . ":" . $minutos;

													?>
														
														<span> TEMPO: </span> <span style="border-bottom:1px solid #000;"> <?php echo $tempo ;?> </span>

													<?php

												?> 

											</div>

										</div>

										<div style="float:left; width:100%; margin-top:30px;">

											<span style="width:100%"> COMENTÁRIO: </span> <span style="border-bottom:1px solid #000; margin-bottom:5px;"> <?php echo base64_decode($movimentacao->{'chmm_comentario'}) ;?> </span>

										</div>
									
									</div>

								<?php			
							}
						}
					?>

				</body>

			</html>

		<?php

		$html = ob_get_clean();
		
		$arquivo = str_replace(array(".",","), "", microtime(true));
		$fp = fopen($datapacket->getHostRoot()."tmp/".$arquivo.'.html', 'w');
		fwrite($fp, $html);
		fclose($fp);
		
		exec($datapacket->getHostRoot().'class/phantomjs/bin/phantomjs '.$datapacket->getHostRoot().'class/phantomjs/rasterizeRetrato.js '.$datapacket->getHostRoot().'tmp/'.$arquivo.'.html '.$datapacket->getHostRoot().'tmp/'.$arquivo.'.pdf ["7,5in*5in"]');
		
		if(file_exists($datapacket->getHostRoot()."tmp/".$arquivo.'.pdf')){
			
			echo "/desktop/tmp/".$arquivo.'.pdf';

		} else {

			echo "Ocorreu um erro ao gerar o arquivo.";
		}
	
	} else {

		exit("Nenhum codigo foi passado!");
	}
	
?>