<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$datapacket = new TParams();
	$datapacket->debug(true);

	$company = array();
	$company[0] = $datapacket->getCompany();

	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$cad_codigo = "";
	if(isset($dados->{'cad_codigo'}) && !empty($dados->{'cad_codigo'})){
		$aux = "";
		foreach ($dados->{'cad_codigo'} as $cad_codigo) {
			if(empty($aux)){
				$aux .= "'".$cad_codigo."'"; 
			}else{
				$aux .= ", '".$cad_codigo."'"; 
			}
		}
		$cad_codigo = " and a.cad_codigo in (".$aux.")";	
	}

	$emi_descr = "";
	if(isset($dados->{'emi_descr'}) && !empty($dados->{'emi_descr'})){
		$emi_descr = $dados->{'emi_descr'};
	}

	$chq_bompara = "";
	$periodo="INDEFINIDO";
	if(!empty($dados->{'chq_bompara_ini'}) && $dados->{'chq_bompara_ini'} != "Novo Registro" && !empty($dados->{'chq_bompara_fim'}) && $dados->{'chq_bompara_fim'} != "Novo Registro"){
		$periodo=" de ".implode("/",array_reverse(explode("-", substr($dados->{'chq_bompara_ini'},0,10))))." até ".implode("/",array_reverse(explode("-", substr($dados->{'chq_bompara_fim'},0,10))));
	}
	if(!empty($dados->{'chq_bompara_ini'}) && $dados->{'chq_bompara_ini'} != "Novo Registro"){

		$chq_bompara =  " and a.chq_bompara >= '".dataBd($dados->{'chq_bompara_ini'})." 00:00:00'";	

		if(!empty($dados->{'chq_bompara_fim'}) && $dados->{'chq_bompara_fim'} != "Novo Registro"){

			$chq_bompara .= " and a.chq_bompara <= '".dataBd($dados->{'chq_bompara_fim'})." 23:59:59'";
		}
	}else{

		if(!empty($dados->{'chq_bompara_fim'}) && $dados->{'chq_bompara_fim'} != "Novo Registro"){

			$chq_bompara = " and a.chq_bompara <= '".dataBd($dados->{'chq_bompara_fim'})." 23:59:59'";
		}
	}

	$chq_status = "";
	$status = "TODOS";
	if(isset($dados->{'chq_status'}) && !empty($dados->{'chq_status'})){
		
		$chq_status = "and a.chq_status = " . $dados->{'chq_status'};
		
		if($dados->{'chq_status'} == 1){
			$status = "EM SER";
		}else if($dados->{'chq_status'} == 2){
			$status = "LIQUIDADO";
		}else if($dados->{'chq_status'} == 3){
			$status = "DEVOLVIDO";
		}else if($dados->{'chq_status'} == 4){
			$status = "CUSTODIADO";
		}else if($dados->{'chq_status'} == 5){
			$status = "DESCONTADO";
		}else if($dados->{'chq_status'} == 6){
			$status = "TERCEIROS";
		}
	}
	
	$filtro = '{"cod":"501170", "params":[
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
		{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"other"},
		{"name":"emi_descr","value":"%'.$emi_descr.'%","type":"string"},
		{"name":"chq_bompara","value":"'.$chq_bompara.'","type":"other"},
		{"name":"chq_status","value":"'.$chq_status.'","type":"other"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	//echo $datapacket->getLastQuery();
	$cnt = $datapacket->getRecordCount();
	$datapacket->clear();

	$titulo = utf8_decode("RELATÓRIO DE CHEQUES");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $datapacket->getCompany()->{"emp_codigo"} . "/" . $datapacket->getCompany()->{"emp_logo"};
    include("inc/relatorioCabecalho.php");

	$cabecalhoHeight = '280';

    $filtro1 =  base64_encode('<div style="width:20%; float:left"><span style="font-weight:bold;">STATUS: </span>'.utf8_decode($status).'</div>');
    $filtro2 =  base64_encode('<div style="width:20%; float:left"><span style="font-weight:bold;">' . utf8_decode("PERÍODO: ") . '</span>'.utf8_decode($periodo).'</div>');
    $objFiltro = new stdClass();
    $filtros = array(
        $objFiltro->filtro = $filtro1,
        $objFiltro->filtro = $filtro2
    );

	$colunas = array();
		
	array_push($colunas, base64_encode('<div style="float:left; width:8%; text-align:left;">'.utf8_decode("NÚMERO").'</div>')); 
	array_push($colunas, base64_encode('<div style="float:left; width:20%; text-align:left;">CLIENTE</div>')); 
	array_push($colunas, base64_encode('<div style="float:left; width:21%; text-align:left;">EMITENTE</div>'));
	array_push($colunas, base64_encode('<div style="float:left; width:4%; text-align:left;">TELEFONE</div>'));
	array_push($colunas, base64_encode('<div style="float:left; width:8%; text-align:right;">VALOR</div>')); 
	array_push($colunas, base64_encode('<div style="float:left; width:6%; text-align:right;">BOM PARA</div>'));
	array_push($colunas, base64_encode('<div style="float:left; width:10%; text-align:center;">STATUS</div>'));
	array_push($colunas, base64_encode('<div style="float:left; width:19%; text-align:left;">'.utf8_decode("OBSERVAÇÃO").'</div>')); 
	
	$total = 0;
	
	if($cnt > 0){

		foreach ($rowdata as $i=>$cheque) {

			if($i % 2 == 0){
                $backCor = "#EFEEED";
            }else{
                $backCor = "#FFF";
            }
			
			switch($cheque->chq_status){
				case 1:
					$status="EM SER";
					break;
				case 2:
					$status="LIQUIDADO";
					break;
				case 3:
					$status="DEVOLVIDO";
					break;
				case 4:
					$status="CUSTODIADO";
					break;
				case 5:
					$status="DESCONTADO";
					break;
				case 6:
					$status="TERCEIROS";
					break;
				case 7:
					$status="DEPOSITADO";
					break;
			}
			
			?>
				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>">
					
					<div style="width:8%; float:left; text-align:left; padding-left: 0.5%"> <?php echo $cheque->chq_numero . "&nbsp"; ?> </div>
					<div style="width:20%; float:left; text-align:left;"> <?php echo $cheque->cad_nomeraz . "&nbsp"; ?> </div>
					<div style="width:21%; float:left; text-align:left;"> <?php echo $cheque->emi_descr . "&nbsp"; ?> </div>
					<div style="width:4%; float:left; text-align:left;"> <?php echo "(".$cheque->emi_tel_ddd.")".$cheque->emi_tel_numero . "&nbsp"; ?> </div>
					<div style="width:8%; float:left; text-align:right; padding-right: 1%"> <?php echo valorFormat($cheque->chq_valor) . "&nbsp"; ?> </div>
					<div style="width:4%; float:left; text-align:right; padding-right: 1%"> <?php echo data($cheque->chq_bompara) . "&nbsp"; ?> </div>
					<div style="width:10%; float:left; text-align:center;"> <?php echo $status . "&nbsp"; ?> </div>
					<div style="width:19%; float:left; text-align:left;"> <?php echo substr(utf8_encode(base64_decode($cheque->chq_obs)),0,45)."&nbsp;"; ?> </div>

				</div>

			<?php
			$total+=$cheque->chq_valor;
		}
	?>
			<div style="clear:both"><br></div>

			<div class="informacaoRodape_outro">

				<div style="float:left; width:35%; margin-left:10px; padding-right:10%;"><span style="font-weight:bold">Total Geral </span>
					<?php 
						echo ($cnt>1) ? $cnt." CHEQUES" : $cnt." CHEQUE";
					?>
				</div>
				<div style="float:left; width:25%;  font-weight:bold; text-align:right">Soma dos Cheques: <?php echo valorFormat($total)."&nbsp"?></div>
			</div>
	<?php

	} else {

		?>
			
			<div style="width:100%; float:left; margin:50px 0px 0px 0px; padding: 0px 0px; text-align:center">
			
				Não foram encontrados registros para sua pesquisa
			
			</div>

		<?php
	}

	include "../rel/inc/relatorioRodape.php";
	
?>