<?php
	error_reporting(E_ALL);
	ob_start();

	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';

	$datapacket = new TParams();
	$datapacket->debug(true);
	$company = array();
	$company[0] = $datapacket->getCompany();

	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$cad_codvend = "";
	$vendedor = "TODOS";
	if(isset($dados->{'cad_codvend'}) && !empty($dados->{'cad_codvend'})){
		$cad_codvend = "and b.cad_codvend = '" . $dados->{'cad_codvend'}. "'";
		$vendedor = $dados->{'cad_nomevend'};
	}
	
	if(isset($dados->{'agr_codigo'}) && !empty($dados->{'agr_codigo'})){
		$cad_codvend .= " and c.agr_codigo = '" . $dados->{'agr_codigo'}. "' ";
	}

	$not_data = "";
	$periodo_ini = "2000-01-01";
	if(isset($dados->{'data_ini'}) && !empty($dados->{'data_ini'})){
		$not_data = "and b.not_data >= '" . data($dados->{'data_ini'}, true) . " 00:00:00' ";
		$periodo_ini = $dados->{'data_ini'};
	}

	$periodo_fim = "2100-12-31";
	if(isset($dados->{'data_fim'}) && !empty($dados->{'data_fim'})){
		$not_data .= "and b.not_data <= '" . data($dados->{'data_fim'}, true) . " 23:59:59'";
		$periodo_fim = $dados->{'data_fim'};
	}

	$ref_codigo = "";
	$produtos = "TODOS";
	if(isset($dados->{'ref_codigo'}) && !empty($dados->{'ref_codigo'})){
		$aux = "";

		foreach($dados->{'ref_codigo'} as $produto){
			$aux .= (empty($aux)) ? strval($produto) : ", '" . $produto . "'";
		}

		$ref_codigo = "and a.ref_codigo in (" . $aux . ")";
		$produtos = "ESPECÍFICOS";
	}

	//se ja existe nota para o pedido e o tipo da nota nao for mais (2 = pedido) traz a nota caso contrario traz o pedido  
	$ref_codigo .= ' and b.not_codigo not in(select header_nota.not_codigo_pai from header_nota where LENGTH(header_nota.not_codigo_pai) > 0 and header_nota.not_tipo not in (2,7) )';

	$filtro = '{"cod":"501200", "params":[
		{"name":"database","value":"'.$company[0]->{'emp_db_comum'}.'","type":"other"},
		{"name":"cad_codvend","value":"'.$cad_codvend.'","type":"other"},
		{"name":"not_data","value":"'.$not_data.'","type":"other"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"}
	]}';
	$datapacket->setHost($datapacket->getHost($company[0]->{'emp_db_sge'}));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	// echo $datapacket->getLastQuery();
	$cnt = $datapacket->getRecordCount();
	$datapacket->clear();

	$titulo = utf8_decode("RELATÓRIO DE COMISSÃO DO VENDEDOR POR PRODUTOS");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $datapacket->getCompany()->{"emp_codigo"} . "/" . $datapacket->getCompany()->{"emp_logo"};
	include "../rel/inc/relatorioCabecalho.php";

    $cabecalhoHeight = 290;

	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = base64_encode('<span style="font-weight:bold;">' .utf8_decode("PERÍODO"). ': </span> <span style="font-weight:normal; margin-right:100px">' .utf8_decode("DE " . data($periodo_ini) . " ATÉ " . data($periodo_fim)).'</span>'),
		$objFiltro->filtro = base64_encode('<span style="font-weight:bold;">' .utf8_decode("VENDEDOR"). ': </span> <span style="font-weight:normal; margin-right:100px">' .utf8_decode($vendedor).'</span>'),
		$objFiltro->filtro = base64_encode('<span style="font-weight:bold;">' .utf8_decode("PRODUTOS"). ': </span> <span style="font-weight:normal;">' .utf8_decode($produtos).'</span>')
	);

    $colunas = array(
        base64_encode('<div style="float:left; width:19.5%; text-align:left;">VENDEDOR</div>'),
        base64_encode('<div style="float:left; width:29.5%; text-align:left;">PRODUTO</div>'),
        base64_encode('<div style="float:left; width:11.5%; text-align:left;">VALOR</div>'),
        base64_encode('<div style="float:left; width:12%; text-align:left;">QUANTIDADE</div>'),
        base64_encode('<div style="float:left; width:9%; text-align:left;">TOTAL</div>'),
        base64_encode('<div style="float:left; width:9%; text-align:left;">' . utf8_decode('PRODUTO COMISSÃO') .'</div>'),
        base64_encode('<div style="float:left; width:7.5%; text-align:left; padding-left: 34px">' . utf8_decode('TOTAL COMISSÃO') .'</div>')
    );

	if($cnt > 0){

		// Pegar todo os vendedores
		$vendedores = array();
		foreach($rowdata as $item) {

			if(!empty($item->{'cad_codvend'})){

				$vendedor = new stdClass();
				$vendedor->{'codigo'} = $item->{'cad_codvend'};
				$vendedor->{'nome'} = $item->{'cad_nomevend'};

				if(!in_array($vendedor, $vendedores)){

					array_push($vendedores,  $vendedor);
				}
			}
		}
		// Pegar produtos de cada vendedor
		foreach ($vendedores as $vendedor) {

			$vendedor->{'produtos'} = array();
			$vendedor->{'total'} = 0;
			
			foreach ($rowdata as $produto) {

				if($vendedor->{'codigo'} == $produto->{'cad_codvend'}){
					
					$vendedor->{'total'} += $produto->{'itn_subtotal'};
					
					$prod = new stdClass();
					$prod->{'ref_codigo'} = $produto->{'ref_codigo'};
					$prod->{'itn_descr'} = $produto->{'itn_descr'};
					$prod->{'itn_valor'} = $produto->{'itn_valor'};
					$prod->{'itn_qtde'} = $produto->{'itn_qtde'};
					$prod->{'itn_subtotal'} = $produto->{'itn_subtotal'};
					$prod->{'ref_comissao'} = $produto->{'ref_comissao'};

					$indice = objectInArray($vendedor->{'produtos'}, "ref_codigo", $prod->{"ref_codigo"}, true);

					if($indice || $indice === 0) {

						$vendedor->{'produtos'}[$indice]->{'itn_qtde'} += $prod->{'itn_qtde'};
						$vendedor->{'produtos'}[$indice]->{'itn_subtotal'} += $prod->{'itn_subtotal'};

					} else {
						array_push($vendedor->{'produtos'}, $prod);
					}
				}
			}
			
		}

		$totalGeralProdutos = 0;
		$totalGeralValor = 0;
		$totalGeralQuantidade = 0;
		$totalGeralSubtotal = 0;
		$totalGeralComis = 0;
		
		//ordenar do maior valor total de vendas, para o menor
		if(isset($dados->{'ascdesc'}) && $dados->{'ascdesc'} == 'asc'){
			usort($vendedores, function($a, $b) {
				return $a->total <=> $b->total;
			});
		}else{
			usort($vendedores, function($a, $b) {
				return $b->total <=> $a->total;
			});
		}

		// Percorrer e listar vendedor e seus produtos
		foreach ($vendedores as $vendedor) {

			$totalvalor = 0;
			$totalquantidade = 0;
			$totalsubtotal = 0;
			$totalComis = 0;

			?>

				<div class="informacaoListagem"> <?php echo $vendedor->{'nome'}; ?> </div>

			<?php

			if(isset($dados->{'ascdesc'}) && $dados->{'ascdesc'} == 'asc'){
				$vendedor->{'produtos'} = ordenacao($vendedor->{'produtos'}, "itn_qtde", "asc");
			} else {
				$vendedor->{'produtos'} = ordenacao($vendedor->{'produtos'}, "itn_qtde", "desc");
			}
			
			foreach($vendedor->{'produtos'} as $produto){

				$comissaoCalculada = $produto->{'itn_qtde'} * (($produto->{'ref_comissao'} * $produto->{'itn_valor'}) / 100);
				
				if( isset($dados->{'tiporel'}) && $dados->{'tiporel'}=='0' ){
				?>

					<div style="float:left; width:100%; background-color:<?php echo $backCor; ?>;  margin:0px 0px 0px 0px; padding:2px 0px 0px 0px;">

						<div style="float:left; width:20%; text-align: left; padding-left: 20%">  <?php echo substr($produto->{'ref_codigo'} . "-" . $produto->{'itn_descr'}, 0, 38); ?> </div>
						<div style="float:left; width:12%; text-align:right"> <?php echo valorFormat($produto->{'itn_valor'}); ?> </div>
						<div style="float:left; width:12%; text-align:right"> <?php echo valorFormat($produto->{'itn_qtde'}); ?> </div>
						<div style="float:left; width:12%; text-align:right"> <?php echo valorFormat($produto->{'itn_subtotal'}); ?> </div>
						<div style="float:left; width:11%; text-align:right"> <?php echo valorFormat($produto->{'ref_comissao'}) . "%"; ?> </div>
						<div style="float:left; width:12%; text-align:right"> <?php echo valorFormat($comissaoCalculada); ?> </div>

					</div>

				<?php
				}

				$totalvalor += $produto->{'itn_valor'};
				$totalquantidade += $produto->{'itn_qtde'};
				$totalsubtotal += $produto->{'itn_subtotal'};
				$totalComis += $comissaoCalculada;
			}
			?>

				<div class="informacaoRodape">

					<div style="float:left; width:20%; padding-left: 20%"> TOTAL PRODUTOS <?php echo count($vendedor->{'produtos'}); ?> </div>
					<div style="float:left; width:12%; text-align:right"> <?php echo valorFormat($totalvalor); ?> </div>
					<div style="float:left; width:12%; text-align:right"> <?php echo valorFormat($totalquantidade); ?> </div>
					<div style="float:left; width:12%; text-align:right"> <?php echo valorFormat($totalsubtotal); ?> </div>
					<div style="float:left; width:20%; text-align:right; padding-left: 3%"> <?php echo valorFormat($totalComis); ?> </div>

				</div>

			<?php

			$totalGeralProdutos += count($vendedor->{'produtos'});
			$totalGeralValor += $totalvalor;
			$totalGeralQuantidade += $totalquantidade;
			$totalGeralSubtotal += $totalsubtotal;
			$totalGeralComis += $totalComis;
		}

		?>

			<div class="informacaoRodape_outro">

				<div style="float:left; width:20%;"> TOTAL VENDEDOR <?php echo count($vendedores); ?> </div>
				<div style="float:left; width:20%;"> TOTAL PRODUTOS <?php echo $totalGeralProdutos; ?> </div>
				<div style="float:left; width:12%; text-align:right"> <?php echo valorFormat($totalGeralValor); ?> </div>
				<div style="float:left; width:12%; text-align:right"> <?php echo valorFormat($totalGeralQuantidade); ?> </div>
				<div style="float:left; width:12%; text-align:right"> <?php echo valorFormat($totalGeralSubtotal); ?> </div>
				<div style="float:left; width:20%; text-align:right; padding-left: 3%"> <?php echo valorFormat($totalGeralComis); ?> </div>

			</div>

		<?php

	} else {

		?>

			<div style="float:left; width:100%; margin:50px 0px 10px 0px; padding:3px 0px; text-align:center;font-weight:bold">Nenhum Resultado para sua pesquisa</div>

		<?php

	}

	include "../rel/inc/relatorioRodape.php";

?>
