<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include('../php/TParams.class.php');
	include('../php/funcoes.php');

	$datapacket = new TParams();
	$empresa = $datapacket->getCompany();

	if(!isset($_POST['dados']) || empty($_POST['dados'])){
		exit("erro de parametro");
	}

	$dados = json_decode(base64_decode($_POST['dados']));

	$totalHoras = 0;

	$chmd_data_ini = "1900-01-01 00:00:00";
	if(isset($dados->{'chmd_data_ini'})&&!empty($dados->{'chmd_data_ini'})){
		$chmd_data_ini = data($dados->{'chmd_data_ini'},true)." 00:00:00";
	}

	$chmd_data_fim = date("Y-m-d H:i:s");
	if(isset($dados->{'chmd_data_fim'})&&!empty($dados->{'chmd_data_fim'})){
		$chmd_data_fim = data($dados->{'chmd_data_fim'},true)." 23:59:59";
	}

	$cad_codigo = '%';
	if (isset($dados->{'cad_codigo'})&&!empty($dados->{'cad_codigo'})){
		$cad_codigo = $dados->{'cad_codigo'};
	}

	$chmd_tipo = '1,2,3';
    if(isset($dados->{'chmd_tipo'})&&!empty($dados->{'chmd_tipo'})){
    	$chmd_tipo = $dados->{'chmd_tipo'};
    }
	
	$chmd_tpatendimento = '1,2,3,4,5';
    if(isset($dados->{'chmd_tpatendimento'})&&!empty($dados->{'chmd_tpatendimento'})){
    	$chmd_tpatendimento = $dados->{'chmd_tpatendimento'};
    }
	
	$chmd_prioridade = '1,2,3,4,5';
    if(isset($dados->{'chmd_prioridade'})&&!empty($dados->{'chmd_prioridade'})){
    	$chmd_prioridade = $dados->{'chmd_prioridade'};
    }
	
	$chmd_status = '1,2,3,4';
    if(isset($dados->{'chmd_status'})&&!empty($dados->{'chmd_status'})){
    	$chmd_status = $dados->{'chmd_status'};
    }

	$chmd_tecnico = '%';
	if (isset($dados->{'chmd_tecnico'})&&!empty($dados->{'chmd_tecnico'})){
		$chmd_tecnico = $dados->{'chmd_tecnico'};
	}
	
	$cod_modulo = '%';
	if (isset($dados->{'cod_modulo'})&&!empty($dados->{'cod_modulo'})){
		$cod_modulo = $dados->{'cod_modulo'};
	}

	$chmm_tempo_menor = 0;
	if (isset($dados->{'chmm_tempo_menor'})&&!empty($dados->{'chmm_tempo_menor'})){
		$chmm_tempo_menor = $dados->{'chmm_tempo_menor'};
	}

	$chmm_tempo_maior = 99999999;
	if (isset($dados->{'chmm_tempo_maior'})&&!empty($dados->{'chmm_tempo_maior'})){
		$chmm_tempo_maior = $dados->{'chmm_tempo_maior'};
	}

	$filtro = '{"cod":"701190", "params":[
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
		{"name":"chmd_data_ini","value":"'.$chmd_data_ini.'","type":"string"},
		{"name":"chmd_data_fim","value":"'.$chmd_data_fim.'","type":"string"},
		{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
		{"name":"chmd_tipo","value":"'.$chmd_tipo.'","type":"other"},
		{"name":"chmd_tpatendimento","value":"'.$chmd_tpatendimento.'","type":"other"},
		{"name":"chmd_tecnico","value":"'.$chmd_tecnico.'","type":"string"},
		{"name":"cod_modulo","value":"'.$cod_modulo.'","type":"string"},
		{"name":"chmd_prioridade","value":"'.$chmd_prioridade.'","type":"other"},
		{"name":"chmd_status","value":"'.$chmd_status.'","type":"other"}
	]}';

	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	$cnt = $datapacket->getRecordCount();
	// echo $datapacket-> getLastQuery();
	$datapacket->clear();

	$titulo = utf8_decode("RELATÓRIO DE CHAMADOS");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $empresa->emp_codigo . "/" . $empresa->emp_logo;

	include("./inc/relatorioCabecalho.php");

	$filtros = '';
	$colunas = '';
																
	if($cnt > 0){
		
		?>
			<div class="informacaoColuna">
				<div style="float:left; width:5%; text-align:left;">NÚMERO</div>
				<div style="float:left; width:10%; text-align:left;">DATA INÍCIO</div>
				<div style="float:left; width:13%; text-align:left;">CLIENTE</div>
				<div style="float:left; width:13%; text-align:left;">TÉCNICO</div>
				<!--<div style="float:left; width:6%; text-align:left;">ORIGEM</div>-->
				<div style="float:left; width:8%; text-align:left;">ATENDIMENTO</div>
				<div style="float:left; width:9%; text-align:left;">SITUAÇÃO</div>
				<div style="float:left; width:15%; text-align:left;">DESCRIÇÃO</div>
				<div style="float:left; width:15%; text-align:left;">MÓDULO</div>
				<div style="float:left; width:5%; text-align:right;">DURAÇÃO</div>
				<div style="float:left; width:5%; text-align:right;">AVALIAÇÃO</div>
			</div>
		<?php
		
		foreach($rowdata as $i=>$chamado){

			if($i % 2 == 0){
				$backCor = "#F7F7F7";
			}else{
				$backCor = "#fff";
			}

			$tempo = $chamado->{'chmm_tempo'};
			$horas = (intval($tempo) < 10) ? "0" . intval($tempo) : intval($tempo);
			$minutos = intval(((($tempo - intval($tempo)) * 60)	/ 100) * 100);
			$minutos = (strlen(strval($minutos)) == 1) ? "0" . $minutos : $minutos;
			$tempo = $horas . ":" . $minutos;
			
			?>

				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>;">
					<div style="float:left; width:5%; text-align:left; padding-left:0.5%;"><?php echo $chamado->{'chmd_numero'}?></div>
					<div style="float:left; width:10%; text-align:left; padding-left:0.5%;"><?php echo implode("/",array_reverse(explode("-", substr($chamado->{'chmd_data'},0,10)))).substr($chamado->{'chmd_data'},10)."&nbsp";?></div>
					<div style="float:left; width:13%; text-align:left;"><?php echo substr($chamado->{'cad_nomeraz'},0,25)."&nbsp";?></div>
					<div style="float:left; width:13%; text-align:left;"><?php echo substr($chamado->{'cad_tecnico'},0,25)."&nbsp";?></div>
					<!--<div style="float:left; width:6%; text-align:left;">
						<?php 
							/*if ($chamado->{'chmd_tipo'} == 1) {
								echo 'INTERNO';
							} else {
								echo 'EXTERNO';
							}*/
						?>
					</div>-->
					<div style="float:left; width:8%; text-align:left;">
						<?php 
							if ($chamado->{'chmd_tpatendimento'} == 1) {
								echo 'TELEFONE';
							} elseif($chamado->{'chmd_tpatendimento'} == 2) {
								echo 'REMOTO';
							}elseif($chamado->{'chmd_tpatendimento'} == 3) {
								echo 'RETORNO';
							}elseif($chamado->{'chmd_tpatendimento'} == 4) {
								echo 'FINALIZADO';
							}elseif($chamado->{'chmd_tpatendimento'} == 5) {
								echo 'TELEFONE + REMOTO';
							}
						?>
					</div>
					<div style="float:left; width:9%; text-align:left;">
						<?php 
							if ($chamado->{'chmd_status'} == 1) {
								echo 'ABERTO';
							} elseif($chamado->{'chmd_status'} == 2) {
								echo 'DESENVOLVIMENTO';
							}elseif($chamado->{'chmd_status'} == 3) {
								echo 'FINALIZADO';
							}elseif($chamado->{'chmd_status'} == 4) {
								echo 'IMPEDIMENTO';
							}
						?>
					</div>
					<div style="float:left; width:15%; text-align:left;"><?php echo str_replace("\"","",substr(unicode_convert(base64_decode($chamado->{'chmd_descr'})),0))."&nbsp";?></div>
					<div style="float:left; width:15%; text-align:left;"><?php echo ( isset($chamado->{'mod_descr'}) && $chamado->{'mod_descr'}!="" ) ? $chamado->{'mod_descr'} : "&nbsp;";?></div>
					<div style="float:left; width:5%; text-align:center;"><?php echo $tempo."&nbsp";?></div>
					<div style="float:left; width:5%; text-align:center;">
						<?php
							switch($chamado->{'chmd_avaliacao'}){
								case 1:
									echo "&#x2605;";
									break;
								case 2:
									echo "&#x2605;&nbsp;&#x2605;";
									break;
								case 3:
									echo "&#x2605;&nbsp;&#x2605;&nbsp;&#x2605;";
									break;
								case 4:
									echo "&#x2605;&nbsp;&#x2605;&nbsp;&#x2605;&nbsp;&#x2605;";
									break;
								case 5:
									echo "&#x2605;&nbsp;&#x2605;&nbsp;&#x2605;&nbsp;&#x2605;&nbsp;&#x2605;";
									break;
								default:
									echo "&nbsp;";
							}
						?>
					</div>
				</div>

			<?php

			$totalHoras += $chamado->{'chmm_tempo'};
		}

		$horas = (intval($totalHoras) < 10) ? "0" . intval($totalHoras) : intval($totalHoras);
		$minutos = intval(((($totalHoras - intval($totalHoras)) * 60)	/ 100) * 100);
		$minutos = (strlen(strval($minutos)) == 1) ? "0" . $minutos : $minutos;
		$tempo = $horas . ":" . $minutos;

		?>
			<div class="informacaoRodape_outro" style="margin-top: 50px;">Total de Horas:
				<?php echo $tempo."&nbsp";?> 
			</div>
		<?php
	}else{

		?>
		<div style="float:left; width:100%; margin:50px 0px 10px 0px; padding:3px 0px; text-align:center;font-weight:bold">Nenhum Resultado para sua pesquisa</div>

		<?php
	}
	include "inc/relatorioRodape.php";

?>