<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';

	$Datapacket = new TParams();
	$Datapacket->debug(true);
	$Datapacket->clear();

	$company = array();
	$company[0] = $Datapacket->getCompany();

	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$cta_codigo = "IS NOT NULL";
	if($dados->{'cta_codigo'}!=""){
		$cta_codigo = "=".$dados->{'cta_codigo'};
	}

	$data_ini = date("Y-m-01");
	if(isset($dados->{'data_ini'})&&!empty($dados->{'data_ini'})){
		$data_ini = data($dados->{'data_ini'},true, '/');
	}

	$data_fim = date("Y-m-d");
	if(isset($dados->{'data_fim'})&&!empty($dados->{'data_fim'})){
		$data_fim = data($dados->{'data_fim'},true, '/');
	}

	$conciliado = "%%";
	if(isset($dados->{'conciliado'})&&!empty($dados->{'conciliado'})){
		if($dados->{'conciliado'} == "sim" ){
			$conciliado = 1;
		}else if ($dados->{'conciliado'} == "nao"){
			$conciliado = 0;
		}
	}
	$lan_dc = "1,2";
	if(isset($dados->{'doc_pagrec'})&&!empty($dados->{'doc_pagrec'}) && $dados->{'doc_pagrec'}!='99'){
		$lan_dc = $dados->{'doc_pagrec'};
	}
	
	$busca="";
	if( isset($dados->{"estorno"}) && $dados->{"estorno"}==0 ){
		$busca.= "";
	}else{
		$busca.= " and (a.lan_estorno is null and (select count(lan.lan_sequencia) from lancto lan where lan.lan_estorno = a.lan_sequencia and lan.doc_codigo=b.doc_codigo) = 0) ";
	}

	$filtro = '{"cod":"501180", "params":[
		{"name":"data_ini","value":"'.$data_ini.' 00:00:00","type":"string"},
		{"name":"data_fim","value":"'.$data_fim.' 23:59:59","type":"string"},
		{"name":"cta_codigo","value":"'.$cta_codigo.'","type":"other"},
		{"name":"lan_conc","value":"'.$conciliado.'","type":"string"},
		{"name":"lan_dc","value":"'.$lan_dc.'","type":"other"},
		{"name":"database","value":"'.$company[0]->{'emp_db_comum'}.'","type":"other"},
		{"name":"busca","value":"'.$busca.'","type":"other"}
	]}';

	$Datapacket->setHost($Datapacket->getHost($company[0]->{'emp_db_sge'}));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	// echo $Datapacket->getLastQuery();
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();
	
	$titulo = utf8_decode("RELATÓRIO DE LANÇAMENTOS EM CONTA");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $Datapacket->getCompany()->{"emp_codigo"} . "/" . $Datapacket->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");

    $cabecalhoHeight = 240;

	$contaExbicao = '';
	if ($cta_codigo == 'IS NOT NULL'){

        $contaExbicao = "SEM CONTA";

    } else {

        $contaExbicao = $dados->cta_descr;

    }

	$conciliadoExibicao = '';
	if ($conciliado === 1) {

        $conciliadoExibicao = "SIM";

    } elseif ($conciliado === 0) {

        $conciliadoExibicao = "NÃO";

    } else {

        $conciliadoExibicao = "AMBOS";
		
    }

    $tipo = '';
	if ($dados->{'doc_pagrec'} == 1) {

	    $tipo = "DÉBITO";

    } elseif ($dados->{'doc_pagrec'} == 2) {

	    $tipo = "CRÉDITO";

    } else {

	    $tipo = "CRÉDITO/ DÉBITO";

    }

    $periodo = "PERÍODO: DE " . data($data_ini) . " ATÉ " . data($data_fim);

	$filtros = array(
		base64_encode('<div style="float:left; padding-right:1%;"><span style="font-weight:bold;"> CONTA: '.$contaExbicao.' </span></div>'),
		base64_encode('<div style="float:left; padding-right:1%;"><span style="font-weight:bold;">' . utf8_decode($periodo) . ' </span></div>'),
		base64_encode('<div style="float:left; padding-right:1%;"><span style="font-weight:bold;"> TIPO: ' . utf8_decode($tipo). '</span></div>'),
		base64_encode('<div style="float:left; padding-right:1%;"><span style="font-weight:bold;"> CONCILIADO: ' . utf8_decode($conciliadoExibicao) . ' </span></div>'),
	);

	$objColuna = new stdClass();

	$colunas = '';

	if($cnt > 0){

		$totalGeral = 0;
		$totalDebito = 0;	
		$totalCredito = 0;
		$ant="";

		if(!empty($rowdata)){
			
			foreach ($rowdata as $i=>$pes){
				
				if($ant!=$pes->cta_codigo || $i==0){
					
					if($i!=0){
						?>
						<div class="informacaoListagem"> SALDO FINAL <?php echo $rowdata[$i-1]->cta_descr?>:    
							<?php echo ($sal!=0) ? number_format($sal, 2, ",", ".") : "0,00";?>
						</div><br>
						<?php
					}
					
					$filtroSaldo = '{"cod":"500151","params":[
						{"name":"cta_codigo","value":"'.$cta_codigo.'","type":"other"},
						{"name":"lan_conc","value":"'.$conciliado.'","type":"string"},
						{"name":"lan_dtmov","value":"'.$data_ini.'","type":"string"}
					]}';
					$Datapacket->setHost($Datapacket->getHost($company[0]->{'emp_db_sge'}));
					$Datapacket->add($filtroSaldo);
					$rowdataSaldo = $Datapacket->open(true);
					$Datapacket->clear();
					$saldoDisp = $rowdataSaldo[0]->saldo;
					$sal = $saldoDisp;
					?>
					<div class="informacaoListagem" style="margin-top:20px"><div style="width50%;float:left"><?php echo (isset($pes->cta_descr)) ? $pes->cta_descr : "LANÇAMENTOS SEM CONTA";?>:</div><div style="width46%;text-align:right; padding-right:4%">SALDO INICIAL R$: <?php echo ($saldoDisp!=0) ? number_format($saldoDisp,2,",",".") : "0,00";?></div></div>
					<div class="informacaoColuna">
						<div style="float:left; width:9%;">DOC. NÚMERO</div>
						<div style="float:left; width:6%;  text-align:left;">DATA</div>
						<div style="float:left; width:6%;  text-align:left;">DATA MOV</div>
						<div style="float:left; width:19%; text-align:left;">PAGADOR/ RECEBEDOR</div>
						<div style="float:left; width:25%; text-align:left;">DESCRIÇÃO</div>
						<div style="float:left; width:6%; text-align:left;">CONCILIADO</div>
						<div style="float:left; width:6%;  text-align:left ; padding-left:2%;">FORMA PGTO</div>
						<div style="float:left; width:8%; text-align:right;">VALOR</div>		
						<div style="float:left; width:8%; text-align:right;">SALDO</div>						
					</div>
					<?php
					$ant = $pes->cta_codigo;
				}

				if($i % 2 == 0){
					$backCor = "#EFEEED";
				}else{
					$backCor = "#fff";
				}
				
				$sal = ($pes->lan_dc==1) ? $sal - $pes->lan_valor : $sal + $pes->lan_valor;

				?>

				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>; border:0.5px solid #000; font-size:12px; margin-top:2px">
					<div style="width:7.5%; float:left; text-align:right;"> <?php echo $pes->{'doc_numero'};?>&nbsp; </div>
					<div style="width:7%;  float:left; text-align:center;"> <?php echo data($pes->{'lan_data'});?>&nbsp; </div>
					<div style="width:7%;  float:left; text-align:center;"> <?php echo data($pes->{'lan_dtmov'});?>&nbsp; </div>
					<div style="width:19%; float:left; text-align:left;"> <?php echo substr($pes->{'cad_nomeraz'},0,35)."&nbsp;";?>&nbsp; </div>
					<div style="width:25%; float:left; text-align:left;"> <?php echo substr($pes->{'lan_historico'},0,72);?>&nbsp; </div>
					<div style="width:6%; float:left; text-align: center"> <?php echo ($pes->{'lan_conc'} && $pes->{'lan_conc'}==1) ? "Sim" : "Não";?>&nbsp; </div>
					<div style="width:6%;  float:left; text-align:left; padding-left: 2%">
						<?php
							switch($pes->{'lan_forpag'}){
								case 1:
									echo "Dinheiro";
									break;
								case 2:
									echo "Cartão Créd.";
									break;
								case 3:
									echo "Cartão Déb.";
									break;
								case 4:
									echo "Cheque";
									break;
								case 5:
									echo "Dep. Bancário";
									break;
								case 6:
									echo "Transf. Bancária";
									break;
								case 7:
									echo "Permuta";
									break;
								case 8:
									echo "Boleto";
									break;
								case 9:
									echo "Déb. em Conta";
									break;
								case 10:
									echo "Pix";
								case 99:
									echo "Outro";
									break;
								default:
									echo "Dinheiro";
									break;
							}
						?>
					</div>
					<div style="width:8%; float:left; text-align:right;"> <?php echo ($pes->lan_dc==1) ? "-" : ""; echo ($pes->{'lan_valor'}!=0) ? number_format($pes->lan_valor,2,",",".") : "0,00";?> </div>
					<div style="width:8%; float:left; text-align:right;"> <?php echo ($sal!=0) ? number_format($sal, 2, ",", ".") : "0,00";?> </div>
				</div>
				<?php
				
				if($pes->lan_dc==1){
					$totalDebito += $pes->{'lan_valor'};
				}else{
					$totalCredito += $pes->{'lan_valor'};
				}
				
			}
			?>
			<div class="informacaoListagem" style="width:96%;text-align:right; padding-right:4%"> SALDO FINAL <?php echo $rowdata[$i-1]->cta_descr?>:    
				<?php echo ($sal!=0) ? number_format($sal, 2, ",", ".") : "0,00";?>
			</div><br>
			<?php
			$total = $sal - $saldoDisp;
		}

		?>
		
		<div class="informacaoRodape_outro">Saldo Inicial:
			<?php echo ($saldoDisp!=0) ? number_format($saldoDisp,2,",",".") : "0,00";?>
		</div>

		<div class="informacaoRodape_outro">Total de Créditos:
			<?php echo ($totalCredito!=0) ? number_format($totalCredito,2,",",".") : "0,00";?>
		</div>


		<div class="informacaoRodape_outro">Total de Débitos:
			<?php echo ($totalDebito!=0) ? number_format(-$totalDebito,2,",",".") : "0,00";?>
		</div>
		
		<div class="informacaoRodape_outro">Diferença do período:
			<?php echo ($total!=0) ? number_format($total,2,",",".") : "0,00";?>
		</div>

		<?php		

	} else {

		?>
		<div style="width:100%; float:left; margin:50px 0px 0px 0px; padding: 0px 0px; text-align:center">
			Não foram encontrados registros para sua pesquisa
		</div>
		<?php
	}

	include "../rel/inc/relatorioRodape.php";

?>