<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include('../php/TParams.class.php');
	include('../php/funcoes.php');

	$datapacket = new TParams();
	$empresa = $datapacket->getCompany();

	if(!isset($_POST['dados']) || empty($_POST['dados'])){
		exit("erro de parametro");
	}

	$dados = json_decode(base64_decode($_POST['dados']));

	$totalHoras = 0;

	$coa_data = "2016-01-01 00:00:00";
	if(isset($dados->{'coa_data'})&&!empty($dados->{'coa_data'})){
		$coa_data = data($dados->{'coa_data'},true)." 00:00:00";
	}

	$coa_data2 = date("Y-m-d H:i:s");
	if(isset($dados->{'coa_data2'})&&!empty($dados->{'coa_data2'})){
		$coa_data2 = data($dados->{'coa_data2'},true)." 23:59:59";
	}

	$coa_responsavel = '%';
	if (isset($dados->{'coa_responsavel'})&&!empty($dados->{'coa_responsavel'})){
		$coa_responsavel = $dados->{'coa_responsavel'};
	}

	$coa_origem = '';
    if(isset($dados->{'coa_origem'})&&!empty($dados->{'coa_origem'})){
    	$coa_origem = $dados->{'coa_origem'};
    }
	
	$rat_codigo = '';
    if(isset($dados->{'rat_codigo'})&&!empty($dados->{'rat_codigo'})){
    	$rat_codigo = $dados->{'rat_codigo'};
    }
	
	$coa_prioridade = '1,2,3,4,5';
    if(isset($dados->{'coa_prioridade'})&&!empty($dados->{'coa_prioridade'})){
    	$coa_prioridade = $dados->{'coa_prioridade'};
    }
	
	$coa_status = '';
    if(isset($dados->{'coa_status'})&&!empty($dados->{'coa_status'})){
    	$coa_status = $dados->{'coa_status'};
    }

	$filtro = '{"cod":"700796", "params":[
		{"name":"db","value":"'.$datapacket->getDb().'","type":"other"},
		{"name":"coa_data","value":"'.$coa_data.'","type":"string"},
		{"name":"coa_data2","value":"'.$coa_data2.'","type":"string"},
		{"name":"coa_responsavel","value":"'.$coa_responsavel.'","type":"string"},
		{"name":"coa_origem","value":"'.$coa_origem.'","type":"other"},
		{"name":"rat_codigo","value":"'.$rat_codigo.'","type":"other"},
		{"name":"coa_prioridade","value":"'.$coa_prioridade.'","type":"string"},
		{"name":"coa_status","value":"'.$coa_status.'","type":"other"}
	]}';

	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	$cnt = $datapacket->getRecordCount();
	// echo $datapacket-> getLastQuery();
	$datapacket->clear();

	$titulo = utf8_decode("RELATÓRIO DE LEADS");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $empresa->emp_codigo . "/" . $empresa->emp_logo;

	include("./inc/relatorioCabecalho.php");

	$filtros = '';
	$colunas = '';
	$contador=0;
																
	if($cnt > 0){
		
		?>
			<div class="informacaoColuna">
				<div style="float:left; width:5%; text-align:left;">NÚMERO</div>
				<div style="float:left; width:7%; text-align:left;">DATA</div>
				<div style="float:left; width:7%; text-align:left;">RETORNO</div>
				<div style="float:left; width:13%; text-align:left;">CLIENTE</div>
				<div style="float:left; width:10%; text-align:left;">CONTATO</div>
				<!--<div style="float:left; width:8%; text-align:left;">RAMO</div>-->
				<div style="float:left; width:8%; text-align:left;">SITUAÇÃO</div>
				<div style="float:left; width:8%; text-align:left;">TELEFONE</div>
				<div style="float:left; width:15%; text-align:left;">E-MAIL</div>
				<div style="float:left; width:8%; text-align:left;">ORIGEM</div>
				<div style="float:left; width:18%; text-align:left;">DESCRIÇÃO</div>
			</div>
		<?php
		
		foreach($rowdata as $i=>$lead){

			if($i % 2 == 0){
				$backCor = "#F7F7F7";
			}else{
				$backCor = "#fff";
			}			
			?>

				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>;">
					<div style="float:left; width:5%; text-align:left;"><?php echo $lead->{'coa_codigo'}?></div>
					<div style="float:left; width:7%; text-align:left; "><?php echo implode("/",array_reverse(explode("-", substr($lead->{'coa_data'},0,10))))."&nbsp";?></div>
					<div style="float:left; width:7%; text-align:left;"><?php echo implode("/",array_reverse(explode("-", substr($lead->{'coa_dtretorno'},0,10))))."&nbsp";?></div>
					<div style="float:left; width:13%; text-align:left;"><?php echo substr($lead->{'cliente'},0,25)."&nbsp";?></div>
					<div style="float:left; width:10%; text-align:left;"><?php echo substr($lead->{'coa_contato'},0,20)."&nbsp";?></div>
					<!--<div style="float:left; width:8%; text-align:left;"><?php //echo substr($lead->{'ramo'},0,15)."&nbsp";?></div>-->
					<div style="float:left; width:8%; text-align:left;">
						<?php 
							if ($lead->{'coa_status'} == 1) {
								echo 'Análise';
							} elseif($lead->{'coa_status'} == 2) {
								echo 'Primeira proposta';
							}elseif($lead->{'coa_status'} == 3) {
								echo 'Nutrição';
							}elseif($lead->{'coa_status'} == 4) {
								echo 'Ganho';
							}elseif($lead->{'coa_status'} == 5) {
								echo 'Perdido';
							}elseif($lead->{'coa_status'} == 6) {
								echo 'Prospecção';
							}elseif($lead->{'coa_status'} == 7) {
								echo 'Negociação';
							}
						?>
					</div>
					<div style="float:left; width:8%; text-align:left;"><?php echo '('.$lead->{'coa_ddd'}.') '.$lead->{'coa_telefone'}."&nbsp;";?></div>
					<div style="float:left; width:15%; text-align:left;"><?php echo $lead->{'coa_email'}."&nbsp";?></div>
					<div style="float:left; width:8%; text-align:left;">
						<?php 
							if ($lead->{'coa_origem'} == 1) {
								echo 'Facebook';
							} elseif($lead->{'coa_origem'} == 2) {
								echo 'Instagram';
							}elseif($lead->{'coa_origem'} == 3) {
								echo 'Site (orgãnico)';
							}elseif($lead->{'coa_origem'} == 4) {
								echo 'Google Ads';
							}elseif($lead->{'coa_origem'} == 5) {
								echo 'Indicação';
							}elseif($lead->{'coa_origem'} == 6) {
								echo 'Mídia impressa';
							}elseif($lead->{'coa_origem'} == 7) {
								echo 'E-book';
							}elseif($lead->{'coa_origem'} == 8) {
								echo 'Planilha';
							}elseif($lead->{'coa_origem'} == 9) {
								echo 'Infográfico';
							}elseif($lead->{'coa_origem'} == 10) {
								echo 'Newsletter';
							}elseif($lead->{'coa_origem'} == 99) {
								echo 'Outros';
							}
						?>
					</div>
					<div style="float:left; width:18%; text-align:justify;">
						<?php
							echo utf8_decode(base64_decode($lead->{'coa_descr'}));
						?>
					</div>
				</div>

			<?php

			$contador ++;
		}

		?>
			<div class="informacaoRodape_outro" style="margin-top: 50px;">Total de Leads:
				<?php echo $contador."&nbsp";?> 
			</div>
		<?php
	}else{

		?>
		<div style="float:left; width:100%; margin:50px 0px 10px 0px; padding:3px 0px; text-align:center;font-weight:bold">Nenhum Resultado para sua pesquisa</div>

		<?php
	}
	include "inc/relatorioRodape.php";

?>