<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	$dados  = json_decode(base64_decode($_REQUEST['dados']));
	
	$mar_codigo = "";
	if(isset($dados->marca) && !empty($dados->marca) && $dados->marca != "Novo Registro"){
		$aux = $dados->marca;
		$str = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$str .= "'".$aux[$i]."' ";
			}else{
				$str .= ",'".$aux[$i]."'";
			}
		}
		$mar_codigo = " and a.mar_codigo in (".$str.")";
	}

	$grp_codigo = "";
	if(isset($dados->grupo) && !empty($dados->grupo) && $dados->grupo != "Novo Registro"){
		$aux = $dados->grupo;
		$str = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$str .= "'".$aux[$i]."' ";
			}else{
				$str .= ",'".$aux[$i]."'";
			}
		}
		$grp_codigo = " and a.grp_codigo in (".$str.")";
	}
	
	if($dados->ordenar == 1){
		$ordenar = "order by a.ref_status asc, a.ref_descr asc";
		$ordenado = "PRODUTO";
	}else if($dados->ordenar == 2){
		$ordenar = "order by c.mar_descr asc, a.ref_status asc, a.ref_descr asc";
		$ordenado = "MARCA / PRODUTO";
	}else if($dados->ordenar == 3){
		$ordenar = "order by b.grp_descr asc, a.ref_status asc, a.ref_descr asc";
		$ordenado = "GRUPO / PRODUTO";
	}else{
		$ordenar = "";
		$ordenado = "";
	}
	
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->emp_codigo.'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();
	
	$filtro='{"cod":"700930","params":[
		{"name":"emp_codigo","value":"'.$dados->emp_codigo.'","type":"string"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"other"},
		{"name":"ordenar","value":"'.$ordenar.'","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	//echo $Datapacket->getLastQuery();
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();

	$titulo = utf8_decode("RELATÓRIO DE LISTA DE PREÇOS");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");

	$marcaExibicao = "TODAS";
	if (isset($dados->marca[0])) {
        $marcaExibicao = "ESPECÍFICA";
    }

    $grupoExbicao = "TODOS";
	if (isset($dados->grupo[0])) {
	    $grupoExbicao = "ESPECÍFICO";
    }


	$filtro1 = base64_encode('<div style="float:left; width:500px; text-align:left"><span style="font-weight:bold;"> ORDENADO: </span>' . $ordenado .'</div>');
	$filtro2 = base64_encode('<div style="float:left; width:500px; text-align:left"><span style="font-weight:bold;"> MARCA: </span>' . utf8_decode($marcaExibicao) .'</div>');
	$filtro3 = base64_encode('<div style="float:left; width:500px; text-align:left"><span style="font-weight:bold;"> GRUPO: </span>' . utf8_decode($grupoExbicao) .'</div>');
	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = $filtro1,
		$objFiltro->filtro = $filtro2,
		$objFiltro->filtro = $filtro3,
	);
	
	$colunas = '';

    $cabecalhoHeight = "280";

    $colunas = array();
    array_push($colunas, base64_encode('<div style="float:left; width:7%; text-align:left;">CODIGO</div>'));
    array_push($colunas, base64_encode('<div style="float:left; width:6%;  text-align:left; padding-right: 4%">GRUPO</div>'));
    array_push($colunas, base64_encode('<div style="float:left; width:12%; text-align:left;">MARCA</div>'));
    array_push($colunas, base64_encode('<div style="float:left; width:26%; text-align:left;">PRODUTO</div>'));
    array_push($colunas, base64_encode('<div style="float:left; width:13%; text-align:left;">COD. BARRAS</div>'));
    array_push($colunas, base64_encode('<div style="float:left; width:8%; text-align:left;">NCM</div>'));
    array_push($colunas, base64_encode('<div style="float:left; width:7%; text-align:left;">ESTOQUE</div>'));
    array_push($colunas, base64_encode('<div style="float:left; width:9%; text-align:left;">ATACADO</div>'));
    array_push($colunas, base64_encode('<div style="float:left; width:5%; text-align:left;">VAREJO</div>'));
    // array_push($colunas, base64_encode('<div style="float:left; width:3%; text-align:left;">MINIMO</div>'));
	
	if($cnt > 0 ){
		$cntAtiv=0;
		$cntInativ=0;
        
		for($i=0;$i<$cnt;$i++){
            
			if($i % 2 == 0){
                $backCor = "#EFEEED";
            }else{
                $backCor = "#FFF";
            }
        	
			?>	
				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>">
					<div style="float:left; width: 7%; text-align: left;"> <?php echo $rowdata[$i]->{'ref_codigo'}."&nbsp";?>						</div>
					<div style="float:left; width: 10%; text-align: left;"> <?php echo $rowdata[$i]->{'grp_descr'}."&nbsp";?>						</div>
					<div style="float:left; width: 12%; text-align: left;"> <?php echo $rowdata[$i]->{'mar_descr'}."&nbsp";?>						</div>
					<div style="float:left; width: 20%; text-align: left;"> 
						<?php 
							if(isset($rowdata[$i]->{'ref_status'})&&$rowdata[$i]->{'ref_status'}==0){
								echo $rowdata[$i]->{'ref_descr'}."&nbsp";
								$cntAtiv++;
							}else{
								echo "# ".$rowdata[$i]->{'ref_descr'}."&nbsp";
								$cntInativ++;
							}
						?>
					</div>
					<div style="float:left; width: 12%; text-align:right;"> <?php echo $rowdata[$i]->{'ref_codbar'}."&nbsp";?>		</div> 					
					<div style="float:left; width: 10%; text-align:right;"> <?php echo $rowdata[$i]->{'ref_ncm'}."&nbsp";?>					</div>		 			
					<div style="float:left; width: 8%;  text-align:right;"> <?php echo qtde($rowdata[$i]->{'stk_qde'})."&nbsp";?>	</div>
					<div style="float:left; width: 8%;  text-align:right;"> <?php echo valorFormat($rowdata[$i]->{'urf_precoata'})."&nbsp";?>		</div>
					<div style="float:left; width: 8%;  text-align:right;"> <?php echo valorFormat($rowdata[$i]->{'ref_preco'})."&nbsp";?>		</div>
					<!--<div style="float:left; width: 5%;  text-align:right;"> <?php //echo valorFormat($rowdata[$i]->{'ref_precomin'})."&nbsp";?>		</div>-->
				</div>
			<?php
		}

		?>	
			<div class="informacaoRodape">
				<div style="float:left; width: 30%; font-weight: bold"> Total Geral Produtos (<?php echo $cnt;?>)</div>
				<div style="float:left; width: 33%; font-weight: bold"> Total Ativos (<?php echo $cntAtiv;?>)</div>
				<div style="float:left; width: 33%; font-weight: bold"> Total Inativos (<?php echo $cntInativ;?>)</div>
			</div>
		<?php
	}else{
		?>	
			<div style="width:100%; font-size:12px; float:left; text-align: center; font-weight: bold; margin-top:50px">
				NENHUM RESULTADO PARA SUA PESQUISA
			</div>
		<?php
	}
	
	include "../rel/inc/relatorioRodape.php";
	
?>