<?php

	set_time_limit(0);

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';

	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();

	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$not_tipo = "";
	$tipo = "";
	if(isset($dados->{'not_tipo'})&&!empty($dados->{'not_tipo'})&&gettype($dados->{'not_tipo'}) == "array"){
		foreach ($dados->{'not_tipo'} as $key => $value) {
			if($key == 0){
				$not_tipo = $value;
			}else{
				$not_tipo .= ",".$value;
			}
			if($value == 2){
				if(empty($tipo)){
					$tipo = "Pedido";
				}else{
					$tipo .= ", Pedido";
				}
			}else if($value == 9) {
				if(empty($tipo)){
					$tipo = "NF-e";
				}else{
					$tipo .= ", NF-e";
				}
			}else if($value == 11) {
				if(empty($tipo)){
					$tipo = "E-commerce";
				}else{
					$tipo .= ", E-commerce";
				}
			}else if($value == 12) {
				if(empty($tipo)){
					$tipo = "NFC-e";
				}else{
					$tipo .= ", NFC-e";
				}
			}else if($value == 13) {
				if(empty($tipo)){
					$tipo = "Pedido PDV";
				}else{
					$tipo .= ", Pedido PDV";
				}
			}
		}
		$not_tipo = " and b.not_tipo in (".$not_tipo.")";
	}else if(isset($dados->{'not_tipo'})&&!empty($dados->{'not_tipo'})&&(gettype($dados->{'not_tipo'}) == "string"||gettype($dados->{'not_tipo'}) == "integer")){
		if($dados->{'not_tipo'}==9){
			$not_tipo = " and b.not_tipo = 9";
			$tipo = 'NF-e';
		}else if($dados->{'not_tipo'}==11){
			$not_tipo = " and b.not_tipo = 11";
			$tipo = 'E-commerce';
		}else if($dados->{'not_tipo'}==12){
			$not_tipo = " and b.not_tipo = 12";
			$tipo = 'NFC-e';
		}else if($dados->{'not_tipo'}==13){
			$not_tipo = " and b.not_tipo = 13";
			$tipo = 'Pedido não fiscal';
		}else if($dados->{'not_tipo'}==2){
			$not_tipo = " and b.not_tipo = 2";
			$tipo = 'Pedido';
		}
	}else{
		$tipo = "TODOS";
		$not_tipo = " and b.not_tipo in (2, 9, 11, 12, 13)";
	}
	
	//série
	if(isset($dados->{'ser_codigo'}) && $dados->{'ser_codigo'}!=""){
		$not_tipo .= " and b.ser_codigo = '".$dados->{'ser_codigo'}."' ";
	}

	$not_status = " and b.not_status in (0,1,2,3) ";
	$status = "TODOS";
	//status
	if(isset($dados->{'not_tipo'})&&!empty($dados->{'not_tipo'})&&$dados->{'not_tipo'}==11){
		if(isset($dados->{'ecm_status'})&&$dados->{'ecm_status'}!=""&&$dados->{'ecm_status'}!=0){
			$not_status = "and h.ecm_status =".$dados->{'ecm_status'};
			switch($dados->{'ecm_status'}){
				case 1:
					$status = "AGUARDANDO";
					break;
				case 2:
					$status = "PROCESSANDO";
					break;
				case 3:
					$status = "PAGO";
					break;
				case 4:
					$status = "EXPEDIÇÃO";
					break;
				case 5:
					$status = "ENVIADO";
					break;
				case 6:
					$status = "CANCELADO";
					break;
				case 7:
					$status = "ANÁLISE PARA GARANTIA";
					break;
				case 8:
					$status = "REENVIADO";
					break;
				case 9:
					$status = "CONCLUÍDO";
					break;
			}
		}
	}else{
		if(isset($dados->{'not_status'})&&(!empty($dados->{'not_status'})||$dados->{'not_status'} == 0)){
			if($dados->{'not_status'}==1){
				$not_status = "and b.not_status = 2";
				$status = "FATURADOS";
			}else if($dados->{'not_status'}==2){
				$not_status = "and b.not_status = 3";
				$status = "CANCELADOS";
			}else if($dados->{'not_status'}==3){
				$not_status = "and b.not_status in (0,1)";
				$status = "ABERTOS (PENDENTES)";
			}else if($dados->{'not_status'}==4){
				$not_status = "and b.not_status in (0,1)";
				$status = "ABERTOS";
			}else if($dados->{'not_status'}==5){
				$not_status = "and b.not_status = 2";
				$status = "FATURADOS";
			}else if($dados->{'not_status'}==6){
				$not_status = "and b.not_status in (0,1)";	
				$status = "PENDENTES";
			}else if($dados->{'not_status'}==7){
				$not_status = "and b.not_status = 2";
				$status = "AUTORIZADOS";
			} 
		}
	}
	
	//Condição de pagamento
	if( isset($dados->{'cdp_codigo'}) && !empty($dados->{'cdp_codigo'}) && $dados->{'cdp_codigo'} != 0 ){
		$not_status .= "and b.cdp_codigo = ".$dados->{'cdp_codigo'};
	}
	
	//Tipo de Documento
	if( isset($dados->{'doc_tipo'}) && !empty($dados->{'doc_tipo'}) && $dados->{'doc_tipo'} != 0 ){
		$not_status .= "and doc.doc_tipo = ".$dados->{'doc_tipo'};
	}

	$ref_codigo = "";
	if(isset($dados->{'produtos'}) && count($dados->{'produtos'})>0){
		$aux = $dados->{'produtos'};
		$aux2 = '';
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 = $aux[$i];
			}else{
				$aux2 .= ", ".$aux[$i];
			}
		}
		$ref_codigo = "and a.ref_codigo in (".$aux2.")";
	}
	
	if(isset($dados->{'servicos'}) && count($dados->{'servicos'})>0){
		$aux = $dados->{'servicos'};
		$aux2 = '';
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 = $aux[$i];
			}else{
				$aux2 .= ", ".$aux[$i];
			}
		}
		$ref_codigo .= " and i.svc_codigo in (".$aux2.")";
	}
	
	//data de prestação do serviço
	if(isset($dados->{'its_dataini'}) && !empty($dados->{'its_dataini'})){
		$ref_codigo .= " and i.its_data >= '".dataBdcomhoras_ini(dataBdcombarra($dados->{'its_dataini'}))." 00:00:00'";
		if(isset($dados->{'its_datafim'})&&!empty($dados->{'its_datafim'})){
			$ref_codigo .= " and i.its_data <= '".dataBdcomhoras_fim(dataBdcombarra($dados->{'its_datafim'}))." 23:59:59'";
		}
	}else if(isset($dados->{'its_datafim'}) && !empty($dados->{'its_datafim'})){
		$ref_codigo .= " and i.its_data between '".Date('Y-m-d 00:00:00', strtotime("-30 days " . $dados->{'its_datafim'})) . "' and '" . dataBdcomhoras_fim(dataBdcombarra($dados->{'its_datafim'}))." 23:59:59'";
	}

	$cad_codigo = "";
	$cliente = "TODOS";
	if(isset($dados->{'clientes'})&&!empty($dados->{'clientes'})){
		$aux = $dados->{'clientes'};
		$aux2 = '';
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 = "'".$aux[$i]."'";
			}else{
				$aux2 .= ", '".$aux[$i]."'";
			}
		}
		if($aux2 && $aux2!="" && $aux2!="''"){
			$cad_codigo = "and b.cad_codigo in (".$aux2.")";
			$cliente = utf8_decode("ESPEC&Iacute;FICO");
		}
	}

	$cad_uf = "";
	if(isset($dados->{'uf'})&&!empty($dados->{'uf'})){
		$cad_uf = " and c.cad_uf = '" . $dados->{'uf'} . "'";
	}

	$cad_codmun = "";
	if(isset($dados->{'municipios'})&&!empty($dados->{'municipios'})){
		$aux = $dados->{'municipios'};
		$aux2 = '';
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 = $aux[$i];
			}else{
				$aux2 .= ", ".$aux[$i];
			}
		}
		$cad_codmun = "and c.cad_codmun in (".$aux2.")";
	}

	$cad_codvend = "";
	$vendedor = "TODOS";
	if(isset($dados->{'vendedores'})&&!empty($dados->{'vendedores'})){
		$aux = $dados->{'vendedores'};
		$aux2 = '';
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 = "'".$aux[$i]."'";
			}else{
				$aux2 .= ", '".$aux[$i]."'";
			}
		}
		$cad_codvend = "and b.cad_codvend in (".$aux2.")";
		$vendedor = utf8_decode("ESPEC&Iacute;FICO");
	}

	$pdv_codigo = "";
	$terminal = "TODOS";
	if(isset($dados->{'terminal'})&&!empty($dados->{'terminal'})){
		$aux = $dados->{'terminal'};
		$aux2 = '';
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 = "'".$aux[$i]."'";
			}else{
				$aux2 .= ", '".$aux[$i]."'";
			}
		}
		$pdv_codigo = "and f.pdv_codigo in (".$aux2.")";
		$terminal = utf8_decode("ESPEC&Iacute;FICO");
	}
	
	//cfop
	$cfo_codigo = "";
	$cfop = "TODOS";
	if(isset($dados->{'cfop'})&&!empty($dados->{'cfop'})){
		$aux = explode(", ", $dados->{'cfop'});
		$aux2 = '';
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 = "'".$aux[$i]."'";
			}else{
				$aux2 .= ", '".$aux[$i]."'";
			}
		}
		if($aux2 && $aux2!="" && $aux2!="''"){
			$cfo_codigo = "and b.cfo_codigo in (".$aux2.")";
			$cfop = $dados->{'cfop'};
		}
	}

	$not_totalnota = "";
	if(isset($dados->{'not_valor_ini'})&&!empty($dados->{'not_valor_ini'})&&$dados->{'not_valor_ini'}>0){
		$not_totalnota = " and b.not_totalnota >= ".$dados->{'not_valor_ini'};
		if(isset($dados->{'not_valor_fim'})&&!empty($dados->{'not_valor_fim'})&&$dados->{'not_valor_fim'}>0){
			$not_totalnota .= " and b.not_totalnota <= ".$dados->{'not_valor_fim'};
		}
	}else{
		if(isset($dados->{'not_valor_fim'})&&!empty($dados->{'not_valor_fim'})&&$dados->{'not_valor_fim'}>0){
			$not_totalnota .= " and b.not_totalnota <= ".$dados->{'not_valor_fim'};
		}
	}

	$not_data = "";
	if(isset($dados->{'not_data_ini'}) && !empty($dados->{'not_data_ini'})){
		$not_data = " and b.not_data >= '".dataBdcomhoras_ini(dataBdcombarra($dados->{'not_data_ini'}))." 00:00:00'";

		if(isset($dados->{'not_data_fim'})&&!empty($dados->{'not_data_fim'})){
			$not_data .= " and b.not_data <= '".dataBdcomhoras_fim(dataBdcombarra($dados->{'not_data_fim'}))." 23:59:59'";
			$datas = utf8_decode("DE ".$dados->{'not_data_ini'}." ATÉ ".$dados->{'not_data_fim'});
		} else {
			$periodo .= " and b.not_data <= '". Date('Y-m-d 23:59:59', strtotime("+30 days"));
			$datas = utf8_decode("A PARTIR DE ".$dados->{'not_data_ini'});
		}
		
	}else if(isset($dados->{'not_data_fim'}) && !empty($dados->{'not_data_fim'})){
		$not_data .= " and b.not_data between '".Date('Y-m-d 00:00:00', strtotime("-30 days " . $dados->{'not_data_fim'})) . "' and '" . dataBdcomhoras_fim(dataBdcombarra($dados->{'not_data_fim'}))." 23:59:59'";
		$datas = utf8_decode("DE ".Date('d/m/Y', strtotime("-30 days " . $dados->{'not_data_fim'}))." ATÉ ".$dados->{'not_data_fim'});

	} else {
		$not_data = " and b.not_data between '" . Date('Y-m-d 00:00:00', strtotime("-30 days")) . "' and '" . Date('Y-m-d 23:59:59') . "'";
		$datas = utf8_decode("DE ".Date('d/m/Y', strtotime("-30 days"))." ATÉ ".Date('d/m/Y'));
		// $not_data = " and b.not_data between '" . Date('Y-01-01 00:00:00') . "' and '" . Date('Y-m-d 23:59:59') . "'";
	}

	$ordem = "asc";
	if(isset($dados->{'ordem'})&&!empty($dados->{'ordem'})){
		$ordem = $dados->{'ordem'};
	}

	$ordenacao = ", b.not_numero".$ordem;
	$ordenado = "TODOS";
	if(isset($dados->{'ordenacao'})&&!empty($dados->{'ordenacao'})||$dados->{'ordenacao'}==0){
		if($dados->{'ordenacao'}== 0){
			$ordenacao = ", b.not_numero ".$ordem;
			$ordenado = "NÚMERO DO DOCUMENTO";
			if($ordem == 'asc'){
				$ordenado = $ordenado." ASCENDENTE";
			}else{
				$ordenado = $ordenado." DESCENDENTE";
			}
		}else if($dados->{'ordenacao'}== 1){
			$ordenacao = ", a.itn_descr ".$ordem;
			$ordenado = "PRODUTO";
			if($ordem == 'asc'){
				$ordenado = $ordenado." ASCENDENTE";
			}else{
				$ordenado = $ordenado." DESCENDENTE";
			}
		}else if($dados->{'ordenacao'}== 2){
			$ordenacao = ", c.cad_nomeraz ".$ordem;
			$ordenado = "NOME DO CLIENTE";
			if($ordem == 'asc'){
				$ordenado = $ordenado." ASCENDENTE";
			}else{
				$ordenado = $ordenado." DESCENDENTE";
			}
		}else{
			$ordenacao = ", b.not_numero ".$ordem;
			$ordenado = "NÚMERO DO DOCUMENTO";
			if($ordem == 'asc'){
				$ordenado = $ordenado." ASCENDENTE";
			}else{
				$ordenado = $ordenado." DESCENDENTE";
			}
		}
	}

	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->{'emp_codigo'}.'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();

		//se ja existe nota para o pedido e o tipo da nota nao for mais (2 = pedido) traz a nota caso contrario traz o pedido 
		 if(strstr($tipo, "NF-e") || strstr($tipo, "NFC-e") || strstr($tipo, "Pedido PDV")){
			$extra = ' and b.not_codigo not in(select header_nota.not_codigo_pai from header_nota where LENGTH(header_nota.not_codigo_pai) > 0 and header_nota.not_tipo not in (2,7) )';
		 }

		$filtro = '{"cod":"700540", "params":[
		{"name":"database","value":"'.$company[0]->{'emp_db_comum'}.'","type":"other"}, 
		{"name":"not_tipo","value":"'.$not_tipo.'","type":"other"}, 
		{"name":"not_status","value":"'.$not_status.'","type":"other"}, 
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"}, 
		{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"other"}, 
		{"name":"cfo_codigo","value":"'.$cfo_codigo.'","type":"other"}, 
		{"name":"cad_uf","value":"'.$cad_uf.'","type":"other"}, 
		{"name":"cad_codmun","value":"'.$cad_codmun.'","type":"other"},   			
		{"name":"cad_codvend","value":"'.$cad_codvend.'","type":"other"}, 
		{"name":"not_totalnota","value":"'.$not_totalnota.'","type":"other"}, 
		{"name":"not_data","value":"'.$not_data.'","type":"other"},
		{"name":"pdv_codigo","value":"'.$pdv_codigo.'","type":"other"},
		{"name":"ordenacao","value":"'.$ordenacao.'","type":"other"},
		{"name":"extra","value":"'.$extra.'","type":"other"}

	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
		// echo $Datapacket->getLastQuery();
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();

	/*
	$filtroCanceladas = '{"cod":"501350","params":[
		{"name":"not_status","value":"3","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtroCanceladas);
	$rowdataCanceladas = $Datapacket->open(true);
		// echo $Datapacket->getLastQuery();
	$Datapacket->clear();
	

	$filtroRma = '{"cod":"501351","params":[
		{"name":"cfo_codigo","value":"5915,6915","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtroRma);
	$rowdataRma = $Datapacket->open(true);
		// echo $Datapacket->getLastQuery();
	$Datapacket->clear();
	*/



	if(empty($not_dtemissaofim)){
		$not_dtemissaofim = date('Y-m-d H:i:s');
	}

	$titulo = utf8_decode("RELATÓRIO ANALÍTICO DE VENDAS");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");

	$filtro1 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> TIPO: </span> <span style="font-weight:normal;">' .utf8_decode($tipo).'</span></div>');
	$filtro2 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> '.utf8_decode('PERÍODO').': </span> <span style="font-weight:normal;">' .$datas.'</span></div>');
	$filtro3 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> CFOP: </span> <span style="font-weight:normal;">' .utf8_decode($cfop).'</span></div>');
	$filtro4 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> STATUS: </span> <span style="font-weight:normal;">' .utf8_decode($status).'</span></div>');
	$filtro5 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> CLIENTE: </span> <span style="font-weight:normal;">' .utf8_decode($cliente).'</span></div>');
	$filtro6 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> VENDEDOR: </span> <span style="font-weight:normal;">' .utf8_decode($vendedor).'</span></div>');
	$filtro7 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> '.utf8_decode("ORDENAÇÃO").': </span> <span style="font-weight:normal;">' .utf8_decode($ordenado).'</span></div>');
	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = $filtro1,
		$objFiltro->filtro = $filtro2,
		$objFiltro->filtro = $filtro3,
		$objFiltro->filtro = $filtro4,
		$objFiltro->filtro = $filtro5,
		$objFiltro->filtro = $filtro6,
		$objFiltro->filtro = $filtro7
	);

	$cabecalhoHeight = "300"; // passar apenas numeros sem px, %..;

	$colunas = array();
		
		array_push($colunas, base64_encode('<div style="float:left; width:7%;  text-align:left; padding-left:0.5%;"> TIPO </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:5%;">'.utf8_decode("NÚMERO").' </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:6%; text-align:center"> DATA </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:8%; text-align:center"> HORA </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:20%; text-align:left;"> CLIENTE </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:15%; text-align:left;"> VENDEDOR </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:9%; text-align:right; padding-right:3%;"> VALOR TOTAL R$ </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:8%; text-align:left;"> STATUS </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:10%; text-align:left;">'.utf8_decode("OBSERVAÇÃO/ AUX").' </div>'));
			
	if($cnt > 0){

		$arrayNotas = array();
		$arrayNfe = array();
		$arrayNfeClientes = array();
		$arrayNfeProdutos = array();
		$arrayNfce = array();
		$arrayNfceClientes = array();
		$arrayNfceProdutos = array();
		$arrayPedidos = array();
		$arrayPedidosClientes = array();
		$arrayPedidosProdutos = array();
		$arrayPedidosNfiscal = array();
		$arrayPedidosNfiscalClientes = array();
		$arrayPedidosNfiscalProdutos = array();
		$arrayEcm = array();
		$arrayEcmClientes = array();
		$arrayEcmProdutos = array();
		$arrayClientes = array();
		$arrayProdutos = array();
		$nota = "";

		$totalGeralClientes = 0;
		$totalGeralProdutos = 0;
		$totalGeralItens=0;
		$totalGeralValor=0;
		$totalProdGeral = 0;
		$totalServGeral = 0;
		$totalDescGeral = 0;
		$totalAcresGeral = 0;

		$totalGeralNfeClientes = 0;
		$totalGeralNfeProdutos = 0;
		$totalGeralNfeItens=0;
		$totalGeralNfeValor=0;
		$totalProdNfe=0;
		$totalServNfe=0;
		$totalDescNfe=0;
		$totalAcresNfe=0;

		$totalGeralNfceClientes = 0;
		$totalGeralNfceProdutos = 0;
		$totalGeralNfceItens = 0;
		$totalGeralNfceValor = 0;
		$totalProdNfce = 0;
		$totalServNfce = 0;
		$totalDescNfce = 0;
		$totalAcresNfce = 0;

		$totalGeralPedidosClientes = 0;
		$totalGeralPedidosProdutos = 0;
		$totalGeralPedidosItens = 0;
		$totalGeralPedidosValor = 0;
		$totalProdPed = 0;
		$totalServPed = 0;
		$totalDescPed = 0;
		$totalAcresPed = 0;

		$totalGeralPedidosNfiscalClientes = 0;
		$totalGeralPedidosNfiscalProdutos = 0;
		$totalGeralPedidosNfiscalItens = 0;
		$totalGeralPedidosNfiscalValor = 0;
		$totalProdPdv = 0;
		$totalServPdv = 0;
		$totalDescPdv = 0;
		$totalAcresPdv = 0;
		
		$totalGeralEcmClientes = 0;
		$totalGeralEcmProdutos = 0;
		$totalGeralEcmItens = 0;
		$totalGeralEcmValor = 0;
		$totalProdEcm = 0;
		$totalServEcm = 0;
		$totalDescEcm = 0;
		$totalAcresEcm = 0;
		
		

		for($i=0;$i<$cnt;$i++){
			if(objectInArray($arrayNotas, 'not_codigo', $rowdata[$i]->{'not_codigo'}) == false){
				$objeto = new stdClass();
				$objeto->{'not_codigo'} = $rowdata[$i]->{'not_codigo'};
				$objeto->{'not_tipo'} = $rowdata[$i]->{'not_tipo'};
				$objeto->{'not_numero'} = $rowdata[$i]->{'not_numero'};
				$objeto->{'not_data'} = $rowdata[$i]->{'not_data'};
				$objeto->{'cad_nomeraz'} = $rowdata[$i]->{'cad_nomeraz'};
				$objeto->{'cad_nomevend'} = $rowdata[$i]->{'cad_nomevend'};
				$objeto->{'not_totalnota'} = $rowdata[$i]->{'not_totalnota'};
				$objeto->{'not_totalprod'} = $rowdata[$i]->{'not_totalprod'};
				$objeto->{'not_totalserv'} = $rowdata[$i]->{'not_totalserv'};
				$objeto->{'not_valordesc'} = $rowdata[$i]->{'not_valordesc'};
				$objeto->{'not_status'} = $rowdata[$i]->{'not_status'};
				$objeto->{'ecm_status'} = $rowdata[$i]->{'ecm_status'};
				$objeto->{'not_dtfaturam'} = $rowdata[$i]->{'not_dtfaturam'};
				$objeto->{'not_obs1'} = $rowdata[$i]->{'not_obs1'};
				$objeto->{'pdv_descr'} = $rowdata[$i]->{'pdv_descr'};
				$objeto->{'not_auxiliar'} = $rowdata[$i]->{'not_auxiliar'};
				array_push($arrayNotas, $objeto);
			}
				
			if($rowdata[$i]->{'not_tipo'}==2){
				array_push($arrayPedidos, $rowdata[$i]->{'not_codigo'});
				array_push($arrayPedidosClientes, $rowdata[$i]->{'cad_codigo'});
				array_push($arrayPedidosProdutos, $rowdata[$i]->{'ref_codigo'});
			}else if($rowdata[$i]->{'not_tipo'}==9){
				array_push($arrayNfe, $rowdata[$i]->{'not_codigo'});
				array_push($arrayNfeClientes, $rowdata[$i]->{'cad_codigo'});
				array_push($arrayNfeProdutos, $rowdata[$i]->{'ref_codigo'});
			}else if($rowdata[$i]->{'not_tipo'}==11){
				array_push($arrayEcm, $rowdata[$i]->{'not_codigo'});
				array_push($arrayEcmClientes, $rowdata[$i]->{'cad_codigo'});
				array_push($arrayEcmProdutos, $rowdata[$i]->{'ref_codigo'});
			}else if($rowdata[$i]->{'not_tipo'}==12){
				array_push($arrayNfce, $rowdata[$i]->{'not_codigo'});
				array_push($arrayNfceClientes, $rowdata[$i]->{'cad_codigo'});
				array_push($arrayNfceProdutos, $rowdata[$i]->{'ref_codigo'});
			}else if($rowdata[$i]->{'not_tipo'}==13){
				array_push($arrayPedidosNfiscal, $rowdata[$i]->{'not_codigo'});
				array_push($arrayPedidosNfiscalClientes, $rowdata[$i]->{'cad_codigo'});
				array_push($arrayPedidosNfiscalProdutos, $rowdata[$i]->{'ref_codigo'});
			} 
			array_push($arrayClientes, $rowdata[$i]->{'cad_codigo'});
			array_push($arrayProdutos, $rowdata[$i]->{'ref_codigo'});
		}

		$totalGeralNotas = count($arrayNotas);
		$totalGeralClientes = count(array_unique($arrayClientes));
		$totalGeralProdutos = count(array_unique($arrayProdutos));
		$totalGeralNfe = count(array_unique($arrayNfe));
		$totalGeralNfeClientes = count(array_unique($arrayNfeClientes));
		$totalGeralNfeProdutos = count(array_unique($arrayNfeProdutos));
		$totalGeralNfce = count(array_unique($arrayNfce));
		$totalGeralNfceClientes = count(array_unique($arrayNfceClientes));
		$totalGeralNfceProdutos = count(array_unique($arrayNfceProdutos));
		$totalGeralPedidos = count(array_unique($arrayPedidos));
		$totalGeralPedidosClientes = count(array_unique($arrayPedidosClientes));
		$totalGeralPedidosProdutos = count(array_unique($arrayPedidosProdutos));
		$totalGeralPedidosNfiscal = count(array_unique($arrayPedidosNfiscal));
		$totalGeralPedidosNfiscalClientes = count(array_unique($arrayPedidosNfiscalClientes));
		$totalGeralPedidosNfiscalProdutos = count(array_unique($arrayPedidosNfiscalProdutos));
		$totalGeralEcm = count(array_unique($arrayEcm));
		$totalGeralEcmClientes = count(array_unique($arrayEcmClientes));
		$totalGeralEcmProdutos = count(array_unique($arrayEcmProdutos));
		$totalNotaCancelada=0;
		$totalNotaRma=0;

		unset($arrayNfe);
		unset($arrayNfeClientes);
		unset($arrayNfeProdutos);
		unset($arrayNfce);
		unset($arrayNfceClientes);
		unset($arrayNfceProdutos);
		unset($arrayPedidos);
		unset($arrayPedidosClientes);
		unset($arrayPedidosProdutos);
		unset($arrayPedidosNfiscal);
		unset($arrayPedidosNfiscalClientes);
		unset($arrayPedidosNfiscalProdutos);
		unset($arrayEcm);
		unset($arrayEcmClientes);
		unset($arrayEcmProdutos);

		foreach($arrayNotas as $i => $nota){

			$arrayProdutos = array();
			$prod=array();
			$serv=array();

			if($i % 2 == 0){
				$backCor = "#EFEEED";
			}else{
				$backCor = "#FFF";
			}
			?>

			<div class="informacaoListagem">

				<div style="width:7%; float:left; text-align:left; padding-left:0.5%"> 						

					<?php 

						if($nota->{'not_tipo'}==2){
							echo "Pedido";
						}else if($nota->{'not_tipo'}==9){
							echo "NF-e";
						}else if($nota->{'not_tipo'}==11){
							echo "E-commerce";
						}else if($nota->{'not_tipo'}==12){
							echo "NFC-e";
						}else if($nota->{'not_tipo'}==13){
							echo "Ped. não fiscal";
						}else{
							echo "&nbsp";
						}

					?>

				</div> 

				<div style="width:5%; float:left; "> <?php echo $nota->{'not_numero'}."&nbsp" ;?> </div>

				<div style="width:6%; float:left; text-align:center"> 
					<?php 

						if(isset($nota->{'not_data'})&&!empty($nota->{'not_data'})){
							echo data($nota->{'not_data'}) ;
						}else{
							echo "&nbsp";
						}

					?> 
				</div>
				
				<div style="width:8%; float:left; text-align:center"> 
					<?php 

						if(isset($nota->{'not_data'})&&!empty($nota->{'not_data'})){
							echo substr($nota->{'not_data'}, 10)." h";
						}else{
							echo "&nbsp";
						}

					?> 
				</div>

				<div style="width:20%; float:left;"> <?php echo substr($nota->{'cad_nomeraz'},0,35)."&nbsp";?> </div>
				<div style="width:15%; float:left;"> <?php echo substr($nota->{'cad_nomevend'},0,25)."&nbsp";?> </div>
				<div style="width:9%; padding-right:2%; float:left; text-align:right;">	<?php echo valorFormat($nota->{'not_totalnota'})."&nbsp" ;?> </div>
				<div style="width:10%; float:left;">	
					<?php 
						//RMA
						if( isset($nota->{'cfo_codigo'}) && strstr((string)$nota->{'cfo_codigo'}, "5915|6915") ){
							$totalNotaRma = $totalNotaRma + $nota->{'not_totalnota'};
						}
						if($nota->{'not_tipo'} == 11){
							switch($nota->{'ecm_status'}){
								case 1:
									echo "Aguardando";
									break;
								case 2:
									echo "Processando";
									break;
								case 3:
									echo "Pago";
									break;
								case 4:
									echo "Expedição";
									break;
								case 5:
									echo "Enviado";
									break;
								case 6:
									echo "Cancelado";
									break;
								case 7:
									echo "Análise para Garantia";
									break;
								case 8:
									echo "Reenviado";
									break;
								case 9:
									echo "Concluído";
									break;
							}
						}elseif($nota->{'not_tipo'} == 9 || $nota->{'not_tipo'} == 12){
							if($nota->{'not_status'}==0 || $nota->{'not_status'}==1){
								echo "Pendente";
							}else if($nota->{'not_status'}==2){
								echo "Autorizada";
							}else if($nota->{'not_status'}==3){
								echo "Cancelada";
								$totalNotaCancelada = $totalNotaCancelada+$nota->{'not_totalnota'};
							}else{
								echo "&nbsp";
							}
						}else {
							if($nota->{'not_status'}==0 || $nota->{'not_status'}==1){
								echo "Aberto";
							}else if($nota->{'not_status'}==2){
								echo "Faturado";
							}else if($nota->{'not_status'}==3){
								echo "Cancelado";
								$totalNotaCancelada = $totalNotaCancelada+$nota->{'not_totalnota'};
							}else{
								echo "&nbsp";
							}
						}
					?> 
				</div>

				<div style="width:15%; float:left; text-align:left;">
					<?php
						if( isset($nota->{'not_auxiliar'}) && $nota->{'not_auxiliar'}!="" ){
							echo substr($nota->{'not_auxiliar'}, 0,40)."&nbsp";
						}else{
							echo substr(base64_decode($nota->{'not_obs1'}), 0,70)."&nbsp";
						}
					?>
				</div>

			</div>

			<?php

				// totalizacao valor em nota
				if($nota->{'not_tipo'}==2){
					$totalGeralPedidosValor += $nota->{'not_totalnota'};
					$totalProdPed += $nota->{'not_totalprod'};
					$totalServPed += $nota->{'not_totalserv'};
					$totalDescPed += $nota->{'not_valordesc'};
					$totalAcresPed +=$nota->{'not_totalnota'}-$nota->{'not_totalprod'}-$nota->{'not_totalserv'}+$nota->{'not_valordesc'};
				}else if($nota->{'not_tipo'}==9){
					$totalGeralNfeValor += $nota->{'not_totalnota'};
					$totalProdNfe += $nota->{'not_totalprod'};
					$totalServNfe += $nota->{'not_totalserv'};
					$totalDescNfe += $nota->{'not_valordesc'};
					$totalAcresNfe += $nota->{'not_totalnota'}-$nota->{'not_totalprod'}-$nota->{'not_totalserv'}+$nota->{'not_valordesc'};
				}else if($nota->{'not_tipo'}==11){
					$totalGeralEcmValor += $nota->{'not_totalnota'};
					$totalProdEcm += $nota->{'not_totalprod'};
					$totalServEcm += $nota->{'not_totalserv'};
					$totalDescEcm += $nota->{'not_valordesc'};
					$totalAcresEcm += $nota->{'not_totalnota'}-$nota->{'not_totalprod'}-$nota->{'not_totalserv'}+$nota->{'not_valordesc'};
				}else if($nota->{'not_tipo'}==12){
					$totalGeralNfceValor += $nota->{'not_totalnota'};
					$totalProdNfce += $nota->{'not_totalprod'};
					$totalServNfce += $nota->{'not_totalserv'};
					$totalDescNfce += $nota->{'not_valordesc'};
					$totalAcresNfce += $nota->{'not_totalnota'}-$nota->{'not_totalprod'}-$nota->{'not_totalserv'}+$nota->{'not_valordesc'};
				}else if($nota->{'not_tipo'}==13){
					$totalGeralPedidosNfiscalValor += $nota->{'not_totalnota'};
					$totalProdPdv += $nota->{'not_totalprod'};
					$totalServPdv += $nota->{'not_totalserv'};
					$totalDescPdv += $nota->{'not_valordesc'};
					$totalAcresPdv += $nota->{'not_totalnota'}-$nota->{'not_totalprod'}-$nota->{'not_totalserv'}+$nota->{'not_valordesc'};
				}

				for($j=0;$j<$cnt;$j++){
					
					// totalizacao quantidade de item em nota
					if($nota->{'not_codigo'}==$rowdata[$j]->{'not_codigo'} && array_search($rowdata[$j]->{'ref_codigo'}.$rowdata[$j]->{'itn_ordem'}, $prod)===false){

						if($rowdata[$j]->{'not_tipo'}==2){
							$totalGeralPedidosItens += qtde($rowdata[$j]->{'itn_qtde'});
						}else if($rowdata[$j]->{'not_tipo'}==9){
							$totalGeralNfeItens += qtde($rowdata[$j]->{'itn_qtde'});
						}else if($rowdata[$j]->{'not_tipo'}==11){
							$totalGeralEcmItens += qtde($rowdata[$j]->{'itn_qtde'});
						}else if($rowdata[$j]->{'not_tipo'}==12){
							$totalGeralNfceItens += qtde($rowdata[$j]->{'itn_qtde'});
						}else if($rowdata[$j]->{'not_tipo'}==13){
							$totalGeralPedidosNfiscalItens += qtde($rowdata[$j]->{'itn_qtde'});
						} 

						?>

						<div style="width:100%; float:left; border:0.5px solid #000; padding:3px 1px; margin:1px 0px 1px 20px; font-size:11px;">

							<div style="width:25%; float:left;">	<?php echo substr($rowdata[$j]->{'itn_descr'},0,50);?> </div>

							<div style="width:20%; float:left; padding-left:2%;">	
								<?php 
									if(isset($rowdata[$j]->{'itn_codbar'})&&!empty($rowdata[$j]->{'itn_codbar'})){
										echo "Cód Barras: ".$rowdata[$j]->{'itn_codbar'} ;	
									}else if(isset($rowdata[$j]->{'ref_codbar'})&&!empty($rowdata[$j]->{'ref_codbar'})){
										echo "Cód Barras: ".$rowdata[$j]->{'ref_codbar'} ;	
									}else{
										echo "&nbsp";	
									}
								?> 
							</div>

							<div style="width:20%; float:left;"> <?php echo "Cód Fabr.: ".$rowdata[$j]->{'ref_codigo_forn'} ;?> </div>

							<div style="width:10%; float:left;"> <?php echo "Qntd: ".qtde($rowdata[$j]->{'itn_qtde'}) ;?> </div>

							<div style="width:10%; float:left; "> Unitário: <span style="float:center"><?php echo valorFormat($rowdata[$j]->{'itn_valor'}) ;?> </span></div>

							<div style="width:10%; float:left; text-align: right"> Total: <span style="float:center"><?php echo valorFormat($rowdata[$j]->{'itn_qtde'}*$rowdata[$j]->{'itn_valor'}) ;?> </span></div>

						</div>

						<?php
						array_push($prod, $rowdata[$j]->{'ref_codigo'}.$rowdata[$j]->{'itn_ordem'});
					}
					if($nota->{'not_codigo'}==$rowdata[$j]->{'not_codigo'} && array_search($rowdata[$j]->{'its_codigo'}, $serv)===false ){
						?>
						
						<div style="width:100%; float:left; border:0.5px solid #000; padding:3px 1px; margin:1px 0px 1px 20px; font-size:11px;">

							<div style="width:25%; float:left;">	<?php echo substr($rowdata[$j]->{'its_descr'},0,50);?> </div>

							<div style="width:20%; float:left; padding-left:2%">	
								<?php echo substr($rowdata[$j]->{'its_obs'},0,50)."&nbsp;";?>
							</div>

							<div style="width:20%; float:left;">
								<?php
									if( isset($rowdata[$j]->{'its_data'}) && $rowdata[$j]->{'its_data'}!="" ){
										echo "Data prestação: ".implode("/", array_reverse(explode("-", substr($rowdata[$j]->{'its_data'},0,10))))." às ".substr($rowdata[$j]->{'its_data'}, 11, 5)." h";
									}else{
										echo "&nbsp;";
									}
								?>
							</div>

							<div style="width:10%; float:left;"> <?php echo "Qntd: ".qtde($rowdata[$j]->{'its_qtde'}) ;?> </div>

							<div style="width:10%; float:left;"> Unitário: <span style="float:center"><?php echo valorFormat($rowdata[$j]->{'its_valor'}) ;?> </span></div>

							<div style="width:10%; float:left; text-align: right"> Total: <span style="float:center"><?php echo valorFormat($rowdata[$j]->{'its_subtotal'}) ;?> </span></div>

						</div>
						
						<?php
						array_push($serv, $rowdata[$j]->{'its_codigo'});
					}

				}

			?>
			<div style="clear:both">&nbsp</div>
			<?php

		}

		$totalGeralItens = $totalGeralNfeItens + $totalGeralNfceItens + $totalGeralPedidosItens + $totalGeralPedidosNfiscalItens + $totalGeralEcmItens;
		$totalGeralValor = $totalGeralNfeValor + $totalGeralNfceValor + $totalGeralPedidosValor + $totalGeralPedidosNfiscalValor + $totalGeralEcmValor;
		$totalProdGeral = $totalProdNfe + $totalProdNfce + $totalProdPdv + $totalProdPed + $totalProdEcm;
		$totalServGeral = $totalServNfe + $totalServNfce + $totalServPdv + $totalServPed + $totalServEcm;
		$totalDescGeral = $totalDescNfe + $totalDescNfce + $totalDescPdv + $totalDescPed + $totalDescEcm;
		$totalAcresGeral = $totalAcresNfe + $totalAcresNfce + $totalAcresPdv + $totalAcresPed + $totalAcresEcm;

		// $totalNotaCancelada = $rowdataCanceladas[0]->{'total'};
		// $totalNotaRma = $rowdataRma[0]->{'total'};
		$totalSaldo = $totalGeralValor - $totalNotaCancelada - $totalNotaRma;
		
		if($totalGeralNfe>0){
		?>
		<div class="informacaoRodape">
			<div style="width:10%; float:left; font-weight:bold">	NF-e: (<?php echo qtde($totalGeralNfe) ;?>)</div>
			<div style="width:10%; float:left;">	Clientes: (<?php echo qtde($totalGeralNfeClientes) ;?>) </div>
			<div style="width:10%; float:left;">	Produtos: (<?php echo qtde($totalGeralNfeProdutos)  ;?>) </div>
			<div style="width:10%; float:left;">	Ítens: (<?php echo qtde($totalGeralNfeItens) ;?>) </div>
			<div style="width:12%; float:left;">	V. Prod. R$: <?php echo valorFormat($totalProdNfe) ;?> </div>
			<div style="width:12%; float:left;">	V. Serv. R$: <?php echo valorFormat($totalServNfe) ;?> </div>
			<div style="width:12%; float:left;">	Descontos R$: <?php echo valorFormat($totalDescNfe) ;?> </div>
			<div style="width:12%; float:left;">	Acréscimos R$: <?php echo valorFormat($totalAcresNfe) ;?> </div>
			<div style="width:12%; float:left;">	Total R$: <?php echo valorFormat($totalGeralNfeValor) ;?> </div>
		</div>
		<?php
		}
		if($totalGeralNfce>0){
		?>
		<div class="informacaoRodape">
			<div style="width:10%; float:left; font-weight:bold">	NFC-e: (<?php echo qtde($totalGeralNfce) ;?>)</div>
			<div style="width:10%; float:left;">	Clientes: (<?php echo qtde($totalGeralNfceClientes) ;?>) </div>
			<div style="width:10%; float:left;">	Produtos: (<?php echo qtde($totalGeralNfceProdutos)  ;?>) </div>
			<div style="width:10%; float:left;">	Ítens: (<?php echo qtde($totalGeralNfceItens) ;?>) </div>
			<div style="width:12%; float:left;">	V. Prod. R$: <?php echo valorFormat($totalProdNfce) ;?> </div>
			<div style="width:12%; float:left;">	V. Serv. R$: <?php echo valorFormat($totalServNfce) ;?> </div>
			<div style="width:12%; float:left;">	Descontos R$: <?php echo valorFormat($totalDescNfce) ;?> </div>
			<div style="width:12%; float:left;">	Acréscimos R$: <?php echo valorFormat($totalAcresNfce) ;?> </div>
			<div style="width:12%; float:left;">	Total R$: <?php echo valorFormat($totalGeralNfceValor) ;?> </div>
		</div>
		<?php
		}
		if($totalGeralPedidos){
		?>
		<div class="informacaoRodape">
			<div style="width:10%; float:left; font-weight:bold">	Pedido: (<?php echo qtde($totalGeralPedidos) ;?>)</div>
			<div style="width:10%; float:left;">	Clientes: (<?php echo qtde($totalGeralPedidosClientes) ;?>) </div>
			<div style="width:10%; float:left;">	Produtos: (<?php echo qtde($totalGeralPedidosProdutos)  ;?>) </div>
			<div style="width:10%; float:left;">	Ítens: (<?php echo qtde($totalGeralPedidosItens) ;?>) </div>
			<div style="width:12%; float:left;">	V. Prod. R$: <?php echo valorFormat($totalProdPed) ;?> </div>
			<div style="width:12%; float:left;">	V. Serv. R$: <?php echo valorFormat($totalServPed) ;?> </div>
			<div style="width:12%; float:left;">	Descontos R$: <?php echo valorFormat($totalDescPed) ;?> </div>
			<div style="width:12%; float:left;">	Acréscimos R$: <?php echo valorFormat($totalAcresPed) ;?> </div>
			<div style="width:12%; float:left;">	Total R$: <?php echo valorFormat($totalGeralPedidosValor) ;?> </div>
		</div>
		<?php
		}
		if($totalGeralPedidosNfiscal>0){
		?>
		<div class="informacaoRodape">
			<div style="width:10%; float:left; font-weight:bold">	Ped. não fiscal: (<?php echo qtde($totalGeralPedidosNfiscal) ;?>)</div>
			<div style="width:10%; float:left;">	Clientes: (<?php echo qtde($totalGeralPedidosNfiscalClientes) ;?>) </div>
			<div style="width:10%; float:left;">	Produtos: (<?php echo qtde($totalGeralPedidosNfiscalProdutos)  ;?>) </div>
			<div style="width:10%; float:left;">	Ítens: (<?php echo qtde($totalGeralPedidosNfiscalItens) ;?>) </div>
			<div style="width:12%; float:left;">	V. Prod. R$: <?php echo valorFormat($totalProdPdv) ;?> </div>
			<div style="width:12%; float:left;">	V. Serv. R$: <?php echo valorFormat($totalServPdv) ;?> </div>
			<div style="width:12%; float:left;">	Descontos R$: <?php echo valorFormat($totalDescPdv) ;?> </div>
			<div style="width:12%; float:left;">	Acréscimos R$: <?php echo valorFormat($totalAcresPdv) ;?> </div>
			<div style="width:12%; float:left;">	Total R$: <?php echo valorFormat($totalGeralPedidosNfiscalValor) ;?> </div>
		</div>
		<?php
		}
		if($totalGeralEcm>0){
		?>
		<div class="informacaoRodape">
			<div style="width:10%; float:left; font-weight:bold">	E-commerce: (<?php echo qtde($totalGeralEcm) ;?>)</div>
			<div style="width:10%; float:left;">	Clientes: (<?php echo qtde($totalGeralEcmClientes) ;?>) </div>
			<div style="width:10%; float:left;">	Produtos: (<?php echo qtde($totalGeralEcmClientes)  ;?>) </div>
			<div style="width:10%; float:left;">	Ítens: (<?php echo qtde($totalGeralEcmItens) ;?>) </div>
			<div style="width:12%; float:left;">	V. Prod. R$: <?php echo valorFormat($totalProdEcm) ;?> </div>
			<div style="width:12%; float:left;">	V. Serv. R$: <?php echo valorFormat($totalServEcm) ;?> </div>
			<div style="width:12%; float:left;">	Descontos R$: <?php echo valorFormat($totalDescEcm) ;?> </div>
			<div style="width:12%; float:left;">	Acréscimos R$: <?php echo valorFormat($totalAcresEcm) ;?> </div>
			<div style="width:12%; float:left;">	Total R$: <?php echo valorFormat($totalGeralEcmValor) ;?> </div>
		</div>
		<?php
		}
		if($totalNotaCancelada>0){
		?>
		<div class="informacaoRodapeBorderTop">
			<div style="width:88%; float:left;">	VALOR CANCELADAS </div>
			<div style="width:12%; float:left;">	Total R$: <?php echo valorFormat($totalNotaCancelada) ;?></div>
		</div>
		<?php
		}
		if($totalNotaRma>0){
		?>
		<div class="informacaoRodapeBorderTop">
			<div style="width:88%; float:left;;">	VALOR RMA </div>
			<div style="width:12%; float:left;">	Total R$: <?php echo valorFormat($totalNotaRma) ;?></div>
		</div>
		<?php
		}
		?>
		<div class="informacaoRodapeBorderTop">
			<div style="width:88%; float:left;">	SALDO </div>
			<div style="width:12%; float:left;">	Total R$: <?php echo valorFormat($totalSaldo) ;?></div>
		</div>

		<div class="informacaoRodapeBorderTop">
			<div style="width:10%; float:left;">	TOTAL GERAL: (<?php echo qtde($totalGeralNotas) ;?>)</div>
			<div style="width:10%; float:left;">	Clientes: (<?php echo qtde($totalGeralClientes) ;?>) </div>
			<div style="width:10%; float:left;">	Produtos: (<?php echo qtde($totalGeralProdutos)  ;?>) </div>
			<div style="width:10%; float:left;">	Ítens: (<?php echo qtde($totalGeralItens) ;?>) </div>
			<div style="width:12%; float:left;">	V. Prod. R$: <?php echo valorFormat($totalProdGeral) ;?> </div>
			<div style="width:12%; float:left;">	V. Serv. R$: <?php echo valorFormat($totalServGeral) ;?> </div>
			<div style="width:12%; float:left;">	Descontos R$: <?php echo valorFormat($totalDescGeral) ;?> </div>
			<div style="width:12%; float:left;">	Acréscimos R$: <?php echo valorFormat($totalAcresGeral) ;?> </div>
			<div style="width:12%; float:left;">	Total R$: <?php echo valorFormat($totalGeralValor) ;?> </div>
		</div>

		<?php

	}else{
		?>
		<div style="width:100%; margin-top:50px; text-align:center; font-weight:bold">
			SEM REGISTROS
		</div>
		<?php
	}

	include "../rel/inc/relatorioRodape.php";
?>