<?php

	include '../php/TParams.class.php';
	include '../php/funcoes.php';

    set_time_limit(0);

    error_reporting(E_ALL);

    ob_start();
    date_default_timezone_set("America/Sao_Paulo");
    setlocale(LC_ALL, 'pt_BR');

	$Datapacket = new TParams();
	$company[0] = $Datapacket->getCompany();

	$not_status = (isset($_POST['not_cancelada']) && $_POST['not_cancelada']==true) ? '2,3' : '2';
	$dataFinal = (isset($_POST['dataFinal']) && $_POST['dataFinal']!="") ? implode("-",array_reverse(explode("/",$_POST['dataFinal']))) : null;
	$dataInicio = (isset($_POST['dataInicio']) && $_POST['dataInicio']!="") ? implode("-",array_reverse(explode("/",$_POST['dataInicio']))) : null;
    $listaCfop = (isset($_POST['listaCfop']) && $_POST['listaCfop']!="") ? explode(",",$_POST['listaCfop']) : "";
	$cfop_base = ( isset($_POST["cfop_base"]) && $_POST["cfop_base"]==1 ) ? "cfop_nota" : "cfop";
	$not_entrsaida = "";
	
	if( isset($_POST["nfe_entrada"]) ){
		$not_entrsaida.="1,";
	}
	if( isset($_POST["nfe_saida"]) ){
		$not_entrsaida.="2,";
	}
	$not_entrsaida = substr($not_entrsaida,0,-1);
	

    if(empty($dataFinal)){
        $dataFinal = date ('Y-m-d 23:59:59');
    }

    if(empty($dataInicio)){
        $dataInicio = date('Y-m-d', strtotime('-30 days', strtotime($dataFinal)));
		$dataInicio .=' 00:00:00';
    }
        
	$filtro = '{"cod":"700542", "params":[
		{"name":"db","value":"'.$company[0]->emp_db_comum.'","type":"other"},
		{"name":"not_entrsaida","value":"'.$not_entrsaida.'","type":"other"},
		{"name":"dataInicio","value":"'.$dataInicio.'","type":"string"},
		{"name":"dataFinal","value":"'.$dataFinal.'","type":"string"},
		{"name":"not_status","value":"'.$not_status.'","type":"other"}
	]}';
	$Datapacket->setHost($Datapacket->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	$contador_linhas = $Datapacket->getRecordCount();
	$Datapacket->clear();
	
	$totalNotas=0;
	$totalItens=0;
	$tempCodigoNota="";
  
    //montando array de CFOP e produtos
    $cfop_produtos = array();
    for($i=0; $i<count($rowdata); $i++) {
        $tmp1 = base64_decode($rowdata[$i]->itn_tribjson);
        $tmp2 = json_decode($tmp1)->rowdata;

        $cfop_produtos[] = array(
            "cfop" => $tmp2[0]->ref_cfop,
			"numero_nota" => $rowdata[$i]->not_numero,
            "cfop_nota" => $rowdata[$i]->cfo_codigo,
            "cst" => ($company[0]->emp_codregtrib==1) ? $tmp2[0]->tri_csosn : $tmp2[0]->tri_situacao,
            "produto" => $rowdata[$i]->itn_descr,
            "preco" => $rowdata[$i]->itn_valor,
            "quantidade" => $rowdata[$i]->itn_qtde,
            "total" => $rowdata[$i]->itn_subtotal,
            "cliente" =>  $rowdata[$i]->cad_nomeraz,
            "total_nota" => $rowdata[$i]->not_totalnota,
            "subtotal" => $rowdata[$i]->not_totalprod,
            "data" => $rowdata[$i]->not_data,
            "icms" => $rowdata[$i]->not_toticms
        );
		$subtotal+=$rowdata[$i]->itn_subtotal;
		if($tempCodigoNota!=$rowdata[$i]->not_codigo){
			$totalNotas++;
			$tempCodigoNota=$rowdata[$i]->not_codigo;
		}
    }

    //ordena o resultado pelo CFOP obtido
    sort($cfop_produtos);    

    //se a lista foi declarada sera selecionada do resulado do banco
    if(!empty($listaCfop) && is_array($listaCfop) && count($listaCfop)>0){
        $resTmp;

        for($i = 0; $i < count($cfop_produtos); $i++){
            if(in_array($cfop_produtos[$i][$cfop_base], $listaCfop)){
                $resTmp[] = $cfop_produtos[$i];
            }
        }

        $cfop_produtos = $resTmp;
    }

    //gerar total do cfop
    $valorTotalCfop = array();
    foreach ($cfop_produtos as $item){
        if(!array_key_exists($item[$cfop_base], $valorTotalCfop) ){
            $valorTotalCfop[$item[$cfop_base]] = 0;
        }
		if($tempNumeroNota != $item['numero_nota']){
			$valorTotalCfop[$item[$cfop_base]] += $item['total_nota'];
			$tempNumeroNota = $item['numero_nota'];
		}
    }

    //total geral para o final do relatorio
    $totalGeralValor = 0;
    $totalGeralSub = 0;
    $totalIcms = 0;


$titulo = utf8_decode("RELATÓRIO NOTAS FÍSCAIS POR CFOP");
$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $Datapacket->getCompany()->{"emp_codigo"} . "/" . $Datapacket->getCompany()->{"emp_logo"};
include_once("./inc/relatorioCabecalho.php");

$filtro1 =  base64_encode('<div style="float:left; width:30%"><span style="font-weight:bold;"> '.utf8_decode("CFOP").': </span> <span style="font-weight:normal;">'.implode(', ', $listaCfop).'</span></div>');
$filtro2 =  base64_encode('<div style="float:left; width:30%"><span style="font-weight:bold;"> '.utf8_decode("DATA INÍCIO").': </span> <span style="font-weight:normal;">' .implode('/', array_reverse(explode("-", substr($dataInicio, 0, 10)))).'</span></div>');
$filtro3 =  base64_encode('<div style="float:left; width:30%;"><span style="font-weight:bold;"> '.utf8_decode("DATA FINAL").': </span> <span style="font-weight:normal;">' .implode('/', array_reverse(explode("-", substr($dataFinal, 0, 10)))).'</span></div>');
$objFiltro = new stdClass();
$filtros = array(
    $objFiltro->filtro = $filtro1,
    $objFiltro->filtro = $filtro2,
    $objFiltro->filtro = $filtro3
);

$cabecalhoHeight = "250"; // passar apenas numeros sem px, %..;

if($rowdata > 0){

    $tempCfop = "";
    $tempNumeroNota = '';
    foreach($cfop_produtos as $item){

        if($i % 2 == 0){
            $backCor = "#EFEEED";
        }else{
            $backCor = "#FFF";
        }

        if($item[$cfop_base] != $tempCfop) {
            $tempCfop = $item[$cfop_base];
			$tempNumeroNota="";
            ?>


            <div style="float:left;width:100%;color:#FFFFFF;background-color:#2F4454;padding:3px 10px;font-size: 20px;font-family: signika; margin:8px -8px">

                <div style="width:82%; float:left; text-align:left; padding-left:1%"> CFOP: <?php echo $item[$cfop_base]; ?> </div>

                <div style="width:14%; float:left; text-align: right"> TOTAL R$: <?php echo valorFormat($valorTotalCfop[$tempCfop]); ?> </div>

            </div>

        <?php

        }

        ?>

            <div style="width:100%; float:left; border:0.5px solid #000; padding:3px 1px; margin:1px 0px 1px 0px; font-size:11px;">
            
            <?php

            if($tempNumeroNota != $item['numero_nota']){
            
            ?>

                <div style="width:7%; float:left; background-color:#CCC;"> Nº <?php echo $item['numero_nota']; ?> </div>

                <div style="width:35%; float:left; background-color:#CCC;"> <?php echo $item['cliente']; ?> </div>
				
                <div style="width:12%; float:left; background-color:#CCC;"> CFOP NF-e: <?php echo $item['cfop_nota']; ?> </div>

                <div style="width:10%; text-align:center; float:left; background-color:#CCC;"> <?php echo implode('/', array_reverse(explode("-", substr($item['data'], 0, 10)))); ?> </div>
				
                <div style="width:9%; float:left; background-color:#CCC;"> ICMS R$ <?php echo valorFormat($item['icms']); ?> </div>
				
				<div style="width:10%; float:left; background-color:#CCC; text-align: right; padding-right:50px;"> Subtotal R$: <?php echo valorFormat($item['subtotal']); ?> </div>
				
				<div style="width:11%; float:left; background-color:#CCC; text-align: right; padding-right:50px;"> Total R$: <?php echo valorFormat($item['total_nota']); ?> </div>

                <br><br>

            <?php

            $tempNumeroNota = $item['numero_nota'];
			$totalIcms += $item['icms'];
			$totalGeralSub += $item['subtotal'];
			$totalGeralValor += $item['total_nota'];
            } 

            ?>

                <div style="width:35%; float:left;"> <?php echo $item['produto']; ?> </div>

                <div style="width:10%; text-align:center; float:left;"> Qtde: <?php echo qtde($item['quantidade']); ?> </div>

                <div style="width:8%; text-align:center; float:left;"> CFOP: <?php echo $item['cfop']; ?> </div>
				
                <div style="width:8%; text-align:center; float:left;"> CST: <?php echo $item['cst']; ?> </div>
				
                <div style="width:8%; text-align:center; float:left;"> Valor: <?php echo valorFormat($item['preco']); ?> </div>

                <div style="width:23%; text-align:right; float:right; padding-right:50px;"> Subtotal: <?php echo valorFormat($item['total']); ?> </div>

                

            </div>

        <?php
			$totalItens++;
       }

        ?>


    <div style="clear:both">&nbsp</div>

    <div class="informacaoRodapeBorderTop">

        <div style="width:15%; float:left;">	Total de Notas: <?php echo qtde($totalNotas); ?> </div>
        <div style="width:15%; float:left;">	Total de Itens: <?php echo qtde($totalItens); ?> </div>
        <div style="width:38%; float:left; text-align:right">	Total ICMS R$: <?php echo valorFormat($totalIcms); ?> </div>
        <div style="width:16%; float:left; text-align:right">	Subtotal Geral R$: <?php echo valorFormat($totalGeralSub); ?> </div>
        <div style="width:16%; float:left; text-align:right">	Total Geral R$: <?php echo valorFormat($totalGeralValor); ?> </div>

    </div>

    <?php

}else{

    ?>
    <div style="width:100%; margin-top:50px; text-align:center; font-weight:bold">
        SEM REGISTROS
    </div>
    <?php
}
include "../rel/inc/relatorioRodape.php";
?>