<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';

	$datapacket = new TParams();
	$datapacket->debug(true);
	$datapacket->clear();

	$company = array();
	$company[0] = $datapacket->getCompany();

	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$ose_status = "0,1,2,3,4,5,6,7,8";
	if( isset($dados->{'ose_status'})&&!empty($dados->{'ose_status'}) ){
		$ose_status = $dados->{'ose_status'};
	}
	
	if( $ose_status=='6' || $ose_status=='8' ){
		$ose_status = '6,8';
	}

	$cad_codigo = "%";
	if(isset($dados->{'cad_codigo'})&&!empty($dados->{'cad_codigo'})){
		$cad_codigo = $dados->{'cad_codigo'};
	}

	$cad_responsavel = "%";
	if(isset($dados->{'cad_responsavel'})&&!empty($dados->{'cad_responsavel'})){
		$cad_responsavel = $dados->{'cad_responsavel'};
	}

	$ose_data = "1900-01-01";
	if(isset($dados->{'ose_data'})&&!empty($dados->{'ose_data'})){
		$ose_data = data($dados->{'ose_data'},true, '/');
	}

	$data_fim = "3000-12-31";
	if(isset($dados->{'data_fim'})&&!empty($dados->{'data_fim'})){
		$data_fim = data($dados->{'data_fim'},true, '/');
	}

	$filtro = '{"cod":"501340", "params":[
		{"name":"ose_status","value":"'.$ose_status.'","type":"other"},
		{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
		{"name":"cad_responsavel","value":"'.$cad_responsavel.'","type":"string"},
		{"name":"ose_data","value":"'.$ose_data.' 00:00:00","type":"string"},
		{"name":"data_fim","value":"'.$data_fim.' 23:59:59","type":"string"},
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	// echo $datapacket->getLastQuery();
	$cnt = $datapacket->getRecordCount();
	$datapacket->clear();

	$titulo = utf8_decode("RELATÓRIO ORDEM DE SERVIÇO");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $datapacket->getCompany()->{"emp_codigo"} . "/" . $datapacket->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");

	$periodo = $dados->{'ose_data'} . " ATÉ " . $dados->{'data_fim'};

	$status = "TODOS";
	switch ($dados->{'ose_status'}) {
        case "0":
            $status = "NOVA";
            break;
        case "1":
            $status = "ANÁLISE TÉCNICA";
            break;
        case "2":
            $status = "ORÇAMENTO";
            break;
        case "3":
            $status = "EM EXECUÇÃO";
            break;
        case "4":
            $status = "REVISÃO ORÇAMENTO";
            break;
        case "5":
            $status = "CONCLUÍDA";
            break;
        case "6":
            $status = "FATURADA";
            break;
        case "7":
            $status = "CANCELADA";
            break;
        case "8":
            $status = "CONVERTIDA EM NOTA";
            break;
    }

    $responsavel = "TODOS";
	if ($dados->{'cad_responsavel'}[0]) {
	    $responsavel = "ESPECÍFICO";
    }

    $cliente = "TODOS";
	if ($dados->{'cad_codigo'}) {
	    $cliente = "ESPECÍFICO";
    }

    $filtro1 =  base64_encode('<div style="width:20%; float:left"><span style="font-weight:bold;">' . utf8_decode("PERÍODO: ") . '</span>' . utf8_decode($periodo) . '</div>');
    $filtro2 =  base64_encode('<div style="width:10%; float:left"><span style="font-weight:bold;">STATUS: </span>'.utf8_decode($status).'</div>');
    $filtro3 =  base64_encode('<div style="width:20%; float:left"><span style="font-weight:bold;">' . utf8_decode("RESPONSÁVEL TÉCNICO: ") . '</span>'.utf8_decode($responsavel).'</div>');
    $filtro4 =  base64_encode('<div style="width:10%; float:left"><span style="font-weight:bold;">CLIENTE: </span>'.utf8_decode($cliente).'</div>');

    $objFiltro = new stdClass();
    $filtros = array(
        $objFiltro->filtro = $filtro1,
        $objFiltro->filtro = $filtro2,
        $objFiltro->filtro = $filtro3,
        $objFiltro->filtro = $filtro4,
    );

	if($rowdata > 0){
		$totalGeral = 0;
		$cabecalhoHeight = "280"; // passar apenas numeros sem px, %..;
		$colunas = array();
		$ant="";
		$totServ=0;
		$totProd=0;
		$cont=0;
		
		array_push($colunas, base64_encode('<div style="float:left; width:6%;  text-align:left;"> N. OS </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:20%;">CLIENTE</div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:8%;"> DATA </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:20%; text-align:left">  '.utf8_decode('TÉCNICO').'  </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:5%; text-align:left;"> STATUS </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:8%; text-align:right; padding-right:3%"> VALOR R$ </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:15%;">OBS </div>'));
		// array_push($colunas, base64_encode('<div style="float:left; width:10%;">EQUIPAMENTO </div>'));

			foreach ($rowdata as $i=>$pes){

				if($cont % 2 == 0){
					$backCor = "#EFEEED";
				}else{
					$backCor = "#fff";
				}
				
				if($ant!=$pes->{"ose_codigo"}){
				?>
				<div class="informacaoListagem" <?php echo (!$dados->{'produtos'} && !$dados->{'servicos'}) ? 'style="background-color:'.$backCor.'"' : ''; ?>>
					<div style="width:5.5%; float:left; text-align:left; padding-left: 1%;"> <?php echo $pes->{'ose_numero'}."&nbsp";?> </div>
					<div style="width:18%; float:left; text-align:left;">  <?php echo substr($pes->{'cad_nomeraz'},0,35)."&nbsp";?> </div>
					<div style="width:6%; float:left; text-align:right; padding-right: 4%;"> <?php echo data($pes->{'ose_data'})."&nbsp";?> </div>
					<div style="width:18%; float:left; text-align:left;"> <?php echo $pes->{'cad_nome_resp'}."&nbsp";?> </div>
					<div style="width:5%;  float:left; text-align:left;">
						<?php
							switch ($pes->{'ose_status'}) {
								case '0':
									$ose_status = "NOVA";
									break;

								case '1':
									$ose_status = "EM ANÁLISE";
									break;

								case '2':
									$ose_status = "ORÇAMENTO";
									break;

								case '3':
									$ose_status = "EM EXECUÇÃO";
									break;

								case '4':
									$ose_status = "REVISÂO ORÇAMENTO";
									break;

								case '5':
									$ose_status = "CONCLUÍDA";
									break;

								case '6':
									$ose_status = "FATURADA";
									break;

								case '7':
									$ose_status = "CANCELADA";
									break;

								case '8':
									$ose_status = "CONVERTIDA EM NOTA";
									break;
								
								default:
									$ose_status = "&nbsp";
									break;
							}
							echo $ose_status;
						?> 
					</div>
					<div style="width:8%; float:left; text-align:right; padding-right:4%"> <?php echo valorFormat($pes->{'ose_total'})."&nbsp";?> </div>
					<div style="width:16%; float:left;">
						<?php
							$obs = json_decode(base64_decode($pes->{"ose_obs"}));
							if(is_array($obs)){
								foreach($obs as $o){
									echo utf8_encode(base64_decode($o->obs_obs))."<br>";
								}
							}else{
								echo "&nbsp;";
							}
						?>
					</div>
					<!--<div style="width:10%; float:left;">
						<?php
							// echo $pes->{"osd_descr"};
						?>
					</div>-->
				</div>
				<?php
					$ant = $pes->{"ose_codigo"};
					$cont++;
				}
					if($pes->ori_tipo==1){
						$tipo = "Serviço";
						$totServ+=$pes->{'ori_subtotal'};
					}else{
						$tipo = "Produto";
						$totProd+=$pes->{'ori_subtotal'};
					}
					if( ($dados->{'produtos'}==true && $pes->ori_tipo==2) || ($dados->{'servicos'}==true && $pes->ori_tipo==1) ){
				?>
				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>; border:0.5px solid #000; font-size:12px; margin-top:2px; min-height:30px">
					<div style="width:5.5%; float:left; text-align:left; padding-left: 1%;"> <?php echo $tipo;?> </div>
					<div style="width:5.5%; float:left; text-align:left; padding-left: 1%;"> <?php echo $pes->{'cod'}."&nbsp";?> </div>
					<div style="width:22%; float:left; text-align:left;">  <?php echo substr($pes->{'ori_descr'},0,35)."&nbsp";?> </div>
					<div style="width:8%; float:left; padding-right: 4%;"> Unitário: <?php echo valorFormat($pes->{'ori_valor_unitario'})."&nbsp";?> </div>
					<div style="width:8%; float:left; text-align:left;"> Qtde: <?php echo valorFormat($pes->{'ori_quantidade'})."&nbsp";?> </div>
					<div style="width:8%; float:left; text-align:left;"> Desconto: <?php echo valorFormat($pes->{'ori_desconto'})."&nbsp";?> </div>
					<div style="width:8%; float:left; text-align:left;"> Subtotal: <?php echo valorFormat($pes->{'ori_subtotal'})."&nbsp";?> </div>
				</div>
				<?php
					}
				$totalGeral += $pes->{'ori_subtotal'};
			}
		?>
		<div class="informacaoRodape">
			<div style="width:25%; float:left; text-align:right;">Quantidade total de OS: <?php echo $cont;?></div>
			<div style="width:25%; float:left; text-align:right;">Valor Total dos Serviços: R$ <?php echo valorFormat($totServ)."&nbsp";?></div>
			<div style="width:25%; float:left; text-align:right;">Valor Total dos Produtos: R$ <?php echo valorFormat($totProd)."&nbsp";?></div>
			<div style="width:25%; float:left; text-align:right;">Valor Total: R$:  <?php echo valorFormat($totalGeral)."&nbsp";?></div>
		</div>

		<?php		
	}else {

		?>
		<div style="width:100%; float:left; margin:50px 0px 0px 0px; padding: 0px 0px; text-align:center">
			Não foram encontrados registros para sua pesquisa
		</div>
		<?php
	}

	include "../rel/inc/relatorioRodape.php";

?>