<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	if(isset($_REQUEST['pdc_chave']) && !empty($_REQUEST['pdc_chave'])){
		$pdc_chave = $_REQUEST['pdc_chave'];
	}else{
		$pdc_chave = "";
	}

	if(isset($_REQUEST['emp_codigo']) && !empty($_REQUEST['emp_codigo'])){
		$emp_codigo = $_REQUEST['emp_codigo'];
	}else{
		$emp_codigo = $TParams->getCodigo();
	}
	
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();
	
	$filtro='{"cod":"500691","params":[
		{"name":"database","value":"'.$company[0]->{'emp_db_comum'}.'","type":"other"},
		{"name":"pdc_chave","value":"'.$pdc_chave.'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->{'emp_db_sge'}));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	// echo $Datapacket->getLastQuery();
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();
	
	//lanctos
	$filtro='{"cod":"500692","params":[
		{"name":"pdc_chave","value":"'.$pdc_chave.'","type":"string"}
	]}';
	$Datapacket->add($filtro);
	$lanctos = $Datapacket->open(true);
	$Datapacket->clear();	

?>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<title></title>
		<style>
			div,span{
				margin:0;
				padding:0;
				font-family:Arial;
				font-size:13px;
				font-weight:normal;
			}
		</style>
	</head>

	<body onload="window.print();" style="margin:0; padding:0; margin-top:20px">
	
		<div style="width:100%; float:left;">
		
			<div style="width:100%; float:left; text-align:center">

				<?php 
					if(isset($company[0]->{'emp_logo'}) && !empty($company[0]->{'emp_logo'})){
						echo '<img style="width:35%" src="http://'.$_SERVER['SERVER_NAME'].'/uploads/'.$company[0]->{'emp_codigo'}.'/'.$company[0]->{'emp_logo'}.'">';
					}else{
						echo '<h3>'.$company[0]->{'emp_fantasia'}.'</h3>';
					}

				?>
				
				<h3> Fechamento do terminal </h3>
				
				<h3> <?php echo $rowdata[0]->{'pdv_descr'};?> </h3>
				
				<h4>Atendente: <?php echo $rowdata[0]->{'cad_nomeraz'}?></h4>				

			</div>
			
			<div style="width:96%; float:left; margin-top:20px; padding:10px; border:1px solid #000000; background-color:#C1C1C1; font-weight:bold">
				
				Início: <?php echo dataComHoras($rowdata[0]->{'pdc_data'});?>

			</div>

			<div style="width:100%; float:left; margin:0px">
				
				<div style="width:100%; padding:5px 0px; clear:both">
					<div style="width:85%; float:left; text-align:right;">
						Abertura R$:
					</div>
					<div style="width:14%; float:left; text-align:right">
						<?php echo valorFormat($rowdata[0]->{'pdc_caixa_ini'})?>
					</div>
				</div><br>
				
				<div style="width:10%; height:30px; line-height:30px; float:left; background: #CCC; border:1px solid #000; text-align:center">
					PEDIDO
				</div>
				<div style="width:8%; height:30px; line-height:30px; float:left; background: #CCC; border:1px solid #000; text-align:center">
					TIPO
				</div>
				<div style="width:35%; height:30px; line-height:30px; float:left; background: #CCC; border:1px solid #000; text-align:center">
					CLIENTE
				</div>
				<div style="width:14%; height:30px; line-height:30px; float:left; background: #CCC; border:1px solid #000; text-align:center">
					DESCONTO R$
				</div>
				<div style="width:10%; height:30px; line-height:30px; float:left; background: #CCC; border:1px solid #000; text-align:center">
					TOTAL R$
				</div>
				<div style="width:20%; height:30px; line-height:30px; float:left; background: #CCC; border:1px solid #000; text-align:center">
					FORMA PGMTO
				</div>
				
				<br style="clear:both">
				
			<?php
				foreach($rowdata as $r){
					if($r->not_numero){
						switch($r->doc_tipo){
							case 4:
								$doc_tipo = "Cheque";
								break;
							case 5:
								$doc_tipo = "Cartão de Crédito";
								break;
							case 10:
								$doc_tipo = "Dinheiro";
								break;
							case 13:
								$doc_tipo = "Múltiplos";
								break;
							case 24:
								$doc_tipo = "Pix";
								break;
							case 99:
								$doc_tipo = "Outros";
								break;
							default:
								$doc_tipo = "Dinheiro";
								break;
						}
			?>
				<div style="width:10%; height:30px; line-height:30px; float:left; border:1px solid #000; text-align:center">
					<?php echo $r->not_numero; ?>
				</div>
				<div style="width:8%; height:30px; line-height:30px; float:left; border:1px solid #000; text-align:center">
					<?php echo ($r->not_tipo==13) ? 'PDV' : 'NFC-e'; ?>
				</div>
				<div style="width:34%; height:30px; line-height:30px; float:left; border:1px solid #000; padding-left:1%;">
					<?php echo substr($r->cliente, 0, 25); ?>
				</div>
				<div style="width:14%; height:30px; line-height:30px; float:left; border:1px solid #000; text-align:center">
					<?php echo ($r->not_valordesc>0) ? number_format($r->not_valordesc, 2, ",", "") : "0,00"; ?>
				</div>
				<div style="width:10%; height:30px; line-height:30px; float:left; border:1px solid #000; text-align:center">
					<?php echo ($r->not_totalnota>0) ? number_format($r->not_totalnota, 2, ",", "") : "0,00"; ?>
				</div>
				<div style="width:20%; height:30px; line-height:30px; float:left; border:1px solid #000; text-align:center">
					<?php echo $doc_tipo; ?>
				</div>
			<?php
					}
				}
			?>

				<div style="width:100%; padding:5px 0px; clear:both">
					<div style="width:85%; float:left; text-align:right;">
						Total Adicionado R$:
					</div>
					<div style="width:14%; float:left; text-align:right">
						<?php echo valorFormat($rowdata[0]->{'pdc_aditado'})?>
					</div>
				</div>
				
				<?php
					if($rowdata[0]->{'pdc_aditado'}>0){
				?>
					<div style="width:10%; padding:3px; float:right; background: #CCC; border:1px solid #000; text-align:center">
						VALOR R$
					</div>
					<div style="width:50%; padding:3px; float:right; background: #CCC; border:1px solid #000; text-align:left">
						DESCRI&Ccedil;&Atilde;O
					</div>
					<br style="clear:both">
					<?php
						foreach($lanctos as $lancto){
							$descr = explode("MOTIVO:", $lancto->lan_historico);
							$descr = $descr[1];
							if($lancto->lan_dc==2 && !$lancto->doc_codigo){
					?>
							<div style="width:10%; padding:3px; float:right; background: #CCC; border:1px solid #000; text-align:center">
								<?php echo valorFormat($lancto->lan_valor); ?>
							</div>
							<div style="width:50%; padding:3px; float:right; background: #CCC; border:1px solid #000; text-align:left">
								<?php echo $descr;?>
							</div><br style="clear:both">
							
					<?php
							}
						}
					}
				?>

				<div style="width:100%; padding:5px 0px; clear:both">
					<div style="width:85%; float:left; text-align:right;">
						Total Retirado R$:
					</div>
					<div style="width:14%; float:left; text-align:right">
						<?php echo valorFormat($rowdata[0]->{'pdc_retirada'})?>
					</div>
				</div>
				
				<?php
					if($rowdata[0]->{'pdc_retirada'}>0){
						$totTroco=0;
				?>
					<div style="width:10%; padding:3px; float:right; background: #CCC; border:1px solid #000; text-align:center">
						VALOR R$
					</div>
					<div style="width:50%; padding:3px; float:right; background: #CCC; border:1px solid #000; text-align:left">
						DESCRI&Ccedil;&Atilde;O
					</div>
					<br style="clear:both">
					<?php
						foreach($lanctos as $lancto){
							$descr = explode("MOTIVO:", $lancto->lan_historico);
							$descr = (isset($descr[1])) ? $descr[1] : "";
							if($lancto->lan_dc==1 && !$lancto->doc_codigo){
					?>
							<div style="width:10%; padding:3px; float:right; background: #CCC; border:1px solid #000; text-align:center">
								<?php echo valorFormat($lancto->lan_valor); ?>
							</div>
							<div style="width:50%; padding:3px; float:right; background: #CCC; border:1px solid #000; text-align:left">
								<?php echo $descr;?>
							</div><br style="clear:both">
							
					<?php
							}elseif( $lancto->lan_dc==1 ){
								$totTroco+=$lancto->lan_valor;
							}
						}
					}
					if($totTroco>0){
				?>
					<div style="width:10%; padding:3px; float:right; background: #CCC; border:1px solid #000; text-align:center">
						<?php echo valorFormat($totTroco); ?>
					</div>
					<div style="width:50%; padding:3px; float:right; background: #CCC; border:1px solid #000; text-align:left">
						TOTAL TROCO
					</div><br style="clear:both">
				<?php
					}
				?>

				<div style="width:100%; padding:5px 0px; clear:both">
					<div style="width:85%; float:left; text-align:right;">
						Dinheiro R$:
					</div>
					<div style="width:14%; float:left; text-align:right">
						<?php echo valorFormat($rowdata[0]->{'pdc_dinheiro'})?>
					</div>
				</div>

				<div style="width:100%; padding:5px 0px; clear:both">
					<div style="width:85%; float:left; text-align:right;">
						Cheque R$:
					</div>
					<div style="width:14%; float:left; text-align:right">
						<?php echo valorFormat($rowdata[0]->{'pdc_cheque'})?>
					</div>
				</div>

				<div style="width:100%; padding:5px 0px; clear:both">
					<div style="width:85%; float:left; text-align:right;">
						Cart&atilde;o R$:
					</div>
					<div style="width:14%; float:left; text-align:right">
						<?php echo valorFormat($rowdata[0]->{'pdc_cartao'})?>
					</div>
				</div>
				
				<div style="width:100%; padding:5px 0px; clear:both">
					<div style="width:85%; float:left; text-align:right;">
						Pix R$:
					</div>
					<div style="width:14%; float:left; text-align:right">
						<?php echo valorFormat($rowdata[0]->{'pdc_pix'})?>
					</div>
				</div>

				<div style="width:100%; padding:5px 0px; clear:both">
					<div style="width:85%; float:left; text-align:right;">
						Outro R$:
					</div>
					<div style="width:14%; float:left; text-align:right">
						<?php echo valorFormat($rowdata[0]->{'pdc_outro'})?>
					</div>
				</div>

				<div style="width:100%; padding:5px 0px; clear:both">
					<div style="width:85%; float:left; text-align:right;">
						Desconto R$:
					</div>
					<div style="width:14%; float:left; text-align:right">
						<?php echo valorFormat($rowdata[0]->{'pdc_desconto'})?>
					</div>
				</div>

			</div>

			<div style="width:95%; float:left; margin:20px 0px 0px 10px; font-weight:bold; font-size:11px">
				TOTAL VENDA R$: <?php echo valorFormat($rowdata[0]->{'pdc_dinheiro'} + $rowdata[0]->{'pdc_cheque'} + $rowdata[0]->{'pdc_cartao'} + $rowdata[0]->{'pdc_pix'} + $rowdata[0]->{'pdc_outro'})?>
			</div>

			<div style="width:95%; float:left; margin:20px 0px 0px 10px; font-weight:bold; font-size:11px">
				TOTAL DESCONTO R$: <?php echo valorFormat($rowdata[0]->{'pdc_desconto'})?>
			</div>

			<div style="width:95%; float:left; margin:20px 0px 0px 10px; font-weight:bold; font-size:11px">
				TOTAL NO FECHAMENTO R$: <?php echo valorFormat($rowdata[0]->{'pdc_caixa_fim'})?>
			</div>
			
			<div style="width:95%; margin-top:20px; float:left; padding:10px; border:1px solid #000000; background-color:#C1C1C1; font-weight:bold">
				
				<?php echo "Fechamento: ".dataComHoras($rowdata[0]->{'pdc_dtfechamento'});?>

			</div>

		</div>

	</body>

</html>