<?php

	set_time_limit(0);

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';

	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();

	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$busca = "";
	if(isset($dados->{'prj_codigo'}) && $dados->{'prj_codigo'}!=''){
		$busca.= " and a.prj_codigo = ".$dados->{'prj_codigo'};
	}
	
	if(isset($dados->{'tags'}) && count($dados->{'tags'})>0){
		$aux = $dados->{'tags'};
		$aux2 = '';
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 = $aux[$i];
			}else{
				$aux2 .= ", ".$aux[$i];
			}
		}
		$busca.= " and d.tag_codigo in (".$aux2.")";
	}

	$cliente = "TODOS";
	if(isset($dados->{'clientes'})&&!empty($dados->{'clientes'})){
		$aux = $dados->{'clientes'};
		$aux2 = '';
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 = "'".$aux[$i]."'";
			}else{
				$aux2 .= ", '".$aux[$i]."'";
			}
		}
		if($aux2 && $aux2!="" && $aux2!="''"){
			$busca.= " and a.cad_codigo in (".$aux2.")";
			$cliente = utf8_decode("ESPEC&Iacute;FICO");
		}
	}

	$vendedor = "TODOS";
	if(isset($dados->{'vendedores'})&&!empty($dados->{'vendedores'})){
		$aux = $dados->{'vendedores'};
		$aux2 = '';
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 = "'".$aux[$i]."'";
			}else{
				$aux2 .= ", '".$aux[$i]."'";
			}
		}
		$busca.= " and a.cad_responsavel in (".$aux2.")";
		$vendedor = utf8_decode("ESPEC&Iacute;FICO");
	}

	if(isset($dados->{'valor_ini'})&&!empty($dados->{'valor_ini'})&&$dados->{'valor_ini'}>0){
		$busca.= " and a.ipj_valor >= ".$dados->{'valor_ini'};
		if(isset($dados->{'valor_fim'})&&!empty($dados->{'valor_fim'})&&$dados->{'valor_fim'}>0){
			$busca .= " and a.ipj_valor <= ".$dados->{'valor_fim'};
		}
	}else{
		if(isset($dados->{'valor_fim'})&&!empty($dados->{'valor_fim'})&&$dados->{'valor_fim'}>0){
			$busca .= " and a.ipj_valor <= ".$dados->{'valor_fim'};
		}
	}

	if(isset($dados->{'data_fim'}) && !empty($dados->{'data_fim'})){
		$busca .= " and (a.ipj_data between '".implode('-',array_reverse(explode('/',$dados->{'data_ini'}))) . "' and '" . implode('-',array_reverse(explode('/',$dados->{'data_fim'})))."' or a.ipj_data=0)";
		$datas = utf8_decode("DE ".$dados->{'data_ini'}." ATÉ ".$dados->{'data_fim'});
	} else {
		$busca .= " and a.ipj_data between '" . Date('Y-m-d 00:00:00', strtotime("-30 days")) . "' and '" . Date('Y-m-d 23:59:59') . "'";
		$datas = utf8_decode("DE ".Date('d/m/Y', strtotime("-30 days"))." ATÉ ".Date('d/m/Y'));
	}

	$ordem = "asc";
	if(isset($dados->{'ordem'})&&!empty($dados->{'ordem'})){
		$ordem = $dados->{'ordem'};
	}

	$ordenacao = "";
	$ordenado = "TODOS";
	if(isset($dados->{'ordenacao'})&&!empty($dados->{'ordenacao'})||$dados->{'ordenacao'}==0){
		if($dados->{'ordenacao'}== 0){
			$ordenacao = ", a.ipj_titulo ".$ordem;
			$ordenado = "TITULO DO PROJETO";
			if($ordem == 'asc'){
				$ordenado = $ordenado." ASCENDENTE";
			}else{
				$ordenado = $ordenado." DESCENDENTE";
			}
		}else if($dados->{'ordenacao'}== 1){
			$ordenacao = ", a.ipj_data ".$ordem;
			$ordenado = "DATA DO PROJETO";
			if($ordem == 'asc'){
				$ordenado = $ordenado." ASCENDENTE";
			}else{
				$ordenado = $ordenado." DESCENDENTE";
			}
		}else if($dados->{'ordenacao'}== 2){
			$ordenacao = ", a.ipj_valor ".$ordem;
			$ordenado = "VALOR DO PROJETO";
			if($ordem == 'asc'){
				$ordenado = $ordenado." ASCENDENTE";
			}else{
				$ordenado = $ordenado." DESCENDENTE";
			}
		}else{
			$ordenacao = ", a.ipj_titulo ".$ordem;
			$ordenado = "TITULO DO PROJETO";
			if($ordem == 'asc'){
				$ordenado = $ordenado." ASCENDENTE";
			}else{
				$ordenado = $ordenado." DESCENDENTE";
			}
		}
	}

	$company[0] = $TParams->getCompany();

	$filtro = '{"cod":"700804", "params":[
		{"name":"db","value":"'.$company[0]->{'emp_db_comum'}.'","type":"other"}, 
		{"name":"busca","value":"'.$busca.'","type":"other"},
		{"name":"ordem","value":"'.$ordenacao.'","type":"other"}
	]}';
	
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();

	$titulo = utf8_decode("RELATÓRIO DE PROJETOS");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $company[0]->{"emp_codigo"} . "/" . $company[0]->{"emp_logo"};
	include("inc/relatorioCabecalho.php");

	$filtro1 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> PROJETO: </span> <span style="font-weight:normal;">' .utf8_decode($dados->projeto).'</span></div>');
	$filtro2 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> '.utf8_decode('PERÍODO').': </span> <span style="font-weight:normal;">' .$datas.'</span></div>');
	$filtro3 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> CLIENTE: </span> <span style="font-weight:normal;">' .utf8_decode($cliente).'</span></div>');
	$filtro4 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> RESPONSAVEL: </span> <span style="font-weight:normal;">' .utf8_decode($vendedor).'</span></div>');
	$filtro5 =  base64_encode('<div style="float:left; padding-right: 1%"><span style="font-weight:bold;"> '.utf8_decode("ORDENAÇÃO").': </span> <span style="font-weight:normal;">' .utf8_decode($ordenado).'</span></div>');
	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = $filtro1,
		$objFiltro->filtro = $filtro2,
		$objFiltro->filtro = $filtro3,
		$objFiltro->filtro = $filtro4,
		$objFiltro->filtro = $filtro5
	);

	$cabecalhoHeight = "280"; // passar apenas numeros sem px, %..;

	$colunas = array();
		
		array_push($colunas, base64_encode('<div style="float:left; width:20%;  text-align:left;"> TITULO </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:8%; text-align:left"> DATA </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:20%; text-align:left;"> CLIENTE </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:20%; text-align:left;"> TAGS </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:20%; text-align:left;"> ETAPA </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:10%; text-align:left;"> VALOR R$</div>'));
	
	$ant="abc";
	$cod = "";
	$arr = array();
	$contador = 0;
	$contador2 = 0;
	$total = 0;
	
	if($cnt > 0){
		
		foreach($rowdata as $r){
			$tags.= ($r->tag!="") ? $r->tag."; " : "";
			if($rowdata[$contador+1]->ipj_codigo!=$r->ipj_codigo){
				$arr[$r->ipj_codigo] = $tags;
				$tags="";
			}
			$contador++;
		}

		foreach($rowdata as $r){

				if($ant!=$r->cad_responsavel){
					if($ant!="abc"){
			?>
						<div style="float:left; width:100%; text-align: right"><strong>Total: <?php echo valorFormat($total)."&nbsp";?></strong></div>
			<?php
						$total=0;
					}
			?>
			
			<div class="informacaoListagem">
				<div style="width:100%; float:left;"><?php echo ( isset($r->cad_responsavel) && $r->cad_responsavel!="" ) ? $r->responsavel : "SEM RESPONSAVEL";?></div>
			</div>
			
			<?php
					$ant = $r->cad_responsavel;
				}
				
				if($cod!=$r->ipj_codigo){
					
			?>
			<div style="float:left; width:20%;"><?php echo substr($r->ipj_titulo,0,30)."&nbsp";?></div>
			<div style="float:left; width:8%;"><?php echo ($r->ipj_data!=0) ? data($r->ipj_data)."&nbsp" : "&nbsp";?></div>
			<div style="float:left; width:20%;"><?php echo substr($r->cliente,0,30)."&nbsp";?></div>
			<div style="float:left; width:20%;"><?php echo substr($arr[$r->ipj_codigo],0,40)."&nbsp";?></div>
			<div style="float:left; width:20%;"><?php echo $r->etapa."&nbsp";?></div>
			<div style="float:left; width:10%;"><?php echo valorFormat($r->ipj_valor)."&nbsp";?></div>
			
			<?php
					$cod = $r->ipj_codigo;
					$total+=$r->ipj_valor;
				}
				$contador2++;
				if($contador2==count($rowdata)){
			?>
					<div style="float:left; width:100%; text-align: right"><strong>Total: <?php echo valorFormat($total)."&nbsp";?></strong></div>
			<?php
				}
		}

	}else{
		?>
		<div style="width:100%; margin-top:50px; text-align:center; font-weight:bold">
			SEM REGISTROS
		</div>
		<?php
	}

	include "../rel/inc/relatorioRodape.php";
?>