<?php
	setlocale (LC_ALL, 'pt_BR.UTF-8');
	include_once "../class/mpdf/mpdf.php";
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	
	function cnpj($n){
		$n = substr($n, 0, 2).".".substr($n, 2, 3).".".substr($n, 5, 3)."/".substr($n, 8, 4)."-".substr($n, 12, 2);
		return $n;
	}
	
	function cpf($n){
		$n = substr($n, 0, 3).".".substr($n, 3, 3).".".substr($n, 6, 3)."-".substr($n, 9, 2);
		return $n;
	}
	
	function extenso($valor=0, $complemento=true) {
		$rt="";
		$singular = array("centavo", "real", "mil", "milhão", "bilhão", "trilhão", "quatrilhão");
		$plural = array("centavos", "reais", "mil", "milhões", "bilhões", "trilhões","quatrilhões");
	 
		$c = array("", "cem", "duzentos", "trezentos", "quatrocentos","quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
		$d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta","sessenta", "setenta", "oitenta", "noventa");
		$d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze","dezesseis", "dezesete", "dezoito", "dezenove");
		$u = array("", "um", "dois", "três", "quatro", "cinco", "seis","sete", "oito", "nove");
	 
		$z=0;
		
		$valor = str_replace(",",".",$valor);
		$valor = (float) $valor;
		$valor = number_format($valor, 2, ".", ".");
		
		$inteiro = explode(".", $valor);
		for($i=0;$i<count($inteiro);$i++)
			for($ii=strlen($inteiro[$i]);$ii<3;$ii++)
				$inteiro[$i] = "0".$inteiro[$i];
	 
		// $fim identifica onde que deve se dar junção de centenas por "e" ou por "," ;) 
		$fim = count($inteiro) - ($inteiro[count($inteiro)-1] > 0 ? 1 : 2);
		for ($i=0;$i<count($inteiro);$i++) {
			$valor = $inteiro[$i];
			$rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
			$rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
			$ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";
		
			$r = $rc.(($rc && ($rd || $ru)) ? " e " : "").$rd.(($rd && $ru) ? " e " : "").$ru;
			$t = count($inteiro)-1-$i;
			if ($complemento == true) {
				$r .= $r ? " ".($valor > 1 ? $plural[$t] : $singular[$t]) : "";
				if ($valor == "000")$z++; elseif ($z > 0) $z--;
				if (($t==1) && ($z>0) && ($inteiro[0] > 0)) $r .= (($z>1) ? " de " : "").$plural[$t]; 
			}
			
			if ($r) $rt = $rt . ((($i > 0) && ($i <= $fim) && ($inteiro[0] > 0) && ($z < 1)) ? ( ($i < $fim) ? ", " : " e ") : " ") . $r;
		}
	 
		return($rt ? $rt : "zero");
	}

	$Datapacket = new Datapacket();
	$TParams=new TParams();
	$mpdfTodos = new mPDF('utf-8', 'A4', 0, '', 5, 5, 5, 5, 5);
	$mpdfTodos->SetHTMLFooter('
	<div style="width:950px; height:20px; margin:0px auto; font-size:8px;">
		<div style="width:950px; text-align:right;">FACIL ONLINE - JC MANTOVAN</div>
	</div>'
	);
	
	//doc_codigo(s)
	$doc_codigo = json_decode($_REQUEST["doc_codigo"]);
	$codigos="";
	
	if( is_array($doc_codigo) ){
		foreach($doc_codigo as $c) $codigos.= "'".$c."', ";
		$codigos = substr($codigos, 0, -2);
	}else{
		$codigos = "'".$doc_codigo."'";
	}
	
	//empresa
	$company = $TParams->getCompany();	

	//docto
	$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
	$filtro = '{"cod":"500480","params":[
		{"name":"doc_codigo","value":"'.$codigos.'","type":"other"},
		{"name":"database","value":"'.$company->{'emp_db_comum'}.'","type":"other"}
	]}';
	$Datapacket->add($filtro);
	$doctos = $Datapacket->open(true);
	
	if(count($doctos)>0){
		
		ob_start();
		
		if($doctos[0]->{'doc_tipo'}==3 || ($doctos[0]->{'doc_tipo'}==7 && isset($_REQUEST["total"])) ){
			
?>
<!DOCTYPE HTML>
<html lang="pt_BR">
<head>
	<meta charset="UTF-8">
	<?php
	$css = '
	<style type="text/css">
		*{
			margin:0;
			padding:0;
		}
		body{
			width:650px;
		}
		.espaco{
			float:left;
			width:5px;
		}
		.np{
			font-family: Arial, Helvetica, sans-serif;
			font-size:12px;
			border:1px solid #000;
			width:78%;
			padding:10px;
			float:left;
		}
		.logo{
			float:left;
			width:18%;
			border:1px solid #000;
		}
		.np2{
			margin:10px 0px 0px 10px;
			line-height:18px;
		}
		h2{
			font-size:14px;
		}
		.assinatura{
			width:35%;
			border-bottom:1px solid #000;
			margin:30px 0px 0px 350px;
		}
	</style>';
	?>
</head>
<body>
	<?php
		foreach($doctos as $docto){
			
			$filter = '{"cod":"700290","params":[{"name":"cad_codigo","value":"'.$docto->{"cad_codigo"}.'","type":"string"}]}';

			$Datapacket->clear();
			$Datapacket->setHost($TParams->getHost($company->{'emp_db_comum'}));
			$Datapacket->add($filter);
			$endereco = $Datapacket->open(true);
			$desconto = (isset($docto->{'doc_desconto'}) && $docto->{'doc_desconto'}>0) ? $docto->{'doc_desconto'} : 0;
			
			$valor = ( isset($_REQUEST["total"]) ) ? number_format((float) ($docto->{"doc_tparc"}*($docto->{"doc_valor"}-$desconto)), 2, ",", "") : number_format((float) ($docto->{"doc_valor"}-$desconto), 2, ",", "")
			
	?>

			<div class="logo"><img src="../resources/images/np.jpg" alt="" style="height:298px;margin-left:10px;"></div>
			<div class="espaco">&nbsp;</div>
			<div class="np">
				<div style="float:left;width:60%">
					<h2>NOTA PROMISSÓRIA Nº <?php echo $docto->{"doc_numero"}?></h2>
				</div>
				<div style="width:30%">
					<h2>VALOR R$  <?php echo $valor;?></h2>
				</div>
				
				<div class="np2">
					Pagarei por esta única via de NOTA PROMISÓRIA, à <?php echo $company->{"emp_razao"}?>, CNPJ: <?php echo cnpj($company->{"emp_cpfcnpj"});?>, ou à sua ordem.<br>
					A quantia de R$ <?php echo $valor;?> (<?php echo extenso($valor)?> ).<br>
					<?php if( isset($_REQUEST["total"]) ){ ?>
						Em <?php echo $docto->{"doc_tparc"}?> parcelas iguais de R$ <?php echo number_format((float) ($docto->{"doc_valor"}-$desconto), 2, ",", "");?>, a partir do dia <?php echo implode("/", array_reverse(explode("-", substr($docto->{"doc_dtvcto"}, 0, 10))));?>.
					<?php }else{ ?>
						No dia <?php echo implode("/", array_reverse(explode("-", substr($docto->{"doc_dtvcto"}, 0, 10))));?>.
					<?php } ?>
					
					<br><br>
					
					<strong>EMITENTE:</strong> <?php echo $docto->{"cad_nomeraz"}?><br>
					<strong>CNPJ/CPF:</strong> <?php echo (strlen($docto->{"cad_cnpjcpf"})<14) ? cpf($docto->{"cad_cnpjcpf"}) : cnpj($docto->{"cad_cnpjcpf"})?><br>
					<div style="float:left;width:65%"><strong>ENDEREÇO:</strong> <?php echo $endereco[0]->{"end_nome"}?>, <?php echo $endereco[0]->{"end_num"}?> <?php echo ($endereco[0]->{"end_complemento"}!="") ? $endereco[0]->{"end_complemento"} : ""?> - <?php echo $endereco[0]->{"end_bairro"}?></div> <strong>CIDADE/UF:</strong> <?php echo $endereco[0]->{"end_cidade"}?> - <?php echo $endereco[0]->{"end_uf"}?><br><br>
					<div style="float:left;width:65%"><strong>Data emissão: <?php echo date("d/m/Y")?></strong></div> <strong>Pagável em: <?php echo $company->{'emp_cidade'}?> -  <?php echo $company->{'emp_uf'}?></strong><br><br>
					<div class="assinatura">
						
					</div>
				</div>
			</div><br style="clear:both">
			
	<?php
		}
	?>
</body>
</html>
<?php

			$dir = $TParams->uploads.$company->{'emp_codigo'}.'/promissorias/';
			$dir2 = $TParams->uploads2.$company->{'emp_codigo'}.'/promissorias/';
			if(!is_dir($dir))
				@mkdir($dir,0777);
			
			$html = ob_get_clean();
			$mpdfTodos->WriteHTML($css, 1);
			$mpdfTodos->WriteHTML($html, 2);
			$mpdfTodos->Output($dir.$doctos[0]->{"doc_codigo"}.".pdf");
			
			echo "<a href='".$dir2.$doctos[0]->{"doc_codigo"}.".pdf"."' style='text-decoration:none; font-weight:bold; color:#000'>Clique aqui para imprimir a Promissória</a>
			<script>
				setTimeout(function(){
					location.href='".$dir2.$doctos[0]->{"doc_codigo"}.".pdf"."'
				},500);
			</script>
			";
			
		}else{
			
			echo "O documento selecionado não é uma Nota Promissória!";
			
		}
		
	}else{
		
		echo "Nâo foram encontrados documentos correspondentes!";
		
	}
?>