<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$datapacket = new datapacket();
	$datapacket->debug(true);
	$TParams = new TParams();
	
	$company = array($TParams->getCompany());

	$dados = json_decode(base64_decode($_REQUEST['dados']));
	
	$razaoEmp   = isset($company[0]->{'emp_razao'}) 		  ? $company[0]->{'emp_razao'}             : "";
	$cidadeEmp  = isset($company[0]->{'emp_cidade'}) 		  ? $company[0]->{'emp_cidade'}            : "";
	$cnpjEmp    = isset($company[0]->{'emp_cpfcnpj'}) 		  ? $company[0]->{'emp_cpfcnpj'}           : "";
	$endEmp     = isset($company[0]->{'emp_endereco'}) 		  ? $company[0]->{'emp_endereco'}          : "";
	$foneEmp    = isset($company[0]->{'emp_fone'}) 			  ? $company[0]->{'emp_fone'}              : "";
	$faxEmp		= isset($company[0]->{'emp_fax'}) 			  ? $company[0]->{'emp_fax'}               : "";
	$fantEmp    = isset($company[0]->{'emp_fantasia'}) 		  ? $company[0]->{'emp_fantasia'}          : "";
	$bairroEmp	= isset($company[0]->{'emp_bairro'}) 		  ? $company[0]->{'emp_bairro'}            : "";
	$numEmp		= isset($company[0]->{'emp_num'}) 			  ? $company[0]->{'emp_num'}               : "";
	$ufEmp     	= isset($company[0]->{'emp_uf'}) 			  ? $company[0]->{'emp_uf'}                : "";
	$logoEmp    = isset($company[0]->{'emp_logo'}) 			  ? $company[0]->{'emp_logo'}              : "";
	$codEmp     = isset($company[0]->{'emp_codigo'}) 		  ? $company[0]->{'emp_codigo'}            : "";
	$cepEmp     = isset($company[0]->{'emp_cep'}) 			  ? $company[0]->{'emp_cep'}               : "";
	$emailEmp   = isset($company[0]->{'emp_email'})  ? $company[0]->{'emp_email'}    : "";
	$impressao  = 1;	
	
	if(isset($dados->{'doc_codigo'}) && !empty($dados->{'doc_codigo'})){
	
		$filtroDocto = '{"cod":"500670","params":[
			{"name":"database","value":"'.$TParams->getDb().'","type":"other"},
			{"name":"doc_codigo","value":"'.$dados->{'doc_codigo'}.'","type":"string"}
		]}';
		$datapacket->setHost($TParams->getHost($company[0]->{'emp_db_sge'}));
		$datapacket->add($filtroDocto);
		$ret = $datapacket->open(true);
		$datapacket->clear();

		$docNumero = $ret[0]->{'doc_numero'};
		$nomeRaz = $ret[0]->{'cad_nomeraz'};
		$cpfCnpj = $ret[0]->{'cad_cnpjcpf'};
		$descricao = $ret[0]->{'doc_obs'};
		$servico = $ret[0]->{'svc_descr'};
		$docData = $ret[0]->{'doc_data'};
		$docDataVcto = $ret[0]->{'doc_dtvcto'};
		$docCodigo = $ret[0]->{'doc_codigo'};
		$docValorPago = $ret[0]->{'doc_valorpg'};
		$docStatus = $ret[0]->{'doc_status'};
		$docValorJaPago = $ret[0]->{'doc_valor_ja_pago'};
		$docValorTotal = $ret[0]->{'doc_valor'}-$ret[0]->{'doc_desconto'};
		$docDesconto = $ret[0]->{'doc_desconto'};
		$docAbat = ($dados->{'doc_desconto'}>0) ? $dados->{'doc_desconto'} : 0;
		
		$docMulta = $dados->{'doc_multa'};
		$docJuros = $dados->{'doc_juros'};
		$diasAtraso = $dados->{'dias_atraso'};
			
		if(isset($dados->{'doc_valor'}) && !empty($dados->{'doc_valor'})){
		
			$docValor = $dados->{'doc_valor'};
			
			$docDataPgto = implode("/", array_reverse( explode("-", substr($dados->{'doc_dtpgto'}, 0, 10))));
		
		}else{
		
			$docValor = $ret[0]->{'doc_valor_ja_pago'};
			$docDataPgto = $ret[0]->{'doc_dtpgto'};

			// $time_inicial = strtotime($ret[0]->{'doc_dtvcto'});
			// $time_final = strtotime($ret[0]->{'doc_dtpgto'});
			// $date_diff = $time_final - $time_inicial;
			// $diasAtraso = (int)floor( $date_diff / (60 * 60 * 24));
		}
		
		$diasAtraso = $dados->{'dias_atraso'};
		if($diasAtraso > 0 || $ret[0]->{'dias_atraso'}>0){

			if($docStatus == 1){

				$docValorJuros = $ret[0]->{'doc_jurospg'};
				$docValorMulta = $ret[0]->{'doc_multapg'};
				/*
				$saldo = $ret[0]->{'doc_valoratt'} - $docValorPago;
				$time_inicial_juros = strtotime($docDataPgto);
				$time_final_juros = strtotime(date('Y-m-d'));
				$date_diff_juros = $time_final_juros - $time_inicial_juros;
				$dias_atraso_juros = (int)floor( $date_diff_juros / (60 * 60 * 24));
				*/
				if($dias_atraso_juros > 0){
                    $docValorJuros = (($saldo * $docJuros) / 100) * $dias_atraso_juros; 
                	$docValorTotal = $ret[0]->{'doc_valoratt'} + $docValorJuros;
                }else{
                	$docValorTotal = $ret[0]->{'doc_valoratt'};
                }

			}else{

				$docValorJuros = 0;
                $docValorJuros = (isset($dados->{'doc_juros'})) ? $dados->{'doc_juros'} : $ret[0]->{'doc_jurospg'}; 
				$docValorMulta = (isset($dados->{'doc_multa'})) ? $dados->{'doc_multa'} : $ret[0]->{'doc_multapg'};
                $docValorTotal = $ret[0]->{'doc_valor'}-$ret[0]->{'doc_desconto'}+$docValorJuros+$docValorMulta;
			}

		}
		if($docAbat==0 && $docStatus==2 && $docValorJaPago<$docValorTotal){
			$docAbat = $docValorTotal-$docValorJaPago;
		}

		if(substr($docNumero, 0, 3) == "CTT"){
			
			$tamNumFat = strlen($docNumero);
			$ctt_numero = substr($docNumero,3,$tamNumFat-3);
			if(strstr($ctt_numero,"-")){
				$arrayNumFat = explode("-",$ctt_numero);	
				$ctt_numero = $arrayNumFat[0];
			}
			
			$filtroContrato = '{"cod":"500830","params":[
				{"name":"ctt_codigo","value":"'.$ctt_numero.'","type":"other"}
			]}';
			$datapacket->clear();
			$datapacket->setHost($TParams->getHost($company[0]->{'emp_db_sge'}));
			$datapacket->add($filtroContrato);
			$retContrato = $datapacket->open(true);
			
			$ctt_dataini = isset($retContrato[0]->{'ctt_dataini'}) ? $retContrato[0]->{'ctt_dataini'} : "";
			$ctt_datafim = isset($retContrato[0]->{'ctt_datafim'}) ? $retContrato[0]->{'ctt_datafim'} : "";
		}
		
	} else {

		$company[0]->{'emp_modelo_imp'} = 0;

		$nomeRaz = ""; 
		if(isset($dados->{'cad_nomeraz'}) && !empty($dados->{'cad_nomeraz'})){
			$nomeRaz = $dados->{'cad_nomeraz'}; 
		}else if(isset($dados->{'cad_snomefant'}) && !empty($dados->{'cad_snomefant'})){
			$nomeRaz = $dados->{'cad_snomefant'}; 
		}

		$cpfCnpj = ""; 
		if(isset($dados->{'cad_cnpjcpf'}) && !empty($dados->{'cad_cnpjcpf'})){
			$cpfCnpj = $dados->{'cad_cnpjcpf'}; 
		}

		$descricao = ""; 
		if(isset($dados->{'descricao'}) && !empty($dados->{'descricao'})){
			$descricao = $dados->{'descricao'}; 
		}

		$docValor = ""; 
		if(isset($dados->{'valor'}) && !empty($dados->{'valor'})){
			$docValor = $dados->{'valor'};
		}

	}

	$tipoImpresso = "";
	if(isset($dados->{'tipo'}) && !empty($dados->{'tipo'})){
		$tipoImpresso = $dados->{'tipo'};
	}
	
	$valorExtenso = extenso($docValor);

	?>

	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">
		
		<head>
		
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		
			<title><?php echo $razaoEmp; ?></title>

		</head>
		
		<body style="font-family:Calibri; font-size:16px;">
		
			<?php 

				// modelo paisagem com assinatura do cliente
				if($company[0]->{'emp_modelo_imp'} == 0){ 
					
					// comprovante
					if(isset($tipoImpresso) && $tipoImpresso == "comprovante"){ 

						?>
			
							<div style="width:100%;margin:0 auto; border:2px solid #1A1A1A; font-size:18px; overflow:hidden;padding-bottom:10px;">
								
								<div style="float:left; width:100%; margin:10px 0px 0px 0px; font-size:23px;">
									<div style="float:left; margin:0 20px">
										
										<?php 

											if(!empty($logoEmp)){

												?>
										
													<img src="http://<?php echo $_SERVER['SERVER_NAME']; ?>/uploads/<?php echo $codEmp; ?>/<?php echo $logoEmp; ?>" style="height:50px;">

												<?php

											} else {

												echo "&nbsp";

											} 

										?>
								
									</div>
							
									<div style="float:left; width:30%; text-align:right;"> 
										
										<span> COMPROVANTE </span>

									</div>
									
									<div style="float:left; width:40%; text-align:center; font-size:24px;"> 
										
										<div style="float:left; width:96.5%; text-align:right"> 

											R$ 
											
											<span style="background-color:#CCC; margin-top:-20px; font-size:20px; padding:1px 30px"> 
											
												<?php 
									
													if($docValor != 0){
														echo number_format($docValor, 2, ',', '.'); 
													}else{
														echo "";
													}
												?>

											</span>

										</div>
									
									</div>

								</div>	

								<div style="float:left; width:100%; line-height:25px; margin: 15px 0px 0px 10px; font-weight:bold">
								
									Atesto que recebi da:
								
								</div>
								
								<div style="float:left; width:100%; line-height:25px; margin: 10px 0px 0px 10px; font-size:16px">
								
									<span>
										<?php 
											if ($company[0]->{'emp_titulo'} == 2) {
												echo $fantEmp."&nbsp;&nbsp;&nbsp;&nbsp;"; 
											} else {
												echo $razaoEmp."&nbsp;&nbsp;&nbsp;&nbsp;"; 
											}
										?>
									</span>

									<span style="font-weight:bold">
										CNPJ:
									</span>

									<span>
										<?php echo maskCNPJCPF($cnpjEmp)."&nbsp;"; ?>
									</span>
								
								</div>

								<div style="float:left; width:100%; margin: 15px 0px 0px 10px;">
								
									<div style="float:left; width:22%; font-weight:bold">
								
										A quantia de: 
								
									</div>
								
									<div style="float:left; width:96%; border-bottom:1px solid #000; padding-left:5px">
								
										<?php echo !empty($valorExtenso) ? $valorExtenso : "&nbsp"; ?>
								
									</div>
								
								</div>

								<div style="float:left; width:100%; margin-top: 15px; padding-left: 10px;">
								
									<?php

										if(!empty($descricao)){

												?>

													<div style="float:left; width:100%;">
													
														<div style="float:left; width:32%; font-weight:bold">
													
															Correspondente a: 
													
														</div>
													
													</div>

													<div style="float:left; width:96%; margin-top:5px; border-bottom:1px solid #000; ">
													
														<span>

															<?php echo $descricao; ?>

														</span>
												
													</div>

												<?php

										} else {

											echo "&nbsp";
										}

									?>

								</div>

								<div style="float:left; width:100%; margin: 20px 0px 0px 10px; font-size: 14px;">
								
									<div style="float:left; width:100%; line-height:25px; font-weight:bold">
								
										<?php echo $cidadeEmp.", ".date("d/m/Y");?>
								
									</div>
								
									<div style="float:left; width:100%; line-height:25px; margin: 0px 0px 0px 0px;">
								
										<div style="float:left; width:300px; margin:0px 0px 0px 0px; border-bottom:1px solid #000">&nbsp</div>
								
									</div>
								
									<div style="float:left; width:100%; line-height:25px; margin: 5px 0px 0px 0px;">
								
										<div style="float:left; margin:0px 10px 0px 0px;">
								
											<?php echo $nomeRaz; ?>
								
										</div> 
								
										<div style="float:left; width:200px;">
								
											<?php if(!empty($cpfCnpj)){echo " - ".maskCNPJCPF($cpfCnpj);}?>
								
										</div>
								
									</div>
								
								</div>

							</div>
						
						<?php

					// Recibo 
					}else{

						?>
					
							<div style="float:left; width:100%; margin:0 auto; border:2px solid #1A1A1A;">
								
								<div style="float:left; width:150px; height:44px; margin:10px 0px 0px 10px;">
								
									<div style="float:left;">
										
										<?php 

											if(!empty($logoEmp)){

												?>
										
													<img src="http://<?php echo $_SERVER['SERVER_NAME']; ?>/uploads/<?php echo $codEmp; ?>/<?php echo $logoEmp; ?>" style="height:50px;">

												<?php

											} else {

												echo "&nbsp";

											} 

										?>
								
									</div>
								
								</div>
								
								<div style="float:left; width:150px; height:44px; line-height:44px; margin: 0px 0px 0px 5px;">
								
									<span style="font-size:23px;">RECIBO</span>
								
								</div>
								
								<div style="float:left; width:40px; height:44px; line-height:44px; margin: 5px 0px 0px 0px;">
								
									<span style="font-size:26px;">R$</span>
								
								</div>			
								
								<div style="float:left; width:123px; height:25px; margin:15px 0px 0px 0px; text-align:center; background-color:#cccccc">
								
									<span style="color:#000; font-size:20px; line-height:25px; padding:5px;">
								
										<?php 
								
											if($docValor != 0){
								
												echo number_format($docValor, 2, ',', '.'); 
								
											}else{
								
												echo "";
								
											}
								
										?>
								
									</span>
								
								</div>
								
								<div style="float:left; width:100%; line-height:25px; margin: 20px 0px 0px 10px;">
								
									<div style="float:left; width:100%;">
								
										<?php 

											if ($company[0]->{'emp_titulo'} == 2) {
												echo $fantEmp."&nbsp;&nbsp;&nbsp;&nbsp;CNPJ:&nbsp;". maskCNPJCPF($cnpjEmp)."&nbsp;"; 
											} else {
												echo $razaoEmp."&nbsp;&nbsp;&nbsp;&nbsp;CNPJ:&nbsp;". maskCNPJCPF($cnpjEmp)."&nbsp;"; 
											}
										?>
								
									</div>
								
								</div>
								
								<div style="float:left; width:100%; line-height:25px; margin:0px 0px 0px 10px;">
								
									<div style="float:left; width:100%;">
								
										<?php echo $endEmp."&nbsp;&nbsp;&nbsp;".$numEmp; ?>
								
									</div>
								
									<div style="float:left; width:100%;">
								
										<?php echo $bairroEmp." ".$cidadeEmp." ".telefone($foneEmp); ?>
								
									</div>
								
								</div>
								
								<div style="float:left; width:90%; margin:10px 0px 0px 10px;">
								
									RECEBEMOS de <?php echo $nomeRaz; ?> - CPF/CNPJ:&nbsp; <?php echo maskCNPJCPF($cpfCnpj); ?>
								
								</div>
								
								<div style="float:left; width:100%; margin:10px 0px 0px 10px;">

									<div style="float:left; width:200px; line-height:25px; margin:0px 0px 0px 0px;">
									
										a quantia de 
									
									</div>
									
									<div style="float:left; width:96%; margin:0px 0px 0px 0px; background-color:#cccccc;overflow:hidden">
									
										<span style="color:#000; font-size:20px; line-height:25px; padding:5px;">
									
											<?php echo $valorExtenso; ?>
									
										</span>
									
									</div>

								</div>
								
								<div style="float:left; width:100%; line-height:25px; margin:5px 0px 0px 5px;">
								
									<div style="float:left; width:100%;">
								
										<?php 
								
											if(isset($docNumero) && !empty($docNumero)){
								
												if(!empty($descricao)){
								
													echo "Correspondente ao documento nº ".$docNumero." / ".$descricao;
								
												}else{
								
													echo "Correspondente ao documento nº ".$docNumero;

												}
								
											}else{
								
												echo !empty($descricao) ? "Correspondente a - ".$descricao : "&nbsp";
								
											}
								
										?>
								
									</div>
								
								</div>
								
								<div style="float:left; width:100%; height:15px; margin: 10px 0px 0px 10px;">
								
									<?php echo isset($servico) ? $servico : ""; ?>
								
								</div>
								
								<div style="float:left; width:100%; margin:10px 0px 20px 10px;">

									<div style="float:left; width:100%; ">
									
										Assinatura ________________________________________________
									
									</div>
									
									<div style="float:left; width:100%; margin-top: 10px">
									
										<?php echo $cidadeEmp . " &nbsp; (".$ufEmp.")" ; ?> &nbsp; - <?php echo date("d/m/Y");?>
									
									</div>

								</div>
							
							</div>
					
						<?php 

					} 

				// modelo retrato com exibição dos valores do documento
				}else{ 

					?>
				
						<div style="font-size:28px !important; font-weight:bold; width:100%; font-family: Calibri !important">
						
							<div style="float:left; width:100%; margin:0px 0px 20px 0px">
								
								<img src="http://<?php echo $_SERVER['SERVER_NAME']; ?>/uploads/<?php echo $codEmp; ?>/<?php echo $logoEmp; ?>">
							
							</div>
							
							<div style="float:left; width:100%;"> 
								<?php 
									if ($company[0]->{'emp_titulo'} == 2) {
										echo $fantEmp;
									} else {
										echo $razaoEmp;
									}

								?>  
							</div>
							
							<div style="float:left; width:100%;">
								<?php echo $endEmp." - ".$numEmp;  ?>
							</div>
							
							<div style="float:left; width:100%;"> 
								<?php echo $cidadeEmp." - ".$ufEmp." | CEP: ".cep($cepEmp); ?>
							</div>
							
							<div style="float:left; width:100%;"> 
								<?php
									echo "Telefone: ".telefone($foneEmp);
									echo ( isset($faxEmp) && $faxEmp!="" ) ? " | ".telefone($faxEmp) : "";
								?>
							</div>
							
							<div style="float:left; width:100%;"> 
								<?php echo "Email: ".strtolower($emailEmp); ?>
							</div>
							
							<?php 

								if(!empty($docNumero)){ 

									?>
							
										<div style="float:left; margin:10px 0px 10px 0px; width:100%;">
											---------------------------------------------------
											<div>
												<span style="margin:0px 0px 0px 0px;"><?php echo date("d/m/Y H:i:s");?> </span> 
												<span style="margin:0px 0px 0px 100px;"> Nº <?php echo $docCodigo; ?> </span> 
											</div>
											<div style="margin:20px 0px; float:left; text-align:center; width:600px;">
												COMPROVANTE DE BAIXA DE DOCUMENTO
											</div>
										</div>
										
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Nome: <?php echo $nomeRaz;  ?>
										</div>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											CPF/CNPJ: <?php echo maskCNPJCPF($cpfCnpj);  ?>
										</div>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Data Vencimento: <?php echo data($docDataVcto); ?>
										</div>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Data Pagamento: <?php if(isset($dados->{'doc_valor'})){echo $docDataPgto;}else{echo data($docDataPgto);} ?>
										</div>
										<?php if(isset($ctt_dataini)&&!empty($ctt_dataini)){ ?>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Data Evento: <?php 
												if(isset($ctt_dataini)&&!empty($ctt_dataini)){ 
													echo data($ctt_dataini);
												}else{ 
													echo "";
												} 
											?>
										</div>
										<?php } ?>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Data Emissão: <?php 
												if(isset($ctt_datafim)&&!empty($ctt_datafim)){ 
													echo data($ctt_datafim);
												}else{ 
													echo data($docData);
												}
											?>
										</div>
										<?php
											if(isset($dados->{'forma_pgto'})){
												echo '<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> Forma de Pagamento: '.$dados->{'forma_pgto'}.'</div>';
											}
										?>
										<?php if(isset($descricao) && $descricao!=""){ ?>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Descrição: <?php echo $descricao; ?>
										</div>
										<?php } ?>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Valor Original: <?php echo valorFormat($ret[0]->{'doc_valor'}); ?>
										</div>
										<?php if(isset($docDesconto) && $docDesconto>0){ ?>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Valor do Desconto: <?php echo valorFormat($docDesconto);  ?>
										</div>
										<?php } ?>
										<?php if(isset($diasAtraso) && $diasAtraso>0){ ?>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Dias Atraso: <?php echo !empty($diasAtraso) ? $diasAtraso : 0; ?>
										</div>
										<?php } ?>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Valor da Multa: <?php echo isset($docValorMulta)?valorFormat($docValorMulta):'0,00'; ?>
										</div>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Valor da Mora: <?php echo isset($docValorJuros)?valorFormat($docValorJuros):'0,00'; ?>
										</div>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Valor Total: <?php echo valorFormat($docValorTotal);  ?>
										</div>
										<?php if(isset($docValorJaPago) && $docValorJaPago>0){ ?>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Valor Já Pago: <?php echo valorFormat($docValorJaPago);  ?>
										</div>
										<?php } ?>
										<?php if(isset($docAbat) && $docAbat>0){ ?>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Abatimento: <?php echo valorFormat($docAbat);  ?>
										</div>
										<?php } ?>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											<?php 
												if(isset($dados->{'doc_valor'}) && !empty($dados->{'doc_valor'})){
													echo "Valor Pago: ".valorFormat($docValor);
												}
											?>
										</div>
									
									<?php 

								}else{ 

									?>
							
										<div style="float:left; margin:10px 0px 10px 0px; width:100%;">
											---------------------------------------------------
											<div>
												<span style="margin:0px 0px 0px 0px;"> <?php echo date("d/m/Y H:i:s"); ?> </span> 
											</div>
											<div style="margin:20px 0px; float:left; text-align:center; width:600px;">
												COMPROVANTE DE RECEBIMENTO
											</div>
										</div>
										
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Nome: <?php echo $nomeRaz;  ?>
										</div>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											CPF/CNPJ: <?php echo $cnpjEmp; ?>
										</div>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Descrição: <?php echo utf8_encode($descricao); ?>
										</div>
										<div style="float:left; margin:0px 0px 7px 0px; width:100%;"> 
											Valor: <?php echo valorFormat($docValor); ?>
										</div>
							
									<?php 
								} 
							?>
						
						</div>

					<?php 
				} 

			?>
			
		</body>

	</html>

	<?php
	
	$html = ob_get_clean();
	
	if(!is_dir($TParams->getHostRoot()."tmp/")){
		mkdir($TParams->getHostRoot()."tmp/", 0777, true);
	}

	$arquivo = str_replace(array(".",","), "", microtime(true));
	$fp = fopen($TParams->getHostRoot()."tmp/".$arquivo.'.html', 'w');
	fwrite($fp, $html);
	fclose($fp);
	if($company[0]->{'emp_modelo_imp'} == 0){ 
		exec($TParams->getHostRoot().'class/phantomjs/bin/phantomjs '.$TParams->getHostRoot().'class/phantomjs/rasterizeRecibo.js '.$TParams->getHostRoot().'tmp/'.$arquivo.'.html '.$TParams->getHostRoot().'tmp/'.$arquivo.'.pdf ["7,5in*5in"]');
	}else{
		exec($TParams->getHostRoot().'class/phantomjs/bin/phantomjs '.$TParams->getHostRoot().'class/phantomjs/rasterizeReciboTermico.js '.$TParams->getHostRoot().'tmp/'.$arquivo.'.html '.$TParams->getHostRoot().'tmp/'.$arquivo.'.pdf ["7,5in*5in"]');
	}

	if(file_exists($TParams->getHostRoot()."tmp/".$arquivo.'.pdf')){
		echo $TParams->HostClient."/tmp/".$arquivo.'.pdf';
	}else{
		echo "Ocorreu um erro ao gerar o arquivo.";
	}


?>