<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include('../php/TParams.class.php');
	include('../php/funcoes.php');

	$datapacket = new TParams();
	$empresa = $datapacket->getCompany();

	if(!isset($_POST['dados']) || empty($_POST['dados'])){
		exit("erro de parametro");
	}

	$dados = json_decode(base64_decode($_POST['dados']));

	$doc_pagrec = "";
	$lan_dc = "";
	$tpcliente = "";
	$cad_codvend = "";
	$vendedor = "";
	$labelVendedor = "";		
	if(!empty($dados->{'sistema'}) && $dados->{'sistema'} != "Novo Registro"){
		$doc_pagrec = $dados->{'sistema'};	
		$lan_dc = $dados->{'sistema'};	
		if($dados->{'sistema'} == 1){
			$pagarece = " (CONTAS A PAGAR)";
			$tpcliente = "CREDORES";
		}else{
			$pagarece = " (CONTAS A RECEBER)";
			$tpcliente = "DEVEDORES";
			$vendedor = "";
			$labelVendedor = "TODOS VENDEDORES";
			if(!empty($dados->{'vendedor'}) && $dados->{'vendedor'} != "Novo Registro"){
				$cad_codvend .= " and b.cad_codvend = '".$dados->{'vendedor'}."'";
				$labelVendedor = "VENDEDOR: ";
				$vendedor = $dados->{'vendedor_nome'};
			}
		}
	}

	$doc_status = " and a.doc_status = 4";
	$status = "AGRUPADOS";	


	$doc_numero = "";
	if(isset($dados->{'numero'}) && !empty($dados->{'numero'})){
		$doc_numero = " and a.doc_numero like '".$dados->{'numero'}."%'";	
	}

	$doc_tipo = "";
	if(!empty($dados->{'tipo'}) && $dados->{'tipo'} != "Novo Registro"){
		$aux = $dados->{'tipo'};
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i == 0){
				$aux2 .= "'".$aux[$i]."'"; 
			}else{
				$aux2 .= ", '".$aux[$i]."'"; 
			}
		}
		$doc_tipo = " and a.doc_tipo in (".$aux2.")";	
	}

	$cad_codigo = "";
	if(!empty($dados->{'beneficiario'}) && $dados->{'beneficiario'} != "Novo Registro"){
		$aux = $dados->{'beneficiario'};
		$aux2 = "";
		$j=count($aux)-1;
		for($i=0;$i<count($aux);$i++){
			if($j < count($aux)){
				$aux2 .= "'".$aux[$i]."'"; 
			}else{
				$aux2 .= ", '".$aux[$i]."'"; 
			}
			$j++;
		}
		$cad_codigo = " and b.cad_codigo in (".$aux2.")";	
	}


		//---- Numero
	$doc_numero = "";
	if(isset($dados->{'numero'}) && !empty($dados->{'numero'})){
		$doc_numero = " and a.doc_numero like '".$dados->{'numero'}."%'";	
	}
		//----

		//---- valor
	$doc_valor = "";
	$lan_valor = "";
	$valores = "TODOS";
	if(!empty($dados->{'valor_ini'}) && $dados->{'valor_ini'} != "Novo Registro"){
		$doc_valor = " and a.doc_valor >= ".str_replace(",",".",$dados->{'valor_ini'});
		$lan_valor = " and lan_valor >= ".str_replace(",",".",$dados->{'valor_ini'});
		$valores = "DE R$ ".valorFormat($dados->{'valor_ini'});
		if(!empty($dados->{'valor_fim'}) && $dados->{'valor_fim'} != "Novo Registro"){
			$doc_valor .= " and a.doc_valor <= ".str_replace(",",".",$dados->{'valor_fim'});
			$lan_valor .= " and lan_valor <= ".str_replace(",",".",$dados->{'valor_fim'});
			$valores .= " ATÉ R$ ".valorFormat($dados->{'valor_fim'});
		}
	}else{
		if(!empty($dados->{'valor_fim'}) && $dados->{'valor_fim'} != "Novo Registro"){
			$doc_valor = " and a.doc_valor <= ".str_replace(",",".",$dados->{'valor_fim'});
			$lan_valor .= " and lan_valor <= ".str_replace(",",".",$dados->{'valor_fim'});
			$valores .= " ATÉ R$ ".valorFormat($dados->{'valor_fim'});
		}
	}
		//----
		//--- data
	$doc_data = "";
	$periodo_data_ini = "01/01/2000";
	$periodo_data_fim = date('d/m/Y');
	$data_doc = "";
	if(!empty($dados->{'data_ini'}) && $dados->{'data_ini'} != "Novo Registro"){
		$doc_data =  " and a.doc_data >= '".dataBd($dados->{'data_ini'})." 00:00:00'";	
		$periodo_data_ini = data($dados->{'data_ini'});
		$data_doc = "DE ".data($dados->{'data_ini'});
		if(!empty($dados->{'data_fim'}) && $dados->{'data_fim'} != "Novo Registro"){
			$doc_data .= " and a.doc_data <= '".dataBd($dados->{'data_fim'})." 23:59:59'";
			$periodo_data_fim .= data($dados->{'data_fim'});
			$data_doc .= " ATÉ ".data($dados->{'data_fim'});
		}
	}else{
		if(!empty($dados->{'data_fim'}) && $dados->{'data_fim'} != "Novo Registro"){
			$doc_data = " and a.doc_data <= '".dataBd($dados->{'data_fim'})." 23:59:59'";
			$periodo_data_fim .= data($dados->{'data_fim'});
			$data_doc = " ATÉ ".data($dados->{'data_fim'});
		}
	}
	if($doc_data == ""){
		$data_doc = "TODAS";
	}
		//---- 
		//---- vencimento
	$doc_dtvcto = "";
	$vencimento_doc = "TODAS";
	if(!empty($dados->{'vencimento_ini'}) && $dados->{'vencimento_ini'} != "Novo Registro"){
		$doc_dtvcto = " and a.doc_dtvcto >= '".dataBd($dados->{'vencimento_ini'})." 00:00:00'";	
		$vencimento_doc = "DE ".data($dados->{'vencimento_ini'});
		if(!empty($dados->{'vencimento_fim'}) && $dados->{'vencimento_fim'} != "Novo Registro"){
			$doc_dtvcto .= " and a.doc_dtvcto <= '".dataBd($dados->{'vencimento_fim'})." 23:59:59'";	
			$vencimento_doc .= " ATÉ ".data($dados->{'vencimento_fim'});
		}
	}else{
		if(!empty($dados->{'vencimento_fim'}) && $dados->{'vencimento_fim'} != "Novo Registro"){
			$doc_dtvcto = " and a.doc_dtvcto <= '".dataBd($dados->{'vencimento_fim'})." 23:59:59'";	
			$vencimento_doc = "ATÉ ".data($dados->{'vencimento_fim'});
		}
	}
		//----
		//---- pagamento
	$doc_dtpgto = "";
	$lan_data = "";
	$pagamento_doc = "TODAS";
	if(!empty($dados->{'pagamento_ini'}) && $dados->{'pagamento_ini'} != "Novo Registro"){
		$doc_dtpgto = " and e.lan_dtmov >= '".dataBd($dados->{'pagamento_ini'})." 00:00:00'";	
		$lan_data = " and lan_dtmov >= '".dataBd($dados->{'pagamento_ini'})." 00:00:00'";	
		$pagamento_doc = "DE ".data($dados->{'pagamento_ini'});
		if(!empty($dados->{'pagamento_fim'}) && $dados->{'pagamento_fim'} != "Novo Registro"){
			$doc_dtpgto .= " and e.lan_dtmov <= '".dataBd($dados->{'pagamento_fim'})." 23:59:59'";	
			$lan_data .= " and lan_dtmov <= '".dataBd($dados->{'pagamento_fim'})." 23:59:59'";	
			$pagamento_doc .= " ATÉ ".data($dados->{'pagamento_fim'});
		}
	}else{
		if(!empty($dados->{'pagamento_fim'}) && $dados->{'pagamento_fim'} != "Novo Registro"){
			$doc_dtpgto = " and e.lan_dtmov <= '".dataBd($dados->{'pagamento_fim'})." 23:59:59'";	
			$lan_data = " and lan_dtmov <= '".dataBd($dados->{'pagamento_fim'})." 23:59:59'";	
			$pagamento_doc = "ATÉ ".data($dados->{'pagamento_fim'});
		}
	}
		//----
		//---- plano de contas
	$plc_codigo = "";
	$plc_descr = "TODOS";
	if(!empty($dados->{'plc_codigo'}) && $dados->{'plc_codigo'} != "Novo Registro"){
		$plc_codigo = " and a.plc_codigo = '".$dados->{'plc_codigo'}."'";
		$plc_descr = $dados->{'plc_descr'};
	}
		//----
		//---- centro de custo
	$ccu_codigo = "";
	$ccu_descr = "TODOS";
	if(!empty($dados->{'ccu_codigo'}) && $dados->{'ccu_codigo'} != "Novo Registro"){
		$ccu_codigo = " and a.ccu_codigo = '".$dados->{'ccu_codigo'}."'";
		$ccu_descr = $dados->{'ccu_descr'};
	}
		//----
		//---- ordenação
	if($dados->{'asc_desc'} == 1){
		$asc_desc = "asc";	
	}else{
		$asc_desc = "desc";
	}

	$ordenacao = "";
	if(!empty($dados->{'ordenar'}) && $dados->{'ordenar'} != "Novo Registro"){
		if($dados->{'ordenar'} == 1){
			$ordenacao = "order by a.doc_dtvcto ".$asc_desc;
		}else if($dados->{'ordenar'} == 2){
			$ordenacao = "order by b.cad_nomeraz ".$asc_desc;
		}else if($dados->{'ordenar'} == 3){
			$ordenacao = "order by a.doc_numero ".$asc_desc;
		}else if($dados->{'ordenar'} == 4){
			$ordenacao = "order by a.doc_valor ".$asc_desc;
		}else if($dados->{'ordenar'} == 5){
			$ordenacao = "order by e.lan_dtmov ".$asc_desc;
		}else if($dados->{'ordenar'} == 6){
			$ordenacao = "order by a.doc_nossonumero ".$asc_desc;
		}
	}

	$filtro = '{"cod":"500582", "params":[
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
		{"name":"doc_pagrec","value":"'.$doc_pagrec.'","type":"integer"},
		{"name":"doc_numero","value":"'.$doc_numero.'","type":"other"},
		{"name":"doc_valor","value":"'.$doc_valor.'","type":"other"},
		{"name":"doc_data","value":"'.$doc_data.'","type":"other"},
		{"name":"doc_dtpgto","value":"'.$doc_dtpgto.'","type":"other"},
		{"name":"doc_dtvcto","value":"'.$doc_dtvcto.'","type":"other"},
		{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"other"},
		{"name":"cad_codvend","value":"'.$cad_codvend.'","type":"other"},
		{"name":"doc_tipo","value":"'.$doc_tipo.'","type":"other"},
		{"name":"doc_status","value":"'.$doc_status.'","type":"other"},
		{"name":"ccu_codigo","value":"'.$ccu_codigo.'","type":"other"},
		{"name":"plc_codigo","value":"'.$plc_codigo.'","type":"other"},
		{"name":"lan_dtmov","value":"'.$lan_data.'","type":"other"},
		{"name":"ordenacao","value":"'.$ordenacao.'","type":"other"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	$cnt = $datapacket->getRecordCount();
	$datapacket->clear();


	$titulo = utf8_decode("RELATÓRIO DE BOLETOS AGRUPADOS PELO SISTEMA");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $empresa->emp_codigo . "/" . $empresa->emp_logo;

	include("./inc/relatorioCabecalho.php");

	$filtros = '';

	$colunas = '';

	if($cnt > 0){

		?>
			<div class="informacaoColuna">
				<div style="float:left; width:20%; text-align:left;">CLIENTE</div>
				<div style="float:left; width:8%; text-align:right;">VENCIMENTO</div>
				<div style="float:left; width:15%; text-align:right;">VALOR R$</div>
				<div style="float:left; width:15%; text-align:right; padding-right: 4%">NÚMERO DOC.</div>
				<div style="float:left; width:33%; text-align:left;">OBSERVAÇÃO</div>
			</div>

		<?php

		foreach($rowdata as $i=>$unificado){

			if($i % 2 == 0){
				$backCor = "#F7F7F7";
			}else{
				$backCor = "#fff";
			}
			
			?>

				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>;">
					<div style="width:20%; float:left; text-align:left; padding-left:0.5%;"><?php echo $unificado->{'cad_nomeraz'};?></div>
					<div style="width:8%;  float:left; text-align:right;"><?php echo data($unificado->{'doc_dtvcto'});?></div>
					<div style="width:15%; float:left; text-align:right;"><?php echo valorFormat($unificado->{'doc_valor'});?></div>
					<div style="width:15%; float:left; text-align:right; padding-right: 4%"><?php echo $unificado->{'doc_numero'};?></div>
					<div style="width:33%; float:left; text-align:left;"><?php echo substr($unificado->{'doc_descr'},0,70);?></div>
				</div>

			<?php
		}
	}else{

		?>
		<div style="float:left; width:100%; margin:50px 0px 10px 0px; padding:3px 0px; text-align:center;font-weight:bold">Nenhum Resultado para sua pesquisa</div>

		<?php
	}
	include "inc/relatorioRodape.php";

?>