<?php
	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';

	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	$totalNotas = 0;
	$totalValor = 0;
	$totalGeralNotas = 0;
	$totalGeralValor = 0;
	
	$dados  = json_decode(base64_decode($_REQUEST['dados']));
	
	$mun_codigo = "";
	if(isset($dados->cidades) && !empty($dados->cidades)){
		$cidades = $dados->cidades;
		$str = "";
		for($i=0;$i<count($cidades);$i++){
			if($i==0){
				$str .= "'".$cidades[$i]."' ";
			}else{
				$str .= ",'".$cidades[$i]."'";
			}
		}
		$mun_codigo = " and d.mun_codigo in (".$str.")";
	}

	if(isset($dados->estado) && !empty($dados->estado)){
		$mun_codigo .= " and d.mun_uf_sigla = '".$dados->estado."'";
	}

	$not_data = "";
	$periodo = "TODOS";
	if(!empty($dados->{'data_ini'})){
		$not_data =	" and a.not_data >= '".$dados->{'data_ini'}."'"; 
		$periodo = "DE ".data($dados->{'data_ini'});
		if(!empty($dados->{'data_fim'})){
			$not_data .= " and a.not_data <= '".$dados->{'data_fim'}."'";
			$periodo .= utf8_decode(" ATÉ ").data($dados->{'data_fim'});
		}
	}else{
		if(!empty($dados->{'data_fim'})){
			$not_data = " and a.not_data <= '".$dados->{'data_fim'}."'";
			$periodo = utf8_decode(" ATÉ ").data($dados->{'data_fim'});
		}
	}
	
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->emp_codigo.'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();
	
	$filtro='{"cod":"500540","params":[
		{"name":"database","value":"'.$company[0]->{'emp_db_comum'}.'","type":"other"},
		{"name":"mun_codigo","value":"'.$mun_codigo.'","type":"other"},
		{"name":"not_data","value":"'.$not_data.'","type":"other"}		
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	$cnt = $Datapacket->getRecordCount();
	// echo $Datapacket->getLastQuery();
	$Datapacket->clear();
	
	$titulo = utf8_decode("RELATÓRIO DE VENDAS POR CIDADE SINTÉTICO");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
	
	include("inc/relatorioCabecalho.php");

    $cabecalhoHeight = 270;

    $estado = "TODOS";
    if (isset($dados->estado)) {
        $estado = "ESPECÍFICO";
    }

    $cidade = "TODAS";
    if (isset($dados->cidades[0])) {
        $cidade = "ESPECÍFICO(S)";
    }

    $filtro1 =  base64_encode('<div style="float:left;width: 500px"><span style="font-weight:bold;">'.utf8_decode('PERÍODO:').'</span> <span style="font-weight:normal;">'.$periodo.'</span></div>');
    $filtro2 =  base64_encode('<div style="width:20%; float:left"><span style="font-weight:bold;">ESTADO: </span>'.utf8_decode($estado).'</div>');
    $filtro3 =  base64_encode('<div style="width:20%; float:left"><span style="font-weight:bold;">CIDADE: </span>'.utf8_decode($cidade).'</div>');
    $objFiltro = new stdClass();
    $filtros = array(
        $objFiltro->filtro = $filtro1,
        $objFiltro->filtro = $filtro2,
        $objFiltro->filtro = $filtro3
    );

    $colunas = array(
        base64_encode('<div style="float:left; width:3%; margin-left:82%; text-align:right;">TOTAL</div>')
    );

	if($cnt == 0){ ?>
	
		<div style="width:100%; margin:20px auto; text-align:center;">
			SEM REGISTROS
		</div>
		
	<?php }else{

		$arrayCidade = array();
		$arrayUf = array();
		$cod_mun = '';
		$cod_uf = '';
		
		
		$arrayCli = array();
		$totalCli = 0;
		$totalProd = 0;
		$totalItens = 0;
		$totalNotas = 0;

		$totalGeralProd = 0;
		$totalGeralItens = 0;
		$totalGeralValor = 0;
		$totalGeralNotas = 0;
		$totalGeralCli = 0;
		
		for($i=0; $i<$cnt; $i++){
			if($cod_mun != $rowdata[$i]->{'mun_codigo'}){
				array_push($arrayCidade,$rowdata[$i]->{'mun_codigo'}."@".$rowdata[$i]->{'mun_cidade'}." - ".$rowdata[$i]->{'mun_uf_sigla'});
				if($cod_uf != $rowdata[$i]->{'mun_uf_sigla'}){
					array_push($arrayUf,$rowdata[$i]->{'mun_uf_sigla'});
				}
				$cod_mun = $rowdata[$i]->{'mun_codigo'};
				$cod_uf = $rowdata[$i]->{'mun_uf_sigla'};
			}
		}
		
		for($j=0; $j<count($arrayCidade); $j++){
			
			$municipio = explode("@",$arrayCidade[$j]);

			if($j%2==0){
				$backCor = "#e7e7e7";
			}else{
				$backCor = "#fff";
			}
			
			?>	
			
			<div style="width:100%; float:left; font-size:12px;">
				
				<?php
					for($k=0; $k<$cnt; $k++){

						if($municipio[0] == $rowdata[$k]->{'mun_codigo'}){
							

							$codigo = $rowdata[$k]->{'not_numero'};
							$not_data = data($rowdata[$k]->{'not_data'});
							$cdp_descr = valorVazio($rowdata[$k]->{'cdp_descr'});
							$cad_snomefant = $rowdata[$k]->{'cad_snomefant'};
							$total = valorFormat($rowdata[$k]->{'not_totalnota'});
							$cad_telefone = $rowdata[$k]->{'cad_telefone'};
							$cfop = $rowdata[$k]->{'cfo_codigo'};
							$prods = $rowdata[$k]->{'produto_qtde'};
							$itens = qtde($rowdata[$k]->{'itn_qtde'});
							
							array_push($arrayCli,$cad_snomefant);
							$totalProd+= $prods;
							$totalItens+= $itens;
							$totalValor+= $total;
							$totalNotas++;
						}

					} 
					$totalCli = count(array_unique($arrayCli));

					?>
					<div style="width:100%; float:left;margin:1px 0px 1px 0px; padding:0px 0px; background-color:<?php echo $backCor; ?>">
						<div style="font-weight:bold; float:left; width:14%;"> <?php echo $municipio[1]; ?> </div> 
						<div style="font-weight:bold; float:left; width:15%;"> TOTAL CLIENTES (<?php echo $totalCli; ?>) </div> 
						<div style="font-weight:bold; float:left; width:14%;"> NOTAS (<?php echo $totalNotas; ?>) </div> 
						<div style="font-weight:bold; float:left; width:14%;"> PRODUTOS (<?php echo qtde($totalProd); ?>) </div> 
						<div style="font-weight:bold; float:left; width:14%;"> ÍTENS (<?php echo qtde($totalItens); ?>) </div>
						<div style="font-weight:bold; float:left; width:14%; text-align: right;">  <?php echo valorFormat($totalValor); ?> </div> 
					</div>
					
					<?php
					
					$totalGeralProd+= $totalProd;
					$totalGeralItens+= $totalItens;
					$totalGeralValor+= $totalValor;
					$totalGeralNotas+= $totalNotas;
					$totalGeralCli+= $totalCli;

					$totalProd  = 0;
					$totalItens = 0;
					$totalValor = 0;
					$totalNotas = 0;
					$totalCli = 0;
					$arrayCli = array();
				?>
			
			</div> 
		
			<?php 
		}
	
		?>
			<div class="informacaoRodape_outro">
				<div style="font-weight:bold;float:left;width:14%;"> TOTAL GERAL CIDADES (<?php echo count($arrayCidade); ?>) </div> 
				<div style="font-weight:bold;float:left;width:15%;"> TOTAL CLIENTES (<?php echo $totalGeralCli; ?>) </div> 
				<div style="font-weight:bold;float:left;width:14%;"> NOTAS (<?php echo $totalGeralNotas; ?>) </div> 
				<div style="font-weight:bold;float:left;width:14%;"> PRODUTOS (<?php echo qtde($totalGeralProd); ?>) </div> 
				<div style="font-weight:bold;float:left;width:14%;"> ITENS (<?php echo qtde($totalGeralItens); ?>) </div> 
				<div style="font-weight:bold;float:left;width:14%; text-align: right;">  <?php echo valorFormat($totalGeralValor); ?> </div> 
			</div>
		<?php
	}
	
	include "../rel/inc/relatorioRodape.php";
	
?>