<?php
	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';

	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	$totalNotas = 0;
	$totalValor = 0;
	$totalGeralNotas = 0;
	$totalGeralValor = 0;
	
	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$grp_codigo = "";
	$grupo = "TODOS";
	if(isset($dados->grupo) && !empty($dados->grupo)){
		$aux = $dados->grupo;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$grp_codigo = " and c.grp_codigo in (".$aux2.")";
		$grupo = implode(' | ', $dados->grupo_descr);
	}
	
	$sgp_codigo = "";
	$subgrupo = "TODOS";
	if(isset($dados->subgrupo) && !empty($dados->subgrupo)){
		$aux = $dados->subgrupo;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$sgp_codigo = " and c.sgp_codigo in (".$aux2.")";
		$subgrupo = implode(' | ', $dados->subgrupo_descr);
	}
	
	$agr_codigo = "";
	if(isset($dados->agr_codigo) && !empty($dados->agr_codigo)){
		$agr_codigo = " and c.agr_codigo = ".$dados->agr_codigo."";
	}
	
	$mar_codigo = "";
	if(isset($dados->marca) && !empty($dados->marca)){
		$aux = $dados->marca;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$mar_codigo = " and c.mar_codigo in (".$aux2.")";
	}

	$ref_codigo = "";
	if(isset($dados->produto) && !empty($dados->produto)){
		$aux = $dados->produto;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ref_codigo = " and b.ref_codigo in (".$aux2.")";
	}
	
	$ven_codigo="";
	if(isset($dados->vendedor) && !empty($dados->vendedor)){
		$aux = $dados->vendedor;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ven_codigo = " and a.cad_codvend in (".$aux2.")";
	}
	
	$not_tipo="";
	if(isset($dados->not_tipo) && !empty($dados->not_tipo)){
		$aux = $dados->not_tipo;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$not_tipo = $aux2;
	}else{
		$not_tipo = "2,9,12,13";
	}

	$cfo_codigo = "";
	$inclurCfop = "TODOS";
	$excluirCfop = "NENHUM";
	if(isset($dados->cfop_incluir) && !empty($dados->cfop_incluir)){
		$aux = explode(", ", $dados->cfop_incluir);
		$aux2 = "";
		$j=count($aux)-1;
		for($i=0;$i<count($aux);$i++){
			if($j < count($aux)){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
			$j++;
		}
		$cfo_codigo = " and a.cfo_codigo in (".$aux2.")";
		$inclurCfop = $aux2;
	}else if(isset($dados->cfop_excluir) && !empty($dados->cfop_excluir)){
		$aux = explode(", ", $dados->cfop_excluir);
		$aux2 = "";
		$j=count($aux)-1;
		for($i=0;$i<count($aux);$i++){
			$cfo_codigo .= " and a.cfo_codigo != ".$aux[$i]; 
		}
		$excluirCfop = $aux2;
	}else{
		$cfo_codigo = "";
	}

	if(isset($dados->data_ini) && !empty($dados->data_ini)){
		$data_ini = implode("-", array_reverse(explode("/", substr($dados->data_ini,0,10))))." 00:00:00";
	}else{
		$data_ini  = "2000-01-01 00:00:00";
	}

	if(isset($dados->data_fim) && !empty($dados->data_fim)){
		$data_fim = implode("-", array_reverse(explode("/", substr($dados->data_fim,0,10))))." 23:59:59";
	}else {
		$data_fim = date('Y-m-d 23:59:59');
	}

	$valorizar = 1;
	$filtroValorizar = utf8_decode("PREÇO VAREJO");
	if(isset($dados->{'valorizar'}) && !empty($dados->{'valorizar'})){
		if($dados->{'valorizar'} == 2){
			$valorizar = 2;
			$filtroValorizar = utf8_decode("PREÇO ATACADO");
		}else if($dados->{'valorizar'} == 3){
			$valorizar = 3;
			$filtroValorizar = utf8_decode("PREÇO MÍNIMO");
		}
	}
	
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->emp_codigo.'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();
	
	//se ja existe nota para o pedido e o tipo da nota nao for mais (2 = pedido) traz a nota caso contrario traz o pedido  
	 if(strstr($not_tipo, "9") || strstr($not_tipo, "12") || strstr($not_tipo, "13")){
		$extra = $agr_codigo.' and a.not_codigo not in(select header_nota.not_codigo_pai from header_nota where LENGTH(header_nota.not_codigo_pai) > 0 and header_nota.not_tipo not in (2,7) ) ';
	 }else{
		$extra = $agr_codigo;
	}
	
	$filtro='{"cod":"500570","params":[
		{"name":"database","value":"'.$company[0]->emp_db_comum.'","type":"other"}, 
		{"name":"emp_codigo","value":"'.$company[0]->emp_codigo.'","type":"string"},
		{"name":"not_tipo","value":"'.$not_tipo.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"other"}, 
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"}, 
		{"name":"cfo_codigo","value":"'.$cfo_codigo.'","type":"other"}, 
		{"name":"ven_codigo","value":"'.$ven_codigo.'","type":"other"}, 
		{"name":"data_ini","value":"'.$data_ini.'","type":"string"}, 
		{"name":"data_fim","value":"'.$data_fim.'","type":"string"},
		{"name":"extra","value":"'.$extra.'","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	//echo $Datapacket->getLastQuery();
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();
	
	$titulo = utf8_decode("RELATÓRIO SINTÉTICO DE VENDAS POR PRODUTO");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");
	
	$filtro1 =  base64_encode('<div style="float:left;margin-right:8px;"><span style="font-weight:bold;">'.utf8_decode("PERÍODO: ")."</span> ".data($data_ini)." a ".data($data_fim).' | </div>');
	$filtro2 =  base64_encode(utf8_decode('<div style="float:left;margin-right:8px;"><span style="font-weight:bold;"> GRUPO: </span>'.$grupo.' | </div>'));
	$filtro3 =  base64_encode(utf8_decode('<div style="float:left;margin-right:8px;"><span style="font-weight:bold;"> SUBGRUPO: </span>'.$subgrupo.' | </div>'));
	$filtro4 =  base64_encode('<div style="float:left;margin-right:8px;"><span style="font-weight:bold;"> INCLUIR CFOP: </span>'.$inclurCfop.' | </div>');
	$filtro5 =  base64_encode('<div style="float:left;margin-right:8px;"><span style="font-weight:bold;"> EXCLUIR CFOP: </span>'.$excluirCfop.' | </div>');
	$filtro6 =  base64_encode('<div style="float:left;margin-right:8px;"><span style="font-weight:bold;"> VALORIZADO POR: </span>'.$filtroValorizar.'</div>');
	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = $filtro1,
		$objFiltro->filtro = $filtro2,
		$objFiltro->filtro = $filtro3,
		$objFiltro->filtro = $filtro4,
		$objFiltro->filtro = $filtro5,
		$objFiltro->filtro = $filtro6
	);

	$colunas = '';

	?>
		<div class="informacaoColuna">
			<div style="float:left; width:68%; text-align:left;"> PRODUTO </div>
			<div style="float:left; width:10%; text-align:right;"> QTDE </div>
			<div style="float:left; width:10%; text-align:right;"> TOTAL </div>
			<div style="float:left; width:10%; text-align:right;"> PMU </div>
		</div>

	<?php

	$arrayProd = array();
	$produto = "";

	$totalClientes = array();
	$totalProdutos = array();
	$totalNotas = array();
	$totalItens = 0;
	$totalQtde = 0;
	$totalTotal = 0;
	$pmu = 0;

	$totalGeralProdutos = 0;
	$totalGeralQtde = 0;
	$totalGeralClientes = 0;
	$totalGeralValor = 0;
	$totalGeralEstoque = 0;

	if($cnt > 0){
		
		for($i=0; $i<$cnt; $i++){
			if($produto != $rowdata[$i]->{'ref_codigo'}){
				array_push($arrayProd, $rowdata[$i]->{'ref_codigo'}."%".$rowdata[$i]->{'ref_descr'}."%".$rowdata[$i]->{'ref_codbar'}."%".$rowdata[$i]->{'mar_descr'}."%".$rowdata[$i]->{'ref_propriedade'}."%".$rowdata[$i]->{'stk_total'}."%".$rowdata[$i]->{'urf_precovar'}."%".$rowdata[$i]->{'urf_precoata'}."%".$rowdata[$i]->{'urf_precomin'});
				$produto = $rowdata[$i]->{'ref_codigo'};
			}
		}

		$totalGeralProdutos += count(array_unique($arrayProd));

		for($j=0;$j<count($arrayProd);$j++){
			if($j % 2 == 0){
                $backCor = "#EFEEED";
            }else{
                $backCor = "#FFF";
            }

			$aux = explode("%",$arrayProd[$j]);
			
			for($k=0;$k<count($rowdata);$k++){

				if($aux[0] == $rowdata[$k]->{'ref_codigo'}){
					array_push($totalClientes, $rowdata[$k]->{'cad_codigo'});
					array_push($totalNotas, $rowdata[$k]->{'not_codigo'});
					array_push($totalProdutos, $rowdata[$k]->{'cad_codigo'});
					$totalItens++;
					$totalQtde += $rowdata[$k]->{'itn_qtde'};
					$totalTotal += $rowdata[$k]->{'itn_subtotal'};
				}
			}
			
			$pmu = $totalTotal/$totalQtde;
			
			?>
				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>; ">
		
					<div style="width:20%; float:left;"><?php echo substr($aux[1]."&nbsp",0,40);?></div>
					<div style="width:12%; float:left;">Cod. Barras: <?php echo $aux[2]."&nbsp";?></div>			
					<div style="width:8%; float:left;">Clientes<?php echo " (".count(array_unique($totalClientes)).")";?></div>
					<div style="width:8%; float:left;">Notas<?php echo " (".count(array_unique($totalNotas)).")";?></div>
					<div style="width:10%; float:left;">Estoque atual: <?php echo qtde($aux[5])."&nbsp";?></div>
					<div style="width:10%; float:left;">Valor estoque: 
						<?php 
							$stkCalculado = 0;
							if($valorizar == 1){
								$stkCalculado = $aux[5] * $aux[6];
							}else if($valorizar == 2){
								$stkCalculado = $aux[5] * $aux[7];
							}else if($valorizar == 3){
								$stkCalculado = $aux[5] * $aux[8];
							} 
							if($stkCalculado > 0){
								$totalGeralEstoque += $stkCalculado;
							}
							echo valorFormat($stkCalculado);
						?>
					</div>
					
					<div style="width:10%; float:left; text-align:right;"><?php echo qtde($totalQtde);?></div>
					<div style="width:10%; float:left; text-align:right;"><?php echo valorFormat($totalTotal);?></div>
					<div style="width:10%; float:left; text-align:right;"><?php echo valorFormat($pmu);?></div>

				</div>

			<?php

			
			$totalGeralQtde += $totalQtde;
			$totalGeralClientes += count(array_unique($totalClientes));
			$totalGeralValor += $totalTotal;

			$totalClientes = array();
			$totalProdutos = array();
			$totalNotas = array();
			$totalItens = 0;
			$totalQtde = 0;
			$totalTotal = 0;
			$pmu = 0;
		}

		?>
			<div class="informacaoRodape_outro">
				<div style="float:left; width:20%; font-weight:bold; text-align:left"> TOTAL GERAL: Produtos <?php echo qtde($totalGeralProdutos) ;?> </div>
				<div style="float:left; width:20%; font-weight:bold; text-align:left"> Quantidade <?php echo qtde($totalGeralQtde) ;?> </div>
				<div style="float:left; width:20%; font-weight:bold; text-align:left"> Valor total <?php echo valorFormat($totalGeralValor) ;?> </div>
				<div style="float:left; width:20%; font-weight:bold; text-align:left"> Clientes <?php echo qtde($totalGeralClientes) ;?> </div>
				<div style="float:left; width:20%; font-weight:bold; text-align:left"> Estoque <?php echo valorFormat($totalGeralEstoque) ;?> </div>
			</div>
		<?php 

	}else{
		?>
		<div style="width:100%; float:left; padding:1px 0px; margin: 10px 0px 20px 400px; font-weight:bold">
			Não há resultados para a pesquisa.
		</div>
		<?php
	}
	

	include "../rel/inc/relatorioRodape.php";

?>