<?php
	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';

	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$ctg_codigo = "";
	$categoria = "TODAS";
	if(isset($dados->categoria) && !empty($dados->categoria)){
		$aux = $dados->categoria;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ctg_codigo = " and c.ctg_codigo in (".$aux2.")";
		$categoria = implode(' | ', $dados->categoria_descr);
	}
	
	$sub_codigo = "";
	$subcategoria = "TODAS";
	if(isset($dados->subcategoria) && !empty($dados->subcategoria)){
		$aux = $dados->subcategoria;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$sub_codigo = " and s.sub_codigo in (".$aux2.")";
		$subcategoria = implode(' | ', $dados->subcategoria_descr);
	}

	$svc_codigo = "";
	if(isset($dados->servico) && !empty($dados->servico)){
		$aux = $dados->servico;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$svc_codigo = " and b.svc_codigo in (".$aux2.")";
	}
	
	$ven_codigo="";
	if(isset($dados->vendedor) && !empty($dados->vendedor)){
		$aux = $dados->vendedor;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ven_codigo = " and a.cad_codvend in (".$aux2.")";
	}
	
	if(isset($dados->cliente) && !empty($dados->cliente) ){
		$aux = $dados->cliente;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ven_codigo .= " and a.cad_codigo in (".$aux2.")";
	}

	if(isset($dados->data_ini) && !empty($dados->data_ini)){
		$data_ini = implode("-", array_reverse(explode("/", substr($dados->data_ini,0,10))))." 00:00:00";
	}else{
		$data_ini  = "2000-01-01 00:00:00";
	}

	if(isset($dados->data_fim) && !empty($dados->data_fim)){
		$data_fim = implode("-", array_reverse(explode("/", substr($dados->data_fim,0,10))))." 23:59:59";
	}else {
		$data_fim = date('Y-m-d 23:59:59');
	}
	
	//se ja existe nota para o pedido e o tipo da nota nao for mais (2 = pedido) traz a nota caso contrario traz o pedido  
	//$extra = $agr_codigo.' and a.not_codigo not in(select header_nota.not_codigo_pai from header_nota where LENGTH(header_nota.not_codigo_pai) > 0 and header_nota.not_tipo not in (2,7) ) ';
	
	$filtro='{"cod":"500571","params":[
		{"name":"database","value":"'.$TParams->getCompany()->emp_db_comum.'","type":"other"},
		{"name":"emp_codigo","value":"'.$TParams->getCompany()->emp_codigo.'","type":"string"},
		{"name":"ctg_codigo","value":"'.$ctg_codigo.'","type":"other"},
		{"name":"sub_codigo","value":"'.$sub_codigo.'","type":"other"},
		{"name":"svc_codigo","value":"'.$svc_codigo.'","type":"other"},
		{"name":"ven_codigo","value":"'.$ven_codigo.'","type":"other"},
		{"name":"data_ini","value":"'.$data_ini.'","type":"string"},
		{"name":"data_fim","value":"'.$data_fim.'","type":"string"},
		{"name":"extra","value":"'.$extra.'","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($TParams->getCompany()->emp_db_sge));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	//echo $Datapacket->getLastQuery();
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();
	
	$titulo = utf8_decode("RELATÓRIO ANALÍTICO DE VENDAS POR SERVIÇO");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");
	
	$filtro1 =  base64_encode('<div style="float:left;margin-right:8px;"><span style="font-weight:bold;">'.utf8_decode("PERÍODO: ")."</span> ".data($data_ini)." a ".data($data_fim).' | </div>');
	$filtro2 =  base64_encode(utf8_decode('<div style="float:left;margin-right:8px;"><span style="font-weight:bold;"> CATEGORIA: </span>'.$categoria.' | </div>'));
	$filtro3 =  base64_encode(utf8_decode('<div style="float:left;margin-right:8px;"><span style="font-weight:bold;"> SUBCATEGORIA: </span>'.$subcategoria.'</div>'));
	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = $filtro1,
		$objFiltro->filtro = $filtro2,
		$objFiltro->filtro = $filtro3
	);
	
	$colunas = '';

	$arrayServ = array();
	$servico = "";

	$totalClientes = array();
	$totalItens = 0;
	$totalQtde = 0;
	$totalTotal = 0;
	$totalGeralQtde = 0;
	$totalGeralValor = 0;
	$totalGeralClientes = array();
	$pmu = 0;

	if($cnt > 0){
		for($i=0; $i<$cnt; $i++){
			if($servico != $rowdata[$i]->{'svc_codigo'}){
				array_push($arrayServ, $rowdata[$i]->{'svc_codigo'}."%".$rowdata[$i]->{'svc_descr'}."%".$rowdata[$i]->{'svc_valor'}."%".$rowdata[$i]->{'svc_valormin'});
				$servico = $rowdata[$i]->{'svc_codigo'};
			}
		}

		for($j=0;$j<count($arrayServ);$j++){
			$aux = explode("%",$arrayServ[$j]);
			?>
			<div class="informacaoListagem">
				<div style="width:45%; float:left;"><?php echo $aux[1]."&nbsp";?></div>
				<div style="width:15%; float:left;">CÓDIGO: <?php echo $aux[0]."&nbsp";?></div>
				<div style="width:15%; float:left;">
					Valor Base: <?php echo valorFormat($aux[2]);?>
				</div>
				<div style="width:15%; float:left;">
					Valor Mínimo: <?php echo valorFormat($aux[3]);?>
				</div>
			</div>
			<div class="informacaoColuna">
				<div style="float:left; width:25%;"> CLIENTE </div>
				<div style="float:left; width:20%;"> VENDEDOR </div>
				<div style="float:left; width:8%;"> Nº </div>
				<div style="float:left; width:8%;"> DATA </div>
				<div style="float:left; width:5%; text-align:right;"> QTDE. </div>
				<div style="float:left; width:8%; text-align:right;">UNITÁRIO</div>
				<div style="float:left; width:8%; text-align:right;">DESCONTO</div>
				<div style="float:left; width:8%; text-align:right"> TOTAL </div>
			</div>
			<?php
			$ant="";
			for($k=0;$k<count($rowdata);$k++){

				if($k % 2 == 0){
	                $backCor = "#EFEEED";
	            }else{
	                $backCor = "#FFF";
	            }

				if($aux[0] == $rowdata[$k]->{'svc_codigo'} && $ant!=$rowdata[$k]->{'not_codigo'}){
					array_push($totalClientes, $rowdata[$k]->{'cad_codigo'});
					$totalItens++;
					$totalQtde += $rowdata[$k]->{'its_qtde'};
					$totalTotal += $rowdata[$k]->{'its_subtotal'};
					?>
					<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>; margin-bottom:7px ">
						<div style="width:25%; float:left; text-align:left;"><?php echo substr($rowdata[$k]->{'cad_nomeraz'},0,36)."&nbsp";?></div>
						<div style="width:20%; float:left; text-align:left;"><?php echo substr($rowdata[$k]->{'vendedor'},0,30)."&nbsp;";?></div>
						<div style="width:8%; float:left;"><?php echo $rowdata[$k]->{'not_numero'}."&nbsp";?></div>
						<div style="width:8%; float:left; "><?php echo data($rowdata[$k]->{'not_data'}."&nbsp");?></div>
						<div style="width:5%; float:left; text-align:right;"><?php echo qtde($rowdata[$k]->{'its_qtde'})."&nbsp";?></div>
						<div style="width:8%; float:left; text-align:right;"><?php echo valorFormat($rowdata[$k]->{'its_valor'})."&nbsp";?></div>
						<div style="width:8%; float:left; text-align:right;"><?php echo valorFormat($rowdata[$k]->{'its_desc'})."&nbsp";?></div>
						<div style="width:8%; float:left; text-align:right;"><?php echo valorFormat($rowdata[$k]->{'its_subtotal'})."&nbsp";?></div>
					</div>
					<?php
					$ant=$rowdata[$k]->{'not_codigo'};
				}
			}
			$pmu = $totalTotal/$totalQtde;
			?>
			<div class="informacaoRodape">
				<div style="width:20%; float:left; text-align:left; padding-right: 17% ">Total Clientes<?php echo " (".count(array_unique($totalClientes)).")";?></div>
				<div style="width:10%; float:left; text-align:right; padding-right: 12%">Notas<?php echo " (".$totalItens.")";?></div>
				<div style="width:8%; float:left; text-align:right;"><?php echo valorFormat($totalQtde)."&nbsp";?></div>
				<div style="width:8%; float:left; text-align:right;"><span style="background-color:#f7f7f7;border:1px solid #e7e7e7">PMU:<?php echo valorFormat($pmu)."&nbsp";?></span></div>
				<div style="width:7%; float:left; text-align:right;"><?php echo valorFormat($totalTotal);?></div>
			</div>
			<?php

			$totalGeralQtde += $totalQtde;
			$totalGeralValor += $totalTotal;
			array_push($totalGeralClientes,  $rowdata[$k]->{'cad_codigo'});

			$totalClientes = array();
			$totalItens = 0;
			$totalQtde = 0;
			$totalTotal = 0;
			$pmu = 0;
		}
		$totalGeralClientes = count(array_unique($totalGeralClientes));
		?>
			<div class="informacaoRodape_outro">
				<div style="width:20%; float:left;">TOTAL GERAL: Serviços <?php echo count(array_unique($arrayServ));?></div>
				<div style="width:20%; float:left; text-align:center">Quantidade <?php echo qtde($totalGeralQtde);?></div>
				<div style="width:20%; float:left; text-align:center">Valor total R$ <?php echo valorFormat($totalGeralValor);?></div>
				<div style="width:20%; float:left; text-align:center">Clientes <?php echo qtde($totalGeralClientes);?></div>
			</div>
		<?php
	}else{
		?>
		<div style="width:100%; float:left; padding:1px 0px; margin: 10px 0px 20px 400px; font-weight:bold">
			Não há resultados para a pesquisa.
		</div>
		<?php
	}
	

	include "../rel/inc/relatorioRodape.php";

?>