<?php
	setlocale (LC_ALL, 'pt_BR.UTF-8');
	set_time_limit(900);
	include_once "../class/mpdf/mpdf.php";
	include_once "../class/useful.php";
	include_once "../class/class_calculoJuros.php";
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';

	$Datapacket = new Datapacket();
	$Useful = new Useful();
	$TParams=new TParams();

	function unescape($source, $lf, $iconv_to = 'UTF-8') {
		$source = str_replace('%0A',$lf,$source);
		$decodedStr = '';
		$pos = 0;
		$len = strlen ($source);
		while ($pos < $len) {
			$charAt = substr ($source, $pos, 1);
			if ($charAt == '%') {
				$pos++;
				$charAt = substr ($source, $pos, 1);
				if ($charAt == 'u') {
					// we got a unicode character
					$pos++;
					$unicodeHexVal = substr ($source, $pos, 4);
					$unicode = hexdec ($unicodeHexVal);
					$decodedStr .= code2utf($unicode);
					$pos += 4;
				} else {
					// we have an escaped ascii character
					$hexVal = substr ($source, $pos, 2);
					$decodedStr .= chr (hexdec ($hexVal));
					$pos += 2;
				}
			} else {
				$decodedStr .= $charAt;
				$pos++;
			}
		}

		if ($iconv_to != "UTF-8") {
			$decodedStr = iconv("UTF-8", $iconv_to, $decodedStr);
		}
		
		return $decodedStr;
	}
	
	$doc_codigo = json_decode($_REQUEST["doc_codigo"]);

	if( is_array($doc_codigo)){
		foreach($doc_codigo as $c) $codigos.= "'".$c."', ";
		$codigos = substr($codigos, 0, -2);
	}else{
		$codigos="'".$_REQUEST["doc_codigo"]."'";
	}
	
	//empresa
	$company = $TParams->getCompany();	

	//docto
	$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
	$filtro = '{"cod":"500480","params":[
		{"name":"doc_codigo","value":"'.$codigos.'","type":"other"},
		{"name":"database","value":"'.$company->{'emp_db_comum'}.'","type":"other"}
	]}';
	$Datapacket->add($filtro);
	$doctos = $Datapacket->open(true);
	$Datapacket->clear();

	if(count($doctos)>0){
		//tipo
		if($doctos[0]->{'doc_tipo'}==2 || $doctos[0]->{'doc_tipo'}==14){
			//carteira
			if(isset($doctos[0]->{'doc_carteira'}) && $doctos[0]->{'doc_carteira'}!=""){
				//Banco selecionado
				$emp_bancos = json_decode(base64_decode($company->{'emp_bancos'}));

				foreach($emp_bancos as $banco){
					if($banco->{"carteira"}==$doctos[0]->{'doc_carteira'}){
						$bancos = $banco;
					}
					$banco = (array) $banco;
					if($banco["carteira"]==$doctos[0]->{'doc_carteira'}){
						$bancoSel = $banco;
					}
				}
				
				if(!isset($bancoSel)){
					foreach($emp_bancos as $banco){
						if($banco->{"carteira"}."-".$banco->{"variacao"}==$doctos[0]->{'doc_carteira'}){
							$bancos = $banco;
						}
						$banco = (array) $banco;
						if($banco["carteira"]."-".$banco["variacao"]==$doctos[0]->{'doc_carteira'}){
							$bancoSel = $banco;
						}
					}
				}

				$layout  	= $bancoSel["banco_numero"];
				$carteira  	= $bancoSel["carteira"];
				
				if(isset($_REQUEST["boletoAtt"])){
					
					$boletoAtt = json_decode(base64_decode($_REQUEST["boletoAtt"]));
					
				//verifica se boleto esta vencido	na impressão única
				}elseif( substr($doctos[0]->{'doc_dtvcto'}, 0, 10) < date("Y-m-d") && count($doctos)==1 ){
					$boletoAtt = new StdClass();
					$boletoAtt->{"juros"} = true;
					$boletoAtt->{"multa"} = true;
					$boletoAtt->{"novaData"} = date("Y-m-d H:i:s");
				}
				
				if(isset($boletoAtt) && !empty($boletoAtt)){

					if(isset($boletoAtt->{"novaData"}) && !empty($boletoAtt->{"novaData"})){

						$usu_login = "";
						if(isset($boletoAtt->{"usu_login"}) && !empty($boletoAtt->{"usu_login"})) {
							$usu_login = $boletoAtt->{"usu_login"};
						}

						$lgd_descr = "";
						if($boletoAtt->{"novaData"} != $doctos[0]->{"doc_dtvcto"}){
							$lgd_descr = "Impresso com novo vencimento: " .  implode("/", array_reverse(explode("-", substr($boletoAtt->{"novaData"}, 0, 10))));
						}

						$novaData = $boletoAtt->{"novaData"};

						$filtro = '{"cod":"501240","params":[
							{"name":"lgd_tipo","value":"4","type":"integer"},
							{"name":"doc_codigo","value":"'.$doctos[0]->{"doc_codigo"}.'","type":"string"},
							{"name":"usu_login","value":"'.$usu_login.'","type":"string"},
							{"name":"lgd_dtatualizada","value":"'.$boletoAtt->{"novaData"}.' 00:00:00","type":"string"},
							{"name":"lgd_descr","value":"'.$lgd_descr.'","type":"string"}
						]}';
						$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
						$Datapacket->add($filtro);
						$Datapacket->open(true);
						$Datapacket->clear();
						
					}
					
				}


				$layPos= strpos ($layout,'(');
				if($layPos){
					$layout = substr($layout,0,-3);
				}

				if($layout=="001" || $layout=="104" || $layout=="237" || $layout=="341" || $layout=="748" || $layout=="756" || $layout=="033"){

					if($layout == "001"){
						$layout="bb";
					}elseif($layout == "104"){
						if(strstr($carteira, "SIG")){
							$layout="caixa_sigcb";
						}else{
							$layout="caixa";
						}
					}elseif($layout == "237"){
						$layout="bradesco";
					}elseif($layout == "341"){
						$layout="itau";
					}elseif($layout == "399"){
						$layout="hsbc";
					}elseif($layout == "748"){
						$layout="sicredi";
					}elseif($layout == "756"){
						$layout="sicoob";
					}elseif($layout == "033"){
						$layout="santander";
					}
					
					include_once "../class/class_".$layout.".php";

					$ok="";
					$cnt = count($doctos);

					$company->{'emp_fantasia'}=ucwords(strtolower($Useful->strLower($company->{'emp_fantasia'})));
					
					if( !isset($_REQUEST["carne"]) ) {
						
						$mpdfTodos = new mPDF('utf-8', 'A4', 0, '', 10, 0, 5, 14, 0);
						$mpdfTodos->SetHTMLFooter('<div style="width:950px; height:20px; margin:0px auto; font-size:8px;">
							<div style="width:950px; text-align:right;">FACIL ONLINE - JC MANTOVAN</div>
						</div>');
						
					}else{
						
						$mpdfTodos = new mPDF('utf-8', 'A4', 0, '', 10, 0, 0, 0, 0);
						
					}
					$mpdfTodos->list_indent_first_level = 0;
					
					$linhas = "";
					
					if(count($doctos)>0){
						foreach($doctos as $docto){
							$mpdf=new mPDF('utf-8','A4','','',32,25,27,25,16,13);
							$mpdf->SetDisplayMode(100);
							$mpdf->list_indent_first_level = 0;	
							
							$update='';
							$docValor  = $docto->{'doc_valor'};
							//desconto
							if( isset($docto->{'doc_desconto'}) && $docto->{'doc_desconto'}>0 ) $docValor-=$docto->{'doc_desconto'};
							$docObs    = $docto->{'doc_obs'};
							$docObs2   .= $docto->{'doc_descr'}."<br>";
							$docCodigo = $docto->{'doc_codigo'};
							$docNumero = $docto->{'doc_numero'};
							$docData   = $docto->{'doc_data'};
							$docVcto   = $docto->{'doc_dtvcto'};
							$svcCodigo = $docto->{'svc_codigo'};
							$docInst1 = "";
							if( isset($boletoAtt->{"instr1"}) || isset($boletoAtt->{"instr2"}) || isset($boletoAtt->{"instr3"}) || isset($boletoAtt->{"instr4"}) || isset($boletoAtt->{"instr5"}) ){
								$docInst1  = (isset($boletoAtt->{"instr1"})) ? strtoupper($boletoAtt->{"instr1"}) : "";
								$docInst2  = (isset($boletoAtt->{"instr2"})) ? strtoupper($boletoAtt->{"instr2"}) : "";
								$docInst3  = (isset($boletoAtt->{"instr3"})) ? strtoupper($boletoAtt->{"instr3"}) : "";
								$docInst4  = (isset($boletoAtt->{"instr4"})) ? strtoupper($boletoAtt->{"instr4"}) : "";
								$docInst5  = (isset($boletoAtt->{"instr5"})) ? strtoupper($boletoAtt->{"instr5"}) : "";
							}else{
								$docInst1  = ($docto->{'cad_instrucao1'}) ? $docto->{'cad_instrucao1'} : "";
								$docInst2  = ($docto->{'cad_instrucao2'}) ? $docto->{'cad_instrucao2'} : "";
								$docInst3  = ($docto->{'cad_instrucao3'}) ? $docto->{'cad_instrucao3'} : "";
								$docInst4  = ($docto->{'cad_instrucao4'}) ? $docto->{'cad_instrucao4'} : "";
								$docInst5  = ($docto->{'cad_instrucao5'}) ? $docto->{'cad_instrucao5'} : "";
							}
							$sacado    = $docto->{'cad_nomeraz'};
							$cadCodigo = $docto->{'cad_codigo'};
							$cnpjCpf   = $docto->{'cad_cnpjcpf'};
							$sacador   = $docto->{'sac_nomeraz'};
							$sacCnpj   = $docto->{'sac_cnpjcpf'};
							$nParc   = $docto->{'doc_nparc'};
							$tParc   = $docto->{'doc_tparc'};
							
							$docData   = explode(' ',$docData);
							$docData   = explode('-',$docData[0]);
							$docData   = $docData[2]."/".$docData[1]."/".$docData[0];
							$docVcto   = explode(' ',$docVcto);
							$docVcto   = explode('-',$docVcto[0]);
							$docVcto   = $docVcto[2]."/".$docVcto[1]."/".$docVcto[0];
								
								if(isset($boletoAtt)){
									
									$bolJuros = 0;
									if($docto->{'doc_juros'}>0 && $boletoAtt->{"juros"}){
										$bolJuros = $docto->{'doc_juros'};
									}
									$bolMulta = 0;
									if($docto->{'doc_multa'}>0 && $boletoAtt->{"multa"}){
										$bolMulta= $docto->{'doc_multa'};
									}
									
								}else{
									
									if($company->{'emp_multa'}>0)
										$bolMulta = $company->{'emp_multa'};
									if($docto->{'cad_multa'}>0)
										$bolMulta = $docto->{'cad_multa'};
									if($docto->{'doc_multa'}>0)
										$bolMulta = $docto->{'doc_multa'};

									if($company->{'emp_jurosdiario'}>0)
										$bolJuros = $company->{'emp_jurosdiario'};
									if($docto->{'cad_jurosdiario'}>0)
										$bolJuros = $docto->{'cad_jurosdiario'};
									if($docto->{'doc_juros'}>0)
										$bolJuros = $docto->{'doc_juros'}; 
									
								}
								
								$docVctoProvisorio  = implode("-", array_reverse(explode("/", $docVcto)));
								$docVctoProvisorio = date( "d-m-Y", strtotime($docVctoProvisorio) );
								$docVctoProvisorio  = implode("-", array_reverse(explode("-", $docVctoProvisorio)));

								$constructor  = '{
									"valor":"'.$docValor.'",
									"vencto":"'.$docto->{'doc_dtvcto'}.'",
									"novoVencto":"';
								$constructor.= (isset($boletoAtt->{"novaData"})) ? $boletoAtt->{"novaData"} : $docVctoProvisorio ;
								$constructor.= '",
									"multa":"'.$bolMulta.'",
									"juros":"'.$bolJuros.'"
								}';
								
								$CalculoJuros = new CalculoJuros($constructor);
								$juros = json_decode($CalculoJuros->getData());

							if( isset($boletoAtt->{"juros"}) || isset($boletoAtt->{"multa"}) || isset($boletoAtt->{"novaData"}) ){
							
								// $docInst1 = $docto->{'cad_instrucao1'};
								$docInst5 = "VENCIMENTO ORIGINAL: ".$docVcto;
								if( (isset($boletoAtt->{"juros"}) || isset($boletoAtt->{"multa"})) && substr($boletoAtt->{"novaData"},0,10)>substr($docto->{'doc_dtvcto'},0,10) ){
									$docInst5 .= "<br>VALOR ORIGINAL: ".sprintf("%5.2f",$docValor);
									$docInst5 .= ($juros->{'multa'}>0 || $juros->{'juros'}>0) ? "<br>ENCARGOS POR ATRASO JUROS/MULTA: ".sprintf("%5.2f",$juros->{'multa'}+$juros->{'juros'}) : "";
									// $docInst5 .= "<br>VALOR A PAGAR: ".sprintf("%5.2f",$juros->{'total'});
									$docValor = $juros->{'total'};
								}
								$docVcto  = date('d/m/Y',strtotime($boletoAtt->{"novaData"}));
								
							}else{
							
								// $docInst1 = ($docto->{'cad_instrucao1'}) ? $docto->{'cad_instrucao1'} : "";
								$docInst5 = "";
								$docInst5.= ($juros->{'multa'}>0) ? "AP&Oacute;S VENCIMENTO COBRAR MULTA DE: R$ ".sprintf("%5.2f",$juros->{'multa'}) : "";
								$docInst5 .= ($juros->{'infJuros'}>0) ? "<br>JUROS POR DIA DE ATRASO: R$ ".number_format($juros->{'infJuros'},2,",","") : "";

							}
							//instrução para protesto
							if($docto->{'doc_protesto'}==1 && $docto->{'doc_dias_protesto'}>0){
								$docInst5.= "<br>PROTESTAR TÍTULO APÓS ".$docto->{'doc_dias_protesto'}." DIAS";
							}elseif($docto->{'doc_protesto'}==0 && $docto->{'doc_dias_protesto'}>0){
								$docInst5.= "<br>NÃO RECEBER APÓS ".$docto->{'doc_dias_protesto'}." DIAS";
							}

							$filter = '{"cod":"700290","params":[{"name":"cad_codigo","value":"'.$cadCodigo.'","type":"string"}]}';

							$Datapacket->clear();
							$Datapacket->setHost($TParams->getHost($company->{'emp_db_comum'}));
							$Datapacket->add($filter);
							$rowdataEnd = $Datapacket->open(true);

							$filter = '{"cod":"700293","params":[
								{"name":"svc_codigo","value":"'.$svcCodigo.'","type":"string"},
								{"name":"db","value":"'.$company->{'emp_db_comum'}.'","type":"other"}
							]}';
							$Datapacket->clear();
							$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
							$Datapacket->add($filter);
							$rowdataSvc = $Datapacket->open(true);
							$docDescr  = ucwords(strtolower($Useful->strLower($rowdataSvc[0]->{'svc_descr'})));

							if(count($rowdataEnd)>0){
								foreach($rowdataEnd as $endRow){
									if($endRow->{'end_tipo'}==3 || $endRow->{'end_tipo'}==1){
										if($endRow->{'end_nome'}!="")
											$endereco1 = $endRow->{'end_nome'}.', '.$endRow->{'end_num'};
										if($endRow->{'end_nome'}!="" and ($endRow->{'end_compl'} or $endRow->{'end_bairro'})!="")
											$endereco1 .= ' - ';
										if($endRow->{'end_compl'}!="")
											$endereco1 .= $endRow->{'end_compl'};
										if($endRow->{'end_compl'}!="" and $endRow->{'end_bairro'}!="")
											$endereco1 .= ' - ';
										if($endRow->{'end_bairro'}!="")
											$endereco1 .= $endRow->{'end_bairro'};

										if($endRow->{'end_cep'}!="")
											$endereco2 = substr($endRow->{'end_cep'},0,5)."-".substr($endRow->{'end_cep'},-3);
										if($endRow->{'end_cep'}!="" and ($endRow->{'end_cidade'} or $endRow->{'end_uf'})!="")
											$endereco2 .= ' - ';
										if($endRow->{'end_cidade'}!="")
											$endereco2 .= $endRow->{'end_cidade'};
										if($endRow->{'end_cidade'}!="" and $endRow->{'end_uf'}!="")
											$endereco2 .= ' - ';
										if($endRow->{'end_uf'}!="")
											$endereco2 .= $endRow->{'end_uf'};
									}else{
										$endereco1='';
										$endereco2='';
									}
								}
								
								if($endereco1==''){
									foreach($rowdataEnd as $endRow){
										if($endRow->{'end_nome'}!="")
											$endereco1 = $endRow->{'end_nome'}.', '.$endRow->{'end_num'};
										if($endRow->{'end_nome'}!="" and ($endRow->{'end_compl'} or $endRow->{'end_bairro'})!="")
											$endereco1 .= ' - ';
										if($endRow->{'end_compl'}!="")
											$endereco1 .= $endRow->{'end_compl'};
										if($endRow->{'end_compl'}!="" and $endRow->{'end_bairro'}!="")
											$endereco1 .= ' - ';
										if($endRow->{'end_bairro'}!="")
											$endereco1 .= $endRow->{'end_bairro'};

										if($endRow->{'end_cep'}!="")
											$endereco2 = substr($endRow->{'end_cep'},0,5)."-".substr($endRow->{'end_cep'},-3);
										if($endRow->{'end_cep'}!="" and ($endRow->{'end_cidade'} or $endRow->{'end_uf'})!="")
											$endereco2 .= ' - ';
										if($endRow->{'end_cidade'}!="")
											$endereco2 .= $endRow->{'end_cidade'};
										if($endRow->{'end_cidade'}!="" and $endRow->{'end_uf'}!="")
											$endereco2 .= ' - ';
										if($endRow->{'end_uf'}!="")
											$endereco2 .= $endRow->{'end_uf'};
										break;
									}					
								}
							}

							$row = array($docValor,$docCodigo,$docNumero,$docData,$docVcto,$docDescr,$docInst1,$docInst2,$docInst3,$docInst4,$docInst5,$docData,$docVcto,utf8_decode($sacado),$cnpjCpf,$endereco1,$endereco2,$docObs,utf8_decode($sacador),$sacCnpj, $nParc, $tParc);

							$stylesheet = file_get_contents('css/boleto.css');
							$htmlBanco = new GERAR_HTML();
							$htmlBanco->cpny(json_encode($company),$row,$bancos);

							$banco = $bancoSel;
							
							if( !isset($_REQUEST["carne"]) ) $mpdfTodos->addPage('P');
							$mpdfTodos->WriteHTML($stylesheet,1);
							$mpdfTodos->WriteHTML(utf8_encode($htmlBanco->html),2);
							
							$mpdf->AddPage();
							$mpdf->WriteHTML($stylesheet,1);
							$mpdf->WriteHTML(utf8_encode($htmlBanco->html),2);
							
							$filtro5  = '{"cod":"500481","params":[
								{"name":"doc_nossonumero","value":"'.$htmlBanco->nossonumero.'","type":"string"},
								{"name":"doc_linhadig","value":"'.str_replace(array(' ','.'),array('',''),$htmlBanco->linhaDigitavel).'","type":"string"},
								{"name":"doc_codigo","value":"'.$docCodigo.'","type":"string"}
							]}';

							$Datapacket->clear();
							$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
							$Datapacket->add($filtro5);
							$Datapacket->open(true);
							
							$linhas.=$htmlBanco->linhaDigitavel."<br><br>";
							
						  $dirBoletos = $TParams->uploads.$company->{'emp_codigo'}.'/boletos/';
						  $dirBoletos2 = $TParams->uploads2.$company->{'emp_codigo'}.'/boletos/';
						  
						  if(!is_dir($TParams->uploads.$company->{'emp_codigo'}.'/'))
							@mkdir($TParams->uploads.$company->{'emp_codigo'}.'/', 0777);
						  
						  if(!is_dir($dirBoletos))
							@mkdir($dirBoletos,0777);

							//boleto gerado	{
							$filter = '{"cod":"500482","params":[{"name":"doc_boletogerado","value":1,"type":"integer"},{"name":"doc_codigo","value":"'.$docCodigo.'","type":"string"}]}';
							$Datapacket->clear();
							$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
							$Datapacket->add($filter);
							$ret = $Datapacket->open(true);
							//}
							//$mpdf->Output();

							$mpdf->Output($dirBoletos.$docCodigo.'.pdf');

						}
					}

					$caminhoImpressao =$docCodigo.'.pdf';
					$mpdfTodos->Output($dirBoletos.$caminhoImpressao); 
					//************************************************************
					
					// SMS
					if(isset($_REQUEST['sms'])){
						
						setlocale (LC_TIME, 'pt_BR');

						//seleciona modelo
						$filter = '{"cod":"700268","params":[
							{"name":"dbcomum","value":"'.$company->{'emp_db_comum'}.'","type":"other"},
							{"name":"men_codigo","value":"24","type":"integer"}
						]}';
						$Datapacket->clear();
						$Datapacket->add($filter);
						$ret = $Datapacket->open(true);
						
						if($ret && $ret[0] && $ret[0]->men_conteudo && $ret[0]->men_conteudo!=""){
							
							$msg_conteudo = base64_decode($ret[0]->men_conteudo);
							
						}else{
							
							// $msg_conteudo = 'Prezado(a) '.ucwords(strtolower($sacado)).' código de barras de seu boleto é '.$linhas.' qualquer dúvida entre em contato';
							$msg_conteudo = 'Prezado cliente código de barras de seu boleto é '.$linhas.' qualquer dúvida entre em contato';
							
						}
						
						$msg_destinatario = str_replace(" ", "", $_REQUEST["sms"]);
						$msg_conteudo = base64_encode(str_replace("{{boleto}}", strip_tags(str_replace(array("."," "),"",$linhas)), $msg_conteudo));
						//registro da mensagem no sistema
						$filtro = '{"cod":"700321","params":[
							{"name":"msg_codigo","value":"","type":"string"},
							{"name":"msg_tipo","value":"2","type":"integer"},
							{"name":"men_codigo","value":"24","type":"integer"},
							{"name":"msg_remetente","value":" ","type":"string"},
							{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
							{"name":"cad_codigo","value":"'.$cadCodigo.'","type":"string"},
							{"name":"msg_assunto","value":" ","type":"string"},
							{"name":"msg_conteudo","value":"'.utf8_decode($msg_conteudo).'","type":"string"},
							{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
							{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
							{"name":"msg_status","value":"0","type":"integer"},
							{"name":"msg_anexo","value":" ","type":"string"}
						]}';
						
						$Datapacket->clear();
						$Datapacket->add($filtro);
						$ret = $Datapacket->open(false, true);
						
						if($ret){
							if(count($doctos)>0){
								$Datapacket->clear();
								//vinculo mensagem-docto
								foreach($doctos as $docto){
									$filtro = '{"cod":"700329","params":[
										{"name":"msg_codigo","value":"'.$ret.'","type":"integer"},
										{"name":"vin_tabela","value":"docto","type":"string"},
										{"name":"vin_codigo","value":"'.$docto->{'doc_codigo'}.'","type":"string"}
									]}';
									$Datapacket->add($filtro);
								}
								$Datapacket->open();
							}
							//enviar a mensagem
							$_REQUEST["acao"] = "enviar";
							$_REQUEST["msg_codigo"] = $ret;
							
							include_once "../php/mensagem.php";
						}
					
					//WhatsApp
					}elseif(isset($_REQUEST['whatsapp'])){

						$msg_conteudo = 'Prezado cliente, segue link para seu boleto '.$linhas.', qualquer dúvida entre em contato';
						$url = $dirBoletos.$docCodigo.'.pdf';
						
						$msg_destinatario = str_replace(" ", "", $_REQUEST["whatsapp"]);
						$msg_anexo = base64_encode("[{\"descricao\" : \"segue link para seu boleto ".$_POST["svc_descr"]."\", \"arquivo\" : \"".$url.''."\" }]");
						//registro da mensagem no sistema
						$filtro = '{"cod":"700321","params":[
							{"name":"msg_codigo","value":"","type":"string"},
							{"name":"msg_tipo","value":"3","type":"integer"},
							{"name":"men_codigo","value":"24","type":"integer"},
							{"name":"msg_remetente","value":" ","type":"string"},
							{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
							{"name":"cad_codigo","value":"'.$cadCodigo.'","type":"string"},
							{"name":"msg_assunto","value":" ","type":"string"},
							{"name":"msg_conteudo","value":"'.base64_encode('Prezado cliente, {{anexo}}: {{link}}').'","type":"string"},
							{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
							{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
							{"name":"msg_status","value":"0","type":"integer"},
							{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
						]}';
						
						$Datapacket->clear();
						$Datapacket->add($filtro);
						$ret = $Datapacket->open(false, true);
						
						if($ret){
							if(count($doctos)>0){
								$Datapacket->clear();
								//vinculo mensagem-docto
								foreach($doctos as $docto){
									$filtro = '{"cod":"700329","params":[
										{"name":"msg_codigo","value":"'.$ret.'","type":"integer"},
										{"name":"vin_tabela","value":"docto","type":"string"},
										{"name":"vin_codigo","value":"'.$docto->{'doc_codigo'}.'","type":"string"}
									]}';
									$Datapacket->add($filtro);
								}
								$Datapacket->open();
							}
							//enviar a mensagem
							$_REQUEST["acao"] = "enviar";
							$_REQUEST["msg_codigo"] = $ret;
							
							include_once "../php/mensagem.php";
						}
						
					}
					
					// email
					if(isset($_REQUEST['email'])){
						
						setlocale (LC_TIME, 'pt_BR');

						$url = $dirBoletos2.$docCodigo.'.pdf';
						
						//modelo de mensagem a ser enviada: 2=primeiro envio; 7=lembrete de vencimento
						if( isset($_REQUEST["msg"]) && $_REQUEST["msg"]==2 ){
							$men_codigo=2;
						}elseif( isset($doctos[0]) && ( substr($doctos[0]->{"doc_dtvcto"}, 0, 10) == date("Y-m-d", strtotime(date("Y-m-d H:i:s")."+ 1 days")) || substr($doctos[0]->{"doc_dtvcto"}, 0, 10) == date("Y-m-d", strtotime(date("Y-m-d H:i:s")."+ 2 days")) ) ){
							$men_codigo=7;
						}elseif( isset($doctos[0]) && substr($doctos[0]->{"doc_dtvcto"}, 0, 10) < date("Y-m-d") ){
							// $men_codigo=12;
							$men_codigo=7;
						}else{
							$men_codigo=2;
						}
						
						$filter = '{"cod":"700268","params":[
							{"name":"dbcomum","value":"'.$company->{'emp_db_comum'}.'","type":"other"},
							{"name":"men_codigo","value":"'.$men_codigo.'","type":"integer"}
						]}';
						$Datapacket->clear();
						$Datapacket->add($filter);
						$ret = $Datapacket->open(true);
						
						if($ret && $ret[0] && $ret[0]->men_conteudo && $ret[0]->men_conteudo!=""){
							
							$msg_conteudo = $ret[0]->men_conteudo;
							
							$msg_remetente = $ret[0]->men_remetente;
							
							$msg_assunto = $ret[0]->men_assunto;
							
						}else{
							
							$msg_conteudo = base64_encode('
							Prezado(a) '.ucwords(strtolower($sacado)).'<br><br>
							Você está recebendo em anexo o(s) boleto(s) de cobrança referentes a:<br>
							'.utf8_decode($docObs).'<br><br>
							Você ainda tem a opção de acessar pelo link abaixo:<br><br>
							<a href="'.$url.'">'.$url.'</a><br><br>
							Ou ainda, utilizar a linha digitável para efetuar o pagamento:<br><br>
							'.$linhas.'
							Caso este pagamento já tenha sido efetuado, favor ignorar este e-mail<br><br>
							Qualquer dúvida entre em contato.<br>
							'.unescape($company->{'emp_msgemail'},'<br>').'<br><br><br>
							A responsabilidade pelos dados do boleto pertence à
							'.utf8_decode($company->{'emp_fantasia'}));
							
							$msg_remetente = $company->{'emp_emailremetente'};
							
							$msg_assunto = "Boleto ".utf8_decode($company->{'emp_fantasia'}).": ".$sacado;
							
						}
						
						$msg_destinatario = str_replace(array("\"", "]", "["), "", $_REQUEST["email"]);
						$msg_anexo = base64_encode("[{\"descricao\" : \"".base64_encode(utf8_decode($docObs))."\", \"arquivo\" : \"".$dirBoletos.$docCodigo.'.pdf'."\" }]");
						
						//registro da mensagem no sistema
						$filtro = '{"cod":"700321","params":[
							{"name":"msg_codigo","value":"","type":"string"},
							{"name":"msg_tipo","value":"1","type":"integer"},
							{"name":"men_codigo","value":"'.$men_codigo.'","type":"integer"},
							{"name":"msg_remetente","value":"'.$msg_remetente.'","type":"string"},
							{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
							{"name":"cad_codigo","value":"'.$cadCodigo.'","type":"string"},
							{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
							{"name":"msg_conteudo","value":"'.utf8_decode($msg_conteudo).'","type":"string"},
							{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
							{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
							{"name":"msg_status","value":"0","type":"integer"},
							{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
						]}';
						
						$Datapacket->clear();
						$Datapacket->add($filtro);
						$ret = $Datapacket->open(false, true);
						
						if($ret){
							if(count($doctos)>0){
								$Datapacket->clear();
								//vinculo mensagem-docto
								foreach($doctos as $docto){
									$filtro = '{"cod":"700329","params":[
										{"name":"msg_codigo","value":"'.$ret.'","type":"integer"},
										{"name":"vin_tabela","value":"docto","type":"string"},
										{"name":"vin_codigo","value":"'.$docto->{'doc_codigo'}.'","type":"string"}
									]}';
									$Datapacket->add($filtro);
								}
								$Datapacket->open();
							}
							//enviar a mensagem
							$_REQUEST["acao"] = "enviar";
							$_REQUEST["msg_codigo"] = $ret;
							
							include_once "../php/mensagem.php";
						}
						
					}
					 
					if($ok!=""){
						echo $ok;
					}

					if(!isset($_REQUEST['email']) && !isset($_REQUEST['sms'])){ //added para envio de emails
						echo "<a href='".$dirBoletos2.$caminhoImpressao."' style='text-decoration:none; font-weight:bold; color:#000'>Clique aqui para imprimir os boletos</a>
						<script>
							setTimeout(function(){
								location.href='".$dirBoletos2.$caminhoImpressao."'
							},500);
						</script>
						";
						// echo "<script>location.href='".$dirBoletos.$caminhoImpressao."'</script>";
					}
				
				//Banco Inter
				}elseif($layout=="077"){
					$dircert = $TParams->uploads.$company->{'emp_codigo'}.'/certificados/'.$company->{'emp_cpfcnpj'}.'.';
					if( isset($bancoSel["conta2"]) && $bancoSel["conta2"]!="" && isset($bancoSel["contrato"]) && $bancoSel["contrato"]!="" ){
						//método por token (versao 2.0)
						$dircert = $TParams->uploads.$company->{'emp_codigo'}.'/inter/'.$company->{'emp_cpfcnpj'}.'.';
						if( is_file($dircert."crt") && file_exists($dircert."crt") ){
						
						//cancelamento
						if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="cancelar" ){
							
							foreach($doctos as $docto){

								$curl = curl_init();
								curl_setopt_array($curl, array(
								  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/oauth/v2/token',
								  CURLOPT_RETURNTRANSFER => true,
								  CURLOPT_SSLCERT => $dircert."crt",
								  CURLOPT_SSLKEY => $dircert."key",
								  CURLOPT_SSL_VERIFYHOST => false,
								  CURLOPT_SSL_VERIFYPEER => false,
								  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
								  CURLOPT_CUSTOMREQUEST => 'POST',
								  CURLOPT_POSTFIELDS => 'client_id='.$bancoSel["contrato"].'&client_secret='.$bancoSel["conta2"].'&scope=boleto-cobranca.write&grant_type=client_credentials',
								  CURLOPT_HTTPHEADER => array(
									'Content-Type: application/x-www-form-urlencoded'
								  ),
								));
								$response = curl_exec($curl);
								curl_close($curl);
								$response = json_decode($response, true);										
								$token = $response["access_token"];

								$curl = curl_init();
								curl_setopt_array($curl, array(
								  // CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/cobranca/v2/boletos/'.$docto->{'doc_nossonumero'}.'/cancelar',
								  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/cobranca/v3/cobrancas/'.$docto->{'doc_referencia'}.'/cancelar',
								  CURLOPT_RETURNTRANSFER => true,
								  CURLOPT_SSLCERT => $dircert."crt",
								  CURLOPT_SSLKEY => $dircert."key",
								  CURLOPT_SSL_VERIFYHOST => false,
								  CURLOPT_SSL_VERIFYPEER => false,
								  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
								  CURLOPT_CUSTOMREQUEST => 'POST',
								  CURLOPT_POSTFIELDS =>'{
										"motivoCancelamento":"SUBSTITUICAO"
									}',
								  CURLOPT_HTTPHEADER => array(
									'Authorization: Bearer '.$token,
									'Content-Type: application/json'
								  ),
								));
								$response = curl_exec($curl);
								curl_close($curl);
								$response = json_decode($response, true);
								print_r($response);
										
							}
							
						}else{
							
							if(count($doctos)==1){
									foreach($doctos as $docto){
										//gerar
										if($docto->{'doc_boletogerado'}!=1){
											$curl = curl_init();
											curl_setopt_array($curl, array(
											  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/oauth/v2/token',
											  CURLOPT_RETURNTRANSFER => true,
											  CURLOPT_SSLCERT => $dircert."crt",
											  CURLOPT_SSLKEY => $dircert."key",
											  CURLOPT_SSL_VERIFYHOST => false,
											  CURLOPT_SSL_VERIFYPEER => false,
											  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
											  CURLOPT_CUSTOMREQUEST => 'POST',
											  CURLOPT_POSTFIELDS => 'client_id='.$bancoSel["contrato"].'&client_secret='.$bancoSel["conta2"].'&scope=boleto-cobranca.write&grant_type=client_credentials',
											  CURLOPT_HTTPHEADER => array(
												'Content-Type: application/x-www-form-urlencoded'
											  ),
											));
											$response = curl_exec($curl);
											curl_close($curl);
											$response = json_decode($response, true);										
											$token = $response["access_token"];
											
											$email = ( isset($_REQUEST["email"]) && $_REQUEST["email"]!="" ) ? $_REQUEST["email"] : "";
											$tipoPessoa = ( strlen($docto->{'cad_cnpjcpf'})==14 ) ? "JURIDICA" : "FISICA";
											$juros = ( isset($docto->{'doc_juros'}) && $docto->{'doc_juros'}>0 ) ? $docto->{'doc_juros'} : 0;
											$multa = ( isset($docto->{'doc_multa'}) && $docto->{'doc_multa'}>0 ) ? $docto->{'doc_multa'} : 0;
											$desconto = ( isset($docto->{'doc_desconto'}) && $docto->{'doc_desconto'}>0 ) ? $docto->{'doc_desconto'} : 0;
											$valordoc = $docto->{'doc_valor'};
											if($juros>0){
												$jsonjuros = '"mora":{
												  "codigo":"TAXAMENSAL",
												  "taxa":'.(number_format(($juros*30), 2)).'
											   },';
											}else{
												$jsonjuros = '';
											}
											if($multa>0){
												$jsonmulta = '"multa":{
												  "codigo":"PERCENTUAL",
												  "taxa":'.$multa.'
											   },';
											}else{
												$jsonmulta = '';
											}
											if($desconto>0){
												$jsondesconto = '"desconto":{
												  "codigo":"VALORFIXODATAINFORMADA",
												  "valor":'.$desconto.',
												  "quantidadeDias":"1"
											   },';
											}else{
												$jsondesconto = '';
											}
											if( isset($boletoAtt->{"instr1"}) || isset($boletoAtt->{"instr2"}) || isset($boletoAtt->{"instr3"}) || isset($boletoAtt->{"instr4"}) || isset($boletoAtt->{"instr5"}) ){
												$docInst1  = (isset($boletoAtt->{"instr1"})) ? strtoupper($boletoAtt->{"instr1"}) : "";
												$docInst2  = (isset($boletoAtt->{"instr2"})) ? strtoupper($boletoAtt->{"instr2"}) : "";
												$docInst3  = (isset($boletoAtt->{"instr3"})) ? strtoupper($boletoAtt->{"instr3"}) : "";
												$docInst4  = (isset($boletoAtt->{"instr4"})) ? strtoupper($boletoAtt->{"instr4"}) : "";
												$docInst5  = (isset($boletoAtt->{"instr5"})) ? strtoupper($boletoAtt->{"instr5"}) : "";
											}else{
												$docInst1  = ($docto->{'doc_obs'}) ? $docto->{'doc_obs'} : $docto->{'doc_descr'};
												$docInst2  = "";
												$docInst3  = "";
												$docInst4  = "";
												$docInst5  = "";
											}
											
											$curl = curl_init();
											curl_setopt_array($curl, array(
											  // CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/cobranca/v2/boletos',
											  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/cobranca/v3/cobrancas',
											  CURLOPT_RETURNTRANSFER => true,
											  CURLOPT_SSLCERT => $dircert."crt",
											  CURLOPT_SSLKEY => $dircert."key",
											  CURLOPT_SSL_VERIFYHOST => false,
											  CURLOPT_SSL_VERIFYPEER => false,
											  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
											  CURLOPT_CUSTOMREQUEST => 'POST',
											  CURLOPT_POSTFIELDS =>'{
													"seuNumero":"'.substr($docto->{'doc_numero'},0,14).'",
													"valorNominal":'.$valordoc.',
													"valorAbatimento":0,
													"dataVencimento":"'.substr($docto->{'doc_dtvcto'},0,10).'",
													"numDiasAgenda":60,
													"formasRecebimento":["BOLETO","PIX"],
													"pagador":{
														"cpfCnpj":"'.$docto->{'cad_cnpjcpf'}.'",
														"nome":"'.str_replace("&", "E", $docto->{'cad_nomeraz'}).'",
														"email":"'.$email.'",
														"telefone":"",
														"cep":"'.$docto->{'end_cep'}.'",
														"numero":"'.$docto->{'end_num'}.'",
														"complemento":"'.$docto->{'end_compl'}.'",
														"bairro":"'.$docto->{'end_bairro'}.'",
														"cidade":"'.$docto->{'end_cidade'}.'",
														"uf":"'.$docto->{'end_uf'}.'",
														"endereco":"'.$docto->{'cad_end'}.'",
														"ddd":"",
														"tipoPessoa":"'.$tipoPessoa.'"
													},'.$jsondesconto.'
													'.$jsonmulta.'
													'.$jsonjuros.'
													"mensagem":{
														"linha1":"'.substr($docInst1,0,78).'"
													},
													"desconto2":{
														"codigoDesconto":"NAOTEMDESCONTO",
														"taxa":0,
														"valor":0,
														"data":""
													},
													"desconto3":{
														"codigoDesconto":"NAOTEMDESCONTO",
														"taxa":0,
														"valor":0,
														"data":""
													}
												}',
											  CURLOPT_HTTPHEADER => array(
												'Authorization: Bearer '.$token,
												'Content-Type: application/json'
											  ),
											));

											$response = curl_exec($curl);
											curl_close($curl);
											$response = json_decode($response, true);
											if( is_array($response) && (isset($response["codigoSolicitacao"]) || isset($response["cobranca"]["codigoSolicitacao"])) ){
												$doc_referencia = ( isset($response["codigoSolicitacao"]) ) ? $response["codigoSolicitacao"] : $response["cobranca"]["codigoSolicitacao"];
												
												//consulta pelo codigo da solicitacao
												$curl = curl_init();
												curl_setopt_array($curl, array(
												  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/oauth/v2/token',
												  CURLOPT_RETURNTRANSFER => true,
												  CURLOPT_SSLCERT => $dircert."crt",
												  CURLOPT_SSLKEY => $dircert."key",
												  CURLOPT_SSL_VERIFYHOST => false,
												  CURLOPT_SSL_VERIFYPEER => false,
												  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
												  CURLOPT_CUSTOMREQUEST => 'POST',
												  CURLOPT_POSTFIELDS => 'client_id='.$bancoSel["contrato"].'&client_secret='.$bancoSel["conta2"].'&scope=boleto-cobranca.read&grant_type=client_credentials',
												  CURLOPT_HTTPHEADER => array(
													'Content-Type: application/x-www-form-urlencoded'
												  ),
												));
												$response = curl_exec($curl);
												curl_close($curl);
												$response = json_decode($response, true);										
												$token = $response["access_token"];
												
												$curl = curl_init();
												curl_setopt_array($curl, array(
												  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/cobranca/v3/cobrancas/'.$doc_referencia,
												  CURLOPT_RETURNTRANSFER => true,
												  CURLOPT_SSLCERT => $dircert."crt",
												  CURLOPT_SSLKEY => $dircert."key",
												  CURLOPT_SSL_VERIFYHOST => false,
												  CURLOPT_SSL_VERIFYPEER => false,
												  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
												  CURLOPT_CUSTOMREQUEST => 'GET',
												  CURLOPT_HTTPHEADER => array(
													'Authorization: Bearer '.$token,
													'Content-Type: application/json'
												  ),
												));
												sleep(4);
												$response = curl_exec($curl);
												curl_close($curl);
												$response = json_decode($response, true);
												
												if( is_array($response) && isset($response["boleto"]["nossoNumero"]) ){
													//atualiza boleto ja gerado
													$Datapacket->clear();
													$filter = '{"cod":"500522","params":[
													{"name":"doc_nossonumero","value":"'.$response["boleto"]["nossoNumero"].'","type":"string"},
													{"name":"doc_codbar","value":"'.$response["boleto"]["codigoBarras"].'","type":"string"},
													{"name":"doc_linhadig","value":"'.$response["boleto"]["linhaDigitavel"].'","type":"string"},
													{"name":"doc_referencia","value":"'.$doc_referencia.'","type":"string"},
													{"name":"doc_codigo","value":"'.$docto->{'doc_codigo'}.'","type":"string"}
													]}';
													$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
													$Datapacket->add($filter);
													$ok = $Datapacket->open(true);
													
													$docto->{'doc_referencia'} = $doc_referencia;
												}else{
													//imprime erro
													print_r($response);
												}
												
											}else{
												//imprime erro
												print_r($response);
											}
											
											sleep(4);
										
										}
										
										//imprimir	
										if($docto->{'doc_referencia'} && $docto->{'doc_referencia'}!=""){
											$curl = curl_init();
											curl_setopt_array($curl, array(
											  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/oauth/v2/token',
											  CURLOPT_RETURNTRANSFER => true,
											  CURLOPT_SSLCERT => $dircert."crt",
											  CURLOPT_SSLKEY => $dircert."key",
											  CURLOPT_SSL_VERIFYHOST => false,
											  CURLOPT_SSL_VERIFYPEER => false,
											  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
											  CURLOPT_CUSTOMREQUEST => 'POST',
											  CURLOPT_POSTFIELDS => 'client_id='.$bancoSel["contrato"].'&client_secret='.$bancoSel["conta2"].'&scope=boleto-cobranca.read&grant_type=client_credentials',
											  CURLOPT_HTTPHEADER => array(
												'Content-Type: application/x-www-form-urlencoded'
											  ),
											));
											$response = curl_exec($curl);
											curl_close($curl);
											$response = json_decode($response, true);										
											$token = $response["access_token"];
											
											$dirpdf = $TParams->uploads.$company->{'emp_codigo'}.'/boletos/';
											if(!is_dir($dirpdf)) @mkdir($dirpdf, 0777);
											$curl = curl_init();
											curl_setopt_array($curl, array(
											  // CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/cobranca/v2/boletos/'.$docto->{'doc_nossonumero'}.'/pdf',
											  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/cobranca/v3/cobrancas/'.$docto->{'doc_referencia'}.'/pdf',
											  CURLOPT_RETURNTRANSFER => true,
											  CURLOPT_SSLCERT => $dircert."crt",
											  CURLOPT_SSLKEY => $dircert."key",
											  CURLOPT_SSL_VERIFYHOST => false,
											  CURLOPT_SSL_VERIFYPEER => false,
											  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
											  CURLOPT_CUSTOMREQUEST => 'GET',
											  CURLOPT_HTTPHEADER => array(
												'Accept: application/json',
												'Authorization: Bearer '.$token
											  ),
											));
											$response = json_decode(curl_exec($curl), true);
											curl_close($curl);
											$decoded = base64_decode($response["pdf"]);
											$file = $dirpdf.$docto->{'doc_codigo'}.'.pdf';
											file_put_contents($file, $decoded);

											if (file_exists($file)) {
												
												// email
												if(isset($_REQUEST['email'])){
													
													//modelo de mensagem a ser enviada: 2=primeiro envio; 7=lembrete de vencimento
													if( isset($_REQUEST["msg"]) && $_REQUEST["msg"]==2 ){
														$men_codigo=2;
													}elseif( ( substr($docto->{"doc_dtvcto"}, 0, 10) == date("Y-m-d", strtotime(date("Y-m-d H:i:s")."+ 1 days")) || substr($docto->{"doc_dtvcto"}, 0, 10) == date("Y-m-d", strtotime(date("Y-m-d H:i:s")."+ 2 days")) ) ){
														$men_codigo=7;
													}elseif( substr($docto->{"doc_dtvcto"}, 0, 10) < date("Y-m-d") ){
														$men_codigo=7;
													}else{
														$men_codigo=2;
													}
													$filter = '{"cod":"700268","params":[
														{"name":"dbcomum","value":"'.$company->{'emp_db_comum'}.'","type":"other"},
														{"name":"men_codigo","value":"'.$men_codigo.'","type":"integer"}
													]}';
													$Datapacket->clear();
													$Datapacket->add($filter);
													$ret = $Datapacket->open(true);
													
													if($ret && $ret[0] && $ret[0]->men_conteudo && $ret[0]->men_conteudo!=""){
														$msg_conteudo = $ret[0]->men_conteudo;
														$msg_remetente = $ret[0]->men_remetente;
														$msg_assunto = $ret[0]->men_assunto;
													}else{
														$msg_conteudo = base64_encode('
														Prezado(a) '.ucwords(strtolower($docto->cad_nomeraz)).'<br><br>
														Você está recebendo em anexo o(s) boleto(s) de cobrança referentes a:<br>
														'.utf8_decode($docto->doc_obs).'<br><br>
														Ou ainda, utilizar a linha digitável para efetuar o pagamento:<br><br>
														'.$docto->doc_linhadig.'
														Caso este pagamento já tenha sido efetuado, favor ignorar este e-mail<br><br>
														Qualquer dúvida entre em contato.<br>
														'.unescape($company->{'emp_msgemail'},'<br>').'<br><br><br>
														A responsabilidade pelos dados do boleto pertence à
														'.utf8_decode($company->{'emp_fantasia'}));
														$msg_remetente = $company->{'emp_emailremetente'};														
														$msg_assunto = "Boleto ".utf8_decode($company->{'emp_fantasia'}).": ".$sacado;
													}
													
													$msg_destinatario = str_replace("\"", "", $_REQUEST["email"]);
													$msg_anexo = base64_encode("[{\"descricao\" : \"".base64_encode(utf8_decode($docto->doc_obs))."\", \"arquivo\" : \"".$file.''."\" }]");
													
													//registro da mensagem no sistema
													$filtro = '{"cod":"700321","params":[
														{"name":"msg_codigo","value":"","type":"string"},
														{"name":"msg_tipo","value":"1","type":"integer"},
														{"name":"men_codigo","value":"'.$men_codigo.'","type":"integer"},
														{"name":"msg_remetente","value":"'.$msg_remetente.'","type":"string"},
														{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
														{"name":"cad_codigo","value":"'.$docto->cad_codigo.'","type":"string"},
														{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
														{"name":"msg_conteudo","value":"'.utf8_decode($msg_conteudo).'","type":"string"},
														{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
														{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
														{"name":"msg_status","value":"0","type":"integer"},
														{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
													]}';
													$Datapacket->clear();
													$Datapacket->add($filtro);
													$ret = $Datapacket->open(false, true);
													
													if($ret){
														$Datapacket->clear();
														//vinculo mensagem-docto
														$filtro = '{"cod":"700329","params":[
															{"name":"msg_codigo","value":"'.$ret.'","type":"integer"},
															{"name":"vin_tabela","value":"docto","type":"string"},
															{"name":"vin_codigo","value":"'.$docto->{'doc_codigo'}.'","type":"string"}
														]}';
														$Datapacket->add($filtro);
														$Datapacket->open();
														//enviar a mensagem
														$_REQUEST["acao"] = "enviar";
														$_REQUEST["msg_codigo"] = $ret;
														
														include_once "../php/mensagem.php";
													}
													
												}elseif(isset($_REQUEST['sms'])){

													//seleciona modelo
													$filter = '{"cod":"700268","params":[
														{"name":"dbcomum","value":"'.$company->{'emp_db_comum'}.'","type":"other"},
														{"name":"men_codigo","value":"24","type":"integer"}
													]}';
													$Datapacket->clear();
													$Datapacket->add($filter);
													$ret = $Datapacket->open(true);
													
													if($ret && $ret[0] && $ret[0]->men_conteudo && $ret[0]->men_conteudo!=""){
														$msg_conteudo = base64_decode($ret[0]->men_conteudo);
													}else{
														$msg_conteudo = 'Prezado cliente código de barras de seu boleto é '.$docto->doc_linhadig.' qualquer dúvida entre em contato';
													}
													
													$msg_destinatario = str_replace(" ", "", $_REQUEST["sms"]);
													$msg_conteudo = base64_encode(str_replace("{{boleto}}", strip_tags(str_replace(array("."," "),"",$docto->doc_linhadig)), $msg_conteudo));
													//registro da mensagem no sistema
													$filtro = '{"cod":"700321","params":[
														{"name":"msg_codigo","value":"","type":"string"},
														{"name":"msg_tipo","value":"2","type":"integer"},
														{"name":"men_codigo","value":"24","type":"integer"},
														{"name":"msg_remetente","value":" ","type":"string"},
														{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
														{"name":"cad_codigo","value":"'.$cadCodigo.'","type":"string"},
														{"name":"msg_assunto","value":" ","type":"string"},
														{"name":"msg_conteudo","value":"'.utf8_decode($msg_conteudo).'","type":"string"},
														{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
														{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
														{"name":"msg_status","value":"0","type":"integer"},
														{"name":"msg_anexo","value":" ","type":"string"}
													]}';
													$Datapacket->clear();
													$Datapacket->add($filtro);
													$ret = $Datapacket->open(false, true);
													if($ret){
														//enviar a mensagem
														$_REQUEST["acao"] = "enviar";
														$_REQUEST["msg_codigo"] = $ret;
														
														include_once "../php/mensagem.php";
													}
												
												//WhatsApp
												}elseif(isset($_REQUEST['whatsapp'])){

													$msg_conteudo = 'Prezado cliente, segue link para seu boleto '.$linhas.', qualquer dúvida entre em contato';												
													$msg_destinatario = str_replace(" ", "", $_REQUEST["whatsapp"]);
													$msg_anexo = base64_encode("[{\"descricao\" : \"segue link para seu boleto ".$_POST["svc_descr"]."\", \"arquivo\" : \"".$file.''."\" }]");
													//registro da mensagem no sistema
													$filtro = '{"cod":"700321","params":[
														{"name":"msg_codigo","value":"","type":"string"},
														{"name":"msg_tipo","value":"3","type":"integer"},
														{"name":"men_codigo","value":"24","type":"integer"},
														{"name":"msg_remetente","value":" ","type":"string"},
														{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
														{"name":"cad_codigo","value":"'.$cadCodigo.'","type":"string"},
														{"name":"msg_assunto","value":" ","type":"string"},
														{"name":"msg_conteudo","value":"'.base64_encode('Prezado cliente, {{anexo}}: {{link}}').'","type":"string"},
														{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
														{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
														{"name":"msg_status","value":"0","type":"integer"},
														{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
													]}';
													$Datapacket->clear();
													$Datapacket->add($filtro);
													$ret = $Datapacket->open(false, true);
													if($ret){
														//enviar a mensagem
														$_REQUEST["acao"] = "enviar";
														$_REQUEST["msg_codigo"] = $ret;
														
														include_once "../php/mensagem.php";
													}
												//impressão
												}else{
													header("Content-Type: application/pdf");
													header("Content-Disposition: inline; filename=".$docto->{'doc_codigo'}.".pdf");
													echo file_get_contents($file);
													/*
													para forçar download
													header('Content-Description: File Transfer');
													header('Content-Type: application/octet-stream');
													header('Content-Disposition: attachment; filename="'.basename($file).'"');
													header('Expires: 0');
													header('Cache-Control: must-revalidate');
													header('Pragma: public');
													header('Content-Length: ' . filesize($file));
													readfile($file);
													exit;
													*/
												}
											}
										}
										
									}
								}else{
									echo "Boletos deste Banco são impressos somente individualmente, selecione apenas um boleto";
								}
							
							}
						}else{
							echo "Falta cadastrar arquivo do certificado!";
						}
						
					}else{
						echo "Falta cadastrar arquivo do certificado!";
					}						
					
				}else{
					echo "O banco selecionado (".$layout.") ainda n&atilde;o est&aacute; habilitado no sistema.";
				}
			}else{
				echo "O boleto n&atilde;o possui uma carteira definida, favor selecionar uma carteira!";
			}
		}else{
			echo "Um dos documentos selecionados n&atilde;o &eacute; um boleto!";
		}
	}else{
		echo "Erro! Possiveis causas:<br>- Verifique se a s&eacute;rie utilizada est&aacute; cadastrada no sistema.<br>- Confira se o(s) Boleto(s) de código(s) (".$codigos.") existem no sistema.";
	}
?>
